document.addEventListener("DOMContentLoaded", function () {
    fetch('get_addresses.php')
        .then(response => response.json())
        .then(data => {
            const input = document.querySelector("#addressSearch");
            const hidden = document.querySelector("#retezecadresy");

            // Vytvoření mapy label -> data
            const labelToData = {};
            const list = data.map(item => {
                labelToData[item.label] = item.data;
                return item.label; // do Awesomplete předáváme jen labely
            });

            const awesomplete = new Awesomplete(input, {
                list: list,
                minChars: 2,
                autoFirst: true,
                replace: function(suggestion) {
                    input.value = suggestion;
                    hidden.value = labelToData[suggestion] || '';
                   // alert(hidden.value);
                }
            });
        });
});