try {
/*
* jPreLoader - jQuery plugin
* Create a Loading Screen to preload images and content for you website
*
* Name:			jPreLoader.js
* Author:		Kenny Ooi - http://www.inwebson.com
* Date:			July 11, 2012		
* Version:		2.1
* Example:		http://www.inwebson.com/demo/jpreloader-v2/
*	
*/

(function($) {
	var items = new Array(),
		errors = new Array(),
		onComplete = function() {},
		current = 0;
	
	var jpreOptions = {
		splashVPos: '35%',
		loaderVPos: '50%',
		splashID: '#jpreContent',
		showSplash: true,
		showPercentage: true,
		autoClose: true,
		closeBtnText: 'Start!',
		onetimeLoad: false,
		debugMode: false,
		splashFunction: function() {}
	}
	
	//cookie
	var getCookie = function() {
		if( jpreOptions.onetimeLoad ) {
			var cookies = document.cookie.split('; ');
			for (var i = 0, parts; (parts = cookies[i] && cookies[i].split('=')); i++) {
				if ((parts.shift()) === "jpreLoader") {
					return (parts.join('='));
				}
			}
			return false;
		} else {
			return false;
		}
		
	}
	var setCookie = function(expires) {
		if( jpreOptions.onetimeLoad ) {
			var exdate = new Date();
			exdate.setDate( exdate.getDate() + expires );
			var c_value = ((expires==null) ? "" : "expires=" + exdate.toUTCString());
			document.cookie="jpreLoader=loaded; " + c_value;
		}
	}
	
	//create jpreLoader UI
	var createContainer = function() {
		
		jOverlay = $('<div></div>')
		.attr('id', 'jpreOverlay')
		.css({
			position: "fixed",
			top: 0,
			left: 0,
			width: '100%',
			height: '100%',
			zIndex: 9999999
		})
		.appendTo('body');
		
		if(jpreOptions.showSplash) {
			jContent = $('<div></div>')
			.attr('id', 'jpreSlide')
			.appendTo(jOverlay);
			
			var conWidth = $(window).width() - $(jContent).width();
			$(jContent).css({
				position: "absolute",
				top: jpreOptions.splashVPos,
				left: Math.round((50 / $(window).width()) * conWidth) + '%'
			});
			$(jContent).html($(jpreOptions.splashID).wrap('<div/>').parent().html());
			$(jpreOptions.splashID).remove();
			jpreOptions.splashFunction()			
		}
		
		jLoader = $('<div></div>')
		.attr('id', 'jpreLoader')
		.appendTo(jOverlay);
		
		var posWidth = $(window).width() - $(jLoader).width();
		$(jLoader).css({
			position: 'absolute',
			top: jpreOptions.loaderVPos,
			left: Math.round((50 / $(window).width()) * posWidth) + '%'
		});
		
		jBar = $('<div></div>')
		.attr('id', 'jpreBar')
		.css({
			width: '0%',
			height: '100%'
		})
		.appendTo(jLoader);
		
		if(jpreOptions.showPercentage) {
			jPer = $('<div></div>')
			.attr('id', 'jprePercentage')
			.css({
				position: 'relative',
				height: '100%'
			})
			.appendTo(jLoader)
			.html('Loading...');
		}
		if( !jpreOptions.autoclose ) {
			jButton = $('<div></div>')
			.attr('id', 'jpreButton')
			.on('click', function() {
				loadComplete();
			})
			.css({
				position: 'relative',
				height: '100%'
			})
			.appendTo(jLoader)
			.text(jpreOptions.closeBtnText)
			.hide();
		}
	}
	
	//get all images from css and <img> tag
	var getImages = function(element) {
		$(element).find('*:not(script)').each(function() {
			var url = "";

			if ($(this).css('background-image').indexOf('none') == -1 && $(this).css('background-image').indexOf('-gradient') == -1) {
				url = $(this).css('background-image');
				if(url.indexOf('url') != -1) {
					var temp = url.match(/url\((.*?)\)/);
					url = temp[1].replace(/\"/g, '');
				}
			} else if ($(this).get(0).nodeName.toLowerCase() == 'img' && typeof($(this).attr('src')) != 'undefined') {
				url = $(this).attr('src');
			}
			
			if (url.length > 0) {
				items.push(url);
			}
		});
	}
	
	//create preloaded image
	var preloading = function() {
		for (var i = 0; i < items.length; i++) {
			if(loadImg(items[i]));
		}
	}
	var loadImg = function(url) {
		var imgLoad = new Image();
		$(imgLoad)
		.load(function() {
			completeLoading();
		})
		.error(function() {
			errors.push($(this).attr('src'));
			completeLoading();
		})
		.attr('src', url);
	}
	
	//update progress bar once image loaded
	var completeLoading = function() {
		current++;

		var per = Math.round((current / items.length) * 100);
		$(jBar).stop().animate({
			width: per + '%'
		}, 500, 'linear');
		
		if(jpreOptions.showPercentage) {
			$(jPer).text(per+"%");
		}
		
		//if all images loaded
		if(current >= items.length) {
			current = items.length;
			setCookie();	//create cookie
			
			if(jpreOptions.showPercentage) {
				$(jPer).text("100%");
			}
			
			//fire debug mode
			if (jpreOptions.debugMode) {
				var error = debug();
			}
			
			
			//max progress bar
			$(jBar).stop().animate({
				width: '100%'
			}, 500, 'linear', function() {
				//autoclose on
				if( jpreOptions.autoClose )
					loadComplete();
				else
					$(jButton).fadeIn(1000);
			});	
		}	
	}
	
	//triggered when all images are loaded
	var loadComplete = function() {
		$(jOverlay).fadeOut(800, function() {
			$(jOverlay).remove();
			onComplete();	//callback function
		});
	}
	
	//debug mode
	var debug = function() {
		if(errors.length > 0) {
			var str = 'ERROR - IMAGE FILES MISSING!!!\n\r'
			str	+= errors.length + ' image files cound not be found. \n\r';	
			str += 'Please check your image paths and filenames:\n\r';
			for (var i = 0; i < errors.length; i++) {
				str += '- ' + errors[i] + '\n\r';
			}
			return true;
		} else {
			return false;
		}
	}
	
	$.fn.jpreLoader = function(options, callback) {
        if(options) {
            $.extend(jpreOptions, options );
        }
		if(typeof callback == 'function') {
			onComplete = callback;
		}
		
		//show preloader once JS loaded
		$('body').css({
			'display': 'block'
		});
		
		return this.each(function() {
			if( !(getCookie()) ) {
				createContainer();
				getImages(this);
				preloading();
			}
			else {	//onetime load / cookie is set
				$(jpreOptions.splashID).remove();
				onComplete();
			}
		});
    };

})(jQuery);
} catch (e) {
console.error('Error in file:/templates/archi/js/jpreLoader.js; Error:' + e.message);
};
try {
/*!
 * Bootstrap v3.3.5 (http://getbootstrap.com)
 * Copyright 2011-2015 Twitter, Inc.
 * Licensed under the MIT license
 */
if("undefined"==typeof jQuery)throw new Error("Bootstrap's JavaScript requires jQuery");+function(a){"use strict";var b=a.fn.jquery.split(" ")[0].split(".");if(b[0]<2&&b[1]<9||1==b[0]&&9==b[1]&&b[2]<1)throw new Error("Bootstrap's JavaScript requires jQuery version 1.9.1 or higher")}(jQuery),+function(a){"use strict";function b(){var a=document.createElement("bootstrap"),b={WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd otransitionend",transition:"transitionend"};for(var c in b)if(void 0!==a.style[c])return{end:b[c]};return!1}a.fn.emulateTransitionEnd=function(b){var c=!1,d=this;a(this).one("bsTransitionEnd",function(){c=!0});var e=function(){c||a(d).trigger(a.support.transition.end)};return setTimeout(e,b),this},a(function(){a.support.transition=b(),a.support.transition&&(a.event.special.bsTransitionEnd={bindType:a.support.transition.end,delegateType:a.support.transition.end,handle:function(b){return a(b.target).is(this)?b.handleObj.handler.apply(this,arguments):void 0}})})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var c=a(this),e=c.data("bs.alert");e||c.data("bs.alert",e=new d(this)),"string"==typeof b&&e[b].call(c)})}var c='[data-dismiss="alert"]',d=function(b){a(b).on("click",c,this.close)};d.VERSION="3.3.5",d.TRANSITION_DURATION=150,d.prototype.close=function(b){function c(){g.detach().trigger("closed.bs.alert").remove()}var e=a(this),f=e.attr("data-target");f||(f=e.attr("href"),f=f&&f.replace(/.*(?=#[^\s]*$)/,""));var g=a(f);b&&b.preventDefault(),g.length||(g=e.closest(".alert")),g.trigger(b=a.Event("close.bs.alert")),b.isDefaultPrevented()||(g.removeClass("in"),a.support.transition&&g.hasClass("fade")?g.one("bsTransitionEnd",c).emulateTransitionEnd(d.TRANSITION_DURATION):c())};var e=a.fn.alert;a.fn.alert=b,a.fn.alert.Constructor=d,a.fn.alert.noConflict=function(){return a.fn.alert=e,this},a(document).on("click.bs.alert.data-api",c,d.prototype.close)}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.button"),f="object"==typeof b&&b;e||d.data("bs.button",e=new c(this,f)),"toggle"==b?e.toggle():b&&e.setState(b)})}var c=function(b,d){this.$element=a(b),this.options=a.extend({},c.DEFAULTS,d),this.isLoading=!1};c.VERSION="3.3.5",c.DEFAULTS={loadingText:"loading..."},c.prototype.setState=function(b){var c="disabled",d=this.$element,e=d.is("input")?"val":"html",f=d.data();b+="Text",null==f.resetText&&d.data("resetText",d[e]()),setTimeout(a.proxy(function(){d[e](null==f[b]?this.options[b]:f[b]),"loadingText"==b?(this.isLoading=!0,d.addClass(c).attr(c,c)):this.isLoading&&(this.isLoading=!1,d.removeClass(c).removeAttr(c))},this),0)},c.prototype.toggle=function(){var a=!0,b=this.$element.closest('[data-toggle="buttons"]');if(b.length){var c=this.$element.find("input");"radio"==c.prop("type")?(c.prop("checked")&&(a=!1),b.find(".active").removeClass("active"),this.$element.addClass("active")):"checkbox"==c.prop("type")&&(c.prop("checked")!==this.$element.hasClass("active")&&(a=!1),this.$element.toggleClass("active")),c.prop("checked",this.$element.hasClass("active")),a&&c.trigger("change")}else this.$element.attr("aria-pressed",!this.$element.hasClass("active")),this.$element.toggleClass("active")};var d=a.fn.button;a.fn.button=b,a.fn.button.Constructor=c,a.fn.button.noConflict=function(){return a.fn.button=d,this},a(document).on("click.bs.button.data-api",'[data-toggle^="button"]',function(c){var d=a(c.target);d.hasClass("btn")||(d=d.closest(".btn")),b.call(d,"toggle"),a(c.target).is('input[type="radio"]')||a(c.target).is('input[type="checkbox"]')||c.preventDefault()}).on("focus.bs.button.data-api blur.bs.button.data-api",'[data-toggle^="button"]',function(b){a(b.target).closest(".btn").toggleClass("focus",/^focus(in)?$/.test(b.type))})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.carousel"),f=a.extend({},c.DEFAULTS,d.data(),"object"==typeof b&&b),g="string"==typeof b?b:f.slide;e||d.data("bs.carousel",e=new c(this,f)),"number"==typeof b?e.to(b):g?e[g]():f.interval&&e.pause().cycle()})}var c=function(b,c){this.$element=a(b),this.$indicators=this.$element.find(".carousel-indicators"),this.options=c,this.paused=null,this.sliding=null,this.interval=null,this.$active=null,this.$items=null,this.options.keyboard&&this.$element.on("keydown.bs.carousel",a.proxy(this.keydown,this)),"hover"==this.options.pause&&!("ontouchstart"in document.documentElement)&&this.$element.on("mouseenter.bs.carousel",a.proxy(this.pause,this)).on("mouseleave.bs.carousel",a.proxy(this.cycle,this))};c.VERSION="3.3.5",c.TRANSITION_DURATION=600,c.DEFAULTS={interval:5e3,pause:"hover",wrap:!0,keyboard:!0},c.prototype.keydown=function(a){if(!/input|textarea/i.test(a.target.tagName)){switch(a.which){case 37:this.prev();break;case 39:this.next();break;default:return}a.preventDefault()}},c.prototype.cycle=function(b){return b||(this.paused=!1),this.interval&&clearInterval(this.interval),this.options.interval&&!this.paused&&(this.interval=setInterval(a.proxy(this.next,this),this.options.interval)),this},c.prototype.getItemIndex=function(a){return this.$items=a.parent().children(".item"),this.$items.index(a||this.$active)},c.prototype.getItemForDirection=function(a,b){var c=this.getItemIndex(b),d="prev"==a&&0===c||"next"==a&&c==this.$items.length-1;if(d&&!this.options.wrap)return b;var e="prev"==a?-1:1,f=(c+e)%this.$items.length;return this.$items.eq(f)},c.prototype.to=function(a){var b=this,c=this.getItemIndex(this.$active=this.$element.find(".item.active"));return a>this.$items.length-1||0>a?void 0:this.sliding?this.$element.one("slid.bs.carousel",function(){b.to(a)}):c==a?this.pause().cycle():this.slide(a>c?"next":"prev",this.$items.eq(a))},c.prototype.pause=function(b){return b||(this.paused=!0),this.$element.find(".next, .prev").length&&a.support.transition&&(this.$element.trigger(a.support.transition.end),this.cycle(!0)),this.interval=clearInterval(this.interval),this},c.prototype.next=function(){return this.sliding?void 0:this.slide("next")},c.prototype.prev=function(){return this.sliding?void 0:this.slide("prev")},c.prototype.slide=function(b,d){var e=this.$element.find(".item.active"),f=d||this.getItemForDirection(b,e),g=this.interval,h="next"==b?"left":"right",i=this;if(f.hasClass("active"))return this.sliding=!1;var j=f[0],k=a.Event("slide.bs.carousel",{relatedTarget:j,direction:h});if(this.$element.trigger(k),!k.isDefaultPrevented()){if(this.sliding=!0,g&&this.pause(),this.$indicators.length){this.$indicators.find(".active").removeClass("active");var l=a(this.$indicators.children()[this.getItemIndex(f)]);l&&l.addClass("active")}var m=a.Event("slid.bs.carousel",{relatedTarget:j,direction:h});return a.support.transition&&this.$element.hasClass("slide")?(f.addClass(b),f[0].offsetWidth,e.addClass(h),f.addClass(h),e.one("bsTransitionEnd",function(){f.removeClass([b,h].join(" ")).addClass("active"),e.removeClass(["active",h].join(" ")),i.sliding=!1,setTimeout(function(){i.$element.trigger(m)},0)}).emulateTransitionEnd(c.TRANSITION_DURATION)):(e.removeClass("active"),f.addClass("active"),this.sliding=!1,this.$element.trigger(m)),g&&this.cycle(),this}};var d=a.fn.carousel;a.fn.carousel=b,a.fn.carousel.Constructor=c,a.fn.carousel.noConflict=function(){return a.fn.carousel=d,this};var e=function(c){var d,e=a(this),f=a(e.attr("data-target")||(d=e.attr("href"))&&d.replace(/.*(?=#[^\s]+$)/,""));if(f.hasClass("carousel")){var g=a.extend({},f.data(),e.data()),h=e.attr("data-slide-to");h&&(g.interval=!1),b.call(f,g),h&&f.data("bs.carousel").to(h),c.preventDefault()}};a(document).on("click.bs.carousel.data-api","[data-slide]",e).on("click.bs.carousel.data-api","[data-slide-to]",e),a(window).on("load",function(){a('[data-ride="carousel"]').each(function(){var c=a(this);b.call(c,c.data())})})}(jQuery),+function(a){"use strict";function b(b){var c,d=b.attr("data-target")||(c=b.attr("href"))&&c.replace(/.*(?=#[^\s]+$)/,"");return a(d)}function c(b){return this.each(function(){var c=a(this),e=c.data("bs.collapse"),f=a.extend({},d.DEFAULTS,c.data(),"object"==typeof b&&b);!e&&f.toggle&&/show|hide/.test(b)&&(f.toggle=!1),e||c.data("bs.collapse",e=new d(this,f)),"string"==typeof b&&e[b]()})}var d=function(b,c){this.$element=a(b),this.options=a.extend({},d.DEFAULTS,c),this.$trigger=a('[data-toggle="collapse"][href="#'+b.id+'"],[data-toggle="collapse"][data-target="#'+b.id+'"]'),this.transitioning=null,this.options.parent?this.$parent=this.getParent():this.addAriaAndCollapsedClass(this.$element,this.$trigger),this.options.toggle&&this.toggle()};d.VERSION="3.3.5",d.TRANSITION_DURATION=350,d.DEFAULTS={toggle:!0},d.prototype.dimension=function(){var a=this.$element.hasClass("width");return a?"width":"height"},d.prototype.show=function(){if(!this.transitioning&&!this.$element.hasClass("in")){var b,e=this.$parent&&this.$parent.children(".panel").children(".in, .collapsing");if(!(e&&e.length&&(b=e.data("bs.collapse"),b&&b.transitioning))){var f=a.Event("show.bs.collapse");if(this.$element.trigger(f),!f.isDefaultPrevented()){e&&e.length&&(c.call(e,"hide"),b||e.data("bs.collapse",null));var g=this.dimension();this.$element.removeClass("collapse").addClass("collapsing")[g](0).attr("aria-expanded",!0),this.$trigger.removeClass("collapsed").attr("aria-expanded",!0),this.transitioning=1;var h=function(){this.$element.removeClass("collapsing").addClass("collapse in")[g](""),this.transitioning=0,this.$element.trigger("shown.bs.collapse")};if(!a.support.transition)return h.call(this);var i=a.camelCase(["scroll",g].join("-"));this.$element.one("bsTransitionEnd",a.proxy(h,this)).emulateTransitionEnd(d.TRANSITION_DURATION)[g](this.$element[0][i])}}}},d.prototype.hide=function(){if(!this.transitioning&&this.$element.hasClass("in")){var b=a.Event("hide.bs.collapse");if(this.$element.trigger(b),!b.isDefaultPrevented()){var c=this.dimension();this.$element[c](this.$element[c]())[0].offsetHeight,this.$element.addClass("collapsing").removeClass("collapse in").attr("aria-expanded",!1),this.$trigger.addClass("collapsed").attr("aria-expanded",!1),this.transitioning=1;var e=function(){this.transitioning=0,this.$element.removeClass("collapsing").addClass("collapse").trigger("hidden.bs.collapse")};return a.support.transition?void this.$element[c](0).one("bsTransitionEnd",a.proxy(e,this)).emulateTransitionEnd(d.TRANSITION_DURATION):e.call(this)}}},d.prototype.toggle=function(){this[this.$element.hasClass("in")?"hide":"show"]()},d.prototype.getParent=function(){return a(this.options.parent).find('[data-toggle="collapse"][data-parent="'+this.options.parent+'"]').each(a.proxy(function(c,d){var e=a(d);this.addAriaAndCollapsedClass(b(e),e)},this)).end()},d.prototype.addAriaAndCollapsedClass=function(a,b){var c=a.hasClass("in");a.attr("aria-expanded",c),b.toggleClass("collapsed",!c).attr("aria-expanded",c)};var e=a.fn.collapse;a.fn.collapse=c,a.fn.collapse.Constructor=d,a.fn.collapse.noConflict=function(){return a.fn.collapse=e,this},a(document).on("click.bs.collapse.data-api",'[data-toggle="collapse"]',function(d){var e=a(this);e.attr("data-target")||d.preventDefault();var f=b(e),g=f.data("bs.collapse"),h=g?"toggle":e.data();c.call(f,h)})}(jQuery),+function(a){"use strict";function b(b){var c=b.attr("data-target");c||(c=b.attr("href"),c=c&&/#[A-Za-z]/.test(c)&&c.replace(/.*(?=#[^\s]*$)/,""));var d=c&&a(c);return d&&d.length?d:b.parent()}function c(c){c&&3===c.which||(a(e).remove(),a(f).each(function(){var d=a(this),e=b(d),f={relatedTarget:this};e.hasClass("open")&&(c&&"click"==c.type&&/input|textarea/i.test(c.target.tagName)&&a.contains(e[0],c.target)||(e.trigger(c=a.Event("hide.bs.dropdown",f)),c.isDefaultPrevented()||(d.attr("aria-expanded","false"),e.removeClass("open").trigger("hidden.bs.dropdown",f))))}))}function d(b){return this.each(function(){var c=a(this),d=c.data("bs.dropdown");d||c.data("bs.dropdown",d=new g(this)),"string"==typeof b&&d[b].call(c)})}var e=".dropdown-backdrop",f='[data-toggle="dropdown"]',g=function(b){a(b).on("click.bs.dropdown",this.toggle)};g.VERSION="3.3.5",g.prototype.toggle=function(d){var e=a(this);if(!e.is(".disabled, :disabled")){var f=b(e),g=f.hasClass("open");if(c(),!g){"ontouchstart"in document.documentElement&&!f.closest(".navbar-nav").length&&a(document.createElement("div")).addClass("dropdown-backdrop").insertAfter(a(this)).on("click",c);var h={relatedTarget:this};if(f.trigger(d=a.Event("show.bs.dropdown",h)),d.isDefaultPrevented())return;e.trigger("focus").attr("aria-expanded","true"),f.toggleClass("open").trigger("shown.bs.dropdown",h)}return!1}},g.prototype.keydown=function(c){if(/(38|40|27|32)/.test(c.which)&&!/input|textarea/i.test(c.target.tagName)){var d=a(this);if(c.preventDefault(),c.stopPropagation(),!d.is(".disabled, :disabled")){var e=b(d),g=e.hasClass("open");if(!g&&27!=c.which||g&&27==c.which)return 27==c.which&&e.find(f).trigger("focus"),d.trigger("click");var h=" li:not(.disabled):visible a",i=e.find(".dropdown-menu"+h);if(i.length){var j=i.index(c.target);38==c.which&&j>0&&j--,40==c.which&&j<i.length-1&&j++,~j||(j=0),i.eq(j).trigger("focus")}}}};var h=a.fn.dropdown;a.fn.dropdown=d,a.fn.dropdown.Constructor=g,a.fn.dropdown.noConflict=function(){return a.fn.dropdown=h,this},a(document).on("click.bs.dropdown.data-api",c).on("click.bs.dropdown.data-api",".dropdown form",function(a){a.stopPropagation()}).on("click.bs.dropdown.data-api",f,g.prototype.toggle).on("keydown.bs.dropdown.data-api",f,g.prototype.keydown).on("keydown.bs.dropdown.data-api",".dropdown-menu",g.prototype.keydown)}(jQuery),+function(a){"use strict";function b(b,d){return this.each(function(){var e=a(this),f=e.data("bs.modal"),g=a.extend({},c.DEFAULTS,e.data(),"object"==typeof b&&b);f||e.data("bs.modal",f=new c(this,g)),"string"==typeof b?f[b](d):g.show&&f.show(d)})}var c=function(b,c){this.options=c,this.$body=a(document.body),this.$element=a(b),this.$dialog=this.$element.find(".modal-dialog"),this.$backdrop=null,this.isShown=null,this.originalBodyPad=null,this.scrollbarWidth=0,this.ignoreBackdropClick=!1,this.options.remote&&this.$element.find(".modal-content").load(this.options.remote,a.proxy(function(){this.$element.trigger("loaded.bs.modal")},this))};c.VERSION="3.3.5",c.TRANSITION_DURATION=300,c.BACKDROP_TRANSITION_DURATION=150,c.DEFAULTS={backdrop:!0,keyboard:!0,show:!0},c.prototype.toggle=function(a){return this.isShown?this.hide():this.show(a)},c.prototype.show=function(b){var d=this,e=a.Event("show.bs.modal",{relatedTarget:b});this.$element.trigger(e),this.isShown||e.isDefaultPrevented()||(this.isShown=!0,this.checkScrollbar(),this.setScrollbar(),this.$body.addClass("modal-open"),this.escape(),this.resize(),this.$element.on("click.dismiss.bs.modal",'[data-dismiss="modal"]',a.proxy(this.hide,this)),this.$dialog.on("mousedown.dismiss.bs.modal",function(){d.$element.one("mouseup.dismiss.bs.modal",function(b){a(b.target).is(d.$element)&&(d.ignoreBackdropClick=!0)})}),this.backdrop(function(){var e=a.support.transition&&d.$element.hasClass("fade");d.$element.parent().length||d.$element.appendTo(d.$body),d.$element.show().scrollTop(0),d.adjustDialog(),e&&d.$element[0].offsetWidth,d.$element.addClass("in"),d.enforceFocus();var f=a.Event("shown.bs.modal",{relatedTarget:b});e?d.$dialog.one("bsTransitionEnd",function(){d.$element.trigger("focus").trigger(f)}).emulateTransitionEnd(c.TRANSITION_DURATION):d.$element.trigger("focus").trigger(f)}))},c.prototype.hide=function(b){b&&b.preventDefault(),b=a.Event("hide.bs.modal"),this.$element.trigger(b),this.isShown&&!b.isDefaultPrevented()&&(this.isShown=!1,this.escape(),this.resize(),a(document).off("focusin.bs.modal"),this.$element.removeClass("in").off("click.dismiss.bs.modal").off("mouseup.dismiss.bs.modal"),this.$dialog.off("mousedown.dismiss.bs.modal"),a.support.transition&&this.$element.hasClass("fade")?this.$element.one("bsTransitionEnd",a.proxy(this.hideModal,this)).emulateTransitionEnd(c.TRANSITION_DURATION):this.hideModal())},c.prototype.enforceFocus=function(){a(document).off("focusin.bs.modal").on("focusin.bs.modal",a.proxy(function(a){this.$element[0]===a.target||this.$element.has(a.target).length||this.$element.trigger("focus")},this))},c.prototype.escape=function(){this.isShown&&this.options.keyboard?this.$element.on("keydown.dismiss.bs.modal",a.proxy(function(a){27==a.which&&this.hide()},this)):this.isShown||this.$element.off("keydown.dismiss.bs.modal")},c.prototype.resize=function(){this.isShown?a(window).on("resize.bs.modal",a.proxy(this.handleUpdate,this)):a(window).off("resize.bs.modal")},c.prototype.hideModal=function(){var a=this;this.$element.hide(),this.backdrop(function(){a.$body.removeClass("modal-open"),a.resetAdjustments(),a.resetScrollbar(),a.$element.trigger("hidden.bs.modal")})},c.prototype.removeBackdrop=function(){this.$backdrop&&this.$backdrop.remove(),this.$backdrop=null},c.prototype.backdrop=function(b){var d=this,e=this.$element.hasClass("fade")?"fade":"";if(this.isShown&&this.options.backdrop){var f=a.support.transition&&e;if(this.$backdrop=a(document.createElement("div")).addClass("modal-backdrop "+e).appendTo(this.$body),this.$element.on("click.dismiss.bs.modal",a.proxy(function(a){return this.ignoreBackdropClick?void(this.ignoreBackdropClick=!1):void(a.target===a.currentTarget&&("static"==this.options.backdrop?this.$element[0].focus():this.hide()))},this)),f&&this.$backdrop[0].offsetWidth,this.$backdrop.addClass("in"),!b)return;f?this.$backdrop.one("bsTransitionEnd",b).emulateTransitionEnd(c.BACKDROP_TRANSITION_DURATION):b()}else if(!this.isShown&&this.$backdrop){this.$backdrop.removeClass("in");var g=function(){d.removeBackdrop(),b&&b()};a.support.transition&&this.$element.hasClass("fade")?this.$backdrop.one("bsTransitionEnd",g).emulateTransitionEnd(c.BACKDROP_TRANSITION_DURATION):g()}else b&&b()},c.prototype.handleUpdate=function(){this.adjustDialog()},c.prototype.adjustDialog=function(){var a=this.$element[0].scrollHeight>document.documentElement.clientHeight;this.$element.css({paddingLeft:!this.bodyIsOverflowing&&a?this.scrollbarWidth:"",paddingRight:this.bodyIsOverflowing&&!a?this.scrollbarWidth:""})},c.prototype.resetAdjustments=function(){this.$element.css({paddingLeft:"",paddingRight:""})},c.prototype.checkScrollbar=function(){var a=window.innerWidth;if(!a){var b=document.documentElement.getBoundingClientRect();a=b.right-Math.abs(b.left)}this.bodyIsOverflowing=document.body.clientWidth<a,this.scrollbarWidth=this.measureScrollbar()},c.prototype.setScrollbar=function(){var a=parseInt(this.$body.css("padding-right")||0,10);this.originalBodyPad=document.body.style.paddingRight||"",this.bodyIsOverflowing&&this.$body.css("padding-right",a+this.scrollbarWidth)},c.prototype.resetScrollbar=function(){this.$body.css("padding-right",this.originalBodyPad)},c.prototype.measureScrollbar=function(){var a=document.createElement("div");a.className="modal-scrollbar-measure",this.$body.append(a);var b=a.offsetWidth-a.clientWidth;return this.$body[0].removeChild(a),b};var d=a.fn.modal;a.fn.modal=b,a.fn.modal.Constructor=c,a.fn.modal.noConflict=function(){return a.fn.modal=d,this},a(document).on("click.bs.modal.data-api",'[data-toggle="modal"]',function(c){var d=a(this),e=d.attr("href"),f=a(d.attr("data-target")||e&&e.replace(/.*(?=#[^\s]+$)/,"")),g=f.data("bs.modal")?"toggle":a.extend({remote:!/#/.test(e)&&e},f.data(),d.data());d.is("a")&&c.preventDefault(),f.one("show.bs.modal",function(a){a.isDefaultPrevented()||f.one("hidden.bs.modal",function(){d.is(":visible")&&d.trigger("focus")})}),b.call(f,g,this)})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.tooltip"),f="object"==typeof b&&b;(e||!/destroy|hide/.test(b))&&(e||d.data("bs.tooltip",e=new c(this,f)),"string"==typeof b&&e[b]())})}var c=function(a,b){this.type=null,this.options=null,this.enabled=null,this.timeout=null,this.hoverState=null,this.$element=null,this.inState=null,this.init("tooltip",a,b)};c.VERSION="3.3.5",c.TRANSITION_DURATION=150,c.DEFAULTS={animation:!0,placement:"top",selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,container:!1,viewport:{selector:"body",padding:0}},c.prototype.init=function(b,c,d){if(this.enabled=!0,this.type=b,this.$element=a(c),this.options=this.getOptions(d),this.$viewport=this.options.viewport&&a(a.isFunction(this.options.viewport)?this.options.viewport.call(this,this.$element):this.options.viewport.selector||this.options.viewport),this.inState={click:!1,hover:!1,focus:!1},this.$element[0]instanceof document.constructor&&!this.options.selector)throw new Error("`selector` option must be specified when initializing "+this.type+" on the window.document object!");for(var e=this.options.trigger.split(" "),f=e.length;f--;){var g=e[f];if("click"==g)this.$element.on("click."+this.type,this.options.selector,a.proxy(this.toggle,this));else if("manual"!=g){var h="hover"==g?"mouseenter":"focusin",i="hover"==g?"mouseleave":"focusout";this.$element.on(h+"."+this.type,this.options.selector,a.proxy(this.enter,this)),this.$element.on(i+"."+this.type,this.options.selector,a.proxy(this.leave,this))}}this.options.selector?this._options=a.extend({},this.options,{trigger:"manual",selector:""}):this.fixTitle()},c.prototype.getDefaults=function(){return c.DEFAULTS},c.prototype.getOptions=function(b){return b=a.extend({},this.getDefaults(),this.$element.data(),b),b.delay&&"number"==typeof b.delay&&(b.delay={show:b.delay,hide:b.delay}),b},c.prototype.getDelegateOptions=function(){var b={},c=this.getDefaults();return this._options&&a.each(this._options,function(a,d){c[a]!=d&&(b[a]=d)}),b},c.prototype.enter=function(b){var c=b instanceof this.constructor?b:a(b.currentTarget).data("bs."+this.type);return c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data("bs."+this.type,c)),b instanceof a.Event&&(c.inState["focusin"==b.type?"focus":"hover"]=!0),c.tip().hasClass("in")||"in"==c.hoverState?void(c.hoverState="in"):(clearTimeout(c.timeout),c.hoverState="in",c.options.delay&&c.options.delay.show?void(c.timeout=setTimeout(function(){"in"==c.hoverState&&c.show()},c.options.delay.show)):c.show())},c.prototype.isInStateTrue=function(){for(var a in this.inState)if(this.inState[a])return!0;return!1},c.prototype.leave=function(b){var c=b instanceof this.constructor?b:a(b.currentTarget).data("bs."+this.type);return c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data("bs."+this.type,c)),b instanceof a.Event&&(c.inState["focusout"==b.type?"focus":"hover"]=!1),c.isInStateTrue()?void 0:(clearTimeout(c.timeout),c.hoverState="out",c.options.delay&&c.options.delay.hide?void(c.timeout=setTimeout(function(){"out"==c.hoverState&&c.hide()},c.options.delay.hide)):c.hide())},c.prototype.show=function(){var b=a.Event("show.bs."+this.type);if(this.hasContent()&&this.enabled){this.$element.trigger(b);var d=a.contains(this.$element[0].ownerDocument.documentElement,this.$element[0]);if(b.isDefaultPrevented()||!d)return;var e=this,f=this.tip(),g=this.getUID(this.type);this.setContent(),f.attr("id",g),this.$element.attr("aria-describedby",g),this.options.animation&&f.addClass("fade");var h="function"==typeof this.options.placement?this.options.placement.call(this,f[0],this.$element[0]):this.options.placement,i=/\s?auto?\s?/i,j=i.test(h);j&&(h=h.replace(i,"")||"top"),f.detach().css({top:0,left:0,display:"block"}).addClass(h).data("bs."+this.type,this),this.options.container?f.appendTo(this.options.container):f.insertAfter(this.$element),this.$element.trigger("inserted.bs."+this.type);var k=this.getPosition(),l=f[0].offsetWidth,m=f[0].offsetHeight;if(j){var n=h,o=this.getPosition(this.$viewport);h="bottom"==h&&k.bottom+m>o.bottom?"top":"top"==h&&k.top-m<o.top?"bottom":"right"==h&&k.right+l>o.width?"left":"left"==h&&k.left-l<o.left?"right":h,f.removeClass(n).addClass(h)}var p=this.getCalculatedOffset(h,k,l,m);this.applyPlacement(p,h);var q=function(){var a=e.hoverState;e.$element.trigger("shown.bs."+e.type),e.hoverState=null,"out"==a&&e.leave(e)};a.support.transition&&this.$tip.hasClass("fade")?f.one("bsTransitionEnd",q).emulateTransitionEnd(c.TRANSITION_DURATION):q()}},c.prototype.applyPlacement=function(b,c){var d=this.tip(),e=d[0].offsetWidth,f=d[0].offsetHeight,g=parseInt(d.css("margin-top"),10),h=parseInt(d.css("margin-left"),10);isNaN(g)&&(g=0),isNaN(h)&&(h=0),b.top+=g,b.left+=h,a.offset.setOffset(d[0],a.extend({using:function(a){d.css({top:Math.round(a.top),left:Math.round(a.left)})}},b),0),d.addClass("in");var i=d[0].offsetWidth,j=d[0].offsetHeight;"top"==c&&j!=f&&(b.top=b.top+f-j);var k=this.getViewportAdjustedDelta(c,b,i,j);k.left?b.left+=k.left:b.top+=k.top;var l=/top|bottom/.test(c),m=l?2*k.left-e+i:2*k.top-f+j,n=l?"offsetWidth":"offsetHeight";d.offset(b),this.replaceArrow(m,d[0][n],l)},c.prototype.replaceArrow=function(a,b,c){this.arrow().css(c?"left":"top",50*(1-a/b)+"%").css(c?"top":"left","")},c.prototype.setContent=function(){var a=this.tip(),b=this.getTitle();a.find(".tooltip-inner")[this.options.html?"html":"text"](b),a.removeClass("fade in top bottom left right")},c.prototype.hide=function(b){function d(){"in"!=e.hoverState&&f.detach(),e.$element.removeAttr("aria-describedby").trigger("hidden.bs."+e.type),b&&b()}var e=this,f=a(this.$tip),g=a.Event("hide.bs."+this.type);return this.$element.trigger(g),g.isDefaultPrevented()?void 0:(f.removeClass("in"),a.support.transition&&f.hasClass("fade")?f.one("bsTransitionEnd",d).emulateTransitionEnd(c.TRANSITION_DURATION):d(),this.hoverState=null,this)},c.prototype.fixTitle=function(){var a=this.$element;(a.attr("title")||"string"!=typeof a.attr("data-original-title"))&&a.attr("data-original-title",a.attr("title")||"").attr("title","")},c.prototype.hasContent=function(){return this.getTitle()},c.prototype.getPosition=function(b){b=b||this.$element;var c=b[0],d="BODY"==c.tagName,e=c.getBoundingClientRect();null==e.width&&(e=a.extend({},e,{width:e.right-e.left,height:e.bottom-e.top}));var f=d?{top:0,left:0}:b.offset(),g={scroll:d?document.documentElement.scrollTop||document.body.scrollTop:b.scrollTop()},h=d?{width:a(window).width(),height:a(window).height()}:null;return a.extend({},e,g,h,f)},c.prototype.getCalculatedOffset=function(a,b,c,d){return"bottom"==a?{top:b.top+b.height,left:b.left+b.width/2-c/2}:"top"==a?{top:b.top-d,left:b.left+b.width/2-c/2}:"left"==a?{top:b.top+b.height/2-d/2,left:b.left-c}:{top:b.top+b.height/2-d/2,left:b.left+b.width}},c.prototype.getViewportAdjustedDelta=function(a,b,c,d){var e={top:0,left:0};if(!this.$viewport)return e;var f=this.options.viewport&&this.options.viewport.padding||0,g=this.getPosition(this.$viewport);if(/right|left/.test(a)){var h=b.top-f-g.scroll,i=b.top+f-g.scroll+d;h<g.top?e.top=g.top-h:i>g.top+g.height&&(e.top=g.top+g.height-i)}else{var j=b.left-f,k=b.left+f+c;j<g.left?e.left=g.left-j:k>g.right&&(e.left=g.left+g.width-k)}return e},c.prototype.getTitle=function(){var a,b=this.$element,c=this.options;return a=b.attr("data-original-title")||("function"==typeof c.title?c.title.call(b[0]):c.title)},c.prototype.getUID=function(a){do a+=~~(1e6*Math.random());while(document.getElementById(a));return a},c.prototype.tip=function(){if(!this.$tip&&(this.$tip=a(this.options.template),1!=this.$tip.length))throw new Error(this.type+" `template` option must consist of exactly 1 top-level element!");return this.$tip},c.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(".tooltip-arrow")},c.prototype.enable=function(){this.enabled=!0},c.prototype.disable=function(){this.enabled=!1},c.prototype.toggleEnabled=function(){this.enabled=!this.enabled},c.prototype.toggle=function(b){var c=this;b&&(c=a(b.currentTarget).data("bs."+this.type),c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data("bs."+this.type,c))),b?(c.inState.click=!c.inState.click,c.isInStateTrue()?c.enter(c):c.leave(c)):c.tip().hasClass("in")?c.leave(c):c.enter(c)},c.prototype.destroy=function(){var a=this;clearTimeout(this.timeout),this.hide(function(){a.$element.off("."+a.type).removeData("bs."+a.type),a.$tip&&a.$tip.detach(),a.$tip=null,a.$arrow=null,a.$viewport=null})};var d=a.fn.tooltip;a.fn.tooltip=b,a.fn.tooltip.Constructor=c,a.fn.tooltip.noConflict=function(){return a.fn.tooltip=d,this}}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.popover"),f="object"==typeof b&&b;(e||!/destroy|hide/.test(b))&&(e||d.data("bs.popover",e=new c(this,f)),"string"==typeof b&&e[b]())})}var c=function(a,b){this.init("popover",a,b)};if(!a.fn.tooltip)throw new Error("Popover requires tooltip.js");c.VERSION="3.3.5",c.DEFAULTS=a.extend({},a.fn.tooltip.Constructor.DEFAULTS,{placement:"right",trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'}),c.prototype=a.extend({},a.fn.tooltip.Constructor.prototype),c.prototype.constructor=c,c.prototype.getDefaults=function(){return c.DEFAULTS},c.prototype.setContent=function(){var a=this.tip(),b=this.getTitle(),c=this.getContent();a.find(".popover-title")[this.options.html?"html":"text"](b),a.find(".popover-content").children().detach().end()[this.options.html?"string"==typeof c?"html":"append":"text"](c),a.removeClass("fade top bottom left right in"),a.find(".popover-title").html()||a.find(".popover-title").hide()},c.prototype.hasContent=function(){return this.getTitle()||this.getContent()},c.prototype.getContent=function(){var a=this.$element,b=this.options;return a.attr("data-content")||("function"==typeof b.content?b.content.call(a[0]):b.content)},c.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(".arrow")};var d=a.fn.popover;a.fn.popover=b,a.fn.popover.Constructor=c,a.fn.popover.noConflict=function(){return a.fn.popover=d,this}}(jQuery),+function(a){"use strict";function b(c,d){this.$body=a(document.body),this.$scrollElement=a(a(c).is(document.body)?window:c),this.options=a.extend({},b.DEFAULTS,d),this.selector=(this.options.target||"")+" .nav li > a",this.offsets=[],this.targets=[],this.activeTarget=null,this.scrollHeight=0,this.$scrollElement.on("scroll.bs.scrollspy",a.proxy(this.process,this)),this.refresh(),this.process()}function c(c){return this.each(function(){var d=a(this),e=d.data("bs.scrollspy"),f="object"==typeof c&&c;e||d.data("bs.scrollspy",e=new b(this,f)),"string"==typeof c&&e[c]()})}b.VERSION="3.3.5",b.DEFAULTS={offset:10},b.prototype.getScrollHeight=function(){return this.$scrollElement[0].scrollHeight||Math.max(this.$body[0].scrollHeight,document.documentElement.scrollHeight)},b.prototype.refresh=function(){var b=this,c="offset",d=0;this.offsets=[],this.targets=[],this.scrollHeight=this.getScrollHeight(),a.isWindow(this.$scrollElement[0])||(c="position",d=this.$scrollElement.scrollTop()),this.$body.find(this.selector).map(function(){var b=a(this),e=b.data("target")||b.attr("href"),f=/^#./.test(e)&&a(e);return f&&f.length&&f.is(":visible")&&[[f[c]().top+d,e]]||null}).sort(function(a,b){return a[0]-b[0]}).each(function(){b.offsets.push(this[0]),b.targets.push(this[1])})},b.prototype.process=function(){var a,b=this.$scrollElement.scrollTop()+this.options.offset,c=this.getScrollHeight(),d=this.options.offset+c-this.$scrollElement.height(),e=this.offsets,f=this.targets,g=this.activeTarget;if(this.scrollHeight!=c&&this.refresh(),b>=d)return g!=(a=f[f.length-1])&&this.activate(a);if(g&&b<e[0])return this.activeTarget=null,this.clear();for(a=e.length;a--;)g!=f[a]&&b>=e[a]&&(void 0===e[a+1]||b<e[a+1])&&this.activate(f[a])},b.prototype.activate=function(b){this.activeTarget=b,this.clear();var c=this.selector+'[data-target="'+b+'"],'+this.selector+'[href="'+b+'"]',d=a(c).parents("li").addClass("active");d.parent(".dropdown-menu").length&&(d=d.closest("li.dropdown").addClass("active")),
d.trigger("activate.bs.scrollspy")},b.prototype.clear=function(){a(this.selector).parentsUntil(this.options.target,".active").removeClass("active")};var d=a.fn.scrollspy;a.fn.scrollspy=c,a.fn.scrollspy.Constructor=b,a.fn.scrollspy.noConflict=function(){return a.fn.scrollspy=d,this},a(window).on("load.bs.scrollspy.data-api",function(){a('[data-spy="scroll"]').each(function(){var b=a(this);c.call(b,b.data())})})}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.tab");e||d.data("bs.tab",e=new c(this)),"string"==typeof b&&e[b]()})}var c=function(b){this.element=a(b)};c.VERSION="3.3.5",c.TRANSITION_DURATION=150,c.prototype.show=function(){var b=this.element,c=b.closest("ul:not(.dropdown-menu)"),d=b.data("target");if(d||(d=b.attr("href"),d=d&&d.replace(/.*(?=#[^\s]*$)/,"")),!b.parent("li").hasClass("active")){var e=c.find(".active:last a"),f=a.Event("hide.bs.tab",{relatedTarget:b[0]}),g=a.Event("show.bs.tab",{relatedTarget:e[0]});if(e.trigger(f),b.trigger(g),!g.isDefaultPrevented()&&!f.isDefaultPrevented()){var h=a(d);this.activate(b.closest("li"),c),this.activate(h,h.parent(),function(){e.trigger({type:"hidden.bs.tab",relatedTarget:b[0]}),b.trigger({type:"shown.bs.tab",relatedTarget:e[0]})})}}},c.prototype.activate=function(b,d,e){function f(){g.removeClass("active").find("> .dropdown-menu > .active").removeClass("active").end().find('[data-toggle="tab"]').attr("aria-expanded",!1),b.addClass("active").find('[data-toggle="tab"]').attr("aria-expanded",!0),h?(b[0].offsetWidth,b.addClass("in")):b.removeClass("fade"),b.parent(".dropdown-menu").length&&b.closest("li.dropdown").addClass("active").end().find('[data-toggle="tab"]').attr("aria-expanded",!0),e&&e()}var g=d.find("> .active"),h=e&&a.support.transition&&(g.length&&g.hasClass("fade")||!!d.find("> .fade").length);g.length&&h?g.one("bsTransitionEnd",f).emulateTransitionEnd(c.TRANSITION_DURATION):f(),g.removeClass("in")};var d=a.fn.tab;a.fn.tab=b,a.fn.tab.Constructor=c,a.fn.tab.noConflict=function(){return a.fn.tab=d,this};var e=function(c){c.preventDefault(),b.call(a(this),"show")};a(document).on("click.bs.tab.data-api",'[data-toggle="tab"]',e).on("click.bs.tab.data-api",'[data-toggle="pill"]',e)}(jQuery),+function(a){"use strict";function b(b){return this.each(function(){var d=a(this),e=d.data("bs.affix"),f="object"==typeof b&&b;e||d.data("bs.affix",e=new c(this,f)),"string"==typeof b&&e[b]()})}var c=function(b,d){this.options=a.extend({},c.DEFAULTS,d),this.$target=a(this.options.target).on("scroll.bs.affix.data-api",a.proxy(this.checkPosition,this)).on("click.bs.affix.data-api",a.proxy(this.checkPositionWithEventLoop,this)),this.$element=a(b),this.affixed=null,this.unpin=null,this.pinnedOffset=null,this.checkPosition()};c.VERSION="3.3.5",c.RESET="affix affix-top affix-bottom",c.DEFAULTS={offset:0,target:window},c.prototype.getState=function(a,b,c,d){var e=this.$target.scrollTop(),f=this.$element.offset(),g=this.$target.height();if(null!=c&&"top"==this.affixed)return c>e?"top":!1;if("bottom"==this.affixed)return null!=c?e+this.unpin<=f.top?!1:"bottom":a-d>=e+g?!1:"bottom";var h=null==this.affixed,i=h?e:f.top,j=h?g:b;return null!=c&&c>=e?"top":null!=d&&i+j>=a-d?"bottom":!1},c.prototype.getPinnedOffset=function(){if(this.pinnedOffset)return this.pinnedOffset;this.$element.removeClass(c.RESET).addClass("affix");var a=this.$target.scrollTop(),b=this.$element.offset();return this.pinnedOffset=b.top-a},c.prototype.checkPositionWithEventLoop=function(){setTimeout(a.proxy(this.checkPosition,this),1)},c.prototype.checkPosition=function(){if(this.$element.is(":visible")){var b=this.$element.height(),d=this.options.offset,e=d.top,f=d.bottom,g=Math.max(a(document).height(),a(document.body).height());"object"!=typeof d&&(f=e=d),"function"==typeof e&&(e=d.top(this.$element)),"function"==typeof f&&(f=d.bottom(this.$element));var h=this.getState(g,b,e,f);if(this.affixed!=h){null!=this.unpin&&this.$element.css("top","");var i="affix"+(h?"-"+h:""),j=a.Event(i+".bs.affix");if(this.$element.trigger(j),j.isDefaultPrevented())return;this.affixed=h,this.unpin="bottom"==h?this.getPinnedOffset():null,this.$element.removeClass(c.RESET).addClass(i).trigger(i.replace("affix","affixed")+".bs.affix")}"bottom"==h&&this.$element.offset({top:g-b-f})}};var d=a.fn.affix;a.fn.affix=b,a.fn.affix.Constructor=c,a.fn.affix.noConflict=function(){return a.fn.affix=d,this},a(window).on("load",function(){a('[data-spy="affix"]').each(function(){var c=a(this),d=c.data();d.offset=d.offset||{},null!=d.offsetBottom&&(d.offset.bottom=d.offsetBottom),null!=d.offsetTop&&(d.offset.top=d.offsetTop),b.call(c,d)})})}(jQuery);
} catch (e) {
console.error('Error in file:/templates/archi/js/bootstrap.min.js; Error:' + e.message);
};
try {
/**
 * Isotope v1.5.25
 * An exquisite jQuery plugin for magical layouts
 * http://isotope.metafizzy.co
 *
 * Commercial use requires one-time purchase of a commercial license
 * http://isotope.metafizzy.co/docs/license.html
 *
 * Non-commercial use is licensed under the MIT License
 *
 * Copyright 2013 Metafizzy
 */
(function(a,b,c){"use strict";var d=a.document,e=a.Modernizr,f=function(a){return a.charAt(0).toUpperCase()+a.slice(1)},g="Moz Webkit O Ms".split(" "),h=function(a){var b=d.documentElement.style,c;if(typeof b[a]=="string")return a;a=f(a);for(var e=0,h=g.length;e<h;e++){c=g[e]+a;if(typeof b[c]=="string")return c}},i=h("transform"),j=h("transitionProperty"),k={csstransforms:function(){return!!i},csstransforms3d:function(){var a=!!h("perspective");if(a){var c=" -o- -moz- -ms- -webkit- -khtml- ".split(" "),d="@media ("+c.join("transform-3d),(")+"modernizr)",e=b("<style>"+d+"{#modernizr{height:3px}}"+"</style>").appendTo("head"),f=b('<div id="modernizr" />').appendTo("html");a=f.height()===3,f.remove(),e.remove()}return a},csstransitions:function(){return!!j}},l;if(e)for(l in k)e.hasOwnProperty(l)||e.addTest(l,k[l]);else{e=a.Modernizr={_version:"1.6ish: miniModernizr for Isotope"};var m=" ",n;for(l in k)n=k[l](),e[l]=n,m+=" "+(n?"":"no-")+l;b("html").addClass(m)}if(e.csstransforms){var o=e.csstransforms3d?{translate:function(a){return"translate3d("+a[0]+"px, "+a[1]+"px, 0) "},scale:function(a){return"scale3d("+a+", "+a+", 1) "}}:{translate:function(a){return"translate("+a[0]+"px, "+a[1]+"px) "},scale:function(a){return"scale("+a+") "}},p=function(a,c,d){var e=b.data(a,"isoTransform")||{},f={},g,h={},j;f[c]=d,b.extend(e,f);for(g in e)j=e[g],h[g]=o[g](j);var k=h.translate||"",l=h.scale||"",m=k+l;b.data(a,"isoTransform",e),a.style[i]=m};b.cssNumber.scale=!0,b.cssHooks.scale={set:function(a,b){p(a,"scale",b)},get:function(a,c){var d=b.data(a,"isoTransform");return d&&d.scale?d.scale:1}},b.fx.step.scale=function(a){b.cssHooks.scale.set(a.elem,a.now+a.unit)},b.cssNumber.translate=!0,b.cssHooks.translate={set:function(a,b){p(a,"translate",b)},get:function(a,c){var d=b.data(a,"isoTransform");return d&&d.translate?d.translate:[0,0]}}}var q,r;e.csstransitions&&(q={WebkitTransitionProperty:"webkitTransitionEnd",MozTransitionProperty:"transitionend",OTransitionProperty:"oTransitionEnd otransitionend",transitionProperty:"transitionend"}[j],r=h("transitionDuration"));var s=b.event,t=b.event.handle?"handle":"dispatch",u;s.special.smartresize={setup:function(){b(this).bind("resize",s.special.smartresize.handler)},teardown:function(){b(this).unbind("resize",s.special.smartresize.handler)},handler:function(a,b){var c=this,d=arguments;a.type="smartresize",u&&clearTimeout(u),u=setTimeout(function(){s[t].apply(c,d)},b==="execAsap"?0:100)}},b.fn.smartresize=function(a){return a?this.bind("smartresize",a):this.trigger("smartresize",["execAsap"])},b.Isotope=function(a,c,d){this.element=b(c),this._create(a),this._init(d)};var v=["width","height"],w=b(a);b.Isotope.settings={resizable:!0,layoutMode:"masonry",containerClass:"isotope",itemClass:"isotope-item",hiddenClass:"isotope-hidden",hiddenStyle:{opacity:0,scale:.001},visibleStyle:{opacity:1,scale:1},containerStyle:{position:"relative",overflow:"hidden"},animationEngine:"best-available",animationOptions:{queue:!1,duration:800},sortBy:"original-order",sortAscending:!0,resizesContainer:!0,transformsEnabled:!0,itemPositionDataEnabled:!1},b.Isotope.prototype={_create:function(a){this.options=b.extend({},b.Isotope.settings,a),this.styleQueue=[],this.elemCount=0;var c=this.element[0].style;this.originalStyle={};var d=v.slice(0);for(var e in this.options.containerStyle)d.push(e);for(var f=0,g=d.length;f<g;f++)e=d[f],this.originalStyle[e]=c[e]||"";this.element.css(this.options.containerStyle),this._updateAnimationEngine(),this._updateUsingTransforms();var h={"original-order":function(a,b){return b.elemCount++,b.elemCount},random:function(){return Math.random()}};this.options.getSortData=b.extend(this.options.getSortData,h),this.reloadItems(),this.offset={left:parseInt(this.element.css("padding-left")||0,10),top:parseInt(this.element.css("padding-top")||0,10)};var i=this;setTimeout(function(){i.element.addClass(i.options.containerClass)},0),this.options.resizable&&w.bind("smartresize.isotope",function(){i.resize()}),this.element.delegate("."+this.options.hiddenClass,"click",function(){return!1})},_getAtoms:function(a){var b=this.options.itemSelector,c=b?a.filter(b).add(a.find(b)):a,d={position:"absolute"};return c=c.filter(function(a,b){return b.nodeType===1}),this.usingTransforms&&(d.left=0,d.top=0),c.css(d).addClass(this.options.itemClass),this.updateSortData(c,!0),c},_init:function(a){this.$filteredAtoms=this._filter(this.$allAtoms),this._sort(),this.reLayout(a)},option:function(a){if(b.isPlainObject(a)){this.options=b.extend(!0,this.options,a);var c;for(var d in a)c="_update"+f(d),this[c]&&this[c]()}},_updateAnimationEngine:function(){var a=this.options.animationEngine.toLowerCase().replace(/[ _\-]/g,""),b;switch(a){case"css":case"none":b=!1;break;case"jquery":b=!0;break;default:b=!e.csstransitions}this.isUsingJQueryAnimation=b,this._updateUsingTransforms()},_updateTransformsEnabled:function(){this._updateUsingTransforms()},_updateUsingTransforms:function(){var a=this.usingTransforms=this.options.transformsEnabled&&e.csstransforms&&e.csstransitions&&!this.isUsingJQueryAnimation;a||(delete this.options.hiddenStyle.scale,delete this.options.visibleStyle.scale),this.getPositionStyles=a?this._translate:this._positionAbs},_filter:function(a){var b=this.options.filter===""?"*":this.options.filter;if(!b)return a;var c=this.options.hiddenClass,d="."+c,e=a.filter(d),f=e;if(b!=="*"){f=e.filter(b);var g=a.not(d).not(b).addClass(c);this.styleQueue.push({$el:g,style:this.options.hiddenStyle})}return this.styleQueue.push({$el:f,style:this.options.visibleStyle}),f.removeClass(c),a.filter(b)},updateSortData:function(a,c){var d=this,e=this.options.getSortData,f,g;a.each(function(){f=b(this),g={};for(var a in e)!c&&a==="original-order"?g[a]=b.data(this,"isotope-sort-data")[a]:g[a]=e[a](f,d);b.data(this,"isotope-sort-data",g)})},_sort:function(){var a=this.options.sortBy,b=this._getSorter,c=this.options.sortAscending?1:-1,d=function(d,e){var f=b(d,a),g=b(e,a);return f===g&&a!=="original-order"&&(f=b(d,"original-order"),g=b(e,"original-order")),(f>g?1:f<g?-1:0)*c};this.$filteredAtoms.sort(d)},_getSorter:function(a,c){return b.data(a,"isotope-sort-data")[c]},_translate:function(a,b){return{translate:[a,b]}},_positionAbs:function(a,b){return{left:a,top:b}},_pushPosition:function(a,b,c){b=Math.round(b+this.offset.left),c=Math.round(c+this.offset.top);var d=this.getPositionStyles(b,c);this.styleQueue.push({$el:a,style:d}),this.options.itemPositionDataEnabled&&a.data("isotope-item-position",{x:b,y:c})},layout:function(a,b){var c=this.options.layoutMode;this["_"+c+"Layout"](a);if(this.options.resizesContainer){var d=this["_"+c+"GetContainerSize"]();this.styleQueue.push({$el:this.element,style:d})}this._processStyleQueue(a,b),this.isLaidOut=!0},_processStyleQueue:function(a,c){var d=this.isLaidOut?this.isUsingJQueryAnimation?"animate":"css":"css",f=this.options.animationOptions,g=this.options.onLayout,h,i,j,k;i=function(a,b){b.$el[d](b.style,f)};if(this._isInserting&&this.isUsingJQueryAnimation)i=function(a,b){h=b.$el.hasClass("no-transition")?"css":d,b.$el[h](b.style,f)};else if(c||g||f.complete){var l=!1,m=[c,g,f.complete],n=this;j=!0,k=function(){if(l)return;var b;for(var c=0,d=m.length;c<d;c++)b=m[c],typeof b=="function"&&b.call(n.element,a,n);l=!0};if(this.isUsingJQueryAnimation&&d==="animate")f.complete=k,j=!1;else if(e.csstransitions){var o=0,p=this.styleQueue[0],s=p&&p.$el,t;while(!s||!s.length){t=this.styleQueue[o++];if(!t)return;s=t.$el}var u=parseFloat(getComputedStyle(s[0])[r]);u>0&&(i=function(a,b){b.$el[d](b.style,f).one(q,k)},j=!1)}}b.each(this.styleQueue,i),j&&k(),this.styleQueue=[]},resize:function(){this["_"+this.options.layoutMode+"ResizeChanged"]()&&this.reLayout()},reLayout:function(a){this["_"+this.options.layoutMode+"Reset"](),this.layout(this.$filteredAtoms,a)},addItems:function(a,b){var c=this._getAtoms(a);this.$allAtoms=this.$allAtoms.add(c),b&&b(c)},insert:function(a,b){this.element.append(a);var c=this;this.addItems(a,function(a){var d=c._filter(a);c._addHideAppended(d),c._sort(),c.reLayout(),c._revealAppended(d,b)})},appended:function(a,b){var c=this;this.addItems(a,function(a){c._addHideAppended(a),c.layout(a),c._revealAppended(a,b)})},_addHideAppended:function(a){this.$filteredAtoms=this.$filteredAtoms.add(a),a.addClass("no-transition"),this._isInserting=!0,this.styleQueue.push({$el:a,style:this.options.hiddenStyle})},_revealAppended:function(a,b){var c=this;setTimeout(function(){a.removeClass("no-transition"),c.styleQueue.push({$el:a,style:c.options.visibleStyle}),c._isInserting=!1,c._processStyleQueue(a,b)},10)},reloadItems:function(){this.$allAtoms=this._getAtoms(this.element.children())},remove:function(a,b){this.$allAtoms=this.$allAtoms.not(a),this.$filteredAtoms=this.$filteredAtoms.not(a);var c=this,d=function(){a.remove(),b&&b.call(c.element)};a.filter(":not(."+this.options.hiddenClass+")").length?(this.styleQueue.push({$el:a,style:this.options.hiddenStyle}),this._sort(),this.reLayout(d)):d()},shuffle:function(a){this.updateSortData(this.$allAtoms),this.options.sortBy="random",this._sort(),this.reLayout(a)},destroy:function(){var a=this.usingTransforms,b=this.options;this.$allAtoms.removeClass(b.hiddenClass+" "+b.itemClass).each(function(){var b=this.style;b.position="",b.top="",b.left="",b.opacity="",a&&(b[i]="")});var c=this.element[0].style;for(var d in this.originalStyle)c[d]=this.originalStyle[d];this.element.unbind(".isotope").undelegate("."+b.hiddenClass,"click").removeClass(b.containerClass).removeData("isotope"),w.unbind(".isotope")},_getSegments:function(a){var b=this.options.layoutMode,c=a?"rowHeight":"columnWidth",d=a?"height":"width",e=a?"rows":"cols",g=this.element[d](),h,i=this.options[b]&&this.options[b][c]||this.$filteredAtoms["outer"+f(d)](!0)||g;h=Math.floor(g/i),h=Math.max(h,1),this[b][e]=h,this[b][c]=i},_checkIfSegmentsChanged:function(a){var b=this.options.layoutMode,c=a?"rows":"cols",d=this[b][c];return this._getSegments(a),this[b][c]!==d},_masonryReset:function(){this.masonry={},this._getSegments();var a=this.masonry.cols;this.masonry.colYs=[];while(a--)this.masonry.colYs.push(0)},_masonryLayout:function(a){var c=this,d=c.masonry;a.each(function(){var a=b(this),e=Math.ceil(a.outerWidth(!0)/d.columnWidth);e=Math.min(e,d.cols);if(e===1)c._masonryPlaceBrick(a,d.colYs);else{var f=d.cols+1-e,g=[],h,i;for(i=0;i<f;i++)h=d.colYs.slice(i,i+e),g[i]=Math.max.apply(Math,h);c._masonryPlaceBrick(a,g)}})},_masonryPlaceBrick:function(a,b){var c=Math.min.apply(Math,b),d=0;for(var e=0,f=b.length;e<f;e++)if(b[e]===c){d=e;break}var g=this.masonry.columnWidth*d,h=c;this._pushPosition(a,g,h);var i=c+a.outerHeight(!0),j=this.masonry.cols+1-f;for(e=0;e<j;e++)this.masonry.colYs[d+e]=i},_masonryGetContainerSize:function(){var a=Math.max.apply(Math,this.masonry.colYs);return{height:a}},_masonryResizeChanged:function(){return this._checkIfSegmentsChanged()},_fitRowsReset:function(){this.fitRows={x:0,y:0,height:0}},_fitRowsLayout:function(a){var c=this,d=this.element.width(),e=this.fitRows;a.each(function(){var a=b(this),f=a.outerWidth(!0),g=a.outerHeight(!0);e.x!==0&&f+e.x>d&&(e.x=0,e.y=e.height),c._pushPosition(a,e.x,e.y),e.height=Math.max(e.y+g,e.height),e.x+=f})},_fitRowsGetContainerSize:function(){return{height:this.fitRows.height}},_fitRowsResizeChanged:function(){return!0},_cellsByRowReset:function(){this.cellsByRow={index:0},this._getSegments(),this._getSegments(!0)},_cellsByRowLayout:function(a){var c=this,d=this.cellsByRow;a.each(function(){var a=b(this),e=d.index%d.cols,f=Math.floor(d.index/d.cols),g=(e+.5)*d.columnWidth-a.outerWidth(!0)/2,h=(f+.5)*d.rowHeight-a.outerHeight(!0)/2;c._pushPosition(a,g,h),d.index++})},_cellsByRowGetContainerSize:function(){return{height:Math.ceil(this.$filteredAtoms.length/this.cellsByRow.cols)*this.cellsByRow.rowHeight+this.offset.top}},_cellsByRowResizeChanged:function(){return this._checkIfSegmentsChanged()},_straightDownReset:function(){this.straightDown={y:0}},_straightDownLayout:function(a){var c=this;a.each(function(a){var d=b(this);c._pushPosition(d,0,c.straightDown.y),c.straightDown.y+=d.outerHeight(!0)})},_straightDownGetContainerSize:function(){return{height:this.straightDown.y}},_straightDownResizeChanged:function(){return!0},_masonryHorizontalReset:function(){this.masonryHorizontal={},this._getSegments(!0);var a=this.masonryHorizontal.rows;this.masonryHorizontal.rowXs=[];while(a--)this.masonryHorizontal.rowXs.push(0)},_masonryHorizontalLayout:function(a){var c=this,d=c.masonryHorizontal;a.each(function(){var a=b(this),e=Math.ceil(a.outerHeight(!0)/d.rowHeight);e=Math.min(e,d.rows);if(e===1)c._masonryHorizontalPlaceBrick(a,d.rowXs);else{var f=d.rows+1-e,g=[],h,i;for(i=0;i<f;i++)h=d.rowXs.slice(i,i+e),g[i]=Math.max.apply(Math,h);c._masonryHorizontalPlaceBrick(a,g)}})},_masonryHorizontalPlaceBrick:function(a,b){var c=Math.min.apply(Math,b),d=0;for(var e=0,f=b.length;e<f;e++)if(b[e]===c){d=e;break}var g=c,h=this.masonryHorizontal.rowHeight*d;this._pushPosition(a,g,h);var i=c+a.outerWidth(!0),j=this.masonryHorizontal.rows+1-f;for(e=0;e<j;e++)this.masonryHorizontal.rowXs[d+e]=i},_masonryHorizontalGetContainerSize:function(){var a=Math.max.apply(Math,this.masonryHorizontal.rowXs);return{width:a}},_masonryHorizontalResizeChanged:function(){return this._checkIfSegmentsChanged(!0)},_fitColumnsReset:function(){this.fitColumns={x:0,y:0,width:0}},_fitColumnsLayout:function(a){var c=this,d=this.element.height(),e=this.fitColumns;a.each(function(){var a=b(this),f=a.outerWidth(!0),g=a.outerHeight(!0);e.y!==0&&g+e.y>d&&(e.x=e.width,e.y=0),c._pushPosition(a,e.x,e.y),e.width=Math.max(e.x+f,e.width),e.y+=g})},_fitColumnsGetContainerSize:function(){return{width:this.fitColumns.width}},_fitColumnsResizeChanged:function(){return!0},_cellsByColumnReset:function(){this.cellsByColumn={index:0},this._getSegments(),this._getSegments(!0)},_cellsByColumnLayout:function(a){var c=this,d=this.cellsByColumn;a.each(function(){var a=b(this),e=Math.floor(d.index/d.rows),f=d.index%d.rows,g=(e+.5)*d.columnWidth-a.outerWidth(!0)/2,h=(f+.5)*d.rowHeight-a.outerHeight(!0)/2;c._pushPosition(a,g,h),d.index++})},_cellsByColumnGetContainerSize:function(){return{width:Math.ceil(this.$filteredAtoms.length/this.cellsByColumn.rows)*this.cellsByColumn.columnWidth}},_cellsByColumnResizeChanged:function(){return this._checkIfSegmentsChanged(!0)},_straightAcrossReset:function(){this.straightAcross={x:0}},_straightAcrossLayout:function(a){var c=this;a.each(function(a){var d=b(this);c._pushPosition(d,c.straightAcross.x,0),c.straightAcross.x+=d.outerWidth(!0)})},_straightAcrossGetContainerSize:function(){return{width:this.straightAcross.x}},_straightAcrossResizeChanged:function(){return!0}},b.fn.imagesLoaded=function(a){function h(){a.call(c,d)}function i(a){var c=a.target;c.src!==f&&b.inArray(c,g)===-1&&(g.push(c),--e<=0&&(setTimeout(h),d.unbind(".imagesLoaded",i)))}var c=this,d=c.find("img").add(c.filter("img")),e=d.length,f="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==",g=[];return e||h(),d.bind("load.imagesLoaded error.imagesLoaded",i).each(function(){var a=this.src;this.src=f,this.src=a}),c};var x=function(b){a.console&&a.console.error(b)};b.fn.isotope=function(a,c){if(typeof a=="string"){var d=Array.prototype.slice.call(arguments,1);this.each(function(){var c=b.data(this,"isotope");if(!c){x("cannot call methods on isotope prior to initialization; attempted to call method '"+a+"'");return}if(!b.isFunction(c[a])||a.charAt(0)==="_"){x("no such method '"+a+"' for isotope instance");return}c[a].apply(c,d)})}else this.each(function(){var d=b.data(this,"isotope");d?(d.option(a),d._init(c)):b.data(this,"isotope",new b.Isotope(a,this,c))});return this}})(window,jQuery);
} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.isotope.min.js; Error:' + e.message);
};
try {
/*
 * jQuery Easing v1.3 - http://gsgd.co.uk/sandbox/jquery/easing/
 *
 * Uses the built in easing capabilities added In jQuery 1.1
 * to offer multiple easing options
 *
 * TERMS OF USE - jQuery Easing
 * 
 * Open source under the BSD License. 
 * 
 * Copyright Ă‚Â© 2008 George McGinley Smith
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list 
 * of conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * Neither the name of the author nor the names of contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
*/

// t: current time, b: begInnIng value, c: change In value, d: duration
jQuery.easing['jswing'] = jQuery.easing['swing'];

jQuery.extend( jQuery.easing,
{
	def: 'easeOutQuad',
	swing: function (x, t, b, c, d) {
		//alert(jQuery.easing.default);
		return jQuery.easing[jQuery.easing.def](x, t, b, c, d);
	},
	easeInQuad: function (x, t, b, c, d) {
		return c*(t/=d)*t + b;
	},
	easeOutQuad: function (x, t, b, c, d) {
		return -c *(t/=d)*(t-2) + b;
	},
	easeInOutQuad: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t + b;
		return -c/2 * ((--t)*(t-2) - 1) + b;
	},
	easeInCubic: function (x, t, b, c, d) {
		return c*(t/=d)*t*t + b;
	},
	easeOutCubic: function (x, t, b, c, d) {
		return c*((t=t/d-1)*t*t + 1) + b;
	},
	easeInOutCubic: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t*t + b;
		return c/2*((t-=2)*t*t + 2) + b;
	},
	easeInQuart: function (x, t, b, c, d) {
		return c*(t/=d)*t*t*t + b;
	},
	easeOutQuart: function (x, t, b, c, d) {
		return -c * ((t=t/d-1)*t*t*t - 1) + b;
	},
	easeInOutQuart: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t*t*t + b;
		return -c/2 * ((t-=2)*t*t*t - 2) + b;
	},
	easeInQuint: function (x, t, b, c, d) {
		return c*(t/=d)*t*t*t*t + b;
	},
	easeOutQuint: function (x, t, b, c, d) {
		return c*((t=t/d-1)*t*t*t*t + 1) + b;
	},
	easeInOutQuint: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return c/2*t*t*t*t*t + b;
		return c/2*((t-=2)*t*t*t*t + 2) + b;
	},
	easeInSine: function (x, t, b, c, d) {
		return -c * Math.cos(t/d * (Math.PI/2)) + c + b;
	},
	easeOutSine: function (x, t, b, c, d) {
		return c * Math.sin(t/d * (Math.PI/2)) + b;
	},
	easeInOutSine: function (x, t, b, c, d) {
		return -c/2 * (Math.cos(Math.PI*t/d) - 1) + b;
	},
	easeInExpo: function (x, t, b, c, d) {
		return (t==0) ? b : c * Math.pow(2, 10 * (t/d - 1)) + b;
	},
	easeOutExpo: function (x, t, b, c, d) {
		return (t==d) ? b+c : c * (-Math.pow(2, -10 * t/d) + 1) + b;
	},
	easeInOutExpo: function (x, t, b, c, d) {
		if (t==0) return b;
		if (t==d) return b+c;
		if ((t/=d/2) < 1) return c/2 * Math.pow(2, 10 * (t - 1)) + b;
		return c/2 * (-Math.pow(2, -10 * --t) + 2) + b;
	},
	easeInCirc: function (x, t, b, c, d) {
		return -c * (Math.sqrt(1 - (t/=d)*t) - 1) + b;
	},
	easeOutCirc: function (x, t, b, c, d) {
		return c * Math.sqrt(1 - (t=t/d-1)*t) + b;
	},
	easeInOutCirc: function (x, t, b, c, d) {
		if ((t/=d/2) < 1) return -c/2 * (Math.sqrt(1 - t*t) - 1) + b;
		return c/2 * (Math.sqrt(1 - (t-=2)*t) + 1) + b;
	},
	easeInElastic: function (x, t, b, c, d) {
		var s=1.70158;var p=0;var a=c;
		if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
		if (a < Math.abs(c)) { a=c; var s=p/4; }
		else var s = p/(2*Math.PI) * Math.asin (c/a);
		return -(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
	},
	easeOutElastic: function (x, t, b, c, d) {
		var s=1.70158;var p=0;var a=c;
		if (t==0) return b;  if ((t/=d)==1) return b+c;  if (!p) p=d*.3;
		if (a < Math.abs(c)) { a=c; var s=p/4; }
		else var s = p/(2*Math.PI) * Math.asin (c/a);
		return a*Math.pow(2,-10*t) * Math.sin( (t*d-s)*(2*Math.PI)/p ) + c + b;
	},
	easeInOutElastic: function (x, t, b, c, d) {
		var s=1.70158;var p=0;var a=c;
		if (t==0) return b;  if ((t/=d/2)==2) return b+c;  if (!p) p=d*(.3*1.5);
		if (a < Math.abs(c)) { a=c; var s=p/4; }
		else var s = p/(2*Math.PI) * Math.asin (c/a);
		if (t < 1) return -.5*(a*Math.pow(2,10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )) + b;
		return a*Math.pow(2,-10*(t-=1)) * Math.sin( (t*d-s)*(2*Math.PI)/p )*.5 + c + b;
	},
	easeInBack: function (x, t, b, c, d, s) {
		if (s == undefined) s = 1.70158;
		return c*(t/=d)*t*((s+1)*t - s) + b;
	},
	easeOutBack: function (x, t, b, c, d, s) {
		if (s == undefined) s = 1.70158;
		return c*((t=t/d-1)*t*((s+1)*t + s) + 1) + b;
	},
	easeInOutBack: function (x, t, b, c, d, s) {
		if (s == undefined) s = 1.70158; 
		if ((t/=d/2) < 1) return c/2*(t*t*(((s*=(1.525))+1)*t - s)) + b;
		return c/2*((t-=2)*t*(((s*=(1.525))+1)*t + s) + 2) + b;
	},
	easeInBounce: function (x, t, b, c, d) {
		return c - jQuery.easing.easeOutBounce (x, d-t, 0, c, d) + b;
	},
	easeOutBounce: function (x, t, b, c, d) {
		if ((t/=d) < (1/2.75)) {
			return c*(7.5625*t*t) + b;
		} else if (t < (2/2.75)) {
			return c*(7.5625*(t-=(1.5/2.75))*t + .75) + b;
		} else if (t < (2.5/2.75)) {
			return c*(7.5625*(t-=(2.25/2.75))*t + .9375) + b;
		} else {
			return c*(7.5625*(t-=(2.625/2.75))*t + .984375) + b;
		}
	},
	easeInOutBounce: function (x, t, b, c, d) {
		if (t < d/2) return jQuery.easing.easeInBounce (x, t*2, 0, c, d) * .5 + b;
		return jQuery.easing.easeOutBounce (x, t*2-d, 0, c, d) * .5 + c*.5 + b;
	}
});

/*
 *
 * TERMS OF USE - EASING EQUATIONS
 * 
 * Open source under the BSD License. 
 * 
 * Copyright Ă‚Â© 2001 Robert Penner
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this list of 
 * conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list 
 * of conditions and the following disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * Neither the name of the author nor the names of contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 */
} catch (e) {
console.error('Error in file:/templates/archi/js/easing.js; Error:' + e.message);
};
try {
/*
 * jQuery FlexSlider v2.2.0
 * Copyright 2012 WooThemes
 * Contributing Author: Tyler Smith
 */(function(e){e.flexslider=function(t,n){var r=e(t);r.vars=e.extend({},e.flexslider.defaults,n);var i=r.vars.namespace,s=window.navigator&&window.navigator.msPointerEnabled&&window.MSGesture,o=("ontouchstart"in window||s||window.DocumentTouch&&document instanceof DocumentTouch)&&r.vars.touch,u="click touchend MSPointerUp",a="",f,l=r.vars.direction==="vertical",c=r.vars.reverse,h=r.vars.itemWidth>0,p=r.vars.animation==="fade",d=r.vars.asNavFor!=="",v={},m=!0;e.data(t,"flexslider",r);v={init:function(){r.animating=!1;r.currentSlide=parseInt(r.vars.startAt?r.vars.startAt:0);isNaN(r.currentSlide)&&(r.currentSlide=0);r.animatingTo=r.currentSlide;r.atEnd=r.currentSlide===0||r.currentSlide===r.last;r.containerSelector=r.vars.selector.substr(0,r.vars.selector.search(" "));r.slides=e(r.vars.selector,r);r.container=e(r.containerSelector,r);r.count=r.slides.length;r.syncExists=e(r.vars.sync).length>0;r.vars.animation==="slide"&&(r.vars.animation="swing");r.prop=l?"top":"marginLeft";r.args={};r.manualPause=!1;r.stopped=!1;r.started=!1;r.startTimeout=null;r.transitions=!r.vars.video&&!p&&r.vars.useCSS&&function(){var e=document.createElement("div"),t=["perspectiveProperty","WebkitPerspective","MozPerspective","OPerspective","msPerspective"];for(var n in t)if(e.style[t[n]]!==undefined){r.pfx=t[n].replace("Perspective","").toLowerCase();r.prop="-"+r.pfx+"-transform";return!0}return!1}();r.vars.controlsContainer!==""&&(r.controlsContainer=e(r.vars.controlsContainer).length>0&&e(r.vars.controlsContainer));r.vars.manualControls!==""&&(r.manualControls=e(r.vars.manualControls).length>0&&e(r.vars.manualControls));if(r.vars.randomize){r.slides.sort(function(){return Math.round(Math.random())-.5});r.container.empty().append(r.slides)}r.doMath();r.setup("init");r.vars.controlNav&&v.controlNav.setup();r.vars.directionNav&&v.directionNav.setup();r.vars.keyboard&&(e(r.containerSelector).length===1||r.vars.multipleKeyboard)&&e(document).bind("keyup",function(e){var t=e.keyCode;if(!r.animating&&(t===39||t===37)){var n=t===39?r.getTarget("next"):t===37?r.getTarget("prev"):!1;r.flexAnimate(n,r.vars.pauseOnAction)}});r.vars.mousewheel&&r.bind("mousewheel",function(e,t,n,i){e.preventDefault();var s=t<0?r.getTarget("next"):r.getTarget("prev");r.flexAnimate(s,r.vars.pauseOnAction)});r.vars.pausePlay&&v.pausePlay.setup();r.vars.slideshow&&r.vars.pauseInvisible&&v.pauseInvisible.init();if(r.vars.slideshow){r.vars.pauseOnHover&&r.hover(function(){!r.manualPlay&&!r.manualPause&&r.pause()},function(){!r.manualPause&&!r.manualPlay&&!r.stopped&&r.play()});if(!r.vars.pauseInvisible||!v.pauseInvisible.isHidden())r.vars.initDelay>0?r.startTimeout=setTimeout(r.play,r.vars.initDelay):r.play()}d&&v.asNav.setup();o&&r.vars.touch&&v.touch();(!p||p&&r.vars.smoothHeight)&&e(window).bind("resize orientationchange focus",v.resize);r.find("img").attr("draggable","false");setTimeout(function(){r.vars.start(r)},200)},asNav:{setup:function(){r.asNav=!0;r.animatingTo=Math.floor(r.currentSlide/r.move);r.currentItem=r.currentSlide;r.slides.removeClass(i+"active-slide").eq(r.currentItem).addClass(i+"active-slide");if(!s)r.slides.click(function(t){t.preventDefault();var n=e(this),s=n.index(),o=n.offset().left-e(r).scrollLeft();if(o<=0&&n.hasClass(i+"active-slide"))r.flexAnimate(r.getTarget("prev"),!0);else if(!e(r.vars.asNavFor).data("flexslider").animating&&!n.hasClass(i+"active-slide")){r.direction=r.currentItem<s?"next":"prev";r.flexAnimate(s,r.vars.pauseOnAction,!1,!0,!0)}});else{t._slider=r;r.slides.each(function(){var t=this;t._gesture=new MSGesture;t._gesture.target=t;t.addEventListener("MSPointerDown",function(e){e.preventDefault();e.currentTarget._gesture&&e.currentTarget._gesture.addPointer(e.pointerId)},!1);t.addEventListener("MSGestureTap",function(t){t.preventDefault();var n=e(this),i=n.index();if(!e(r.vars.asNavFor).data("flexslider").animating&&!n.hasClass("active")){r.direction=r.currentItem<i?"next":"prev";r.flexAnimate(i,r.vars.pauseOnAction,!1,!0,!0)}})})}}},controlNav:{setup:function(){r.manualControls?v.controlNav.setupManual():v.controlNav.setupPaging()},setupPaging:function(){var t=r.vars.controlNav==="thumbnails"?"control-thumbs":"control-paging",n=1,s,o;r.controlNavScaffold=e('<ol class="'+i+"control-nav "+i+t+'"></ol>');if(r.pagingCount>1)for(var f=0;f<r.pagingCount;f++){o=r.slides.eq(f);s=r.vars.controlNav==="thumbnails"?'<img src="'+o.attr("data-thumb")+'"/>':"<a>"+n+"</a>";if("thumbnails"===r.vars.controlNav&&!0===r.vars.thumbCaptions){var l=o.attr("data-thumbcaption");""!=l&&undefined!=l&&(s+='<span class="'+i+'caption">'+l+"</span>")}r.controlNavScaffold.append("<li>"+s+"</li>");n++}r.controlsContainer?e(r.controlsContainer).append(r.controlNavScaffold):r.append(r.controlNavScaffold);v.controlNav.set();v.controlNav.active();r.controlNavScaffold.delegate("a, img",u,function(t){t.preventDefault();if(a===""||a===t.type){var n=e(this),s=r.controlNav.index(n);if(!n.hasClass(i+"active")){r.direction=s>r.currentSlide?"next":"prev";r.flexAnimate(s,r.vars.pauseOnAction)}}a===""&&(a=t.type);v.setToClearWatchedEvent()})},setupManual:function(){r.controlNav=r.manualControls;v.controlNav.active();r.controlNav.bind(u,function(t){t.preventDefault();if(a===""||a===t.type){var n=e(this),s=r.controlNav.index(n);if(!n.hasClass(i+"active")){s>r.currentSlide?r.direction="next":r.direction="prev";r.flexAnimate(s,r.vars.pauseOnAction)}}a===""&&(a=t.type);v.setToClearWatchedEvent()})},set:function(){var t=r.vars.controlNav==="thumbnails"?"img":"a";r.controlNav=e("."+i+"control-nav li "+t,r.controlsContainer?r.controlsContainer:r)},active:function(){r.controlNav.removeClass(i+"active").eq(r.animatingTo).addClass(i+"active")},update:function(t,n){r.pagingCount>1&&t==="add"?r.controlNavScaffold.append(e("<li><a>"+r.count+"</a></li>")):r.pagingCount===1?r.controlNavScaffold.find("li").remove():r.controlNav.eq(n).closest("li").remove();v.controlNav.set();r.pagingCount>1&&r.pagingCount!==r.controlNav.length?r.update(n,t):v.controlNav.active()}},directionNav:{setup:function(){var t=e('<ul class="'+i+'direction-nav"><li><a class="'+i+'prev" href="#">'+r.vars.prevText+'</a></li><li><a class="'+i+'next" href="#">'+r.vars.nextText+"</a></li></ul>");if(r.controlsContainer){e(r.controlsContainer).append(t);r.directionNav=e("."+i+"direction-nav li a",r.controlsContainer)}else{r.append(t);r.directionNav=e("."+i+"direction-nav li a",r)}v.directionNav.update();r.directionNav.bind(u,function(t){t.preventDefault();var n;if(a===""||a===t.type){n=e(this).hasClass(i+"next")?r.getTarget("next"):r.getTarget("prev");r.flexAnimate(n,r.vars.pauseOnAction)}a===""&&(a=t.type);v.setToClearWatchedEvent()})},update:function(){var e=i+"disabled";r.pagingCount===1?r.directionNav.addClass(e).attr("tabindex","-1"):r.vars.animationLoop?r.directionNav.removeClass(e).removeAttr("tabindex"):r.animatingTo===0?r.directionNav.removeClass(e).filter("."+i+"prev").addClass(e).attr("tabindex","-1"):r.animatingTo===r.last?r.directionNav.removeClass(e).filter("."+i+"next").addClass(e).attr("tabindex","-1"):r.directionNav.removeClass(e).removeAttr("tabindex")}},pausePlay:{setup:function(){var t=e('<div class="'+i+'pauseplay"><a></a></div>');if(r.controlsContainer){r.controlsContainer.append(t);r.pausePlay=e("."+i+"pauseplay a",r.controlsContainer)}else{r.append(t);r.pausePlay=e("."+i+"pauseplay a",r)}v.pausePlay.update(r.vars.slideshow?i+"pause":i+"play");r.pausePlay.bind(u,function(t){t.preventDefault();if(a===""||a===t.type)if(e(this).hasClass(i+"pause")){r.manualPause=!0;r.manualPlay=!1;r.pause()}else{r.manualPause=!1;r.manualPlay=!0;r.play()}a===""&&(a=t.type);v.setToClearWatchedEvent()})},update:function(e){e==="play"?r.pausePlay.removeClass(i+"pause").addClass(i+"play").html(r.vars.playText):r.pausePlay.removeClass(i+"play").addClass(i+"pause").html(r.vars.pauseText)}},touch:function(){var e,n,i,o,u,a,f=!1,d=0,v=0,m=0;if(!s){t.addEventListener("touchstart",g,!1);function g(s){if(r.animating)s.preventDefault();else if(window.navigator.msPointerEnabled||s.touches.length===1){r.pause();o=l?r.h:r.w;a=Number(new Date);d=s.touches[0].pageX;v=s.touches[0].pageY;i=h&&c&&r.animatingTo===r.last?0:h&&c?r.limit-(r.itemW+r.vars.itemMargin)*r.move*r.animatingTo:h&&r.currentSlide===r.last?r.limit:h?(r.itemW+r.vars.itemMargin)*r.move*r.currentSlide:c?(r.last-r.currentSlide+r.cloneOffset)*o:(r.currentSlide+r.cloneOffset)*o;e=l?v:d;n=l?d:v;t.addEventListener("touchmove",y,!1);t.addEventListener("touchend",b,!1)}}function y(t){d=t.touches[0].pageX;v=t.touches[0].pageY;u=l?e-v:e-d;f=l?Math.abs(u)<Math.abs(d-n):Math.abs(u)<Math.abs(v-n);var s=500;if(!f||Number(new Date)-a>s){t.preventDefault();if(!p&&r.transitions){r.vars.animationLoop||(u/=r.currentSlide===0&&u<0||r.currentSlide===r.last&&u>0?Math.abs(u)/o+2:1);r.setProps(i+u,"setTouch")}}}function b(s){t.removeEventListener("touchmove",y,!1);if(r.animatingTo===r.currentSlide&&!f&&u!==null){var l=c?-u:u,h=l>0?r.getTarget("next"):r.getTarget("prev");r.canAdvance(h)&&(Number(new Date)-a<550&&Math.abs(l)>50||Math.abs(l)>o/2)?r.flexAnimate(h,r.vars.pauseOnAction):p||r.flexAnimate(r.currentSlide,r.vars.pauseOnAction,!0)}t.removeEventListener("touchend",b,!1);e=null;n=null;u=null;i=null}}else{t.style.msTouchAction="none";t._gesture=new MSGesture;t._gesture.target=t;t.addEventListener("MSPointerDown",w,!1);t._slider=r;t.addEventListener("MSGestureChange",E,!1);t.addEventListener("MSGestureEnd",S,!1);function w(e){e.stopPropagation();if(r.animating)e.preventDefault();else{r.pause();t._gesture.addPointer(e.pointerId);m=0;o=l?r.h:r.w;a=Number(new Date);i=h&&c&&r.animatingTo===r.last?0:h&&c?r.limit-(r.itemW+r.vars.itemMargin)*r.move*r.animatingTo:h&&r.currentSlide===r.last?r.limit:h?(r.itemW+r.vars.itemMargin)*r.move*r.currentSlide:c?(r.last-r.currentSlide+r.cloneOffset)*o:(r.currentSlide+r.cloneOffset)*o}}function E(e){e.stopPropagation();var n=e.target._slider;if(!n)return;var r=-e.translationX,s=-e.translationY;m+=l?s:r;u=m;f=l?Math.abs(m)<Math.abs(-r):Math.abs(m)<Math.abs(-s);if(e.detail===e.MSGESTURE_FLAG_INERTIA){setImmediate(function(){t._gesture.stop()});return}if(!f||Number(new Date)-a>500){e.preventDefault();if(!p&&n.transitions){n.vars.animationLoop||(u=m/(n.currentSlide===0&&m<0||n.currentSlide===n.last&&m>0?Math.abs(m)/o+2:1));n.setProps(i+u,"setTouch")}}}function S(t){t.stopPropagation();var r=t.target._slider;if(!r)return;if(r.animatingTo===r.currentSlide&&!f&&u!==null){var s=c?-u:u,l=s>0?r.getTarget("next"):r.getTarget("prev");r.canAdvance(l)&&(Number(new Date)-a<550&&Math.abs(s)>50||Math.abs(s)>o/2)?r.flexAnimate(l,r.vars.pauseOnAction):p||r.flexAnimate(r.currentSlide,r.vars.pauseOnAction,!0)}e=null;n=null;u=null;i=null;m=0}}},resize:function(){if(!r.animating&&r.is(":visible")){h||r.doMath();if(p)v.smoothHeight();else if(h){r.slides.width(r.computedW);r.update(r.pagingCount);r.setProps()}else if(l){r.viewport.height(r.h);r.setProps(r.h,"setTotal")}else{r.vars.smoothHeight&&v.smoothHeight();r.newSlides.width(r.computedW);r.setProps(r.computedW,"setTotal")}}},smoothHeight:function(e){if(!l||p){var t=p?r:r.viewport;e?t.animate({height:r.slides.eq(r.animatingTo).height()},e):t.height(r.slides.eq(r.animatingTo).height())}},sync:function(t){var n=e(r.vars.sync).data("flexslider"),i=r.animatingTo;switch(t){case"animate":n.flexAnimate(i,r.vars.pauseOnAction,!1,!0);break;case"play":!n.playing&&!n.asNav&&n.play();break;case"pause":n.pause()}},pauseInvisible:{visProp:null,init:function(){var e=["webkit","moz","ms","o"];if("hidden"in document)return"hidden";for(var t=0;t<e.length;t++)e[t]+"Hidden"in document&&(v.pauseInvisible.visProp=e[t]+"Hidden");if(v.pauseInvisible.visProp){var n=v.pauseInvisible.visProp.replace(/[H|h]idden/,"")+"visibilitychange";document.addEventListener(n,function(){v.pauseInvisible.isHidden()?r.startTimeout?clearTimeout(r.startTimeout):r.pause():r.started?r.play():r.vars.initDelay>0?setTimeout(r.play,r.vars.initDelay):r.play()})}},isHidden:function(){return document[v.pauseInvisible.visProp]||!1}},setToClearWatchedEvent:function(){clearTimeout(f);f=setTimeout(function(){a=""},3e3)}};r.flexAnimate=function(t,n,s,u,a){!r.vars.animationLoop&&t!==r.currentSlide&&(r.direction=t>r.currentSlide?"next":"prev");d&&r.pagingCount===1&&(r.direction=r.currentItem<t?"next":"prev");if(!r.animating&&(r.canAdvance(t,a)||s)&&r.is(":visible")){if(d&&u){var f=e(r.vars.asNavFor).data("flexslider");r.atEnd=t===0||t===r.count-1;f.flexAnimate(t,!0,!1,!0,a);r.direction=r.currentItem<t?"next":"prev";f.direction=r.direction;if(Math.ceil((t+1)/r.visible)-1===r.currentSlide||t===0){r.currentItem=t;r.slides.removeClass(i+"active-slide").eq(t).addClass(i+"active-slide");return!1}r.currentItem=t;r.slides.removeClass(i+"active-slide").eq(t).addClass(i+"active-slide");t=Math.floor(t/r.visible)}r.animating=!0;r.animatingTo=t;n&&r.pause();r.vars.before(r);r.syncExists&&!a&&v.sync("animate");r.vars.controlNav&&v.controlNav.active();h||r.slides.removeClass(i+"active-slide").eq(t).addClass(i+"active-slide");r.atEnd=t===0||t===r.last;r.vars.directionNav&&v.directionNav.update();if(t===r.last){r.vars.end(r);r.vars.animationLoop||r.pause()}if(!p){var m=l?r.slides.filter(":first").height():r.computedW,g,y,b;if(h){g=r.vars.itemMargin;b=(r.itemW+g)*r.move*r.animatingTo;y=b>r.limit&&r.visible!==1?r.limit:b}else r.currentSlide===0&&t===r.count-1&&r.vars.animationLoop&&r.direction!=="next"?y=c?(r.count+r.cloneOffset)*m:0:r.currentSlide===r.last&&t===0&&r.vars.animationLoop&&r.direction!=="prev"?y=c?0:(r.count+1)*m:y=c?(r.count-1-t+r.cloneOffset)*m:(t+r.cloneOffset)*m;r.setProps(y,"",r.vars.animationSpeed);if(r.transitions){if(!r.vars.animationLoop||!r.atEnd){r.animating=!1;r.currentSlide=r.animatingTo}r.container.unbind("webkitTransitionEnd transitionend");r.container.bind("webkitTransitionEnd transitionend",function(){r.wrapup(m)})}else r.container.animate(r.args,r.vars.animationSpeed,r.vars.easing,function(){r.wrapup(m)})}else if(!o){r.slides.eq(r.currentSlide).css({zIndex:1}).animate({opacity:0},r.vars.animationSpeed,r.vars.easing);r.slides.eq(t).css({zIndex:2}).animate({opacity:1},r.vars.animationSpeed,r.vars.easing,r.wrapup)}else{r.slides.eq(r.currentSlide).css({opacity:0,zIndex:1});r.slides.eq(t).css({opacity:1,zIndex:2});r.wrapup(m)}r.vars.smoothHeight&&v.smoothHeight(r.vars.animationSpeed)}};r.wrapup=function(e){!p&&!h&&(r.currentSlide===0&&r.animatingTo===r.last&&r.vars.animationLoop?r.setProps(e,"jumpEnd"):r.currentSlide===r.last&&r.animatingTo===0&&r.vars.animationLoop&&r.setProps(e,"jumpStart"));r.animating=!1;r.currentSlide=r.animatingTo;r.vars.after(r)};r.animateSlides=function(){!r.animating&&m&&r.flexAnimate(r.getTarget("next"))};r.pause=function(){clearInterval(r.animatedSlides);r.animatedSlides=null;r.playing=!1;r.vars.pausePlay&&v.pausePlay.update("play");r.syncExists&&v.sync("pause")};r.play=function(){r.playing&&clearInterval(r.animatedSlides);r.animatedSlides=r.animatedSlides||setInterval(r.animateSlides,r.vars.slideshowSpeed);r.started=r.playing=!0;r.vars.pausePlay&&v.pausePlay.update("pause");r.syncExists&&v.sync("play")};r.stop=function(){r.pause();r.stopped=!0};r.canAdvance=function(e,t){var n=d?r.pagingCount-1:r.last;return t?!0:d&&r.currentItem===r.count-1&&e===0&&r.direction==="prev"?!0:d&&r.currentItem===0&&e===r.pagingCount-1&&r.direction!=="next"?!1:e===r.currentSlide&&!d?!1:r.vars.animationLoop?!0:r.atEnd&&r.currentSlide===0&&e===n&&r.direction!=="next"?!1:r.atEnd&&r.currentSlide===n&&e===0&&r.direction==="next"?!1:!0};r.getTarget=function(e){r.direction=e;return e==="next"?r.currentSlide===r.last?0:r.currentSlide+1:r.currentSlide===0?r.last:r.currentSlide-1};r.setProps=function(e,t,n){var i=function(){var n=e?e:(r.itemW+r.vars.itemMargin)*r.move*r.animatingTo,i=function(){if(h)return t==="setTouch"?e:c&&r.animatingTo===r.last?0:c?r.limit-(r.itemW+r.vars.itemMargin)*r.move*r.animatingTo:r.animatingTo===r.last?r.limit:n;switch(t){case"setTotal":return c?(r.count-1-r.currentSlide+r.cloneOffset)*e:(r.currentSlide+r.cloneOffset)*e;case"setTouch":return c?e:e;case"jumpEnd":return c?e:r.count*e;case"jumpStart":return c?r.count*e:e;default:return e}}();return i*-1+"px"}();if(r.transitions){i=l?"translate3d(0,"+i+",0)":"translate3d("+i+",0,0)";n=n!==undefined?n/1e3+"s":"0s";r.container.css("-"+r.pfx+"-transition-duration",n)}r.args[r.prop]=i;(r.transitions||n===undefined)&&r.container.css(r.args)};r.setup=function(t){if(!p){var n,s;if(t==="init"){r.viewport=e('<div class="'+i+'viewport"></div>').css({overflow:"hidden",position:"relative"}).appendTo(r).append(r.container);r.cloneCount=0;r.cloneOffset=0;if(c){s=e.makeArray(r.slides).reverse();r.slides=e(s);r.container.empty().append(r.slides)}}if(r.vars.animationLoop&&!h){r.cloneCount=2;r.cloneOffset=1;t!=="init"&&r.container.find(".clone").remove();r.container.append(r.slides.first().clone().addClass("clone").attr("aria-hidden","true")).prepend(r.slides.last().clone().addClass("clone").attr("aria-hidden","true"))}r.newSlides=e(r.vars.selector,r);n=c?r.count-1-r.currentSlide+r.cloneOffset:r.currentSlide+r.cloneOffset;if(l&&!h){r.container.height((r.count+r.cloneCount)*200+"%").css("position","absolute").width("100%");setTimeout(function(){r.newSlides.css({display:"block"});r.doMath();r.viewport.height(r.h);r.setProps(n*r.h,"init")},t==="init"?100:0)}else{r.container.width((r.count+r.cloneCount)*200+"%");r.setProps(n*r.computedW,"init");setTimeout(function(){r.doMath();r.newSlides.css({width:r.computedW,"float":"left",display:"block"});r.vars.smoothHeight&&v.smoothHeight()},t==="init"?100:0)}}else{r.slides.css({width:"100%","float":"left",marginRight:"-100%",position:"relative"});t==="init"&&(o?r.slides.css({opacity:0,display:"block",webkitTransition:"opacity "+r.vars.animationSpeed/1e3+"s ease",zIndex:1}).eq(r.currentSlide).css({opacity:1,zIndex:2}):r.slides.css({opacity:0,display:"block",zIndex:1}).eq(r.currentSlide).css({zIndex:2}).animate({opacity:1},r.vars.animationSpeed,r.vars.easing));r.vars.smoothHeight&&v.smoothHeight()}h||r.slides.removeClass(i+"active-slide").eq(r.currentSlide).addClass(i+"active-slide")};r.doMath=function(){var e=r.slides.first(),t=r.vars.itemMargin,n=r.vars.minItems,i=r.vars.maxItems;r.w=r.viewport===undefined?r.width():r.viewport.width();r.h=e.height();r.boxPadding=e.outerWidth()-e.width();if(h){r.itemT=r.vars.itemWidth+t;r.minW=n?n*r.itemT:r.w;r.maxW=i?i*r.itemT-t:r.w;r.itemW=r.minW>r.w?(r.w-t*(n-1))/n:r.maxW<r.w?(r.w-t*(i-1))/i:r.vars.itemWidth>r.w?r.w:r.vars.itemWidth;r.visible=Math.floor(r.w/r.itemW);r.move=r.vars.move>0&&r.vars.move<r.visible?r.vars.move:r.visible;r.pagingCount=Math.ceil((r.count-r.visible)/r.move+1);r.last=r.pagingCount-1;r.limit=r.pagingCount===1?0:r.vars.itemWidth>r.w?r.itemW*(r.count-1)+t*(r.count-1):(r.itemW+t)*r.count-r.w-t}else{r.itemW=r.w;r.pagingCount=r.count;r.last=r.count-1}r.computedW=r.itemW-r.boxPadding};r.update=function(e,t){r.doMath();if(!h){e<r.currentSlide?r.currentSlide+=1:e<=r.currentSlide&&e!==0&&(r.currentSlide-=1);r.animatingTo=r.currentSlide}if(r.vars.controlNav&&!r.manualControls)if(t==="add"&&!h||r.pagingCount>r.controlNav.length)v.controlNav.update("add");else if(t==="remove"&&!h||r.pagingCount<r.controlNav.length){if(h&&r.currentSlide>r.last){r.currentSlide-=1;r.animatingTo-=1}v.controlNav.update("remove",r.last)}r.vars.directionNav&&v.directionNav.update()};r.addSlide=function(t,n){var i=e(t);r.count+=1;r.last=r.count-1;l&&c?n!==undefined?r.slides.eq(r.count-n).after(i):r.container.prepend(i):n!==undefined?r.slides.eq(n).before(i):r.container.append(i);r.update(n,"add");r.slides=e(r.vars.selector+":not(.clone)",r);r.setup();r.vars.added(r)};r.removeSlide=function(t){var n=isNaN(t)?r.slides.index(e(t)):t;r.count-=1;r.last=r.count-1;isNaN(t)?e(t,r.slides).remove():l&&c?r.slides.eq(r.last).remove():r.slides.eq(t).remove();r.doMath();r.update(n,"remove");r.slides=e(r.vars.selector+":not(.clone)",r);r.setup();r.vars.removed(r)};v.init()};e(window).blur(function(e){focused=!1}).focus(function(e){focused=!0});e.flexslider.defaults={namespace:"flex-",selector:".slides > li",animation:"fade",easing:"swing",direction:"horizontal",reverse:!1,animationLoop:!0,smoothHeight:!1,startAt:0,slideshow:!0,slideshowSpeed:7e3,animationSpeed:600,initDelay:0,randomize:!1,thumbCaptions:!1,pauseOnAction:!0,pauseOnHover:!1,pauseInvisible:!0,useCSS:!0,touch:!0,video:!1,controlNav:!0,directionNav:!0,prevText:"Previous",nextText:"Next",keyboard:!0,multipleKeyboard:!1,mousewheel:!1,pausePlay:!1,pauseText:"Pause",playText:"Play",controlsContainer:"",manualControls:"",sync:"",asNavFor:"",itemWidth:0,itemMargin:0,minItems:1,maxItems:0,move:0,allowOneSlide:!0,start:function(){},before:function(){},after:function(){},end:function(){},added:function(){},removed:function(){}};e.fn.flexslider=function(t){t===undefined&&(t={});if(typeof t=="object")return this.each(function(){var n=e(this),r=t.selector?t.selector:".slides > li",i=n.find(r);if(i.length===1&&t.allowOneSlide===!0||i.length===0){i.fadeIn(400);t.start&&t.start(n)}else n.data("flexslider")===undefined&&new e.flexslider(this,t)});var n=e(this).data("flexslider");switch(t){case"play":n.play();break;case"pause":n.pause();break;case"stop":n.stop();break;case"next":n.flexAnimate(n.getTarget("next"),!0);break;case"prev":case"previous":n.flexAnimate(n.getTarget("prev"),!0);break;default:typeof t=="number"&&n.flexAnimate(t,!0)}}})(jQuery);
} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.flexslider-min.js; Error:' + e.message);
};
try {
/**
 * Owl Carousel v2.3.4
 * Copyright 2013-2018 David Deutsch
 * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE
 */
!function(a,b,c,d){function e(b,c){this.settings=null,this.options=a.extend({},e.Defaults,c),this.$element=a(b),this._handlers={},this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._widths=[],this._invalidated={},this._pipe=[],this._drag={time:null,target:null,pointer:null,stage:{start:null,current:null},direction:null},this._states={current:{},tags:{initializing:["busy"],animating:["busy"],dragging:["interacting"]}},a.each(["onResize","onThrottledResize"],a.proxy(function(b,c){this._handlers[c]=a.proxy(this[c],this)},this)),a.each(e.Plugins,a.proxy(function(a,b){this._plugins[a.charAt(0).toLowerCase()+a.slice(1)]=new b(this)},this)),a.each(e.Workers,a.proxy(function(b,c){this._pipe.push({filter:c.filter,run:a.proxy(c.run,this)})},this)),this.setup(),this.initialize()}e.Defaults={items:3,loop:!1,center:!1,rewind:!1,checkVisibility:!0,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:b,fallbackEasing:"swing",slideTransition:"",info:!1,nestedItemSelector:!1,itemElement:"div",stageElement:"div",refreshClass:"owl-refresh",loadedClass:"owl-loaded",loadingClass:"owl-loading",rtlClass:"owl-rtl",responsiveClass:"owl-responsive",dragClass:"owl-drag",itemClass:"owl-item",stageClass:"owl-stage",stageOuterClass:"owl-stage-outer",grabClass:"owl-grab"},e.Width={Default:"default",Inner:"inner",Outer:"outer"},e.Type={Event:"event",State:"state"},e.Plugins={},e.Workers=[{filter:["width","settings"],run:function(){this._width=this.$element.width()}},{filter:["width","items","settings"],run:function(a){a.current=this._items&&this._items[this.relative(this._current)]}},{filter:["items","settings"],run:function(){this.$stage.children(".cloned").remove()}},{filter:["width","items","settings"],run:function(a){var b=this.settings.margin||"",c=!this.settings.autoWidth,d=this.settings.rtl,e={width:"auto","margin-left":d?b:"","margin-right":d?"":b};!c&&this.$stage.children().css(e),a.css=e}},{filter:["width","items","settings"],run:function(a){var b=(this.width()/this.settings.items).toFixed(3)-this.settings.margin,c=null,d=this._items.length,e=!this.settings.autoWidth,f=[];for(a.items={merge:!1,width:b};d--;)c=this._mergers[d],c=this.settings.mergeFit&&Math.min(c,this.settings.items)||c,a.items.merge=c>1||a.items.merge,f[d]=e?b*c:this._items[d].width();this._widths=f}},{filter:["items","settings"],run:function(){var b=[],c=this._items,d=this.settings,e=Math.max(2*d.items,4),f=2*Math.ceil(c.length/2),g=d.loop&&c.length?d.rewind?e:Math.max(e,f):0,h="",i="";for(g/=2;g>0;)b.push(this.normalize(b.length/2,!0)),h+=c[b[b.length-1]][0].outerHTML,b.push(this.normalize(c.length-1-(b.length-1)/2,!0)),i=c[b[b.length-1]][0].outerHTML+i,g-=1;this._clones=b,a(h).addClass("cloned").appendTo(this.$stage),a(i).addClass("cloned").prependTo(this.$stage)}},{filter:["width","items","settings"],run:function(){for(var a=this.settings.rtl?1:-1,b=this._clones.length+this._items.length,c=-1,d=0,e=0,f=[];++c<b;)d=f[c-1]||0,e=this._widths[this.relative(c)]+this.settings.margin,f.push(d+e*a);this._coordinates=f}},{filter:["width","items","settings"],run:function(){var a=this.settings.stagePadding,b=this._coordinates,c={width:Math.ceil(Math.abs(b[b.length-1]))+2*a,"padding-left":a||"","padding-right":a||""};this.$stage.css(c)}},{filter:["width","items","settings"],run:function(a){var b=this._coordinates.length,c=!this.settings.autoWidth,d=this.$stage.children();if(c&&a.items.merge)for(;b--;)a.css.width=this._widths[this.relative(b)],d.eq(b).css(a.css);else c&&(a.css.width=a.items.width,d.css(a.css))}},{filter:["items"],run:function(){this._coordinates.length<1&&this.$stage.removeAttr("style")}},{filter:["width","items","settings"],run:function(a){a.current=a.current?this.$stage.children().index(a.current):0,a.current=Math.max(this.minimum(),Math.min(this.maximum(),a.current)),this.reset(a.current)}},{filter:["position"],run:function(){this.animate(this.coordinates(this._current))}},{filter:["width","position","items","settings"],run:function(){var a,b,c,d,e=this.settings.rtl?1:-1,f=2*this.settings.stagePadding,g=this.coordinates(this.current())+f,h=g+this.width()*e,i=[];for(c=0,d=this._coordinates.length;c<d;c++)a=this._coordinates[c-1]||0,b=Math.abs(this._coordinates[c])+f*e,(this.op(a,"<=",g)&&this.op(a,">",h)||this.op(b,"<",g)&&this.op(b,">",h))&&i.push(c);this.$stage.children(".active").removeClass("active"),this.$stage.children(":eq("+i.join("), :eq(")+")").addClass("active"),this.$stage.children(".center").removeClass("center"),this.settings.center&&this.$stage.children().eq(this.current()).addClass("center")}}],e.prototype.initializeStage=function(){this.$stage=this.$element.find("."+this.settings.stageClass),this.$stage.length||(this.$element.addClass(this.options.loadingClass),this.$stage=a("<"+this.settings.stageElement+">",{class:this.settings.stageClass}).wrap(a("<div/>",{class:this.settings.stageOuterClass})),this.$element.append(this.$stage.parent()))},e.prototype.initializeItems=function(){var b=this.$element.find(".owl-item");if(b.length)return this._items=b.get().map(function(b){return a(b)}),this._mergers=this._items.map(function(){return 1}),void this.refresh();this.replace(this.$element.children().not(this.$stage.parent())),this.isVisible()?this.refresh():this.invalidate("width"),this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass)},e.prototype.initialize=function(){if(this.enter("initializing"),this.trigger("initialize"),this.$element.toggleClass(this.settings.rtlClass,this.settings.rtl),this.settings.autoWidth&&!this.is("pre-loading")){var a,b,c;a=this.$element.find("img"),b=this.settings.nestedItemSelector?"."+this.settings.nestedItemSelector:d,c=this.$element.children(b).width(),a.length&&c<=0&&this.preloadAutoWidthImages(a)}this.initializeStage(),this.initializeItems(),this.registerEventHandlers(),this.leave("initializing"),this.trigger("initialized")},e.prototype.isVisible=function(){return!this.settings.checkVisibility||this.$element.is(":visible")},e.prototype.setup=function(){var b=this.viewport(),c=this.options.responsive,d=-1,e=null;c?(a.each(c,function(a){a<=b&&a>d&&(d=Number(a))}),e=a.extend({},this.options,c[d]),"function"==typeof e.stagePadding&&(e.stagePadding=e.stagePadding()),delete e.responsive,e.responsiveClass&&this.$element.attr("class",this.$element.attr("class").replace(new RegExp("("+this.options.responsiveClass+"-)\\S+\\s","g"),"$1"+d))):e=a.extend({},this.options),this.trigger("change",{property:{name:"settings",value:e}}),this._breakpoint=d,this.settings=e,this.invalidate("settings"),this.trigger("changed",{property:{name:"settings",value:this.settings}})},e.prototype.optionsLogic=function(){this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},e.prototype.prepare=function(b){var c=this.trigger("prepare",{content:b});return c.data||(c.data=a("<"+this.settings.itemElement+"/>").addClass(this.options.itemClass).append(b)),this.trigger("prepared",{content:c.data}),c.data},e.prototype.update=function(){for(var b=0,c=this._pipe.length,d=a.proxy(function(a){return this[a]},this._invalidated),e={};b<c;)(this._invalidated.all||a.grep(this._pipe[b].filter,d).length>0)&&this._pipe[b].run(e),b++;this._invalidated={},!this.is("valid")&&this.enter("valid")},e.prototype.width=function(a){switch(a=a||e.Width.Default){case e.Width.Inner:case e.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},e.prototype.refresh=function(){this.enter("refreshing"),this.trigger("refresh"),this.setup(),this.optionsLogic(),this.$element.addClass(this.options.refreshClass),this.update(),this.$element.removeClass(this.options.refreshClass),this.leave("refreshing"),this.trigger("refreshed")},e.prototype.onThrottledResize=function(){b.clearTimeout(this.resizeTimer),this.resizeTimer=b.setTimeout(this._handlers.onResize,this.settings.responsiveRefreshRate)},e.prototype.onResize=function(){return!!this._items.length&&(this._width!==this.$element.width()&&(!!this.isVisible()&&(this.enter("resizing"),this.trigger("resize").isDefaultPrevented()?(this.leave("resizing"),!1):(this.invalidate("width"),this.refresh(),this.leave("resizing"),void this.trigger("resized")))))},e.prototype.registerEventHandlers=function(){a.support.transition&&this.$stage.on(a.support.transition.end+".owl.core",a.proxy(this.onTransitionEnd,this)),!1!==this.settings.responsive&&this.on(b,"resize",this._handlers.onThrottledResize),this.settings.mouseDrag&&(this.$element.addClass(this.options.dragClass),this.$stage.on("mousedown.owl.core",a.proxy(this.onDragStart,this)),this.$stage.on("dragstart.owl.core selectstart.owl.core",function(){return!1})),this.settings.touchDrag&&(this.$stage.on("touchstart.owl.core",a.proxy(this.onDragStart,this)),this.$stage.on("touchcancel.owl.core",a.proxy(this.onDragEnd,this)))},e.prototype.onDragStart=function(b){var d=null;3!==b.which&&(a.support.transform?(d=this.$stage.css("transform").replace(/.*\(|\)| /g,"").split(","),d={x:d[16===d.length?12:4],y:d[16===d.length?13:5]}):(d=this.$stage.position(),d={x:this.settings.rtl?d.left+this.$stage.width()-this.width()+this.settings.margin:d.left,y:d.top}),this.is("animating")&&(a.support.transform?this.animate(d.x):this.$stage.stop(),this.invalidate("position")),this.$element.toggleClass(this.options.grabClass,"mousedown"===b.type),this.speed(0),this._drag.time=(new Date).getTime(),this._drag.target=a(b.target),this._drag.stage.start=d,this._drag.stage.current=d,this._drag.pointer=this.pointer(b),a(c).on("mouseup.owl.core touchend.owl.core",a.proxy(this.onDragEnd,this)),a(c).one("mousemove.owl.core touchmove.owl.core",a.proxy(function(b){var d=this.difference(this._drag.pointer,this.pointer(b));a(c).on("mousemove.owl.core touchmove.owl.core",a.proxy(this.onDragMove,this)),Math.abs(d.x)<Math.abs(d.y)&&this.is("valid")||(b.preventDefault(),this.enter("dragging"),this.trigger("drag"))},this)))},e.prototype.onDragMove=function(a){var b=null,c=null,d=null,e=this.difference(this._drag.pointer,this.pointer(a)),f=this.difference(this._drag.stage.start,e);this.is("dragging")&&(a.preventDefault(),this.settings.loop?(b=this.coordinates(this.minimum()),c=this.coordinates(this.maximum()+1)-b,f.x=((f.x-b)%c+c)%c+b):(b=this.settings.rtl?this.coordinates(this.maximum()):this.coordinates(this.minimum()),c=this.settings.rtl?this.coordinates(this.minimum()):this.coordinates(this.maximum()),d=this.settings.pullDrag?-1*e.x/5:0,f.x=Math.max(Math.min(f.x,b+d),c+d)),this._drag.stage.current=f,this.animate(f.x))},e.prototype.onDragEnd=function(b){var d=this.difference(this._drag.pointer,this.pointer(b)),e=this._drag.stage.current,f=d.x>0^this.settings.rtl?"left":"right";a(c).off(".owl.core"),this.$element.removeClass(this.options.grabClass),(0!==d.x&&this.is("dragging")||!this.is("valid"))&&(this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(this.closest(e.x,0!==d.x?f:this._drag.direction)),this.invalidate("position"),this.update(),this._drag.direction=f,(Math.abs(d.x)>3||(new Date).getTime()-this._drag.time>300)&&this._drag.target.one("click.owl.core",function(){return!1})),this.is("dragging")&&(this.leave("dragging"),this.trigger("dragged"))},e.prototype.closest=function(b,c){var e=-1,f=30,g=this.width(),h=this.coordinates();return this.settings.freeDrag||a.each(h,a.proxy(function(a,i){return"left"===c&&b>i-f&&b<i+f?e=a:"right"===c&&b>i-g-f&&b<i-g+f?e=a+1:this.op(b,"<",i)&&this.op(b,">",h[a+1]!==d?h[a+1]:i-g)&&(e="left"===c?a+1:a),-1===e},this)),this.settings.loop||(this.op(b,">",h[this.minimum()])?e=b=this.minimum():this.op(b,"<",h[this.maximum()])&&(e=b=this.maximum())),e},e.prototype.animate=function(b){var c=this.speed()>0;this.is("animating")&&this.onTransitionEnd(),c&&(this.enter("animating"),this.trigger("translate")),a.support.transform3d&&a.support.transition?this.$stage.css({transform:"translate3d("+b+"px,0px,0px)",transition:this.speed()/1e3+"s"+(this.settings.slideTransition?" "+this.settings.slideTransition:"")}):c?this.$stage.animate({left:b+"px"},this.speed(),this.settings.fallbackEasing,a.proxy(this.onTransitionEnd,this)):this.$stage.css({left:b+"px"})},e.prototype.is=function(a){return this._states.current[a]&&this._states.current[a]>0},e.prototype.current=function(a){if(a===d)return this._current;if(0===this._items.length)return d;if(a=this.normalize(a),this._current!==a){var b=this.trigger("change",{property:{name:"position",value:a}});b.data!==d&&(a=this.normalize(b.data)),this._current=a,this.invalidate("position"),this.trigger("changed",{property:{name:"position",value:this._current}})}return this._current},e.prototype.invalidate=function(b){return"string"===a.type(b)&&(this._invalidated[b]=!0,this.is("valid")&&this.leave("valid")),a.map(this._invalidated,function(a,b){return b})},e.prototype.reset=function(a){(a=this.normalize(a))!==d&&(this._speed=0,this._current=a,this.suppress(["translate","translated"]),this.animate(this.coordinates(a)),this.release(["translate","translated"]))},e.prototype.normalize=function(a,b){var c=this._items.length,e=b?0:this._clones.length;return!this.isNumeric(a)||c<1?a=d:(a<0||a>=c+e)&&(a=((a-e/2)%c+c)%c+e/2),a},e.prototype.relative=function(a){return a-=this._clones.length/2,this.normalize(a,!0)},e.prototype.maximum=function(a){var b,c,d,e=this.settings,f=this._coordinates.length;if(e.loop)f=this._clones.length/2+this._items.length-1;else if(e.autoWidth||e.merge){if(b=this._items.length)for(c=this._items[--b].width(),d=this.$element.width();b--&&!((c+=this._items[b].width()+this.settings.margin)>d););f=b+1}else f=e.center?this._items.length-1:this._items.length-e.items;return a&&(f-=this._clones.length/2),Math.max(f,0)},e.prototype.minimum=function(a){return a?0:this._clones.length/2},e.prototype.items=function(a){return a===d?this._items.slice():(a=this.normalize(a,!0),this._items[a])},e.prototype.mergers=function(a){return a===d?this._mergers.slice():(a=this.normalize(a,!0),this._mergers[a])},e.prototype.clones=function(b){var c=this._clones.length/2,e=c+this._items.length,f=function(a){return a%2==0?e+a/2:c-(a+1)/2};return b===d?a.map(this._clones,function(a,b){return f(b)}):a.map(this._clones,function(a,c){return a===b?f(c):null})},e.prototype.speed=function(a){return a!==d&&(this._speed=a),this._speed},e.prototype.coordinates=function(b){var c,e=1,f=b-1;return b===d?a.map(this._coordinates,a.proxy(function(a,b){return this.coordinates(b)},this)):(this.settings.center?(this.settings.rtl&&(e=-1,f=b+1),c=this._coordinates[b],c+=(this.width()-c+(this._coordinates[f]||0))/2*e):c=this._coordinates[f]||0,c=Math.ceil(c))},e.prototype.duration=function(a,b,c){return 0===c?0:Math.min(Math.max(Math.abs(b-a),1),6)*Math.abs(c||this.settings.smartSpeed)},e.prototype.to=function(a,b){var c=this.current(),d=null,e=a-this.relative(c),f=(e>0)-(e<0),g=this._items.length,h=this.minimum(),i=this.maximum();this.settings.loop?(!this.settings.rewind&&Math.abs(e)>g/2&&(e+=-1*f*g),a=c+e,(d=((a-h)%g+g)%g+h)!==a&&d-e<=i&&d-e>0&&(c=d-e,a=d,this.reset(c))):this.settings.rewind?(i+=1,a=(a%i+i)%i):a=Math.max(h,Math.min(i,a)),this.speed(this.duration(c,a,b)),this.current(a),this.isVisible()&&this.update()},e.prototype.next=function(a){a=a||!1,this.to(this.relative(this.current())+1,a)},e.prototype.prev=function(a){a=a||!1,this.to(this.relative(this.current())-1,a)},e.prototype.onTransitionEnd=function(a){if(a!==d&&(a.stopPropagation(),(a.target||a.srcElement||a.originalTarget)!==this.$stage.get(0)))return!1;this.leave("animating"),this.trigger("translated")},e.prototype.viewport=function(){var d;return this.options.responsiveBaseElement!==b?d=a(this.options.responsiveBaseElement).width():b.innerWidth?d=b.innerWidth:c.documentElement&&c.documentElement.clientWidth?d=c.documentElement.clientWidth:console.warn("Can not detect viewport width."),d},e.prototype.replace=function(b){this.$stage.empty(),this._items=[],b&&(b=b instanceof jQuery?b:a(b)),this.settings.nestedItemSelector&&(b=b.find("."+this.settings.nestedItemSelector)),b.filter(function(){return 1===this.nodeType}).each(a.proxy(function(a,b){b=this.prepare(b),this.$stage.append(b),this._items.push(b),this._mergers.push(1*b.find("[data-merge]").addBack("[data-merge]").attr("data-merge")||1)},this)),this.reset(this.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate("items")},e.prototype.add=function(b,c){var e=this.relative(this._current);c=c===d?this._items.length:this.normalize(c,!0),b=b instanceof jQuery?b:a(b),this.trigger("add",{content:b,position:c}),b=this.prepare(b),0===this._items.length||c===this._items.length?(0===this._items.length&&this.$stage.append(b),0!==this._items.length&&this._items[c-1].after(b),this._items.push(b),this._mergers.push(1*b.find("[data-merge]").addBack("[data-merge]").attr("data-merge")||1)):(this._items[c].before(b),this._items.splice(c,0,b),this._mergers.splice(c,0,1*b.find("[data-merge]").addBack("[data-merge]").attr("data-merge")||1)),this._items[e]&&this.reset(this._items[e].index()),this.invalidate("items"),this.trigger("added",{content:b,position:c})},e.prototype.remove=function(a){(a=this.normalize(a,!0))!==d&&(this.trigger("remove",{content:this._items[a],position:a}),this._items[a].remove(),this._items.splice(a,1),this._mergers.splice(a,1),this.invalidate("items"),this.trigger("removed",{content:null,position:a}))},e.prototype.preloadAutoWidthImages=function(b){b.each(a.proxy(function(b,c){this.enter("pre-loading"),c=a(c),a(new Image).one("load",a.proxy(function(a){c.attr("src",a.target.src),c.css("opacity",1),this.leave("pre-loading"),!this.is("pre-loading")&&!this.is("initializing")&&this.refresh()},this)).attr("src",c.attr("src")||c.attr("data-src")||c.attr("data-src-retina"))},this))},e.prototype.destroy=function(){this.$element.off(".owl.core"),this.$stage.off(".owl.core"),a(c).off(".owl.core"),!1!==this.settings.responsive&&(b.clearTimeout(this.resizeTimer),this.off(b,"resize",this._handlers.onThrottledResize));for(var d in this._plugins)this._plugins[d].destroy();this.$stage.children(".cloned").remove(),this.$stage.unwrap(),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.remove(),this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr("class",this.$element.attr("class").replace(new RegExp(this.options.responsiveClass+"-\\S+\\s","g"),"")).removeData("owl.carousel")},e.prototype.op=function(a,b,c){var d=this.settings.rtl;switch(b){case"<":return d?a>c:a<c;case">":return d?a<c:a>c;case">=":return d?a<=c:a>=c;case"<=":return d?a>=c:a<=c}},e.prototype.on=function(a,b,c,d){a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent("on"+b,c)},e.prototype.off=function(a,b,c,d){a.removeEventListener?a.removeEventListener(b,c,d):a.detachEvent&&a.detachEvent("on"+b,c)},e.prototype.trigger=function(b,c,d,f,g){var h={item:{count:this._items.length,index:this.current()}},i=a.camelCase(a.grep(["on",b,d],function(a){return a}).join("-").toLowerCase()),j=a.Event([b,"owl",d||"carousel"].join(".").toLowerCase(),a.extend({relatedTarget:this},h,c));return this._supress[b]||(a.each(this._plugins,function(a,b){b.onTrigger&&b.onTrigger(j)}),this.register({type:e.Type.Event,name:b}),this.$element.trigger(j),this.settings&&"function"==typeof this.settings[i]&&this.settings[i].call(this,j)),j},e.prototype.enter=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]===d&&(this._states.current[b]=0),this._states.current[b]++},this))},e.prototype.leave=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]--},this))},e.prototype.register=function(b){if(b.type===e.Type.Event){if(a.event.special[b.name]||(a.event.special[b.name]={}),!a.event.special[b.name].owl){var c=a.event.special[b.name]._default;a.event.special[b.name]._default=function(a){return!c||!c.apply||a.namespace&&-1!==a.namespace.indexOf("owl")?a.namespace&&a.namespace.indexOf("owl")>-1:c.apply(this,arguments)},a.event.special[b.name].owl=!0}}else b.type===e.Type.State&&(this._states.tags[b.name]?this._states.tags[b.name]=this._states.tags[b.name].concat(b.tags):this._states.tags[b.name]=b.tags,this._states.tags[b.name]=a.grep(this._states.tags[b.name],a.proxy(function(c,d){return a.inArray(c,this._states.tags[b.name])===d},this)))},e.prototype.suppress=function(b){a.each(b,a.proxy(function(a,b){this._supress[b]=!0},this))},e.prototype.release=function(b){a.each(b,a.proxy(function(a,b){delete this._supress[b]},this))},e.prototype.pointer=function(a){var c={x:null,y:null};return a=a.originalEvent||a||b.event,a=a.touches&&a.touches.length?a.touches[0]:a.changedTouches&&a.changedTouches.length?a.changedTouches[0]:a,a.pageX?(c.x=a.pageX,c.y=a.pageY):(c.x=a.clientX,c.y=a.clientY),c},e.prototype.isNumeric=function(a){return!isNaN(parseFloat(a))},e.prototype.difference=function(a,b){return{x:a.x-b.x,y:a.y-b.y}},a.fn.owlCarousel=function(b){var c=Array.prototype.slice.call(arguments,1);return this.each(function(){var d=a(this),f=d.data("owl.carousel");f||(f=new e(this,"object"==typeof b&&b),d.data("owl.carousel",f),a.each(["next","prev","to","destroy","refresh","replace","add","remove"],function(b,c){f.register({type:e.Type.Event,name:c}),f.$element.on(c+".owl.carousel.core",a.proxy(function(a){a.namespace&&a.relatedTarget!==this&&(this.suppress([c]),f[c].apply(this,[].slice.call(arguments,1)),this.release([c]))},f))})),"string"==typeof b&&"_"!==b.charAt(0)&&f[b].apply(f,c)})},a.fn.owlCarousel.Constructor=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._interval=null,this._visible=null,this._handlers={"initialized.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.autoRefresh&&this.watch()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={autoRefresh:!0,autoRefreshInterval:500},e.prototype.watch=function(){this._interval||(this._visible=this._core.isVisible(),this._interval=b.setInterval(a.proxy(this.refresh,this),this._core.settings.autoRefreshInterval))},e.prototype.refresh=function(){this._core.isVisible()!==this._visible&&(this._visible=!this._visible,this._core.$element.toggleClass("owl-hidden",!this._visible),this._visible&&this._core.invalidate("width")&&this._core.refresh())},e.prototype.destroy=function(){var a,c;b.clearInterval(this._interval);for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(c in Object.getOwnPropertyNames(this))"function"!=typeof this[c]&&(this[c]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoRefresh=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._loaded=[],this._handlers={"initialized.owl.carousel change.owl.carousel resized.owl.carousel":a.proxy(function(b){if(b.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(b.property&&"position"==b.property.name||"initialized"==b.type)){var c=this._core.settings,e=c.center&&Math.ceil(c.items/2)||c.items,f=c.center&&-1*e||0,g=(b.property&&b.property.value!==d?b.property.value:this._core.current())+f,h=this._core.clones().length,i=a.proxy(function(a,b){this.load(b)},this);for(c.lazyLoadEager>0&&(e+=c.lazyLoadEager,c.loop&&(g-=c.lazyLoadEager,e++));f++<e;)this.load(h/2+this._core.relative(g)),h&&a.each(this._core.clones(this._core.relative(g)),i),g++}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={lazyLoad:!1,lazyLoadEager:0},e.prototype.load=function(c){var d=this._core.$stage.children().eq(c),e=d&&d.find(".owl-lazy");!e||a.inArray(d.get(0),this._loaded)>-1||(e.each(a.proxy(function(c,d){var e,f=a(d),g=b.devicePixelRatio>1&&f.attr("data-src-retina")||f.attr("data-src")||f.attr("data-srcset");this._core.trigger("load",{element:f,url:g},"lazy"),f.is("img")?f.one("load.owl.lazy",a.proxy(function(){f.css("opacity",1),this._core.trigger("loaded",{element:f,url:g},"lazy")},this)).attr("src",g):f.is("source")?f.one("load.owl.lazy",a.proxy(function(){this._core.trigger("loaded",{element:f,url:g},"lazy")},this)).attr("srcset",g):(e=new Image,e.onload=a.proxy(function(){f.css({"background-image":'url("'+g+'")',opacity:"1"}),this._core.trigger("loaded",{element:f,url:g},"lazy")},this),e.src=g)},this)),this._loaded.push(d.get(0)))},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this._core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Lazy=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(c){this._core=c,this._previousHeight=null,this._handlers={"initialized.owl.carousel refreshed.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&this.update()},this),"changed.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&"position"===a.property.name&&this.update()},this),"loaded.owl.lazy":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&a.element.closest("."+this._core.settings.itemClass).index()===this._core.current()&&this.update()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._intervalId=null;var d=this;a(b).on("load",function(){d._core.settings.autoHeight&&d.update()}),a(b).resize(function(){d._core.settings.autoHeight&&(null!=d._intervalId&&clearTimeout(d._intervalId),d._intervalId=setTimeout(function(){d.update()},250))})};e.Defaults={autoHeight:!1,autoHeightClass:"owl-height"},e.prototype.update=function(){var b=this._core._current,c=b+this._core.settings.items,d=this._core.settings.lazyLoad,e=this._core.$stage.children().toArray().slice(b,c),f=[],g=0;a.each(e,function(b,c){f.push(a(c).height())}),g=Math.max.apply(null,f),g<=1&&d&&this._previousHeight&&(g=this._previousHeight),this._previousHeight=g,this._core.$stage.parent().height(g).addClass(this._core.settings.autoHeightClass)},e.prototype.destroy=function(){var a,b;for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoHeight=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._videos={},this._playing=null,this._handlers={"initialized.owl.carousel":a.proxy(function(a){a.namespace&&this._core.register({type:"state",name:"playing",tags:["interacting"]})},this),"resize.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.video&&this.isInFullScreen()&&a.preventDefault()},this),"refreshed.owl.carousel":a.proxy(function(a){a.namespace&&this._core.is("resizing")&&this._core.$stage.find(".cloned .owl-video-frame").remove()},this),"changed.owl.carousel":a.proxy(function(a){a.namespace&&"position"===a.property.name&&this._playing&&this.stop()},this),"prepared.owl.carousel":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(".owl-video");c.length&&(c.css("display","none"),this.fetch(c,a(b.content)))}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on("click.owl.video",".owl-video-play-icon",a.proxy(function(a){this.play(a)},this))};e.Defaults={video:!1,videoHeight:!1,videoWidth:!1},e.prototype.fetch=function(a,b){var c=function(){return a.attr("data-vimeo-id")?"vimeo":a.attr("data-vzaar-id")?"vzaar":"youtube"}(),d=a.attr("data-vimeo-id")||a.attr("data-youtube-id")||a.attr("data-vzaar-id"),e=a.attr("data-width")||this._core.settings.videoWidth,f=a.attr("data-height")||this._core.settings.videoHeight,g=a.attr("href");if(!g)throw new Error("Missing video URL.");if(d=g.match(/(http:|https:|)\/\/(player.|www.|app.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com|be\-nocookie\.com)|vzaar\.com)\/(video\/|videos\/|embed\/|channels\/.+\/|groups\/.+\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/),d[3].indexOf("youtu")>-1)c="youtube";else if(d[3].indexOf("vimeo")>-1)c="vimeo";else{if(!(d[3].indexOf("vzaar")>-1))throw new Error("Video URL not supported.");c="vzaar"}d=d[6],this._videos[g]={type:c,id:d,width:e,height:f},b.attr("data-video",g),this.thumbnail(a,this._videos[g])},e.prototype.thumbnail=function(b,c){var d,e,f,g=c.width&&c.height?"width:"+c.width+"px;height:"+c.height+"px;":"",h=b.find("img"),i="src",j="",k=this._core.settings,l=function(c){e='<div class="owl-video-play-icon"></div>',d=k.lazyLoad?a("<div/>",{class:"owl-video-tn "+j,srcType:c}):a("<div/>",{class:"owl-video-tn",style:"opacity:1;background-image:url("+c+")"}),b.after(d),b.after(e)};if(b.wrap(a("<div/>",{class:"owl-video-wrapper",style:g})),this._core.settings.lazyLoad&&(i="data-src",j="owl-lazy"),h.length)return l(h.attr(i)),h.remove(),!1;"youtube"===c.type?(f="//img.youtube.com/vi/"+c.id+"/hqdefault.jpg",l(f)):"vimeo"===c.type?a.ajax({type:"GET",url:"//vimeo.com/api/v2/video/"+c.id+".json",jsonp:"callback",dataType:"jsonp",success:function(a){f=a[0].thumbnail_large,l(f)}}):"vzaar"===c.type&&a.ajax({type:"GET",url:"//vzaar.com/api/videos/"+c.id+".json",jsonp:"callback",dataType:"jsonp",success:function(a){f=a.framegrab_url,l(f)}})},e.prototype.stop=function(){this._core.trigger("stop",null,"video"),this._playing.find(".owl-video-frame").remove(),this._playing.removeClass("owl-video-playing"),this._playing=null,this._core.leave("playing"),this._core.trigger("stopped",null,"video")},e.prototype.play=function(b){var c,d=a(b.target),e=d.closest("."+this._core.settings.itemClass),f=this._videos[e.attr("data-video")],g=f.width||"100%",h=f.height||this._core.$stage.height();this._playing||(this._core.enter("playing"),this._core.trigger("play",null,"video"),e=this._core.items(this._core.relative(e.index())),this._core.reset(e.index()),c=a('<iframe frameborder="0" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>'),c.attr("height",h),c.attr("width",g),"youtube"===f.type?c.attr("src","//www.youtube.com/embed/"+f.id+"?autoplay=1&rel=0&v="+f.id):"vimeo"===f.type?c.attr("src","//player.vimeo.com/video/"+f.id+"?autoplay=1"):"vzaar"===f.type&&c.attr("src","//view.vzaar.com/"+f.id+"/player?autoplay=true"),a(c).wrap('<div class="owl-video-frame" />').insertAfter(e.find(".owl-video")),this._playing=e.addClass("owl-video-playing"))},e.prototype.isInFullScreen=function(){var b=c.fullscreenElement||c.mozFullScreenElement||c.webkitFullscreenElement;return b&&a(b).parent().hasClass("owl-video-frame")},e.prototype.destroy=function(){var a,b;this._core.$element.off("click.owl.video");for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Video=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this.core=b,this.core.options=a.extend({},e.Defaults,this.core.options),this.swapping=!0,this.previous=d,this.next=d,this.handlers={"change.owl.carousel":a.proxy(function(a){a.namespace&&"position"==a.property.name&&(this.previous=this.core.current(),this.next=a.property.value)},this),"drag.owl.carousel dragged.owl.carousel translated.owl.carousel":a.proxy(function(a){a.namespace&&(this.swapping="translated"==a.type)},this),"translate.owl.carousel":a.proxy(function(a){a.namespace&&this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()},this)},this.core.$element.on(this.handlers)};e.Defaults={animateOut:!1,
animateIn:!1},e.prototype.swap=function(){if(1===this.core.settings.items&&a.support.animation&&a.support.transition){this.core.speed(0);var b,c=a.proxy(this.clear,this),d=this.core.$stage.children().eq(this.previous),e=this.core.$stage.children().eq(this.next),f=this.core.settings.animateIn,g=this.core.settings.animateOut;this.core.current()!==this.previous&&(g&&(b=this.core.coordinates(this.previous)-this.core.coordinates(this.next),d.one(a.support.animation.end,c).css({left:b+"px"}).addClass("animated owl-animated-out").addClass(g)),f&&e.one(a.support.animation.end,c).addClass("animated owl-animated-in").addClass(f))}},e.prototype.clear=function(b){a(b.target).css({left:""}).removeClass("animated owl-animated-out owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.onTransitionEnd()},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Animate=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._call=null,this._time=0,this._timeout=0,this._paused=!0,this._handlers={"changed.owl.carousel":a.proxy(function(a){a.namespace&&"settings"===a.property.name?this._core.settings.autoplay?this.play():this.stop():a.namespace&&"position"===a.property.name&&this._paused&&(this._time=0)},this),"initialized.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.autoplay&&this.play()},this),"play.owl.autoplay":a.proxy(function(a,b,c){a.namespace&&this.play(b,c)},this),"stop.owl.autoplay":a.proxy(function(a){a.namespace&&this.stop()},this),"mouseover.owl.autoplay":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is("rotating")&&this.pause()},this),"mouseleave.owl.autoplay":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is("rotating")&&this.play()},this),"touchstart.owl.core":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is("rotating")&&this.pause()},this),"touchend.owl.core":a.proxy(function(){this._core.settings.autoplayHoverPause&&this.play()},this)},this._core.$element.on(this._handlers),this._core.options=a.extend({},e.Defaults,this._core.options)};e.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},e.prototype._next=function(d){this._call=b.setTimeout(a.proxy(this._next,this,d),this._timeout*(Math.round(this.read()/this._timeout)+1)-this.read()),this._core.is("interacting")||c.hidden||this._core.next(d||this._core.settings.autoplaySpeed)},e.prototype.read=function(){return(new Date).getTime()-this._time},e.prototype.play=function(c,d){var e;this._core.is("rotating")||this._core.enter("rotating"),c=c||this._core.settings.autoplayTimeout,e=Math.min(this._time%(this._timeout||c),c),this._paused?(this._time=this.read(),this._paused=!1):b.clearTimeout(this._call),this._time+=this.read()%c-e,this._timeout=c,this._call=b.setTimeout(a.proxy(this._next,this,d),c-e)},e.prototype.stop=function(){this._core.is("rotating")&&(this._time=0,this._paused=!0,b.clearTimeout(this._call),this._core.leave("rotating"))},e.prototype.pause=function(){this._core.is("rotating")&&!this._paused&&(this._time=this.read(),this._paused=!0,b.clearTimeout(this._call))},e.prototype.destroy=function(){var a,b;this.stop();for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.autoplay=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){"use strict";var e=function(b){this._core=b,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={"prepared.owl.carousel":a.proxy(function(b){b.namespace&&this._core.settings.dotsData&&this._templates.push('<div class="'+this._core.settings.dotClass+'">'+a(b.content).find("[data-dot]").addBack("[data-dot]").attr("data-dot")+"</div>")},this),"added.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,0,this._templates.pop())},this),"remove.owl.carousel":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,1)},this),"changed.owl.carousel":a.proxy(function(a){a.namespace&&"position"==a.property.name&&this.draw()},this),"initialized.owl.carousel":a.proxy(function(a){a.namespace&&!this._initialized&&(this._core.trigger("initialize",null,"navigation"),this.initialize(),this.update(),this.draw(),this._initialized=!0,this._core.trigger("initialized",null,"navigation"))},this),"refreshed.owl.carousel":a.proxy(function(a){a.namespace&&this._initialized&&(this._core.trigger("refresh",null,"navigation"),this.update(),this.draw(),this._core.trigger("refreshed",null,"navigation"))},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers)};e.Defaults={nav:!1,navText:['<span aria-label="Previous">&#x2039;</span>','<span aria-label="Next">&#x203a;</span>'],navSpeed:!1,navElement:'button type="button" role="presentation"',navContainer:!1,navContainerClass:"owl-nav",navClass:["owl-prev","owl-next"],slideBy:1,dotClass:"owl-dot",dotsClass:"owl-dots",dots:!0,dotsEach:!1,dotsData:!1,dotsSpeed:!1,dotsContainer:!1},e.prototype.initialize=function(){var b,c=this._core.settings;this._controls.$relative=(c.navContainer?a(c.navContainer):a("<div>").addClass(c.navContainerClass).appendTo(this.$element)).addClass("disabled"),this._controls.$previous=a("<"+c.navElement+">").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on("click",a.proxy(function(a){this.prev(c.navSpeed)},this)),this._controls.$next=a("<"+c.navElement+">").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on("click",a.proxy(function(a){this.next(c.navSpeed)},this)),c.dotsData||(this._templates=[a('<button role="button">').addClass(c.dotClass).append(a("<span>")).prop("outerHTML")]),this._controls.$absolute=(c.dotsContainer?a(c.dotsContainer):a("<div>").addClass(c.dotsClass).appendTo(this.$element)).addClass("disabled"),this._controls.$absolute.on("click","button",a.proxy(function(b){var d=a(b.target).parent().is(this._controls.$absolute)?a(b.target).index():a(b.target).parent().index();b.preventDefault(),this.to(d,c.dotsSpeed)},this));for(b in this._overrides)this._core[b]=a.proxy(this[b],this)},e.prototype.destroy=function(){var a,b,c,d,e;e=this._core.settings;for(a in this._handlers)this.$element.off(a,this._handlers[a]);for(b in this._controls)"$relative"===b&&e.navContainer?this._controls[b].html(""):this._controls[b].remove();for(d in this.overides)this._core[d]=this._overrides[d];for(c in Object.getOwnPropertyNames(this))"function"!=typeof this[c]&&(this[c]=null)},e.prototype.update=function(){var a,b,c,d=this._core.clones().length/2,e=d+this._core.items().length,f=this._core.maximum(!0),g=this._core.settings,h=g.center||g.autoWidth||g.dotsData?1:g.dotsEach||g.items;if("page"!==g.slideBy&&(g.slideBy=Math.min(g.slideBy,g.items)),g.dots||"page"==g.slideBy)for(this._pages=[],a=d,b=0,c=0;a<e;a++){if(b>=h||0===b){if(this._pages.push({start:Math.min(f,a-d),end:a-d+h-1}),Math.min(f,a-d)===f)break;b=0,++c}b+=this._core.mergers(this._core.relative(a))}},e.prototype.draw=function(){var b,c=this._core.settings,d=this._core.items().length<=c.items,e=this._core.relative(this._core.current()),f=c.loop||c.rewind;this._controls.$relative.toggleClass("disabled",!c.nav||d),c.nav&&(this._controls.$previous.toggleClass("disabled",!f&&e<=this._core.minimum(!0)),this._controls.$next.toggleClass("disabled",!f&&e>=this._core.maximum(!0))),this._controls.$absolute.toggleClass("disabled",!c.dots||d),c.dots&&(b=this._pages.length-this._controls.$absolute.children().length,c.dotsData&&0!==b?this._controls.$absolute.html(this._templates.join("")):b>0?this._controls.$absolute.append(new Array(b+1).join(this._templates[0])):b<0&&this._controls.$absolute.children().slice(b).remove(),this._controls.$absolute.find(".active").removeClass("active"),this._controls.$absolute.children().eq(a.inArray(this.current(),this._pages)).addClass("active"))},e.prototype.onTrigger=function(b){var c=this._core.settings;b.page={index:a.inArray(this.current(),this._pages),count:this._pages.length,size:c&&(c.center||c.autoWidth||c.dotsData?1:c.dotsEach||c.items)}},e.prototype.current=function(){var b=this._core.relative(this._core.current());return a.grep(this._pages,a.proxy(function(a,c){return a.start<=b&&a.end>=b},this)).pop()},e.prototype.getPosition=function(b){var c,d,e=this._core.settings;return"page"==e.slideBy?(c=a.inArray(this.current(),this._pages),d=this._pages.length,b?++c:--c,c=this._pages[(c%d+d)%d].start):(c=this._core.relative(this._core.current()),d=this._core.items().length,b?c+=e.slideBy:c-=e.slideBy),c},e.prototype.next=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!0),b)},e.prototype.prev=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!1),b)},e.prototype.to=function(b,c,d){var e;!d&&this._pages.length?(e=this._pages.length,a.proxy(this._overrides.to,this._core)(this._pages[(b%e+e)%e].start,c)):a.proxy(this._overrides.to,this._core)(b,c)},a.fn.owlCarousel.Constructor.Plugins.Navigation=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){"use strict";var e=function(c){this._core=c,this._hashes={},this.$element=this._core.$element,this._handlers={"initialized.owl.carousel":a.proxy(function(c){c.namespace&&"URLHash"===this._core.settings.startPosition&&a(b).trigger("hashchange.owl.navigation")},this),"prepared.owl.carousel":a.proxy(function(b){if(b.namespace){var c=a(b.content).find("[data-hash]").addBack("[data-hash]").attr("data-hash");if(!c)return;this._hashes[c]=b.content}},this),"changed.owl.carousel":a.proxy(function(c){if(c.namespace&&"position"===c.property.name){var d=this._core.items(this._core.relative(this._core.current())),e=a.map(this._hashes,function(a,b){return a===d?b:null}).join();if(!e||b.location.hash.slice(1)===e)return;b.location.hash=e}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers),a(b).on("hashchange.owl.navigation",a.proxy(function(a){var c=b.location.hash.substring(1),e=this._core.$stage.children(),f=this._hashes[c]&&e.index(this._hashes[c]);f!==d&&f!==this._core.current()&&this._core.to(this._core.relative(f),!1,!0)},this))};e.Defaults={URLhashListener:!1},e.prototype.destroy=function(){var c,d;a(b).off("hashchange.owl.navigation");for(c in this._handlers)this._core.$element.off(c,this._handlers[c]);for(d in Object.getOwnPropertyNames(this))"function"!=typeof this[d]&&(this[d]=null)},a.fn.owlCarousel.Constructor.Plugins.Hash=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){function e(b,c){var e=!1,f=b.charAt(0).toUpperCase()+b.slice(1);return a.each((b+" "+h.join(f+" ")+f).split(" "),function(a,b){if(g[b]!==d)return e=!c||b,!1}),e}function f(a){return e(a,!0)}var g=a("<support>").get(0).style,h="Webkit Moz O ms".split(" "),i={transition:{end:{WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd",transition:"transitionend"}},animation:{end:{WebkitAnimation:"webkitAnimationEnd",MozAnimation:"animationend",OAnimation:"oAnimationEnd",animation:"animationend"}}},j={csstransforms:function(){return!!e("transform")},csstransforms3d:function(){return!!e("perspective")},csstransitions:function(){return!!e("transition")},cssanimations:function(){return!!e("animation")}};j.csstransitions()&&(a.support.transition=new String(f("transition")),a.support.transition.end=i.transition.end[a.support.transition]),j.cssanimations()&&(a.support.animation=new String(f("animation")),a.support.animation.end=i.animation.end[a.support.animation]),j.csstransforms()&&(a.support.transform=new String(f("transform")),a.support.transform3d=j.csstransforms3d())}(window.Zepto||window.jQuery,window,document);
} catch (e) {
console.error('Error in file:/templates/archi/js/owl.carousel.js; Error:' + e.message);
};
try {
(function ($) {
	$.fn.countTo = function (options) {
		options = options || {};

		return $(this).each(function () {
			// set options for current element
			var settings = $.extend({}, $.fn.countTo.defaults, {
				from:            $(this).data('from'),
				to:              $(this).data('to'),
				speed:           $(this).data('speed'),
				refreshInterval: $(this).data('refresh-interval'),
				decimals:        $(this).data('decimals')
			}, options);

			// how many times to update the value, and how much to increment the value on each update
			var loops = Math.ceil(settings.speed / settings.refreshInterval),
				increment = (settings.to - settings.from) / loops;

			// references & variables that will change with each update
			var self = this,
				$self = $(this),
				loopCount = 0,
				value = settings.from,
				data = $self.data('countTo') || {};

			$self.data('countTo', data);

			// if an existing interval can be found, clear it first
			if (data.interval) {
				clearInterval(data.interval);
			}
			data.interval = setInterval(updateTimer, settings.refreshInterval);

			// initialize the element with the starting value
			render(value);

			function updateTimer() {
				value += increment;
				loopCount++;

				render(value);

				if (typeof(settings.onUpdate) == 'function') {
					settings.onUpdate.call(self, value);
				}

				if (loopCount >= loops) {
					// remove the interval
					$self.removeData('countTo');
					clearInterval(data.interval);
					value = settings.to;

					if (typeof(settings.onComplete) == 'function') {
						settings.onComplete.call(self, value);
					}
				}
			}

			function render(value) {
				var formattedValue = settings.formatter.call(self, value, settings);
				$self.text(formattedValue);
			}
		});
	};

	$.fn.countTo.defaults = {
		from: 0,               // the number the element should start at
		to: 0,                 // the number the element should end at
		speed: 1000,           // how long it should take to count between the target numbers
		refreshInterval: 100,  // how often the element should be updated
		decimals: 0,           // the number of decimal places to show
		formatter: formatter,  // handler for formatting the value before rendering
		onUpdate: null,        // callback method for every time the element is updated
		onComplete: null       // callback method for when the element finishes updating
	};

	function formatter(value, settings) {
		return value.toFixed(settings.decimals);
	}
}(jQuery));

} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.countTo.js; Error:' + e.message);
};
try {
/*!
 * classie v1.0.0
 * class helper functions
 * from bonzo https://github.com/ded/bonzo
 * MIT license
 * 
 * classie.has( elem, 'my-class' ) -> true/false
 * classie.add( elem, 'my-new-class' )
 * classie.remove( elem, 'my-unwanted-class' )
 * classie.toggle( elem, 'my-class' )
 */

/*jshint browser: true, strict: true, undef: true, unused: true */
/*global define: false */

( function( window ) {

'use strict';

// class helper functions from bonzo https://github.com/ded/bonzo

function classReg( className ) {
  return new RegExp("(^|\\s+)" + className + "(\\s+|$)");
}

// classList support for class management
// altho to be fair, the api sucks because it won't accept multiple classes at once
var hasClass, addClass, removeClass;

if ( 'classList' in document.documentElement ) {
  hasClass = function( elem, c ) {
    return elem.classList.contains( c );
  };
  addClass = function( elem, c ) {
    elem.classList.add( c );
  };
  removeClass = function( elem, c ) {
    elem.classList.remove( c );
  };
}
else {
  hasClass = function( elem, c ) {
    return classReg( c ).test( elem.className );
  };
  addClass = function( elem, c ) {
    if ( !hasClass( elem, c ) ) {
      elem.className = elem.className + ' ' + c;
    }
  };
  removeClass = function( elem, c ) {
    elem.className = elem.className.replace( classReg( c ), ' ' );
  };
}

function toggleClass( elem, c ) {
  var fn = hasClass( elem, c ) ? removeClass : addClass;
  fn( elem, c );
}

var classie = {
  // full names
  hasClass: hasClass,
  addClass: addClass,
  removeClass: removeClass,
  toggleClass: toggleClass,
  // short names
  has: hasClass,
  add: addClass,
  remove: removeClass,
  toggle: toggleClass
};

// transport
if ( typeof define === 'function' && define.amd ) {
  // AMD
  define( classie );
} else {
  // browser global
  window.classie = classie;
}

})( window );

} catch (e) {
console.error('Error in file:/templates/archi/js/classie.js; Error:' + e.message);
};
try {
/*global jQuery */
/*!
* FitVids 1.0
*
* Copyright 2011, Chris Coyier - http://css-tricks.com + Dave Rupert - http://daverupert.com
* Credit to Thierry Koblentz - http://www.alistapart.com/articles/creating-intrinsic-ratios-for-video/
* Released under the WTFPL license - http://sam.zoy.org/wtfpl/
*
* Date: Thu Sept 01 18:00:00 2011 -0500
*/

(function( $ ){

  $.fn.fitVids = function( options ) {
    var settings = {
      customSelector: null
    }

    var div = document.createElement('div'),
        ref = document.getElementsByTagName('base')[0] || document.getElementsByTagName('script')[0];

    div.className = 'fit-vids-style';
    div.innerHTML = '&shy;<style> \
.fluid-width-video-wrapper { \
width: 100%; \
position: relative; \
padding: 0; \
} \
\
.fluid-width-video-wrapper iframe, \
.fluid-width-video-wrapper object, \
.fluid-width-video-wrapper embed { \
position: absolute; \
top: 0; \
left: 0; \
width: 100%; \
height: 100%; \
} \
</style>';

    ref.parentNode.insertBefore(div,ref);

    if ( options ) {
      $.extend( settings, options );
    }

    return this.each(function(){
      var selectors = [
        "iframe[src*='player.vimeo.com']",
        "iframe[src*='www.youtube.com']",
        "iframe[src*='www.kickstarter.com']",
        "object",
        "embed"
      ];

      if (settings.customSelector) {
        selectors.push(settings.customSelector);
      }

      var $allVideos = $(this).find(selectors.join(','));

      $allVideos.each(function(){
        var $this = $(this);
        if (this.tagName.toLowerCase() == 'embed' && $this.parent('object').length || $this.parent('.fluid-width-video-wrapper').length) { return; }
        var height = ( this.tagName.toLowerCase() == 'object' || $this.attr('height') ) ? $this.attr('height') : $this.height(),
            width = $this.attr('width') ? $this.attr('width') : $this.width(),
            aspectRatio = height / width;
        if(!$this.attr('id')){
          var videoID = 'fitvid' + Math.floor(Math.random()*999999);
          $this.attr('id', videoID);
        }
        $this.wrap('<div class="fluid-width-video-wrapper"></div>').parent('.fluid-width-video-wrapper').css('padding-top', (aspectRatio * 100)+"%");
        $this.removeAttr('height').removeAttr('width');
      });
    });
  }
})( jQuery );
} catch (e) {
console.error('Error in file:/templates/archi/js/video.resize.js; Error:' + e.message);
};
try {
/*! WOW - v1.0.3 - 2015-01-14
* Copyright (c) 2015 Matthieu Aussaguel; Licensed MIT */(function(){var a,b,c,d,e,f=function(a,b){return function(){return a.apply(b,arguments)}},g=[].indexOf||function(a){for(var b=0,c=this.length;c>b;b++)if(b in this&&this[b]===a)return b;return-1};b=function(){function a(){}return a.prototype.extend=function(a,b){var c,d;for(c in b)d=b[c],null==a[c]&&(a[c]=d);return a},a.prototype.isMobile=function(a){return/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(a)},a.prototype.addEvent=function(a,b,c){return null!=a.addEventListener?a.addEventListener(b,c,!1):null!=a.attachEvent?a.attachEvent("on"+b,c):a[b]=c},a.prototype.removeEvent=function(a,b,c){return null!=a.removeEventListener?a.removeEventListener(b,c,!1):null!=a.detachEvent?a.detachEvent("on"+b,c):delete a[b]},a.prototype.innerHeight=function(){return"innerHeight"in window?window.innerHeight:document.documentElement.clientHeight},a}(),c=this.WeakMap||this.MozWeakMap||(c=function(){function a(){this.keys=[],this.values=[]}return a.prototype.get=function(a){var b,c,d,e,f;for(f=this.keys,b=d=0,e=f.length;e>d;b=++d)if(c=f[b],c===a)return this.values[b]},a.prototype.set=function(a,b){var c,d,e,f,g;for(g=this.keys,c=e=0,f=g.length;f>e;c=++e)if(d=g[c],d===a)return void(this.values[c]=b);return this.keys.push(a),this.values.push(b)},a}()),a=this.MutationObserver||this.WebkitMutationObserver||this.MozMutationObserver||(a=function(){function a(){"undefined"!=typeof console&&null!==console&&console.warn("MutationObserver is not supported by your browser."),"undefined"!=typeof console&&null!==console&&console.warn("WOW.js cannot detect dom mutations, please call .sync() after loading new content.")}return a.notSupported=!0,a.prototype.observe=function(){},a}()),d=this.getComputedStyle||function(a){return this.getPropertyValue=function(b){var c;return"float"===b&&(b="styleFloat"),e.test(b)&&b.replace(e,function(a,b){return b.toUpperCase()}),(null!=(c=a.currentStyle)?c[b]:void 0)||null},this},e=/(\-([a-z]){1})/g,this.WOW=function(){function e(a){null==a&&(a={}),this.scrollCallback=f(this.scrollCallback,this),this.scrollHandler=f(this.scrollHandler,this),this.start=f(this.start,this),this.scrolled=!0,this.config=this.util().extend(a,this.defaults),this.animationNameCache=new c}return e.prototype.defaults={boxClass:"wow",animateClass:"animated",offset:0,mobile:!0,live:!0,callback:null},e.prototype.init=function(){var a;return this.element=window.document.documentElement,"interactive"===(a=document.readyState)||"complete"===a?this.start():this.util().addEvent(document,"DOMContentLoaded",this.start),this.finished=[]},e.prototype.start=function(){var b,c,d,e;if(this.stopped=!1,this.boxes=function(){var a,c,d,e;for(d=this.element.querySelectorAll("."+this.config.boxClass),e=[],a=0,c=d.length;c>a;a++)b=d[a],e.push(b);return e}.call(this),this.all=function(){var a,c,d,e;for(d=this.boxes,e=[],a=0,c=d.length;c>a;a++)b=d[a],e.push(b);return e}.call(this),this.boxes.length)if(this.disabled())this.resetStyle();else for(e=this.boxes,c=0,d=e.length;d>c;c++)b=e[c],this.applyStyle(b,!0);return this.disabled()||(this.util().addEvent(window,"scroll",this.scrollHandler),this.util().addEvent(window,"resize",this.scrollHandler),this.interval=setInterval(this.scrollCallback,50)),this.config.live?new a(function(a){return function(b){var c,d,e,f,g;for(g=[],e=0,f=b.length;f>e;e++)d=b[e],g.push(function(){var a,b,e,f;for(e=d.addedNodes||[],f=[],a=0,b=e.length;b>a;a++)c=e[a],f.push(this.doSync(c));return f}.call(a));return g}}(this)).observe(document.body,{childList:!0,subtree:!0}):void 0},e.prototype.stop=function(){return this.stopped=!0,this.util().removeEvent(window,"scroll",this.scrollHandler),this.util().removeEvent(window,"resize",this.scrollHandler),null!=this.interval?clearInterval(this.interval):void 0},e.prototype.sync=function(){return a.notSupported?this.doSync(this.element):void 0},e.prototype.doSync=function(a){var b,c,d,e,f;if(null==a&&(a=this.element),1===a.nodeType){for(a=a.parentNode||a,e=a.querySelectorAll("."+this.config.boxClass),f=[],c=0,d=e.length;d>c;c++)b=e[c],g.call(this.all,b)<0?(this.boxes.push(b),this.all.push(b),this.stopped||this.disabled()?this.resetStyle():this.applyStyle(b,!0),f.push(this.scrolled=!0)):f.push(void 0);return f}},e.prototype.show=function(a){return this.applyStyle(a),a.className=""+a.className+" "+this.config.animateClass,null!=this.config.callback?this.config.callback(a):void 0},e.prototype.applyStyle=function(a,b){var c,d,e;return d=a.getAttribute("data-wow-duration"),c=a.getAttribute("data-wow-delay"),e=a.getAttribute("data-wow-iteration"),this.animate(function(f){return function(){return f.customStyle(a,b,d,c,e)}}(this))},e.prototype.animate=function(){return"requestAnimationFrame"in window?function(a){return window.requestAnimationFrame(a)}:function(a){return a()}}(),e.prototype.resetStyle=function(){var a,b,c,d,e;for(d=this.boxes,e=[],b=0,c=d.length;c>b;b++)a=d[b],e.push(a.style.visibility="visible");return e},e.prototype.customStyle=function(a,b,c,d,e){return b&&this.cacheAnimationName(a),a.style.visibility=b?"hidden":"visible",c&&this.vendorSet(a.style,{animationDuration:c}),d&&this.vendorSet(a.style,{animationDelay:d}),e&&this.vendorSet(a.style,{animationIterationCount:e}),this.vendorSet(a.style,{animationName:b?"none":this.cachedAnimationName(a)}),a},e.prototype.vendors=["moz","webkit"],e.prototype.vendorSet=function(a,b){var c,d,e,f;f=[];for(c in b)d=b[c],a[""+c]=d,f.push(function(){var b,f,g,h;for(g=this.vendors,h=[],b=0,f=g.length;f>b;b++)e=g[b],h.push(a[""+e+c.charAt(0).toUpperCase()+c.substr(1)]=d);return h}.call(this));return f},e.prototype.vendorCSS=function(a,b){var c,e,f,g,h,i;for(e=d(a),c=e.getPropertyCSSValue(b),i=this.vendors,g=0,h=i.length;h>g;g++)f=i[g],c=c||e.getPropertyCSSValue("-"+f+"-"+b);return c},e.prototype.animationName=function(a){var b;try{b=this.vendorCSS(a,"animation-name").cssText}catch(c){b=d(a).getPropertyValue("animation-name")}return"none"===b?"":b},e.prototype.cacheAnimationName=function(a){return this.animationNameCache.set(a,this.animationName(a))},e.prototype.cachedAnimationName=function(a){return this.animationNameCache.get(a)},e.prototype.scrollHandler=function(){return this.scrolled=!0},e.prototype.scrollCallback=function(){var a;return!this.scrolled||(this.scrolled=!1,this.boxes=function(){var b,c,d,e;for(d=this.boxes,e=[],b=0,c=d.length;c>b;b++)a=d[b],a&&(this.isVisible(a)?this.show(a):e.push(a));return e}.call(this),this.boxes.length||this.config.live)?void 0:this.stop()},e.prototype.offsetTop=function(a){for(var b;void 0===a.offsetTop;)a=a.parentNode;for(b=a.offsetTop;a=a.offsetParent;)b+=a.offsetTop;return b},e.prototype.isVisible=function(a){var b,c,d,e,f;return c=a.getAttribute("data-wow-offset")||this.config.offset,f=window.pageYOffset,e=f+Math.min(this.element.clientHeight,this.util().innerHeight())-c,d=this.offsetTop(a),b=d+a.clientHeight,e>=d&&b>=f},e.prototype.util=function(){return null!=this._util?this._util:this._util=new b},e.prototype.disabled=function(){return!this.config.mobile&&this.util().isMobile(navigator.userAgent)},e}()}).call(this);
} catch (e) {
console.error('Error in file:/templates/archi/js/wow.min.js; Error:' + e.message);
};
try {
/*! Magnific Popup - v1.0.0 - 2015-01-03
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2015 Dmitry Semenov; */
!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a("object"==typeof exports?require("jquery"):window.jQuery||window.Zepto)}(function(a){var b,c,d,e,f,g,h="Close",i="BeforeClose",j="AfterClose",k="BeforeAppend",l="MarkupParse",m="Open",n="Change",o="mfp",p="."+o,q="mfp-ready",r="mfp-removing",s="mfp-prevent-close",t=function(){},u=!!window.jQuery,v=a(window),w=function(a,c){b.ev.on(o+a+p,c)},x=function(b,c,d,e){var f=document.createElement("div");return f.className="mfp-"+b,d&&(f.innerHTML=d),e?c&&c.appendChild(f):(f=a(f),c&&f.appendTo(c)),f},y=function(c,d){b.ev.triggerHandler(o+c,d),b.st.callbacks&&(c=c.charAt(0).toLowerCase()+c.slice(1),b.st.callbacks[c]&&b.st.callbacks[c].apply(b,a.isArray(d)?d:[d]))},z=function(c){return c===g&&b.currTemplate.closeBtn||(b.currTemplate.closeBtn=a(b.st.closeMarkup.replace("%title%",b.st.tClose)),g=c),b.currTemplate.closeBtn},A=function(){a.magnificPopup.instance||(b=new t,b.init(),a.magnificPopup.instance=b)},B=function(){var a=document.createElement("p").style,b=["ms","O","Moz","Webkit"];if(void 0!==a.transition)return!0;for(;b.length;)if(b.pop()+"Transition"in a)return!0;return!1};t.prototype={constructor:t,init:function(){var c=navigator.appVersion;b.isIE7=-1!==c.indexOf("MSIE 7."),b.isIE8=-1!==c.indexOf("MSIE 8."),b.isLowIE=b.isIE7||b.isIE8,b.isAndroid=/android/gi.test(c),b.isIOS=/iphone|ipad|ipod/gi.test(c),b.supportsTransition=B(),b.probablyMobile=b.isAndroid||b.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),d=a(document),b.popupsCache={}},open:function(c){var e;if(c.isObj===!1){b.items=c.items.toArray(),b.index=0;var g,h=c.items;for(e=0;e<h.length;e++)if(g=h[e],g.parsed&&(g=g.el[0]),g===c.el[0]){b.index=e;break}}else b.items=a.isArray(c.items)?c.items:[c.items],b.index=c.index||0;if(b.isOpen)return void b.updateItemHTML();b.types=[],f="",b.ev=c.mainEl&&c.mainEl.length?c.mainEl.eq(0):d,c.key?(b.popupsCache[c.key]||(b.popupsCache[c.key]={}),b.currTemplate=b.popupsCache[c.key]):b.currTemplate={},b.st=a.extend(!0,{},a.magnificPopup.defaults,c),b.fixedContentPos="auto"===b.st.fixedContentPos?!b.probablyMobile:b.st.fixedContentPos,b.st.modal&&(b.st.closeOnContentClick=!1,b.st.closeOnBgClick=!1,b.st.showCloseBtn=!1,b.st.enableEscapeKey=!1),b.bgOverlay||(b.bgOverlay=x("bg").on("click"+p,function(){b.close()}),b.wrap=x("wrap").attr("tabindex",-1).on("click"+p,function(a){b._checkIfClose(a.target)&&b.close()}),b.container=x("container",b.wrap)),b.contentContainer=x("content"),b.st.preloader&&(b.preloader=x("preloader",b.container,b.st.tLoading));var i=a.magnificPopup.modules;for(e=0;e<i.length;e++){var j=i[e];j=j.charAt(0).toUpperCase()+j.slice(1),b["init"+j].call(b)}y("BeforeOpen"),b.st.showCloseBtn&&(b.st.closeBtnInside?(w(l,function(a,b,c,d){c.close_replaceWith=z(d.type)}),f+=" mfp-close-btn-in"):b.wrap.append(z())),b.st.alignTop&&(f+=" mfp-align-top"),b.wrap.css(b.fixedContentPos?{overflow:b.st.overflowY,overflowX:"hidden",overflowY:b.st.overflowY}:{top:v.scrollTop(),position:"absolute"}),(b.st.fixedBgPos===!1||"auto"===b.st.fixedBgPos&&!b.fixedContentPos)&&b.bgOverlay.css({height:d.height(),position:"absolute"}),b.st.enableEscapeKey&&d.on("keyup"+p,function(a){27===a.keyCode&&b.close()}),v.on("resize"+p,function(){b.updateSize()}),b.st.closeOnContentClick||(f+=" mfp-auto-cursor"),f&&b.wrap.addClass(f);var k=b.wH=v.height(),n={};if(b.fixedContentPos&&b._hasScrollBar(k)){var o=b._getScrollbarSize();o&&(n.marginRight=o)}b.fixedContentPos&&(b.isIE7?a("body, html").css("overflow","hidden"):n.overflow="hidden");var r=b.st.mainClass;return b.isIE7&&(r+=" mfp-ie7"),r&&b._addClassToMFP(r),b.updateItemHTML(),y("BuildControls"),a("html").css(n),b.bgOverlay.add(b.wrap).prependTo(b.st.prependTo||a(document.body)),b._lastFocusedEl=document.activeElement,setTimeout(function(){b.content?(b._addClassToMFP(q),b._setFocus()):b.bgOverlay.addClass(q),d.on("focusin"+p,b._onFocusIn)},16),b.isOpen=!0,b.updateSize(k),y(m),c},close:function(){b.isOpen&&(y(i),b.isOpen=!1,b.st.removalDelay&&!b.isLowIE&&b.supportsTransition?(b._addClassToMFP(r),setTimeout(function(){b._close()},b.st.removalDelay)):b._close())},_close:function(){y(h);var c=r+" "+q+" ";if(b.bgOverlay.detach(),b.wrap.detach(),b.container.empty(),b.st.mainClass&&(c+=b.st.mainClass+" "),b._removeClassFromMFP(c),b.fixedContentPos){var e={marginRight:""};b.isIE7?a("body, html").css("overflow",""):e.overflow="",a("html").css(e)}d.off("keyup"+p+" focusin"+p),b.ev.off(p),b.wrap.attr("class","mfp-wrap").removeAttr("style"),b.bgOverlay.attr("class","mfp-bg"),b.container.attr("class","mfp-container"),!b.st.showCloseBtn||b.st.closeBtnInside&&b.currTemplate[b.currItem.type]!==!0||b.currTemplate.closeBtn&&b.currTemplate.closeBtn.detach(),b._lastFocusedEl&&a(b._lastFocusedEl).focus(),b.currItem=null,b.content=null,b.currTemplate=null,b.prevHeight=0,y(j)},updateSize:function(a){if(b.isIOS){var c=document.documentElement.clientWidth/window.innerWidth,d=window.innerHeight*c;b.wrap.css("height",d),b.wH=d}else b.wH=a||v.height();b.fixedContentPos||b.wrap.css("height",b.wH),y("Resize")},updateItemHTML:function(){var c=b.items[b.index];b.contentContainer.detach(),b.content&&b.content.detach(),c.parsed||(c=b.parseEl(b.index));var d=c.type;if(y("BeforeChange",[b.currItem?b.currItem.type:"",d]),b.currItem=c,!b.currTemplate[d]){var f=b.st[d]?b.st[d].markup:!1;y("FirstMarkupParse",f),b.currTemplate[d]=f?a(f):!0}e&&e!==c.type&&b.container.removeClass("mfp-"+e+"-holder");var g=b["get"+d.charAt(0).toUpperCase()+d.slice(1)](c,b.currTemplate[d]);b.appendContent(g,d),c.preloaded=!0,y(n,c),e=c.type,b.container.prepend(b.contentContainer),y("AfterChange")},appendContent:function(a,c){b.content=a,a?b.st.showCloseBtn&&b.st.closeBtnInside&&b.currTemplate[c]===!0?b.content.find(".mfp-close").length||b.content.append(z()):b.content=a:b.content="",y(k),b.container.addClass("mfp-"+c+"-holder"),b.contentContainer.append(b.content)},parseEl:function(c){var d,e=b.items[c];if(e.tagName?e={el:a(e)}:(d=e.type,e={data:e,src:e.src}),e.el){for(var f=b.types,g=0;g<f.length;g++)if(e.el.hasClass("mfp-"+f[g])){d=f[g];break}e.src=e.el.attr("data-mfp-src"),e.src||(e.src=e.el.attr("href"))}return e.type=d||b.st.type||"inline",e.index=c,e.parsed=!0,b.items[c]=e,y("ElementParse",e),b.items[c]},addGroup:function(a,c){var d=function(d){d.mfpEl=this,b._openClick(d,a,c)};c||(c={});var e="click.magnificPopup";c.mainEl=a,c.items?(c.isObj=!0,a.off(e).on(e,d)):(c.isObj=!1,c.delegate?a.off(e).on(e,c.delegate,d):(c.items=a,a.off(e).on(e,d)))},_openClick:function(c,d,e){var f=void 0!==e.midClick?e.midClick:a.magnificPopup.defaults.midClick;if(f||2!==c.which&&!c.ctrlKey&&!c.metaKey){var g=void 0!==e.disableOn?e.disableOn:a.magnificPopup.defaults.disableOn;if(g)if(a.isFunction(g)){if(!g.call(b))return!0}else if(v.width()<g)return!0;c.type&&(c.preventDefault(),b.isOpen&&c.stopPropagation()),e.el=a(c.mfpEl),e.delegate&&(e.items=d.find(e.delegate)),b.open(e)}},updateStatus:function(a,d){if(b.preloader){c!==a&&b.container.removeClass("mfp-s-"+c),d||"loading"!==a||(d=b.st.tLoading);var e={status:a,text:d};y("UpdateStatus",e),a=e.status,d=e.text,b.preloader.html(d),b.preloader.find("a").on("click",function(a){a.stopImmediatePropagation()}),b.container.addClass("mfp-s-"+a),c=a}},_checkIfClose:function(c){if(!a(c).hasClass(s)){var d=b.st.closeOnContentClick,e=b.st.closeOnBgClick;if(d&&e)return!0;if(!b.content||a(c).hasClass("mfp-close")||b.preloader&&c===b.preloader[0])return!0;if(c===b.content[0]||a.contains(b.content[0],c)){if(d)return!0}else if(e&&a.contains(document,c))return!0;return!1}},_addClassToMFP:function(a){b.bgOverlay.addClass(a),b.wrap.addClass(a)},_removeClassFromMFP:function(a){this.bgOverlay.removeClass(a),b.wrap.removeClass(a)},_hasScrollBar:function(a){return(b.isIE7?d.height():document.body.scrollHeight)>(a||v.height())},_setFocus:function(){(b.st.focus?b.content.find(b.st.focus).eq(0):b.wrap).focus()},_onFocusIn:function(c){return c.target===b.wrap[0]||a.contains(b.wrap[0],c.target)?void 0:(b._setFocus(),!1)},_parseMarkup:function(b,c,d){var e;d.data&&(c=a.extend(d.data,c)),y(l,[b,c,d]),a.each(c,function(a,c){if(void 0===c||c===!1)return!0;if(e=a.split("_"),e.length>1){var d=b.find(p+"-"+e[0]);if(d.length>0){var f=e[1];"replaceWith"===f?d[0]!==c[0]&&d.replaceWith(c):"img"===f?d.is("img")?d.attr("src",c):d.replaceWith('<img src="'+c+'" class="'+d.attr("class")+'" />'):d.attr(e[1],c)}}else b.find(p+"-"+a).html(c)})},_getScrollbarSize:function(){if(void 0===b.scrollbarSize){var a=document.createElement("div");a.style.cssText="width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;",document.body.appendChild(a),b.scrollbarSize=a.offsetWidth-a.clientWidth,document.body.removeChild(a)}return b.scrollbarSize}},a.magnificPopup={instance:null,proto:t.prototype,modules:[],open:function(b,c){return A(),b=b?a.extend(!0,{},b):{},b.isObj=!0,b.index=c||0,this.instance.open(b)},close:function(){return a.magnificPopup.instance&&a.magnificPopup.instance.close()},registerModule:function(b,c){c.options&&(a.magnificPopup.defaults[b]=c.options),a.extend(this.proto,c.proto),this.modules.push(b)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:"",preloader:!0,focus:"",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:"auto",fixedBgPos:"auto",overflowY:"auto",closeMarkup:'<button title="%title%" type="button" class="mfp-close">&times;</button>',tClose:"Close (Esc)",tLoading:"Loading..."}},a.fn.magnificPopup=function(c){A();var d=a(this);if("string"==typeof c)if("open"===c){var e,f=u?d.data("magnificPopup"):d[0].magnificPopup,g=parseInt(arguments[1],10)||0;f.items?e=f.items[g]:(e=d,f.delegate&&(e=e.find(f.delegate)),e=e.eq(g)),b._openClick({mfpEl:e},d,f)}else b.isOpen&&b[c].apply(b,Array.prototype.slice.call(arguments,1));else c=a.extend(!0,{},c),u?d.data("magnificPopup",c):d[0].magnificPopup=c,b.addGroup(d,c);return d};var C,D,E,F="inline",G=function(){E&&(D.after(E.addClass(C)).detach(),E=null)};a.magnificPopup.registerModule(F,{options:{hiddenClass:"hide",markup:"",tNotFound:"Content not found"},proto:{initInline:function(){b.types.push(F),w(h+"."+F,function(){G()})},getInline:function(c,d){if(G(),c.src){var e=b.st.inline,f=a(c.src);if(f.length){var g=f[0].parentNode;g&&g.tagName&&(D||(C=e.hiddenClass,D=x(C),C="mfp-"+C),E=f.after(D).detach().removeClass(C)),b.updateStatus("ready")}else b.updateStatus("error",e.tNotFound),f=a("<div>");return c.inlineElement=f,f}return b.updateStatus("ready"),b._parseMarkup(d,{},c),d}}});var H,I="ajax",J=function(){H&&a(document.body).removeClass(H)},K=function(){J(),b.req&&b.req.abort()};a.magnificPopup.registerModule(I,{options:{settings:null,cursor:"mfp-ajax-cur",tError:'<a href="%url%">The content</a> could not be loaded.'},proto:{initAjax:function(){b.types.push(I),H=b.st.ajax.cursor,w(h+"."+I,K),w("BeforeChange."+I,K)},getAjax:function(c){H&&a(document.body).addClass(H),b.updateStatus("loading");var d=a.extend({url:c.src,success:function(d,e,f){var g={data:d,xhr:f};y("ParseAjax",g),b.appendContent(a(g.data),I),c.finished=!0,J(),b._setFocus(),setTimeout(function(){b.wrap.addClass(q)},16),b.updateStatus("ready"),y("AjaxContentAdded")},error:function(){J(),c.finished=c.loadError=!0,b.updateStatus("error",b.st.ajax.tError.replace("%url%",c.src))}},b.st.ajax.settings);return b.req=a.ajax(d),""}}});var L,M=function(c){if(c.data&&void 0!==c.data.title)return c.data.title;var d=b.st.image.titleSrc;if(d){if(a.isFunction(d))return d.call(b,c);if(c.el)return c.el.attr(d)||""}return""};a.magnificPopup.registerModule("image",{options:{markup:'<div class="mfp-figure"><div class="mfp-close"></div><figure><div class="mfp-img"></div><figcaption><div class="mfp-bottom-bar"><div class="mfp-title"></div><div class="mfp-counter"></div></div></figcaption></figure></div>',cursor:"mfp-zoom-out-cur",titleSrc:"title",verticalFit:!0,tError:'<a href="%url%">The image</a> could not be loaded.'},proto:{initImage:function(){var c=b.st.image,d=".image";b.types.push("image"),w(m+d,function(){"image"===b.currItem.type&&c.cursor&&a(document.body).addClass(c.cursor)}),w(h+d,function(){c.cursor&&a(document.body).removeClass(c.cursor),v.off("resize"+p)}),w("Resize"+d,b.resizeImage),b.isLowIE&&w("AfterChange",b.resizeImage)},resizeImage:function(){var a=b.currItem;if(a&&a.img&&b.st.image.verticalFit){var c=0;b.isLowIE&&(c=parseInt(a.img.css("padding-top"),10)+parseInt(a.img.css("padding-bottom"),10)),a.img.css("max-height",b.wH-c)}},_onImageHasSize:function(a){a.img&&(a.hasSize=!0,L&&clearInterval(L),a.isCheckingImgSize=!1,y("ImageHasSize",a),a.imgHidden&&(b.content&&b.content.removeClass("mfp-loading"),a.imgHidden=!1))},findImageSize:function(a){var c=0,d=a.img[0],e=function(f){L&&clearInterval(L),L=setInterval(function(){return d.naturalWidth>0?void b._onImageHasSize(a):(c>200&&clearInterval(L),c++,void(3===c?e(10):40===c?e(50):100===c&&e(500)))},f)};e(1)},getImage:function(c,d){var e=0,f=function(){c&&(c.img[0].complete?(c.img.off(".mfploader"),c===b.currItem&&(b._onImageHasSize(c),b.updateStatus("ready")),c.hasSize=!0,c.loaded=!0,y("ImageLoadComplete")):(e++,200>e?setTimeout(f,100):g()))},g=function(){c&&(c.img.off(".mfploader"),c===b.currItem&&(b._onImageHasSize(c),b.updateStatus("error",h.tError.replace("%url%",c.src))),c.hasSize=!0,c.loaded=!0,c.loadError=!0)},h=b.st.image,i=d.find(".mfp-img");if(i.length){var j=document.createElement("img");j.className="mfp-img",c.el&&c.el.find("img").length&&(j.alt=c.el.find("img").attr("alt")),c.img=a(j).on("load.mfploader",f).on("error.mfploader",g),j.src=c.src,i.is("img")&&(c.img=c.img.clone()),j=c.img[0],j.naturalWidth>0?c.hasSize=!0:j.width||(c.hasSize=!1)}return b._parseMarkup(d,{title:M(c),img_replaceWith:c.img},c),b.resizeImage(),c.hasSize?(L&&clearInterval(L),c.loadError?(d.addClass("mfp-loading"),b.updateStatus("error",h.tError.replace("%url%",c.src))):(d.removeClass("mfp-loading"),b.updateStatus("ready")),d):(b.updateStatus("loading"),c.loading=!0,c.hasSize||(c.imgHidden=!0,d.addClass("mfp-loading"),b.findImageSize(c)),d)}}});var N,O=function(){return void 0===N&&(N=void 0!==document.createElement("p").style.MozTransform),N};a.magnificPopup.registerModule("zoom",{options:{enabled:!1,easing:"ease-in-out",duration:300,opener:function(a){return a.is("img")?a:a.find("img")}},proto:{initZoom:function(){var a,c=b.st.zoom,d=".zoom";if(c.enabled&&b.supportsTransition){var e,f,g=c.duration,j=function(a){var b=a.clone().removeAttr("style").removeAttr("class").addClass("mfp-animated-image"),d="all "+c.duration/1e3+"s "+c.easing,e={position:"fixed",zIndex:9999,left:0,top:0,"-webkit-backface-visibility":"hidden"},f="transition";return e["-webkit-"+f]=e["-moz-"+f]=e["-o-"+f]=e[f]=d,b.css(e),b},k=function(){b.content.css("visibility","visible")};w("BuildControls"+d,function(){if(b._allowZoom()){if(clearTimeout(e),b.content.css("visibility","hidden"),a=b._getItemToZoom(),!a)return void k();f=j(a),f.css(b._getOffset()),b.wrap.append(f),e=setTimeout(function(){f.css(b._getOffset(!0)),e=setTimeout(function(){k(),setTimeout(function(){f.remove(),a=f=null,y("ZoomAnimationEnded")},16)},g)},16)}}),w(i+d,function(){if(b._allowZoom()){if(clearTimeout(e),b.st.removalDelay=g,!a){if(a=b._getItemToZoom(),!a)return;f=j(a)}f.css(b._getOffset(!0)),b.wrap.append(f),b.content.css("visibility","hidden"),setTimeout(function(){f.css(b._getOffset())},16)}}),w(h+d,function(){b._allowZoom()&&(k(),f&&f.remove(),a=null)})}},_allowZoom:function(){return"image"===b.currItem.type},_getItemToZoom:function(){return b.currItem.hasSize?b.currItem.img:!1},_getOffset:function(c){var d;d=c?b.currItem.img:b.st.zoom.opener(b.currItem.el||b.currItem);var e=d.offset(),f=parseInt(d.css("padding-top"),10),g=parseInt(d.css("padding-bottom"),10);e.top-=a(window).scrollTop()-f;var h={width:d.width(),height:(u?d.innerHeight():d[0].offsetHeight)-g-f};return O()?h["-moz-transform"]=h.transform="translate("+e.left+"px,"+e.top+"px)":(h.left=e.left,h.top=e.top),h}}});var P="iframe",Q="//about:blank",R=function(a){if(b.currTemplate[P]){var c=b.currTemplate[P].find("iframe");c.length&&(a||(c[0].src=Q),b.isIE8&&c.css("display",a?"block":"none"))}};a.magnificPopup.registerModule(P,{options:{markup:'<div class="mfp-iframe-scaler"><div class="mfp-close"></div><iframe class="mfp-iframe" src="//about:blank" frameborder="0" allowfullscreen></iframe></div>',srcAction:"iframe_src",patterns:{youtube:{index:"youtube.com",id:"v=",src:"//www.youtube.com/embed/%id%?autoplay=1"},vimeo:{index:"vimeo.com/",id:"/",src:"//player.vimeo.com/video/%id%?autoplay=1"},gmaps:{index:"//maps.google.",src:"%id%&output=embed"}}},proto:{initIframe:function(){b.types.push(P),w("BeforeChange",function(a,b,c){b!==c&&(b===P?R():c===P&&R(!0))}),w(h+"."+P,function(){R()})},getIframe:function(c,d){var e=c.src,f=b.st.iframe;a.each(f.patterns,function(){return e.indexOf(this.index)>-1?(this.id&&(e="string"==typeof this.id?e.substr(e.lastIndexOf(this.id)+this.id.length,e.length):this.id.call(this,e)),e=this.src.replace("%id%",e),!1):void 0});var g={};return f.srcAction&&(g[f.srcAction]=e),b._parseMarkup(d,g,c),b.updateStatus("ready"),d}}});var S=function(a){var c=b.items.length;return a>c-1?a-c:0>a?c+a:a},T=function(a,b,c){return a.replace(/%curr%/gi,b+1).replace(/%total%/gi,c)};a.magnificPopup.registerModule("gallery",{options:{enabled:!1,arrowMarkup:'<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:"Previous (Left arrow key)",tNext:"Next (Right arrow key)",tCounter:"%curr% of %total%"},proto:{initGallery:function(){var c=b.st.gallery,e=".mfp-gallery",g=Boolean(a.fn.mfpFastClick);return b.direction=!0,c&&c.enabled?(f+=" mfp-gallery",w(m+e,function(){c.navigateByImgClick&&b.wrap.on("click"+e,".mfp-img",function(){return b.items.length>1?(b.next(),!1):void 0}),d.on("keydown"+e,function(a){37===a.keyCode?b.prev():39===a.keyCode&&b.next()})}),w("UpdateStatus"+e,function(a,c){c.text&&(c.text=T(c.text,b.currItem.index,b.items.length))}),w(l+e,function(a,d,e,f){var g=b.items.length;e.counter=g>1?T(c.tCounter,f.index,g):""}),w("BuildControls"+e,function(){if(b.items.length>1&&c.arrows&&!b.arrowLeft){var d=c.arrowMarkup,e=b.arrowLeft=a(d.replace(/%title%/gi,c.tPrev).replace(/%dir%/gi,"left")).addClass(s),f=b.arrowRight=a(d.replace(/%title%/gi,c.tNext).replace(/%dir%/gi,"right")).addClass(s),h=g?"mfpFastClick":"click";e[h](function(){b.prev()}),f[h](function(){b.next()}),b.isIE7&&(x("b",e[0],!1,!0),x("a",e[0],!1,!0),x("b",f[0],!1,!0),x("a",f[0],!1,!0)),b.container.append(e.add(f))}}),w(n+e,function(){b._preloadTimeout&&clearTimeout(b._preloadTimeout),b._preloadTimeout=setTimeout(function(){b.preloadNearbyImages(),b._preloadTimeout=null},16)}),void w(h+e,function(){d.off(e),b.wrap.off("click"+e),b.arrowLeft&&g&&b.arrowLeft.add(b.arrowRight).destroyMfpFastClick(),b.arrowRight=b.arrowLeft=null})):!1},next:function(){b.direction=!0,b.index=S(b.index+1),b.updateItemHTML()},prev:function(){b.direction=!1,b.index=S(b.index-1),b.updateItemHTML()},goTo:function(a){b.direction=a>=b.index,b.index=a,b.updateItemHTML()},preloadNearbyImages:function(){var a,c=b.st.gallery.preload,d=Math.min(c[0],b.items.length),e=Math.min(c[1],b.items.length);for(a=1;a<=(b.direction?e:d);a++)b._preloadItem(b.index+a);for(a=1;a<=(b.direction?d:e);a++)b._preloadItem(b.index-a)},_preloadItem:function(c){if(c=S(c),!b.items[c].preloaded){var d=b.items[c];d.parsed||(d=b.parseEl(c)),y("LazyLoad",d),"image"===d.type&&(d.img=a('<img class="mfp-img" />').on("load.mfploader",function(){d.hasSize=!0}).on("error.mfploader",function(){d.hasSize=!0,d.loadError=!0,y("LazyLoadError",d)}).attr("src",d.src)),d.preloaded=!0}}}});var U="retina";a.magnificPopup.registerModule(U,{options:{replaceSrc:function(a){return a.src.replace(/\.\w+$/,function(a){return"@2x"+a})},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var a=b.st.retina,c=a.ratio;c=isNaN(c)?c():c,c>1&&(w("ImageHasSize."+U,function(a,b){b.img.css({"max-width":b.img[0].naturalWidth/c,width:"100%"})}),w("ElementParse."+U,function(b,d){d.src=a.replaceSrc(d,c)}))}}}}),function(){var b=1e3,c="ontouchstart"in window,d=function(){v.off("touchmove"+f+" touchend"+f)},e="mfpFastClick",f="."+e;a.fn.mfpFastClick=function(e){return a(this).each(function(){var g,h=a(this);if(c){var i,j,k,l,m,n;h.on("touchstart"+f,function(a){l=!1,n=1,m=a.originalEvent?a.originalEvent.touches[0]:a.touches[0],j=m.clientX,k=m.clientY,v.on("touchmove"+f,function(a){m=a.originalEvent?a.originalEvent.touches:a.touches,n=m.length,m=m[0],(Math.abs(m.clientX-j)>10||Math.abs(m.clientY-k)>10)&&(l=!0,d())}).on("touchend"+f,function(a){d(),l||n>1||(g=!0,a.preventDefault(),clearTimeout(i),i=setTimeout(function(){g=!1},b),e())})})}h.on("click"+f,function(){g||e()})})},a.fn.destroyMfpFastClick=function(){a(this).off("touchstart"+f+" click"+f),c&&v.off("touchmove"+f+" touchend"+f)}}(),A()});
} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.magnific-popup.min.js; Error:' + e.message);
};
try {
/*!
 * enquire.js v2.1.2 - Awesome Media Queries in JavaScript
 * Copyright (c) 2014 Nick Williams - http://wicky.nillia.ms/enquire.js
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */

!function(a,b,c){var d=window.matchMedia;"undefined"!=typeof module&&module.exports?module.exports=c(d):"function"==typeof define&&define.amd?define(function(){return b[a]=c(d)}):b[a]=c(d)}("enquire",this,function(a){"use strict";function b(a,b){var c,d=0,e=a.length;for(d;e>d&&(c=b(a[d],d),c!==!1);d++);}function c(a){return"[object Array]"===Object.prototype.toString.apply(a)}function d(a){return"function"==typeof a}function e(a){this.options=a,!a.deferSetup&&this.setup()}function f(b,c){this.query=b,this.isUnconditional=c,this.handlers=[],this.mql=a(b);var d=this;this.listener=function(a){d.mql=a,d.assess()},this.mql.addListener(this.listener)}function g(){if(!a)throw new Error("matchMedia not present, legacy browsers require a polyfill");this.queries={},this.browserIsIncapable=!a("only all").matches}return e.prototype={setup:function(){this.options.setup&&this.options.setup(),this.initialised=!0},on:function(){!this.initialised&&this.setup(),this.options.match&&this.options.match()},off:function(){this.options.unmatch&&this.options.unmatch()},destroy:function(){this.options.destroy?this.options.destroy():this.off()},equals:function(a){return this.options===a||this.options.match===a}},f.prototype={addHandler:function(a){var b=new e(a);this.handlers.push(b),this.matches()&&b.on()},removeHandler:function(a){var c=this.handlers;b(c,function(b,d){return b.equals(a)?(b.destroy(),!c.splice(d,1)):void 0})},matches:function(){return this.mql.matches||this.isUnconditional},clear:function(){b(this.handlers,function(a){a.destroy()}),this.mql.removeListener(this.listener),this.handlers.length=0},assess:function(){var a=this.matches()?"on":"off";b(this.handlers,function(b){b[a]()})}},g.prototype={register:function(a,e,g){var h=this.queries,i=g&&this.browserIsIncapable;return h[a]||(h[a]=new f(a,i)),d(e)&&(e={match:e}),c(e)||(e=[e]),b(e,function(b){d(b)&&(b={match:b}),h[a].addHandler(b)}),this},unregister:function(a,b){var c=this.queries[a];return c&&(b?c.removeHandler(b):(c.clear(),delete this.queries[a])),this}},new g});
} catch (e) {
console.error('Error in file:/templates/archi/js/enquire.min.js; Error:' + e.message);
};
try {
// The MIT License (MIT)

// Typed.js | Copyright (c) 2014 Matt Boldt | www.mattboldt.com

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.




! function($) {

    "use strict";

    var Typed = function(el, options) {

        // chosen element to manipulate text
        this.el = $(el);

        // options
        this.options = $.extend({}, $.fn.typed.defaults, options);

        // attribute to type into
        this.isInput = this.el.is('input');
        this.attr = this.options.attr;

        // show cursor
        this.showCursor = this.isInput ? false : this.options.showCursor;

        // text content of element
        this.elContent = this.attr ? this.el.attr(this.attr) : this.el.text()

        // html or plain text
        this.contentType = this.options.contentType;

        // typing speed
        this.typeSpeed = this.options.typeSpeed;

        // add a delay before typing starts
        this.startDelay = this.options.startDelay;

        // backspacing speed
        this.backSpeed = this.options.backSpeed;

        // amount of time to wait before backspacing
        this.backDelay = this.options.backDelay;

        // div containing strings
        this.stringsElement = this.options.stringsElement;

        // input strings of text
        this.strings = this.options.strings;

        // character number position of current string
        this.strPos = 0;

        // current array position
        this.arrayPos = 0;

        // number to stop backspacing on.
        // default 0, can change depending on how many chars
        // you want to remove at the time
        this.stopNum = 0;

        // Looping logic
        this.loop = this.options.loop;
        this.loopCount = this.options.loopCount;
        this.curLoop = 0;

        // for stopping
        this.stop = false;

        // custom cursor
        this.cursorChar = this.options.cursorChar;

        // shuffle the strings
        this.shuffle = this.options.shuffle;
        // the order of strings
        this.sequence = [];

        // All systems go!
        this.build();
    };

    Typed.prototype = {

        constructor: Typed

        ,
        init: function() {
            // begin the loop w/ first current string (global self.strings)
            // current string will be passed as an argument each time after this
            var self = this;
            self.timeout = setTimeout(function() {
                for (var i=0;i<self.strings.length;++i) self.sequence[i]=i;

                // shuffle the array if true
                if(self.shuffle) self.sequence = self.shuffleArray(self.sequence);

                // Start typing
                self.typewrite(self.strings[self.sequence[self.arrayPos]], self.strPos);
            }, self.startDelay);
        }

        ,
        build: function() {
            var self = this;
            // Insert cursor
            if (this.showCursor === true) {
                this.cursor = $("<span class=\"typed-cursor\">" + this.cursorChar + "</span>");
                this.el.after(this.cursor);
            }
            if (this.stringsElement) {
                self.strings = [];
                this.stringsElement.hide();
                var strings = this.stringsElement.find('p');
                $.each(strings, function(key, value){
                    self.strings.push($(value).html());
                });
            }
            this.init();
        }

        // pass current string state to each function, types 1 char per call
        ,
        typewrite: function(curString, curStrPos) {
            // exit when stopped
            if (this.stop === true) {
                return;
            }

            // varying values for setTimeout during typing
            // can't be global since number changes each time loop is executed
            var humanize = Math.round(Math.random() * (100 - 30)) + this.typeSpeed;
            var self = this;

            // ------------- optional ------------- //
            // backpaces a certain string faster
            // ------------------------------------ //
            // if (self.arrayPos == 1){
            //  self.backDelay = 50;
            // }
            // else{ self.backDelay = 500; }

            // contain typing function in a timeout humanize'd delay
            self.timeout = setTimeout(function() {
                // check for an escape character before a pause value
                // format: \^\d+ .. eg: ^1000 .. should be able to print the ^ too using ^^
                // single ^ are removed from string
                var charPause = 0;
                var substr = curString.substr(curStrPos);
                if (substr.charAt(0) === '^') {
                    var skip = 1; // skip atleast 1
                    if (/^\^\d+/.test(substr)) {
                        substr = /\d+/.exec(substr)[0];
                        skip += substr.length;
                        charPause = parseInt(substr);
                    }

                    // strip out the escape character and pause value so they're not printed
                    curString = curString.substring(0, curStrPos) + curString.substring(curStrPos + skip);
                }

                if (self.contentType === 'html') {
                    // skip over html tags while typing
                    var curChar = curString.substr(curStrPos).charAt(0)
                    if (curChar === '<' || curChar === '&') {
                        var tag = '';
                        var endTag = '';
                        if (curChar === '<') {
                            endTag = '>'
                        } else {
                            endTag = ';'
                        }
                        while (curString.substr(curStrPos).charAt(0) !== endTag) {
                            tag += curString.substr(curStrPos).charAt(0);
                            curStrPos++;
                        }
                        curStrPos++;
                        tag += endTag;
                    }
                }

                // timeout for any pause after a character
                self.timeout = setTimeout(function() {
                    if (curStrPos === curString.length) {
                        // fires callback function
                        self.options.onStringTyped(self.arrayPos);

                        // is this the final string
                        if (self.arrayPos === self.strings.length - 1) {
                            // animation that occurs on the last typed string
                            self.options.callback();

                            self.curLoop++;

                            // quit if we wont loop back
                            if (self.loop === false || self.curLoop === self.loopCount)
                                return;
                        }

                        self.timeout = setTimeout(function() {
                            self.backspace(curString, curStrPos);
                        }, self.backDelay);
                    } else {

                        /* call before functions if applicable */
                        if (curStrPos === 0)
                            self.options.preStringTyped(self.arrayPos);

                        // start typing each new char into existing string
                        // curString: arg, self.el.html: original text inside element
                        var nextString = curString.substr(0, curStrPos + 1);
                        if (self.attr) {
                            self.el.attr(self.attr, nextString);
                        } else {
                            if (self.isInput) {
                                self.el.val(nextString);
                            } else if (self.contentType === 'html') {
                                self.el.html(nextString);
                            } else {
                                self.el.text(nextString);
                            }
                        }

                        // add characters one by one
                        curStrPos++;
                        // loop the function
                        self.typewrite(curString, curStrPos);
                    }
                    // end of character pause
                }, charPause);

                // humanized value for typing
            }, humanize);

        }

        ,
        backspace: function(curString, curStrPos) {
            // exit when stopped
            if (this.stop === true) {
                return;
            }

            // varying values for setTimeout during typing
            // can't be global since number changes each time loop is executed
            var humanize = Math.round(Math.random() * (100 - 30)) + this.backSpeed;
            var self = this;

            self.timeout = setTimeout(function() {

                // ----- this part is optional ----- //
                // check string array position
                // on the first string, only delete one word
                // the stopNum actually represents the amount of chars to
                // keep in the current string. In my case it's 14.
                // if (self.arrayPos == 1){
                //  self.stopNum = 14;
                // }
                //every other time, delete the whole typed string
                // else{
                //  self.stopNum = 0;
                // }

                if (self.contentType === 'html') {
                    // skip over html tags while backspacing
                    if (curString.substr(curStrPos).charAt(0) === '>') {
                        var tag = '';
                        while (curString.substr(curStrPos).charAt(0) !== '<') {
                            tag -= curString.substr(curStrPos).charAt(0);
                            curStrPos--;
                        }
                        curStrPos--;
                        tag += '<';
                    }
                }

                // ----- continue important stuff ----- //
                // replace text with base text + typed characters
                var nextString = curString.substr(0, curStrPos);
                if (self.attr) {
                    self.el.attr(self.attr, nextString);
                } else {
                    if (self.isInput) {
                        self.el.val(nextString);
                    } else if (self.contentType === 'html') {
                        self.el.html(nextString);
                    } else {
                        self.el.text(nextString);
                    }
                }

                // if the number (id of character in current string) is
                // less than the stop number, keep going
                if (curStrPos > self.stopNum) {
                    // subtract characters one by one
                    curStrPos--;
                    // loop the function
                    self.backspace(curString, curStrPos);
                }
                // if the stop number has been reached, increase
                // array position to next string
                else if (curStrPos <= self.stopNum) {
                    self.arrayPos++;

                    if (self.arrayPos === self.strings.length) {
                        self.arrayPos = 0;

                        // Shuffle sequence again
                        if(self.shuffle) self.sequence = self.shuffleArray(self.sequence);

                        self.init();
                    } else
                        self.typewrite(self.strings[self.sequence[self.arrayPos]], curStrPos);
                }

                // humanized value for typing
            }, humanize);

        }
        /**
         * Shuffles the numbers in the given array.
         * @param {Array} array
         * @returns {Array}
         */
        ,shuffleArray: function(array) {
            var tmp, current, top = array.length;
            if(top) while(--top) {
                current = Math.floor(Math.random() * (top + 1));
                tmp = array[current];
                array[current] = array[top];
                array[top] = tmp;
            }
            return array;
        }

        // Start & Stop currently not working

        // , stop: function() {
        //     var self = this;

        //     self.stop = true;
        //     clearInterval(self.timeout);
        // }

        // , start: function() {
        //     var self = this;
        //     if(self.stop === false)
        //        return;

        //     this.stop = false;
        //     this.init();
        // }

        // Reset and rebuild the element
        ,
        reset: function() {
            var self = this;
            clearInterval(self.timeout);
            var id = this.el.attr('id');
            this.el.after('<span id="' + id + '"/>')
            this.el.remove();
            if (typeof this.cursor !== 'undefined') {
                this.cursor.remove();
            }
            // Send the callback
            self.options.resetCallback();
        }

    };

    $.fn.typed = function(option) {
        return this.each(function() {
            var $this = $(this),
                data = $this.data('typed'),
                options = typeof option == 'object' && option;
            if (!data) $this.data('typed', (data = new Typed(this, options)));
            if (typeof option == 'string') data[option]();
        });
    };

    $.fn.typed.defaults = {
        strings: ["These are the default values...", "You know what you should do?", "Use your own!", "Have a great day!"],
        stringsElement: null,
        // typing speed
        typeSpeed: 0,
        // time before typing starts
        startDelay: 0,
        // backspacing speed
        backSpeed: 0,
        // shuffle the strings
        shuffle: false,
        // time before backspacing
        backDelay: 500,
        // loop
        loop: false,
        // false = infinite
        loopCount: false,
        // show cursor
        showCursor: true,
        // character for cursor
        cursorChar: "|",
        // attribute to type (null == text)
        attr: null,
        // either html or text
        contentType: 'html',
        // call when done callback function
        callback: function() {},
        // starting callback function before each string
        preStringTyped: function() {},
        //callback for every typed string
        onStringTyped: function() {},
        // callback for reset
        resetCallback: function() {}
    };


}(window.jQuery);

} catch (e) {
console.error('Error in file:/templates/archi/js/typed.js; Error:' + e.message);
};
try {
// DOM.event.move
//
// 2.0.0
//
// Stephen Band
//
// Triggers 'movestart', 'move' and 'moveend' events after
// mousemoves following a mousedown cross a distance threshold,
// similar to the native 'dragstart', 'drag' and 'dragend' events.
// Move events are throttled to animation frames. Move event objects
// have the properties:
//
// pageX:
// pageY:     Page coordinates of pointer.
// startX:
// startY:    Page coordinates of pointer at movestart.
// distX:
// distY:     Distance the pointer has moved since movestart.
// deltaX:
// deltaY:    Distance the finger has moved since last event.
// velocityX:
// velocityY: Average velocity over last few events.


(function(fn) {
	if (typeof define === 'function' && define.amd) {
        define([], fn);
    } else if ((typeof module !== "undefined" && module !== null) && module.exports) {
        module.exports = fn;
	} else {
		fn();
	}
})(function(){
	var assign = Object.assign || window.jQuery && jQuery.extend;

	// Number of pixels a pressed pointer travels before movestart
	// event is fired.
	var threshold = 8;

	// Shim for requestAnimationFrame, falling back to timer. See:
	// see http://paulirish.com/2011/requestanimationframe-for-smart-animating/
	var requestFrame = (function(){
		return (
			window.requestAnimationFrame ||
			window.webkitRequestAnimationFrame ||
			window.mozRequestAnimationFrame ||
			window.oRequestAnimationFrame ||
			window.msRequestAnimationFrame ||
			function(fn, element){
				return window.setTimeout(function(){
					fn();
				}, 25);
			}
		);
	})();
	
	// Shim for customEvent
	// see https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent/CustomEvent#Polyfill
	(function () {
		if ( typeof window.CustomEvent === "function" ) return false;
		function CustomEvent ( event, params ) {
			params = params || { bubbles: false, cancelable: false, detail: undefined };
			var evt = document.createEvent( 'CustomEvent' );
			evt.initCustomEvent( event, params.bubbles, params.cancelable, params.detail );
			return evt;
		}
		
		CustomEvent.prototype = window.Event.prototype;
		window.CustomEvent = CustomEvent;
	})();

	var ignoreTags = {
			textarea: true,
			input: true,
			select: true,
			button: true
		};

	var mouseevents = {
		move:   'mousemove',
		cancel: 'mouseup dragstart',
		end:    'mouseup'
	};

	var touchevents = {
		move:   'touchmove',
		cancel: 'touchend',
		end:    'touchend'
	};

	var rspaces = /\s+/;


	// DOM Events

	var eventOptions = { bubbles: true, cancelable: true };

	var eventsSymbol = typeof Symbol === "function" ? Symbol('events') : {};

	function createEvent(type) {
		return new CustomEvent(type, eventOptions);
	}

	function getEvents(node) {
		return node[eventsSymbol] || (node[eventsSymbol] = {});
	}

	function on(node, types, fn, data, selector) {
		types = types.split(rspaces);

		var events = getEvents(node);
		var i = types.length;
		var handlers, type;

		function handler(e) { fn(e, data); }

		while (i--) {
			type = types[i];
			handlers = events[type] || (events[type] = []);
			handlers.push([fn, handler]);
			node.addEventListener(type, handler);
		}
	}

	function off(node, types, fn, selector) {
		types = types.split(rspaces);

		var events = getEvents(node);
		var i = types.length;
		var type, handlers, k;

		if (!events) { return; }

		while (i--) {
			type = types[i];
			handlers = events[type];
			if (!handlers) { continue; }
			k = handlers.length;
			while (k--) {
				if (handlers[k][0] === fn) {
					node.removeEventListener(type, handlers[k][1]);
					handlers.splice(k, 1);
				}
			}
		}
	}

	function trigger(node, type, properties) {
		// Don't cache events. It prevents you from triggering an event of a
		// given type from inside the handler of another event of that type.
		var event = createEvent(type);
		if (properties) { assign(event, properties); }
		node.dispatchEvent(event);
	}


	// Constructors

	function Timer(fn){
		var callback = fn,
		    active = false,
		    running = false;

		function trigger(time) {
			if (active){
				callback();
				requestFrame(trigger);
				running = true;
				active = false;
			}
			else {
				running = false;
			}
		}

		this.kick = function(fn) {
			active = true;
			if (!running) { trigger(); }
		};

		this.end = function(fn) {
			var cb = callback;

			if (!fn) { return; }

			// If the timer is not running, simply call the end callback.
			if (!running) {
				fn();
			}
			// If the timer is running, and has been kicked lately, then
			// queue up the current callback and the end callback, otherwise
			// just the end callback.
			else {
				callback = active ?
					function(){ cb(); fn(); } :
					fn ;

				active = true;
			}
		};
	}


	// Functions

	function noop() {}

	function preventDefault(e) {
		e.preventDefault();
	}

	function isIgnoreTag(e) {
		return !!ignoreTags[e.target.tagName.toLowerCase()];
	}

	function isPrimaryButton(e) {
		// Ignore mousedowns on any button other than the left (or primary)
		// mouse button, or when a modifier key is pressed.
		return (e.which === 1 && !e.ctrlKey && !e.altKey);
	}

	function identifiedTouch(touchList, id) {
		var i, l;

		if (touchList.identifiedTouch) {
			return touchList.identifiedTouch(id);
		}

		// touchList.identifiedTouch() does not exist in
		// webkit yetâ€¦ we must do the search ourselves...

		i = -1;
		l = touchList.length;

		while (++i < l) {
			if (touchList[i].identifier === id) {
				return touchList[i];
			}
		}
	}

	function changedTouch(e, data) {
		var touch = identifiedTouch(e.changedTouches, data.identifier);

		// This isn't the touch you're looking for.
		if (!touch) { return; }

		// Chrome Android (at least) includes touches that have not
		// changed in e.changedTouches. That's a bit annoying. Check
		// that this touch has changed.
		if (touch.pageX === data.pageX && touch.pageY === data.pageY) { return; }

		return touch;
	}


	// Handlers that decide when the first movestart is triggered

	function mousedown(e){
		// Ignore non-primary buttons
		if (!isPrimaryButton(e)) { return; }

		// Ignore form and interactive elements
		if (isIgnoreTag(e)) { return; }

		on(document, mouseevents.move, mousemove, e);
		on(document, mouseevents.cancel, mouseend, e);
	}

	function mousemove(e, data){
		checkThreshold(e, data, e, removeMouse);
	}

	function mouseend(e, data) {
		removeMouse();
	}

	function removeMouse() {
		off(document, mouseevents.move, mousemove);
		off(document, mouseevents.cancel, mouseend);
	}

	function touchstart(e) {
		// Don't get in the way of interaction with form elements
		if (ignoreTags[e.target.tagName.toLowerCase()]) { return; }

		var touch = e.changedTouches[0];

		// iOS live updates the touch objects whereas Android gives us copies.
		// That means we can't trust the touchstart object to stay the same,
		// so we must copy the data. This object acts as a template for
		// movestart, move and moveend event objects.
		var data = {
			target:     touch.target,
			pageX:      touch.pageX,
			pageY:      touch.pageY,
			identifier: touch.identifier,

			// The only way to make handlers individually unbindable is by
			// making them unique.
			touchmove:  function(e, data) { touchmove(e, data); },
			touchend:   function(e, data) { touchend(e, data); }
		};

		on(document, touchevents.move, data.touchmove, data);
		on(document, touchevents.cancel, data.touchend, data);
	}

	function touchmove(e, data) {
		var touch = changedTouch(e, data);
		if (!touch) { return; }
		checkThreshold(e, data, touch, removeTouch);
	}

	function touchend(e, data) {
		var touch = identifiedTouch(e.changedTouches, data.identifier);
		if (!touch) { return; }
		removeTouch(data);
	}

	function removeTouch(data) {
		off(document, touchevents.move, data.touchmove);
		off(document, touchevents.cancel, data.touchend);
	}

	function checkThreshold(e, data, touch, fn) {
		var distX = touch.pageX - data.pageX;
		var distY = touch.pageY - data.pageY;

		// Do nothing if the threshold has not been crossed.
		if ((distX * distX) + (distY * distY) < (threshold * threshold)) { return; }

		triggerStart(e, data, touch, distX, distY, fn);
	}

	function triggerStart(e, data, touch, distX, distY, fn) {
		var touches = e.targetTouches;
		var time = e.timeStamp - data.timeStamp;

		// Create a movestart object with some special properties that
		// are passed only to the movestart handlers.
		var template = {
			altKey:     e.altKey,
			ctrlKey:    e.ctrlKey,
			shiftKey:   e.shiftKey,
			startX:     data.pageX,
			startY:     data.pageY,
			distX:      distX,
			distY:      distY,
			deltaX:     distX,
			deltaY:     distY,
			pageX:      touch.pageX,
			pageY:      touch.pageY,
			velocityX:  distX / time,
			velocityY:  distY / time,
			identifier: data.identifier,
			targetTouches: touches,
			finger: touches ? touches.length : 1,
			enableMove: function() {
				this.moveEnabled = true;
				this.enableMove = noop;
				e.preventDefault();
			}
		};

		// Trigger the movestart event.
		trigger(data.target, 'movestart', template);

		// Unbind handlers that tracked the touch or mouse up till now.
		fn(data);
	}


	// Handlers that control what happens following a movestart

	function activeMousemove(e, data) {
		var timer  = data.timer;

		data.touch = e;
		data.timeStamp = e.timeStamp;
		timer.kick();
	}

	function activeMouseend(e, data) {
		var target = data.target;
		var event  = data.event;
		var timer  = data.timer;

		removeActiveMouse();

		endEvent(target, event, timer, function() {
			// Unbind the click suppressor, waiting until after mouseup
			// has been handled.
			setTimeout(function(){
				off(target, 'click', preventDefault);
			}, 0);
		});
	}

	function removeActiveMouse() {
		off(document, mouseevents.move, activeMousemove);
		off(document, mouseevents.end, activeMouseend);
	}

	function activeTouchmove(e, data) {
		var event = data.event;
		var timer = data.timer;
		var touch = changedTouch(e, event);

		if (!touch) { return; }

		// Stop the interface from gesturing
		e.preventDefault();

		event.targetTouches = e.targetTouches;
		data.touch = touch;
		data.timeStamp = e.timeStamp;

		timer.kick();
	}

	function activeTouchend(e, data) {
		var target = data.target;
		var event  = data.event;
		var timer  = data.timer;
		var touch  = identifiedTouch(e.changedTouches, event.identifier);

		// This isn't the touch you're looking for.
		if (!touch) { return; }

		removeActiveTouch(data);
		endEvent(target, event, timer);
	}

	function removeActiveTouch(data) {
		off(document, touchevents.move, data.activeTouchmove);
		off(document, touchevents.end, data.activeTouchend);
	}


	// Logic for triggering move and moveend events

	function updateEvent(event, touch, timeStamp) {
		var time = timeStamp - event.timeStamp;

		event.distX =  touch.pageX - event.startX;
		event.distY =  touch.pageY - event.startY;
		event.deltaX = touch.pageX - event.pageX;
		event.deltaY = touch.pageY - event.pageY;

		// Average the velocity of the last few events using a decay
		// curve to even out spurious jumps in values.
		event.velocityX = 0.3 * event.velocityX + 0.7 * event.deltaX / time;
		event.velocityY = 0.3 * event.velocityY + 0.7 * event.deltaY / time;
		event.pageX =  touch.pageX;
		event.pageY =  touch.pageY;
	}

	function endEvent(target, event, timer, fn) {
		timer.end(function(){
			trigger(target, 'moveend', event);
			return fn && fn();
		});
	}


	// Set up the DOM

	function movestart(e) {
		if (e.defaultPrevented) { return; }
		if (!e.moveEnabled) { return; }

		var event = {
			startX:        e.startX,
			startY:        e.startY,
			pageX:         e.pageX,
			pageY:         e.pageY,
			distX:         e.distX,
			distY:         e.distY,
			deltaX:        e.deltaX,
			deltaY:        e.deltaY,
			velocityX:     e.velocityX,
			velocityY:     e.velocityY,
			identifier:    e.identifier,
			targetTouches: e.targetTouches,
			finger:        e.finger
		};

		var data = {
			target:    e.target,
			event:     event,
			timer:     new Timer(update),
			touch:     undefined,
			timeStamp: e.timeStamp
		};

		function update(time) {
			updateEvent(event, data.touch, data.timeStamp);
			trigger(data.target, 'move', event);
		}

		if (e.identifier === undefined) {
			// We're dealing with a mouse event.
			// Stop clicks from propagating during a move
			on(e.target, 'click', preventDefault);
			on(document, mouseevents.move, activeMousemove, data);
			on(document, mouseevents.end, activeMouseend, data);
		}
		else {
			// In order to unbind correct handlers they have to be unique
			data.activeTouchmove = function(e, data) { activeTouchmove(e, data); };
			data.activeTouchend = function(e, data) { activeTouchend(e, data); };

			// We're dealing with a touch.
			on(document, touchevents.move, data.activeTouchmove, data);
			on(document, touchevents.end, data.activeTouchend, data);
		}
	}

	on(document, 'mousedown', mousedown);
	on(document, 'touchstart', touchstart);
	on(document, 'movestart', movestart);


	// jQuery special events
	//
	// jQuery event objects are copies of DOM event objects. They need
	// a little help copying the move properties across.

	if (!window.jQuery) { return; }

	var properties = ("startX startY pageX pageY distX distY deltaX deltaY velocityX velocityY").split(' ');

	function enableMove1(e) { e.enableMove(); }
	function enableMove2(e) { e.enableMove(); }
	function enableMove3(e) { e.enableMove(); }

	function add(handleObj) {
		var handler = handleObj.handler;

		handleObj.handler = function(e) {
			// Copy move properties across from originalEvent
			var i = properties.length;
			var property;

			while(i--) {
				property = properties[i];
				e[property] = e.originalEvent[property];
			}

			handler.apply(this, arguments);
		};
	}

	jQuery.event.special.movestart = {
		setup: function() {
			// Movestart must be enabled to allow other move events
			on(this, 'movestart', enableMove1);

			// Do listen to DOM events
			return false;
		},

		teardown: function() {
			off(this, 'movestart', enableMove1);
			return false;
		},

		add: add
	};

	jQuery.event.special.move = {
		setup: function() {
			on(this, 'movestart', enableMove2);
			return false;
		},

		teardown: function() {
			off(this, 'movestart', enableMove2);
			return false;
		},

		add: add
	};

	jQuery.event.special.moveend = {
		setup: function() {
			on(this, 'movestart', enableMove3);
			return false;
		},

		teardown: function() {
			off(this, 'movestart', enableMove3);
			return false;
		},

		add: add
	};
});

} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.event.move.js; Error:' + e.message);
};
try {
(function($){

  $.fn.twentytwenty = function(options) {
    var options = $.extend({
      default_offset_pct: 0.5,
      orientation: 'horizontal',
      before_label: 'Before',
      after_label: 'After',
      no_overlay: false,
      move_slider_on_hover: false,
      move_with_handle_only: true,
      click_to_move: false
    }, options);

    return this.each(function() {

      var sliderPct = options.default_offset_pct;
      var container = $(this);
      var sliderOrientation = options.orientation;
      var beforeDirection = (sliderOrientation === 'vertical') ? 'down' : 'left';
      var afterDirection = (sliderOrientation === 'vertical') ? 'up' : 'right';


      container.wrap("<div class='twentytwenty-wrapper twentytwenty-" + sliderOrientation + "'></div>");
      if(!options.no_overlay) {
        container.append("<div class='twentytwenty-overlay'></div>");
      }
      var beforeImg = container.find("img:first");
      var afterImg = container.find("img:last");
      container.append("<div class='twentytwenty-handle'></div>");
      var slider = container.find(".twentytwenty-handle");
      slider.append("<span class='twentytwenty-" + beforeDirection + "-arrow'></span>");
      slider.append("<span class='twentytwenty-" + afterDirection + "-arrow'></span>");
      container.addClass("twentytwenty-container");
      beforeImg.addClass("twentytwenty-before");
      afterImg.addClass("twentytwenty-after");

      var overlay = container.find(".twentytwenty-overlay");
      overlay.append("<div class='twentytwenty-before-label' data-content='"+options.before_label+"'></div>");
      overlay.append("<div class='twentytwenty-after-label' data-content='"+options.after_label+"'></div>");

      var calcOffset = function(dimensionPct) {
        var w = beforeImg.width();
        var h = beforeImg.height();
        return {
          w: w+"px",
          h: h+"px",
          cw: (dimensionPct*w)+"px",
          ch: (dimensionPct*h)+"px"
        };
      };

      var adjustContainer = function(offset) {
      	if (sliderOrientation === 'vertical') {
          beforeImg.css("clip", "rect(0,"+offset.w+","+offset.ch+",0)");
          afterImg.css("clip", "rect("+offset.ch+","+offset.w+","+offset.h+",0)");
      	}
      	else {
          beforeImg.css("clip", "rect(0,"+offset.cw+","+offset.h+",0)");
          afterImg.css("clip", "rect(0,"+offset.w+","+offset.h+","+offset.cw+")");
    	}
        container.css("height", offset.h);
      };

      var adjustSlider = function(pct) {
        var offset = calcOffset(pct);
        slider.css((sliderOrientation==="vertical") ? "top" : "left", (sliderOrientation==="vertical") ? offset.ch : offset.cw);
        adjustContainer(offset);
      };

      // Return the number specified or the min/max number if it outside the range given.
      var minMaxNumber = function(num, min, max) {
        return Math.max(min, Math.min(max, num));
      };

      // Calculate the slider percentage based on the position.
      var getSliderPercentage = function(positionX, positionY) {
        var sliderPercentage = (sliderOrientation === 'vertical') ?
          (positionY-offsetY)/imgHeight :
          (positionX-offsetX)/imgWidth;

        return minMaxNumber(sliderPercentage, 0, 1);
      };


      $(window).on("resize.twentytwenty", function(e) {
        adjustSlider(sliderPct);
      });

      var offsetX = 0;
      var offsetY = 0;
      var imgWidth = 0;
      var imgHeight = 0;
      var onMoveStart = function(e) {
        if (((e.distX > e.distY && e.distX < -e.distY) || (e.distX < e.distY && e.distX > -e.distY)) && sliderOrientation !== 'vertical') {
          e.preventDefault();
        }
        else if (((e.distX < e.distY && e.distX < -e.distY) || (e.distX > e.distY && e.distX > -e.distY)) && sliderOrientation === 'vertical') {
          e.preventDefault();
        }
        container.addClass("active");
        offsetX = container.offset().left;
        offsetY = container.offset().top;
        imgWidth = beforeImg.width(); 
        imgHeight = beforeImg.height();          
      };
      var onMove = function(e) {
        if (container.hasClass("active")) {
          sliderPct = getSliderPercentage(e.pageX, e.pageY);
          adjustSlider(sliderPct);
        }
      };
      var onMoveEnd = function() {
          container.removeClass("active");
      };

      var moveTarget = options.move_with_handle_only ? slider : container;
      moveTarget.on("movestart",onMoveStart);
      moveTarget.on("move",onMove);
      moveTarget.on("moveend",onMoveEnd);

      if (options.move_slider_on_hover) {
        container.on("mouseenter", onMoveStart);
        container.on("mousemove", onMove);
        container.on("mouseleave", onMoveEnd);
      }

      slider.on("touchmove", function(e) {
        e.preventDefault();
      });

      container.find("img").on("mousedown", function(event) {
        event.preventDefault();
      });

      if (options.click_to_move) {
        container.on('click', function(e) {
          offsetX = container.offset().left;
          offsetY = container.offset().top;
          imgWidth = beforeImg.width();
          imgHeight = beforeImg.height();

          sliderPct = getSliderPercentage(e.pageX, e.pageY);
          adjustSlider(sliderPct);
        });
      }

      $(window).trigger("resize.twentytwenty");
    });
  };

})(jQuery);

} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.twentytwenty.js; Error:' + e.message);
};
try {
// Â© Copyright 2016 - Archi v1.8.6 by Designesia 
jQuery(window).on("load", function(){
      jQuery(".twentytwenty-container[data-orientation!='vertical']").twentytwenty({default_offset_pct: 0.7});
      jQuery(".twentytwenty-container[data-orientation='vertical']").twentytwenty({default_offset_pct: 0.3, orientation: 'vertical'});
    });
jQuery(document).ready(function () {
    'use strict';				// use strict mode
	jQuery('i').empty();
    var de_header_style 		= 1; // 1 - solid, 2 - transparent
    var de_header_layout 		= 1; // 1 - default, 2 - extended
    var de_header_color 		= 1; // 1 - default, 2 - light style
    var de_header_sticky		= 1; // 1 - sticky, 2 - scroll
    var de_header_mobile_sticky = 2; // 1 - sticky, 2 - scroll
    var de_menu_separator 		= 1; // 1 - dotted, 2 - border, 3 - circle, 4 - square, 5 - plus, 6 - strip, 0 - none
    var de_color_style 			= 1; // 1 - default, 2 - light style
    var de_font_style 			= 1; // 1 - default, 2 - alternate font style

    var mobile_menu_show = 0;

    if (de_color_style == 2) { jQuery('body').addClass('de_light'); }
    if (de_font_style == 2) { jQuery('head').append('<link rel="stylesheet" href="css/font-style-2.css" type="text/css" />'); }
    if (de_header_style == 2) { jQuery('header').addClass('transparent') }
    de_menu_separator = jQuery('.btmenustyle').val();
	if (de_menu_separator == 2) {
        jQuery('#mainmenu').addClass('line-separator');
    } else if (de_menu_separator == 3) {
        jQuery('#mainmenu').addClass('circle-separator');
    } else if (de_menu_separator == 4) {
        jQuery('#mainmenu').addClass('square-separator');
    } else if (de_menu_separator == 5) {
        jQuery('#mainmenu').addClass('plus-separator');
    } else if (de_menu_separator == 6) {
        jQuery('#mainmenu').addClass('strip-separator');
    } else if (de_menu_separator == 0) { jQuery('#mainmenu').addClass('no-separator'); }
    if (de_header_layout == 2) { jQuery('header').addClass('de_header_2'); jQuery('header .info').show(); }
    if (de_header_color == 2) { jQuery('header').addClass('header-light'); }
    if (de_header_sticky == 2) { jQuery('header').addClass('header-scroll'); }
    if (de_header_mobile_sticky == 1) { jQuery('header').addClass('header-mobile-sticky'); }


    // --------------------------------------------------
    // magnificPopup
    // --------------------------------------------------

    jQuery('.simple-ajax-popup-align-top').magnificPopup({
        type: 'ajax',
        alignTop: true,
        overflowY: 'scroll'
    });

    jQuery('.simple-ajax-popup').magnificPopup({
        type: 'ajax'
    });

    // zoom gallery
    jQuery('.zoom-gallery').magnificPopup({
        delegate: 'a',
        type: 'image',
        closeOnContentClick: false,
        closeBtnInside: false,
        mainClass: 'mfp-with-zoom mfp-img-mobile',
        image: {
            verticalFit: true,
            titleSrc: function (item) {
                return item.el.attr('title');
                //return item.el.attr('title') + ' &middot; <a class="image-source-link" href="'+item.el.attr('data-source')+'" target="_blank">image source</a>';
            }
        },
        gallery: {
            enabled: true
        },
        zoom: {
            enabled: true,
            duration: 300, // don't foget to change the duration also in CSS
            opener: function (element) {
                return element.find('img');
            }
        }

    });

    // popup youtube, video, gmaps

    jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
        disableOn: 700,
        type: 'iframe',
        mainClass: 'mfp-fade',
        removalDelay: 160,
        preloader: false,

        fixedContentPos: false
    });

    // image popup

    jQuery('.image-popup-vertical-fit').magnificPopup({
        type: 'image',
        closeOnContentClick: true,
        mainClass: 'mfp-img-mobile',
        image: {
            verticalFit: true
        }

    });

    jQuery('.image-popup-fit-width').magnificPopup({
        type: 'image',
        closeOnContentClick: true,
        image: {
            verticalFit: false
        }
    });

    jQuery('.image-popup-no-margins').magnificPopup({
        type: 'image',
        closeOnContentClick: true,
        closeBtnInside: false,
        fixedContentPos: true,
        mainClass: 'mfp-no-margins mfp-with-zoom', // class to remove default margin from left and right side
        image: {
            verticalFit: true
        },
        zoom: {
            enabled: true,
            duration: 300 // don't foget to change the duration also in CSS
        }
    });

    jQuery('.image-popup-gallery').magnificPopup({
        type: 'image',
        closeOnContentClick: false,
        closeBtnInside: false,
        mainClass: 'mfp-with-zoom mfp-img-mobile',
        image: {
            verticalFit: true,
            titleSrc: function (item) {
                return item.el.attr('title');
                //return item.el.attr('title') + ' &middot; <a class="image-source-link" href="'+item.el.attr('data-source')+'" target="_blank">image source</a>';
            }
        },
        gallery: {
            enabled: true
        }

    });
	/* --------------------------------------------------
	* custom background
	* --------------------------------------------------*/
	function custom_bg() {
		jQuery("div,section").css('background-color', function() {
			return jQuery(this).data('bgcolor');
		});
		jQuery("div,section").css('background', function() {
			return jQuery(this).data('bgimage');
		});
		jQuery("div,section").css('background-size', function() {
			return 'cover';
		});
	}


    // wow jquery

    new WOW().init();

    // --------------------------------------------------
    // init
    // --------------------------------------------------
    function init_de() {

        enquire.register("screen and (max-width: 993px)", {
            match: function () {
                jQuery('header').addClass("header-mobile");
            },
            unmatch: function () {
                jQuery('header').removeClass("header-mobile");
            }
        });

        var $window = jQuery(window);
        jQuery('section[data-type="background"]').each(function () {
            var $bgobj = jQuery(this); // assigning the object

            jQuery(window).scroll(function () {

                enquire.register("screen and (min-width: 993px)", {
                    match: function () {
                        var yPos = -($window.scrollTop() / $bgobj.data('speed'));
                        var coords = '50% ' + yPos + 'px';
                        $bgobj.css({ backgroundPosition: coords });
                    }
                });
            });
            document.createElement("article");
            document.createElement("section");
        });


        /*

        jQuery('.de-team-list').each(function () {

            jQuery(this).find("img").on('load', function () {
                var w = jQuery(this).css("width");
                var h = jQuery(this).css("height");
                //nh = (h.substring(0, h.length - 2)/2)-48;

                jQuery(this).parent().parent().find(".team-pic").css("height", h);
                jQuery(this).parent().parent().find(".team-desc").css("width", w);
                jQuery(this).parent().parent().find(".team-desc").css("height", h);
                jQuery(this).parent().parent().find(".team-desc").css("top", h);

            }).each(function () {
                if (this.complete) jQuery(this).load();
            });
        });

        jQuery(".de-team-list").on("mouseenter", function () {
            var h;
            h = jQuery(this).find("img").css("height");
            jQuery(this).find(".team-desc").stop(true).animate({ 'top': "0px" }, 350, 'easeOutQuad');
            jQuery(this).find("img").stop(true).animate({ 'margin-top': "-100px" }, 400, 'easeOutQuad');
        }).on("mouseleave", function () {
            var h;
            h = jQuery(this).find("img").css("height");
            jQuery(this).find(".team-desc").stop(true).animate({ 'top': h }, 350, 'easeOutQuad');
            jQuery(this).find("img").stop(true).animate({ 'margin-top': "0px" }, 400, 'easeOutQuad');
        })

        */
        
        // portfolio

        jQuery('.item .picframe').each(function () {

            jQuery(this).find("img").css("width", "100%");
            jQuery(this).find("img").css("height", "auto");

            jQuery(this).find("img").on('load', function () {
                var w = jQuery(this).css("width");
                var h = jQuery(this).css("height");
                //nh = (h.substring(0, h.length - 2)/2)-48;

                jQuery(this).parent().css("height", h);

            }).each(function () {
                if (this.complete) jQuery(this).load();
            });
        });

        // --------------------------------------------------
        // portfolio hover
        // --------------------------------------------------
        jQuery('.overlay').fadeTo(1, 0);

        // gallery hover
        /*
        jQuery(".item .picframe").on("mouseenter", function () {
            jQuery(this).parent().find(".overlay").width(jQuery(this).find("img").css("width"));
            jQuery(this).parent().find(".overlay").height(jQuery(this).find("img").css("height"));
            jQuery(this).parent().find(".overlay").stop(true).fadeTo(300, .9);
            var picheight = jQuery(this).find("img").css("height");
            var newheight;
            newheight = (picheight.substring(0, picheight.length - 2) / 2) - 10;
            //alert(newheight);
            jQuery(this).parent().find(".pf_text").stop(true).animate({ 'margin-top': newheight }, 300, 'easeOutCubic');

            var w = jQuery(this).find("img").css("width");
            var h = jQuery(this).find("img").css("height");
            var w = parseInt(w, 10);
            var h = parseInt(h, 10);
            var $scale = 1.2;
            //alert(w);

            jQuery(this).find("img").stop(true).animate({
                width: w * $scale,
                height: h * $scale,
                'margin-left': -w * ($scale - 1) / 2,
                'margin-top': -h * ($scale - 1) / 2
            }, 700, 'easeOutQuad');


        }).on("mouseleave", function () {
            var newheight;
            var picheight = jQuery(this).find("img").css("height");
            newheight = (picheight.substring(0, picheight.length - 2) / 2) - 10;
            jQuery(this).parent().find(".pf_text").stop(true).animate({ 'margin-top': newheight - 30 }, 300, 'easeOutCubic');
            jQuery(this).parent().find(".overlay").stop(true).fadeTo(300, 0);
            jQuery(this).find("img").stop(true).animate({
                width: '100%',
                height: '100%',
                'margin-left': 0,
                'margin-top': 0
            }, 700, 'easeOutQuad');
        })
        */



        jQuery('.overlay').fadeTo(1, 0);
        // team hover
    }
function grid_gallery() {
            jQuery('.grid-item').each(function () {
                var this_col = Number(jQuery(this).parent().attr('data-col'));
                var this_gridspace = Number(jQuery(this).parent().attr('data-gridspace'));
                var this_ratio = eval(jQuery(this).parent().attr('data-ratio'));
                jQuery(this).parent().css('padding-left', this_gridspace);
                var w = ((jQuery(document).width() - (this_gridspace * this_col + 1)) / this_col) - (this_gridspace / this_col);
                var gi = jQuery(this);
                var h = w * this_ratio;
                gi.css('width', w);
                gi.css('height', h);
                gi.find(".pf_title").css('margin-top', (h / 2) - 10);
                gi.css('margin-right', this_gridspace);
                gi.css('margin-bottom', this_gridspace);
                if (gi.hasClass('large')) {
                    jQuery(this).css('width', (w * 2) + this_gridspace);
                    jQuery(this).css('height', (h * 2) + this_gridspace);
                }
                if (gi.hasClass('large-width')) {
                    jQuery(this).css('width', (w * 2) + this_gridspace);
                    jQuery(this).css('height', h);
                }
                if (gi.hasClass('large-height')) {
                    jQuery(this).css('height', (h * 2) + this_gridspace);
                    gi.find(".pf_title").css('margin-top', (h) - 20);
                }
            });
        }

		
		init_de();
        grid_gallery();


    var bt_loader = jQuery('.bt-loader').val();//alert(bt_loader)
    if (bt_loader == 1){
    // --------------------------------------------------
    // preloader
    // --------------------------------------------------

    //calling jPreLoader function with properties
    jQuery('body').jpreLoader({
        splashID: "#jSplash",
        splashFunction: function () {  //passing Splash Screen script to jPreLoader
            jQuery('#jSplash').children('section').not('.selected').hide();
            jQuery('#jSplash').hide().fadeIn(800);
            init_de();
            var timer = setInterval(function () {
                splashRotator();
            }, 1500);
        }
    }, function () {	//jPreLoader callback function
        clearInterval();

        jQuery(function () {
            var v_url = document.URL;

            if (v_url.indexOf('#') != -1) {
                var v_hash = v_url.substring(v_url.indexOf("#") + 1);


                jQuery('html, body').animate({
                    scrollTop: jQuery('#' + v_hash).offset().top - 70
                }, 200);
                return false;
            }
        });


    });

	}
    // End of jPreLoader script

    function splashRotator() {
        var cur = jQuery('#jSplash').children('.selected');
        var next = jQuery(cur).next();

        if (jQuery(next).length != 0) {
            jQuery(next).addClass('selected');
        } else {
            jQuery('#jSplash').children('section:first-child').addClass('selected');
            next = jQuery('#jSplash').children('section:first-child');
        }

        jQuery(cur).removeClass('selected').fadeOut(100, function () {
            jQuery(next).fadeIn(100);
        });
    }


    // --------------------------------------------------
    // function
    // --------------------------------------------------

    function video_autosize() {
        jQuery('.de-video-container').each(function () {
            var height_1 = jQuery(this).css("height");
            var height_2 = jQuery(this).find(".de-video-content").css("height");
            var newheight = (height_1.substring(0, height_1.length - 2) - height_2.substring(0, height_2.length - 2)) / 2;
            jQuery(this).find('.de-video-overlay').css("height", height_1);
            jQuery(this).find(".de-video-content").animate({ 'margin-top': newheight }, 'fast');
        });
    }

    window.onresize = function (event) {

        enquire.register("screen and (min-width: 993px)", {
            match: function () {
                jQuery('#mainmenu').show();
				jQuery('header').removeClass('height-auto');
                mobile_menu_show = 1;				
            },
            unmatch: function () {
                jQuery('#mainmenu').hide();
                mobile_menu_show = 0;
                jQuery("#menu-btn").show();


            }
        });


        // header bottom setting begin
        var mq = window.matchMedia("(max-width: 993px)");
        if (mq.matches) {
            jQuery('.header-bottom').css("display", "block");
            jQuery('.header-bottom').css("top", "0");
        }
        // header bottom setting close

        init();
        init_de();
        video_autosize();
        centery();
        jQuery('#gallery').isotope('reLayout');

        jQuery('header').removeClass('smaller');
        jQuery('header').removeClass('logo-smaller');
        jQuery('header').removeClass('clone');

    };


    function init() {

        var sh = jQuery('#de-sidebar').css("height");
        var dh = jQuery(window).innerHeight();
        var h = parseInt(sh) - parseInt(dh);
        var header_height = parseInt(jQuery('header').height(), 10);
        var screen_height = parseInt(jQuery(window).height(), 10);
        var header_mt = screen_height - header_height;
        var mq = window.matchMedia("(min-width: 993px)");
        var ms = window.matchMedia("(min-width: 768px)");

        window.addEventListener('scroll', function (e) {

            if (mq.matches) {
                var distanceY = window.pageYOffset || document.documentElement.scrollTop,
                shrinkOn = 100,
                header = document.querySelector("header");
                if (distanceY > shrinkOn) {
                    classie.add(header, "smaller");
                } else {
                    if (classie.has(header, "smaller")) {
                        classie.remove(header, "smaller");
                    }

                }
            }

            if (mq.matches) {
				jQuery("header").addClass("clone", 1000, "easeOutBounce");
				
				// header autoshow on scroll begin
					var $document = jQuery(document);
					var vscroll = 0;
					
					if ($document.scrollTop() >= 50 && vscroll == 0) {
						jQuery("header.autoshow").removeClass("scrollOff");
						jQuery("header.autoshow").addClass("scrollOn");
						jQuery("header.autoshow").css("height", "auto");
						vscroll = 1;
					} else {
						jQuery("header.autoshow").removeClass("scrollOn");
						jQuery("header.autoshow").addClass("scrollOff");
						vscroll = 0;
					}
				// header autoshow on scroll close
				
				
                // header bottom on scroll begin
					var $document = jQuery(document);
					var header_height = parseInt(jQuery('header').height(), 10);
					var screen_height = parseInt(jQuery(window).height(), 10);
					var header_mt = screen_height - header_height;

					if ($document.scrollTop() >= header_mt) {
						jQuery('.header-bottom').css("position", "fixed");
						jQuery('.header-bottom').css("top", "0");
					} else if ($document.scrollTop() <= header_mt) {
						jQuery('.header-bottom').css("position", "absolute");
						jQuery('.header-bottom').css("top", header_mt);
					}
                // header bottom on scroll close
				
				
				// side header on scroll begin
					if (jQuery("header").hasClass("side-header")) {
						if (jQuery(document).scrollTop() >= h) {
							jQuery('#de-sidebar').css("position", "fixed");
							if (parseInt(sh) > parseInt(dh)) {
								jQuery('#de-sidebar').css("top", -h);
							}
							jQuery('#main').addClass("col-md-offset-3");
						} else {
							jQuery('#de-sidebar').css("position", "relative");
							if (parseInt(sh) > parseInt(dh)) {
								jQuery('#de-sidebar').css("top", 0);
							}
							jQuery('#main').removeClass("col-md-offset-3");
						}
					}
				// side header on scroll close
            }
        });


        if (mq.matches) {
            jQuery('.header-bottom').css('position', 'absolute');
            jQuery('.header-bottom').css('top', header_mt);
        }


    }
    window.onload = init();
 
    // --------------------------------------------------
    // owlCarousel
    // --------------------------------------------------
	
	jQuery("#gallery-carousel-2").owlCarousel({
        center: false,
			items:2,
			loop:true,
			dots: false,
			margin:0,
			responsive:{
				1000:{
					items:2
				},
				600:{
					items:2
				},
				0:{
					items:1
				}
			}
    });

    jQuery("#gallery-carousel-3").owlCarousel({
        center: false,
			items:3,
			loop:true,
			dots: false,
			margin:0,
			responsive:{
				1000:{
					items:3
				},
				600:{
					items:2
				},
				0:{
					items:1
				}
			}
    });

    jQuery("#gallery-carousel-4").owlCarousel({
        center: false,
			items:4,
			loop:true,
			dots: false,
			margin:0,
			responsive:{
				1000:{
					items:4
				},
				600:{
					items:2
				},
				0:{
					items:1
				}
			}
    });


    jQuery(".carousel-gallery").owlCarousel({
        items: 4,
        navigation: false,
        pagination: false
    });

    jQuery("#blog-carousel").owlCarousel({
            center: false,
			items:2,
			loop:true,
			dots: true,
			margin:30,
			responsive:{
				1000:{
					items:2
				},
				600:{
					items:1
				},
				0:{
					items:1
				}
			}
         });
	
	jQuery(".carousel-4-center-dots").owlCarousel({
            center: true,
			items:4,
			loop:true,
			dots: true,
			margin:30,
			responsive:{
				1000:{
					items:4
				},
				600:{
					items:2
				},
				0:{
					items:1
				}
			}
         });
	
	jQuery("#testimonial-carousel1").owlCarousel({
            center: false,
			items:2,
			loop:true,
			dots: true,
			margin:30,
			mouseDrag:true,
			touchDrag:true,
			responsive:{
				1000:{
					items:2
				},
				600:{
					items:1
				},
				0:{
					items:1
				}
			}
         });
		 jQuery("#testimonial-carousel").owlCarousel({
            center: false,
			items:2,
			loop:true,
			dots: true,
			margin:30,
			responsive:{
				1000:{
					items:2
				},
				600:{
					items:1
				},
				0:{
					items:1
				}
			}
         });
	

    jQuery("#logo-carousel").owlCarousel({
        items: 6,
        loop:true,
		dots: false,
        autoPlay: true
    });
	jQuery("#testimonial-carousel-single").owlCarousel({
			items:1,
			autoplay:true,
			autoplayTimeout:6000,
			animateOut: 'fadeOut',
			animateIn: 'fadeIn',
			loop:true,
			dots:true,
			mouseDrag:false,
			touchDrag:false,
			margin:0,
         });

    jQuery("#contact-carousel").owlCarousel({
        items: 1,
        singleItem: true,
        navigation: false,
        pagination: false,
        autoPlay: true
    });


    jQuery("#text-carousel").owlCarousel({
			items:1,
			autoplay:true,
			autoplayTimeout:4000,
			animateOut: 'fadeOut',
			animateIn: 'fadeIn',
			loop:true,
			dots:false,
			mouseDrag:false,
			touchDrag:false,
			margin:0,
         });
	
	
	jQuery("#single-carousel").owlCarousel({
			items:1,
			autoplay:true,
			autoplayTimeout:4000,
			animateOut: 'fadeOut',
			animateIn: 'fadeIn',
			loop:true,
			dots:false,
			mouseDrag:false,
			touchDrag:false,
			margin:0,
         });
	
	
	 jQuery(".carousel-single-navi").owlCarousel({
        items: 1,
        singleItem: true,
        navigation: true,
        pagination: false,
        mouseDrag: false,
        touchDrag: false,
        transitionStyle: "fade"
    });

    jQuery(".blog-slide").owlCarousel({
        items: 1,
        singleItem: true,
        navigation: false,
        pagination: false,
        autoPlay: false
    });


    // Custom Navigation owlCarousel
    jQuery(".next").on("click", function () {
        jQuery(this).parent().parent().find('.blog-slide').trigger('owl.next');
    });
    jQuery(".prev").on("click", function () {
        jQuery(this).parent().parent().find('.blog-slide').trigger('owl.prev');
    });

	function owlnavcenter(){
    jQuery('.owl-custom-nav').each(function () {
        var owl = jQuery('.owl-custom-nav').next();
        var ow = parseInt(owl.css("height"), 10);
        jQuery(this).css("margin-top", (ow / 2) - 10);

        owl.owlCarousel();

        // Custom Navigation Events
        jQuery(".btn-next").on("click", function () {
            owl.trigger('next.owl.carousel');
        });
        jQuery(".btn-prev").on("click", function () {
            owl.trigger('prev.owl.carousel');
        });
    });
	}
	
	owlnavcenter();


    // --------------------------------------------------
    // custom positiion
    // --------------------------------------------------

    function centery() {
        var $doc_height = jQuery(window).innerHeight();
        jQuery('#homepage #content.content-overlay').css("margin-top", $doc_height);
        jQuery('.full-height').css("height", $doc_height);
        var picheight = jQuery('.center-y').css("height");
        picheight = parseInt(picheight, 10);
        jQuery('.center-y').css('margin-top', (($doc_height - picheight) / 2) - 90);
        jQuery('.full-height .de-video-container').css("height", $doc_height);
    }

    centery();


    // --------------------------------------------------
    // blog list hover
    // --------------------------------------------------
    jQuery(".blog-list").on("mouseenter", function () {
        var v_height = jQuery(this).find(".blog-slide").css("height");
        var v_width = jQuery(this).find(".blog-slide").css("width");
        var newheight = (v_height.substring(0, v_height.length - 2) / 2) - 40;
        jQuery(this).find(".owl-arrow").css("margin-top", newheight);
        jQuery(this).find(".owl-arrow").css("width", v_width);
        jQuery(this).find(".owl-arrow").fadeTo(150, 1);
        //alert(v_height);
    }).on("mouseleave", function () {
        jQuery(this).find(".owl-arrow").fadeTo(150, 0);

    })

    //  logo carousel hover
    jQuery("#logo-carousel img").on("mouseenter", function () {
        jQuery(this).fadeTo(150, .5);
    }).on("mouseleave", function () {
        jQuery(this).fadeTo(150, 1);
    })


    jQuery(window).load(function () {

        video_autosize();
				
        grid_gallery();
		custom_bg();
        // --------------------------------------------------
        // filtering gallery
        // --------------------------------------------------
        var $container = jQuery('#gallery');
        $container.isotope({
            itemSelector: '.item',
            filter: '*'
        });
        jQuery('#filters a').on("click", function () {
            var $this = jQuery(this);
            if ($this.hasClass('selected')) {
                return false;
            }
            var $optionSet = $this.parents();
            $optionSet.find('.selected').removeClass('selected');
            $this.addClass('selected');

            var selector = jQuery(this).attr('data-filter');
            $container.isotope({
                filter: selector
            });
            return false;
        });
 

        // --------------------------------------------------
        // tabs
        // --------------------------------------------------
        jQuery('.de_tab').find('.de_tab_content > div').hide();
        jQuery('.de_tab').find('.de_tab_content > div:first').show();
        jQuery('li').find('.v-border').fadeTo(150, 0);
        jQuery('li.active').find('.v-border').fadeTo(150, 1);

        jQuery('.de_nav li').click(function () {
            jQuery(this).parent().find('li').removeClass("active");
            jQuery(this).addClass("active");
            jQuery(this).parent().parent().find('.v-border').fadeTo(150, 0);
            jQuery(this).parent().parent().find('.de_tab_content > div').hide();

            var indexer = jQuery(this).index(); //gets the current index of (this) which is #nav li
            jQuery(this).parent().parent().find('.de_tab_content > div:eq(' + indexer + ')').fadeIn(); //uses whatever index the link has to open the corresponding box 
            jQuery(this).find('.v-border').fadeTo(150, 1);
        });


        // request quote function

        var rq_step = 1;

        jQuery('#request_form .btn-right').click(function () {

            var rq_name = jQuery('#rq_name').val();
            var rq_email = jQuery('#rq_email').val();
            var rq_phone = jQuery('#rq_phone').val();

            if (rq_step == 1) {
                if (rq_name.length == 0) { jQuery('#rq_name').addClass("error_input"); } else { jQuery('#rq_name').removeClass("error_input"); }
                if (rq_email.length == 0) { jQuery('#rq_email').addClass("error_input"); } else { jQuery('#rq_email').removeClass("error_input"); }
                if (rq_phone.length == 0) { jQuery('#rq_phone').addClass("error_input"); } else { jQuery('#rq_phone').removeClass("error_input"); }
            }

            if (rq_name.length != 0 && rq_email.length != 0 && rq_phone.length != 0) {
                jQuery("#rq_step_1").hide();
                jQuery("#rq_step_2").fadeIn();
            }

        });

        // --------------------------------------------------
        // tabs
        // --------------------------------------------------
        jQuery('.de_review').find('.de_tab_content > div').hide();
        jQuery('.de_review').find('.de_tab_content > div:first').show();
        //jQuery('.de_review').find('.de_nav li').fadeTo(150,.5);
        jQuery('.de_review').find('.de_nav li:first').fadeTo(150, 1);

        jQuery('.de_nav li').click(function () {
            jQuery(this).parent().find('li').removeClass("active");
            //jQuery(this).parent().find('li').fadeTo(150,.5);
            jQuery(this).addClass("active");
            jQuery(this).fadeTo(150, 1);
            jQuery(this).parent().parent().find('.de_tab_content > div').hide();

            var indexer = jQuery(this).index(); //gets the current index of (this) which is #nav li
            jQuery(this).parent().parent().find('.de_tab_content > div:eq(' + indexer + ')').show(); //uses whatever index the link has to open the corresponding box 
        });


        // --------------------------------------------------
        // toggle
        // --------------------------------------------------
        jQuery(".toggle-list h2").addClass("acc_active");
        jQuery(".toggle-list h2").toggle(
        function () {
            jQuery(this).addClass("acc_noactive");
            jQuery(this).next(".ac-content").slideToggle(200);
        },
        function () {
            jQuery(this).removeClass("acc_noactive").addClass("acc_active");
            jQuery(this).next(".ac-content").slideToggle(200);
        })

        var mb;

        // --------------------------------------------------
        // navigation for mobile
        // --------------------------------------------------



        jQuery('#menu-btn').on("click", function () {
            if (mobile_menu_show == 0) {
                jQuery('#mainmenu').slideDown();
				jQuery('header').addClass('height-auto');
                mobile_menu_show = 1;
            } else {
				jQuery('#mainmenu').slideUp('fast', function() {
				   jQuery('header').removeClass('height-auto');
				   mobile_menu_show = 0;
				});                				
            }
        })

        // one page navigation
        /**
       * This part causes smooth scrolling using scrollto.js
       * We target all a tags inside the nav, and apply the scrollto.js to it.
       */

        jQuery("#homepage nav a, .scroll-to").click(function (evn) {

            if (this.href.indexOf('#') != -1) {
                evn.preventDefault();
                jQuery('html,body').scrollTo(this.hash, this.hash);
            }
        });

        jQuery("a.btn").click(function (evn) {

            if (this.href.indexOf('#') != -1) {
                evn.preventDefault();
                jQuery('html,body').scrollTo(this.hash, this.hash);
            }
        });

        jQuery('.de-gallery .item .icon-info').on("click", function () {
            jQuery('.page-overlay').show();
            url = jQuery(this).attr("data-value");

            jQuery("#loader-area .project-load").load(url, function () {
                jQuery("#loader-area").slideDown(500, function () {
                    jQuery('.page-overlay').hide();
                    jQuery('html, body').animate({
                        scrollTop: jQuery('#loader-area').offset().top - 70
                    }, 500, 'easeOutCubic');

                    //

                    jQuery(".image-slider").owlCarousel({
                        items: 1,
                        singleItem: true,
                        navigation: false,
                        pagination: true,
                        autoPlay: false
                    });

                    jQuery(".container").fitVids();

                    jQuery('#btn-close-x').on("click", function () {
                        jQuery("#loader-area").slideUp(500, function () {
                            jQuery('html, body').animate({
                                scrollTop: jQuery('#section-portfolio').offset().top - 70
                            }, 500, 'easeOutCirc');
                        });

                        return false;

                    });

                });
            });
        });

        jQuery('.de-gallery .item').on("click", function () {
            jQuery('#navigation').show();
        });


        // --------------------------------------------------
        // custom page with background on side
        // --------------------------------------------------
        jQuery('.side-bg').each(function () {
            jQuery(this).find(".image-container").css("height", jQuery(this).find(".image-container").parent().css("height"));
        });

        var target = jQuery('.center-y');
        var targetHeight = target.outerHeight();
		
		jQuery('.animated').fadeTo(0, 0);
        jQuery('.animated').each(function () {
            var imagePos = jQuery(this).offset().top;
            var timedelay = jQuery(this).attr('data-delay');

            var topOfWindow = jQuery(window).scrollTop();
            if (imagePos < topOfWindow + 300) {
                jQuery(this).fadeTo(1, 500);
                var $anim = jQuery(this).attr('data-animation');
            }
        });


        // btn arrow up
        jQuery(".arrow-up").on("click", function () {
            jQuery(".coming-soon .coming-soon-content").fadeOut("medium", function () {
                jQuery("#hide-content").fadeIn(600, function () {
                    jQuery('.arrow-up').animate({ 'bottom': '-40px' }, "slow");
                    jQuery('.arrow-down').animate({ 'top': '0' }, "slow");
                });
            });
        });

        // btn arrow down
        jQuery(".arrow-down").on("click", function () {
            jQuery("#hide-content").fadeOut("slow", function () {
                jQuery(".coming-soon .coming-soon-content").fadeIn(800, function () {
                    jQuery('.arrow-up').animate({ 'bottom': '0px' }, "slow");
                    jQuery('.arrow-down').animate({ 'top': '-40' }, "slow");
                });
            });
        });

        /*
        jQuery(document).scroll(function (e) {
            var scrollPercent = (targetHeight - window.scrollY) / targetHeight;
            if (scrollPercent >= 0) {
                target.css('opacity', scrollPercent);
            }
        });
        */
        
        jQuery(document).scroll(function () {
            jQuery('.bthome nav li a').each(function () {
                if (this.href.indexOf('#') != -1) {
                    var href = jQuery(this).attr('href');
                    if (jQuery(window).scrollTop() > jQuery(href).offset().top - 140) {
                        jQuery('nav li a').removeClass('active');
                        jQuery(this).addClass('active');
                    }
                }
            });
        });
    });


    // --------------------------------------------------
    // css animation
    // --------------------------------------------------
    var v_count = '0';

    jQuery(window).load(function () {

        jQuery('.animated').fadeTo(0, 0);
        jQuery('.animated').each(function () {
            var imagePos = jQuery(this).offset().top;
            var timedelay = jQuery(this).attr('data-delay');

            var topOfWindow = jQuery(window).scrollTop();
            if (imagePos < topOfWindow + 300) {
                jQuery(this).fadeTo(1, 500);
                var $anim = jQuery(this).attr('data-animation');
            }
        });


        // btn arrow up
        jQuery(".arrow-up").on("click", function () {
            jQuery(".coming-soon .coming-soon-content").fadeOut("medium", function () {
                jQuery("#hide-content").fadeIn(600, function () {
                    jQuery('.arrow-up').animate({ 'bottom': '-40px' }, "slow");
                    jQuery('.arrow-down').animate({ 'top': '0' }, "slow");
                });
            });
        });

        // btn arrow down
        jQuery(".arrow-down").on("click", function () {
            jQuery("#hide-content").fadeOut("slow", function () {
                jQuery(".coming-soon .coming-soon-content").fadeIn(800, function () {
                    jQuery('.arrow-up').animate({ 'bottom': '0px' }, "slow");
                    jQuery('.arrow-down').animate({ 'top': '-40' }, "slow");
                });
            });
        });

        // isotope
        jQuery('#gallery').isotope('reLayout');

    });



    jQuery(window).scroll(function () {

        // --------------------------------------------------
        // counter
        // --------------------------------------------------

        jQuery('.timer').each(function () {
            var imagePos = jQuery(this).offset().top;

            var topOfWindow = jQuery(window).scrollTop();
            if (imagePos < topOfWindow + 500 && v_count == '0') {

                jQuery(function ($) {

                    // start all the timers
                    jQuery('.timer').each(count);


                    function count(options) {
                        v_count = '1';
                        var $this = jQuery(this);
                        options = jQuery.extend({}, options || {}, $this.data('countToOptions') || {});
                        $this.countTo(options);
                    }
                });

            }
        });

        // --------------------------------------------------
        // progress bar
        // --------------------------------------------------
        jQuery('.de-progress').each(function () {
            var pos_y = jQuery(this).offset().top;
            var value = jQuery(this).find(".progress-bar").attr('data-value');

            var topOfWindow = jQuery(window).scrollTop();
            if (pos_y < topOfWindow + 500) {
                jQuery(this).find(".progress-bar").animate({ 'width': value }, "slow");
            }
        });


        jQuery('.animated').each(function () {
            var imagePos = jQuery(this).offset().top;
            var timedelay = jQuery(this).attr('data-delay');

            var topOfWindow = jQuery(window).scrollTop();
            if (imagePos < topOfWindow + 500) {
                jQuery(this).delay(timedelay).queue(function () {
                    jQuery(this).fadeTo(1, 500);
                    var $anim = jQuery(this).attr('data-animation');
                    jQuery(this).addClass($anim).clearQueue();
                });

            }
        });

        jQuery(".nav-exit").on("click", function () {
            jQuery.magnificPopup.close();
        });



    });


    // mainmenu create span
    jQuery('#mainmenu li a').each(function () {
        if (jQuery(this).next("ul").length > 0) {
            jQuery("<span></span>").insertAfter(jQuery(this));
        }
    });

    // mainmenu arrow click
    jQuery("#mainmenu > li > span").on("click", function () {
        jQuery('header').css("height", "auto");
        var iteration = jQuery(this).data('iteration') || 1;
        switch (iteration) {
            case 1:
                jQuery(this).addClass("active");
                jQuery(this).parent().find("ul:first").css("height", "auto");
                var curHeight = jQuery(this).parent().find("ul:first").height();
                jQuery(this).parent().find("ul:first").css("height", "0");
                jQuery(this).parent().find("ul:first").animate({ 'height': curHeight }, 400, 'easeInOutQuint');

                break;

            case 2:
                jQuery(this).removeClass("active");
                jQuery(this).parent().find("ul:first").animate({ 'height': "0" }, 400, 'easeInOutQuint');
                break;
        }
        iteration++;
        if (iteration > 2) iteration = 1;
        jQuery(this).data('iteration', iteration);
    });
	
	jQuery("#mainmenu > li > ul > li > span").on("click", function () {
        var iteration = jQuery(this).data('iteration') || 1;
        switch (iteration) {
            case 1:
                jQuery(this).addClass("active");
                jQuery(this).parent().find("ul:first").css("height", "auto");
				jQuery(this).parent().parent().parent().find("ul:first").css("height", "auto");
                var curHeight = 22 + jQuery(this).parent().find("ul:first").height();
                jQuery(this).parent().find("ul:first").css("height", "0");
                jQuery(this).parent().find("ul:first").animate({ 'height': curHeight }, 400, 'easeInOutQuint');

                break;

            case 2:
                jQuery(this).removeClass("active");
                jQuery(this).parent().find("ul:first").animate({ 'height': "0" }, 400, 'easeInOutQuint');
                break;
        }
        iteration++;
        if (iteration > 2) iteration = 1;
        jQuery(this).data('iteration', iteration);
    });

   

    //jQUery('footer').append('<a href="#" id="back-to-top"></a>');

    if (jQuery('#back-to-top').length) { 
        var scrollTrigger = 500, // px
            backToTop = function () {
                var scrollTop = jQuery(window).scrollTop();
                if (scrollTop > scrollTrigger) {
                    jQuery('#back-to-top').addClass('show');
                } else {
                    jQuery('#back-to-top').removeClass('show');
                }
            };
        backToTop();
        jQuery(window).on('scroll', function () {
            backToTop();
        });
        jQuery('#back-to-top').on('click', function (e) {
            e.preventDefault();
            jQuery('html,body').animate({
                scrollTop: 0
            }, 700);
        });

        jQuery("section,div").css('background-color', function () {
            return jQuery(this).data('bgcolor');
        });
        jQuery("div.btbg").css('background-image', function () {
			var bturi = jQuery('.bturi').val()+'/'+jQuery(this).data('bgimage'); console.log(bturi)
            return 'url('+bturi+')';
        });
		 
		
    }
	
	// --------------------------------------------------
	// looping background
	// --------------------------------------------------
	 jQuery(function(){
     	"use strict";
        var x = 0;
        setInterval(function(){
            x-=1;
            jQuery('.bg-loop').css('background-position', x + 'px 0');
        }, 50);
    })

});

jQuery(document).ready(function(){
            // jquery typed plugin
            jQuery(".typed").typed({ 
                stringsElement: jQuery('.typed-strings'),
                typeSpeed: 100,
                backDelay: 1500,
                loop: true,
                contentType: 'html', // or text
                // defaults to false for infinite loop
                loopCount: false,
                callback: function () { null; },
                resetCallback: function () { newTyped(); }
            });
        });
jQuery(document).ready(function(){
    jQuery("#mainmenu  a").click(function(){
			
			var v_url = this.hash;
			
			if (v_url.indexOf('#') != -1) {
			var v_hash = v_url.substring(v_url.indexOf("#")+1);
			
				if (window.matchMedia('(max-width: 767px)').matches) {
					n = -1;
				} else {
					n = 69
				}

				jQuery('html, body').animate({					
				scrollTop: jQuery('#' + v_hash).offset().top - n
				}, 400, 'easeInOutQuint');
				return false;
			}
        });
   // jQuery('#mainmenu a').click(function(e){
//		var a_href = jQuery(this).attr('href');
//        jQuery('#mainmenu a').removeClass('active');
//        jQuery(this).addClass('active');
//		scrollToElement(a_href, 500);
//		return false;
//	});
//    
    
});
function scrollToElement(selector, time, verticalOffset) {
	time = typeof(time) != 'undefined' ? time : 1000;
	verticalOffset = typeof(verticalOffset) != 'undefined' ? verticalOffset : 0;
	element = jQuery(selector);
	offset = element.offset();
	offsetTop = offset.top + verticalOffset;
	jQuery('html, body').animate({ 
		scrollTop: offsetTop-30
	}, time);
}
} catch (e) {
console.error('Error in file:/templates/archi/js/designesia.js; Error:' + e.message);
};

try {
// --------------------------------------------------
// switcher.js by designesia 2013
// --------------------------------------------------

jQuery(document).ready(function() {
	
	var bt_uri_css = jQuery('.bttpl').val();
	jQuery(".bg1").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/aqua.css");
	});
	
	jQuery(".bg2").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/blue.css");
	});
	
	jQuery(".bg3").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/green.css");
	});
	
	jQuery(".bg4").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/grey.css");
	});
	
	jQuery(".bg5").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/orange.css");
	});
	
	jQuery(".bg6").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/pink.css");
	});
	
	jQuery(".bg7").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/purple.css");
	});
	
	jQuery(".bg8").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/red.css");
	});
	
	jQuery(".bg9").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/yellow.css");
	});
	
	jQuery(".bg10").click(function(){
		jQuery("#colors").attr("href", bt_uri_css+"colors/lime.css");
	});
	
	
	
	jQuery(".custom-show").hide();
	
	jQuery(".custom-close").click(function(){
		jQuery(this).hide();
		jQuery(".custom-show").show();
		jQuery('#switcher').animate({'left': '+=120px'},'medium');
	});
  	

	jQuery(".custom-show").click(function(){
		jQuery(this).hide();
		jQuery(".custom-close").show();
		jQuery(this).parent().animate({'left': '-=120px'},'medium');
	});
	
	
	jQuery('#de-header').on('change', function() {
		v = this.value
		if(v=='opt-1'){
			jQuery('header').removeClass('transparent');
		}else if(v=='opt-2'){
			jQuery('header').addClass('transparent');
		}
	});
	var menu_style = jQuery('nav.bt-nav-menu').attr('data-menu');
    jQuery('#mainmenu').addClass(menu_style);
	jQuery('#de-menu').on('change', function() {
		jQuery('#mainmenu').removeClass('no-separator');
		jQuery('#mainmenu').removeClass('line-separator');
		jQuery('#mainmenu').removeClass('circle-separator');
		jQuery('#mainmenu').removeClass('square-separator');
		jQuery('#mainmenu').removeClass('plus-separator');
		jQuery('#mainmenu').removeClass('strip-separator');
		v = this.value
		if(v=='opt-1'){
			jQuery('#mainmenu').removeClass('no-separator');
			jQuery('#mainmenu').removeClass('line-separator');
		}else if(v=='opt-2'){
			jQuery('#mainmenu').addClass('line-separator');
		}else if(v=='opt-3'){
			jQuery('#mainmenu').addClass('circle-separator');
		}else if(v=='opt-4'){
			jQuery('#mainmenu').addClass('square-separator');
		}else if(v=='opt-5'){
			jQuery('#mainmenu').addClass('plus-separator');
		}else if(v=='opt-6'){
			jQuery('#mainmenu').addClass('strip-separator');
		}else if(v=='opt-0'){
			jQuery('#mainmenu').addClass('no-separator');
		}
	});
	
	jQuery('#de-pattern li').click(function(){
		n = jQuery('#de-layout').val();
		if(n=="boxed"){
			className = jQuery(this).attr('class');
			jQuery('body').removeClass();
			jQuery('body').addClass(className);
		}else{
			alert('Please select boxed layout first.');
		}
			
	});
});


} catch (e) {
console.error('Error in file:/templates/archi/js/demo.js; Error:' + e.message);
};
try {
window.TaskMonitorDebug = true;
window.TaskMonitorBaseDir = "/";

jQuery(document).ready(function () {
  hhrInitLists();
  if (jQuery(".hhrSpecialHeader").length > 0) {
    var scrolledNow = jQuery(window).scrollTop();

    var scrolledLimit1 = jQuery(".hhrArticle.hhrHeader").outerHeight();
    var scrolledLimit2 = jQuery(".hhrArticle.hhrHeader").offset().top;
    var scrolledLimit =
      parseInt(scrolledLimit1) + parseInt(scrolledLimit2) - 80;
    if (scrolledNow > scrolledLimit) {
      jQuery(".hhrSpecialHeader").addClass("active");
    }
    window.hhrHeaderScrolledLimit = scrolledLimit;
    jQuery(window).scroll(function () {
      if (jQuery(window).scrollTop() > window.hhrHeaderScrolledLimit) {
        if (jQuery(".hhrSpecialHeader").hasClass("active") === false) {
          jQuery(".hhrSpecialHeader").addClass("active");
        }
      } else {
        if (jQuery(".hhrSpecialHeader").hasClass("active") === true) {
          jQuery(".hhrSpecialHeader").removeClass("active");
        }
      }
    });
    console.log(scrolledNow, scrolledLimit);
  } else {
    jQuery(".hhrSpecialHeader").addClass("hidden");
  }

  jQuery("select").select2();

  jQuery(".hhr-home-filter-btn.btn-search").click(function () {
    hhrHomeSearch();
  });
  
  jQuery(".hhr-home-filter input.hhr-input").on("keydown", function (event) {
    if (event.keyCode === 13) {
      hhrHomeSearch();
    }
  });


  if (jQuery(".hhr-home-photo").length > 0) {
    if (jQuery("body").hasClass("en-GB")) {
      hhrWelcomeMessageEn();
    } else {
      hhrWelcomeMessage();
    }
  }

  /* initiate form control if form exists */
  if (jQuery(".hhrform-envelope").length > 0) {
    if (jQuery("body").hasClass("en-GB")) {
      hhrFormInitEn();
    } else {
      hhrFormInit();
    }
  }

  /* initiate home filter if exists */
  if (jQuery(".hhr-home-filter").length > 0) {
    if (jQuery("body").hasClass("en-GB")) {
      hhrHomeFormInitEn();
    } else {
      hhrHomeFormInit();
    }
  }

  /* initiate if article view active */
  if (jQuery(".hhrArticleEnvelope").length > 0) {
    if (jQuery("body").hasClass("en-GB")) {
      hhrEstateStatusCheckEn();
    } else {
      hhrEstateStatusCheck();
    }
  }
});

function newSystemMessage(icon, title, message, content, timeout) {
  return true;
}

function hhrInitLoadNext() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(document).ready(function () {
    var el = jQuery(".hhrEstateIntro.toLoad");
    if (el !== undefined) {
      hhrLoadNext(el, 10);
    }
    hhrInitSliders(jQuery(".hhrFilter"));
  });
}

function hhrInitLoadNextEn() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(document).ready(function () {
    var el = jQuery(".hhrEstateIntro.toLoad");
    if (el !== undefined) {
      hhrLoadNextEn(el, 10);
    }
    hhrInitSlidersEn(jQuery(".hhrFilter"));
  });
}

function BiAjaxIcon(action, additionalMessage) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (action !== undefined && action == "stop") {
    /* clear ajax icon */
    jQuery("#ajaxIcon").remove();
  } else {
    /* display ajax icon */
    if (additionalMessage !== undefined) {
      message =
        additionalMessage + "<br>Please wait while system loads data ...";
    } else {
      message = "Please wait while system loads data ...";
    }
    var icon =
      '<div id="ajaxIcon"><i class="fal fa-spinner fa-pulse fa-fw"></i><span class="message">' +
      message +
      "</span></div>";
    jQuery("body").append(icon);
  }
}

function hhrUpdateFilterCounter(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var totalEstates = jQuery(".hhrEstateIntro").length;
  var displayedEstates = jQuery(".hhrEstateIntro.fresh").length;
  var title = "VyÄŤistit filtr";

  if (window.hhrFilterSortKeysArray === undefined) {
    window.hhrFilterSortKeysArray = [];
    window.hhrFilterSortValuesArray = [];
    window.hhrFilterSortKeysArray[0] = "sortDateDesc";
    window.hhrFilterSortValuesArray[0] = "NejnovÄ›jĹˇĂ­";
    window.hhrFilterSortKeysArray[1] = "sortCenaAsc";
    window.hhrFilterSortValuesArray[1] = "NejlevnÄ›jĹˇĂ­";
    window.hhrFilterSortKeysArray[2] = "sortCenaDesc";
    window.hhrFilterSortValuesArray[2] = "NejdraĹľĹˇĂ­";
    window.hhrFilterSortActualKey = 0;
  }

  if (totalEstates === undefined || totalEstates === 0) {
    var counterHtml =
      '<span class="hhrCounterContent">0 nabĂ­dek k zobrazenĂ­</span><span class="hhrFilterReset" onclick="hhrResetFilter(this)"><i class="fal fa-undo" aria-hidden="true"></i><span class="hhrResetValue">' +
      title +
      "</span></span>" +
      '<span class="hhrFilterSerchById"><input type="text" name="id" class="hhr-input" placeholder="ID nabĂ­dky" /><i class="fa fa-search" aria-hidden="true"></i></span>';
  } else {
    var filterButton =
      '<span class="hhrFilterSwitch" onclick="hhrSwitchFilter(this)"><span class="hhr-showfilter"><i class="fal fa-filter"></i>Zobrazit filtr</span><span class="hhr-hidefilter"><i class="fal fa-filter"></i>SkrĂ˝t filtr</span></span><span class="hhrFilterReset" onclick="hhrResetFilter(this)"><i class="fal fa-undo" aria-hidden="true"></i><span class="hhrResetValue">' +
      title +
      "</span></span>" +
      '<span class="hhrFilterSerchById"><input type="text" name="id" class="hhr-input hhr-input-enter" placeholder="Dle ID nabĂ­dky" onkeydown="hhrSearchByIdEnter(this, event)"/><i class="fa fa-search" aria-hidden="true" onclick="hhrSearchById(this)"></i></span>';
    var sorter =
      '<span class="hhrSorter" onclick="hhrSortEstates(this)"><i class="fal fa-sort-amount-down-alt" aria-hidden="true"></i><span class="hhrSorterValue">' +
      window.hhrFilterSortValuesArray[window.hhrFilterSortActualKey] +
      "</span></span>";
    var counterHtml =
      filterButton +
      '<span class="hhrCounterContent">Zobrazeno ' +
      displayedEstates +
      " z " +
      totalEstates +
      " nabĂ­dek</span>" +
      sorter;
  }
  jQuery(".hhrFilterCounter").html(counterHtml);
  return true;
}

function hhrUpdateFilterCounterEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var totalEstates = jQuery(".hhrEstateIntro").length;
  var displayedEstates = jQuery(".hhrEstateIntro.fresh").length;
  var title = "Clean filter";

  if (window.hhrFilterSortKeysArray === undefined) {
    window.hhrFilterSortKeysArray = [];
    window.hhrFilterSortValuesArray = [];
    window.hhrFilterSortKeysArray[0] = "sortDateDesc";
    window.hhrFilterSortValuesArray[0] = "Newest";
    window.hhrFilterSortKeysArray[1] = "sortCenaAsc";
    window.hhrFilterSortValuesArray[1] = "Cheapest";
    window.hhrFilterSortKeysArray[2] = "sortCenaDesc";
    window.hhrFilterSortValuesArray[2] = "Luxury";
    window.hhrFilterSortActualKey = 0;
  }

  if (totalEstates === undefined || totalEstates === 0) {
    var counterHtml =
      '<span class="hhrCounterContent">0 estates to show</span><span class="hhrFilterReset" onclick="hhrResetFilterEn(this)"><i class="fal fa-undo" aria-hidden="true"></i><span class="hhrResetValue">' +
      title +
      "</span></span>" +
      '<span class="hhrFilterSerchById"><input type="text" name="id" class="hhr-input" placeholder="ID nabĂ­dky" /><i class="fa fa-search" aria-hidden="true"></i></span>';
  } else {
    var filterButton =
      '<span class="hhrFilterSwitch" onclick="hhrSwitchFilterEn(this)"><span class="hhr-showfilter"><i class="fal fa-filter"></i>Show filter</span><span class="hhr-hidefilter"><i class="fal fa-filter"></i>Hide filter</span></span><span class="hhrFilterReset" onclick="hhrResetFilterEn(this)"><i class="fal fa-undo" aria-hidden="true"></i><span class="hhrResetValue">' +
      title +
      "</span></span>" +
      '<span class="hhrFilterSerchById"><input type="text" name="id" class="hhr-input hhr-input-enter" placeholder="By Estate ID" onkeydown="hhrSearchByIdEnter(this, event)"/><i class="fa fa-search" aria-hidden="true" onclick="hhrSearchByIdEn(this)"></i></span>';
    var sorter =
      '<span class="hhrSorter" onclick="hhrSortEstatesEn(this)"><i class="fal fa-sort-amount-down-alt" aria-hidden="true"></i><span class="hhrSorterValue">' +
      window.hhrFilterSortValuesArray[window.hhrFilterSortActualKey] +
      "</span></span>";
    var counterHtml =
      filterButton +
      '<span class="hhrCounterContent">Shown ' +
      displayedEstates +
      " from " +
      totalEstates +
      " estates</span>" +
      sorter;
  }
  jQuery(".hhrFilterCounter").html(counterHtml);
  return true;
}

function hhrSortEstates(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var actualSortValue = parseInt(
    window.hhrFilterSortActualKey === undefined
      ? 0
      : window.hhrFilterSortActualKey
  );
  var totalValues = window.hhrFilterSortKeysArray.length;
  var newSortValue =
    actualSortValue === totalValues - 1 ? 0 : actualSortValue + 1;
  window.hhrFilterSortActualKey = newSortValue;
  jQuery(".hhrSorterValue").text(
    window.hhrFilterSortValuesArray[window.hhrFilterSortActualKey]
  );

  var gaCategory = 'Filter action';
  var gaAction = 'Button click';
  var gaLabel = 'Sort Estates';
  var gaValue = window.hhrFilterSortActualKey;
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': gaValue
});
  // ga('send', 'event', gaCategory, gaAction, gaLabel, gaValue);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel, gaValue);

  hhrPostponedRefresh(el, 1000);
  return true;
}

function hhrSortEstatesEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var actualSortValue = parseInt(
    window.hhrFilterSortActualKey === undefined
      ? 0
      : window.hhrFilterSortActualKey
  );
  var totalValues = window.hhrFilterSortKeysArray.length;
  var newSortValue =
    actualSortValue === totalValues - 1 ? 0 : actualSortValue + 1;
  window.hhrFilterSortActualKey = newSortValue;
  jQuery(".hhrSorterValue").text(
    window.hhrFilterSortValuesArray[window.hhrFilterSortActualKey]
  );

  var gaCategory = 'Filter action';
  var gaAction = 'Button click';
  var gaLabel = 'Sort Estates';
  var gaValue = window.hhrFilterSortActualKey;
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': gaValue
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel, gaValue);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel, gaValue);

  hhrPostponedRefreshEn(el, 1000);
  return true;
}

function hhrPostponedRefresh(el, timeout) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  window.hhrRefreshElement = el;
  window.hhrRefreshTimeout = timeout || 1000;
  if (
    window.hhrRefreshQueued !== undefined &&
    window.hhrRefreshQueued !== false
  ) {
    clearTimeout(window.hhrRefreshQueued);
  }
  window.hhrRefreshQueued = setTimeout(function () {
    hhrCollectFilter(window.hhrRefreshElement);
  }, window.hhrRefreshTimeout);
}

function hhrPostponedRefreshEn(el, timeout) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  window.hhrRefreshElement = el;
  window.hhrRefreshTimeout = timeout || 1000;
  if (
    window.hhrRefreshQueued !== undefined &&
    window.hhrRefreshQueued !== false
  ) {
    clearTimeout(window.hhrRefreshQueued);
  }
  window.hhrRefreshQueued = setTimeout(function () {
    hhrCollectFilterEn(window.hhrRefreshElement);
  }, window.hhrRefreshTimeout);
}

function hhrFilterType(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var filterType = jQuery(el).attr("data-filter-type");
  if (window.hhrFilter === undefined) {
    window.hhrFilter = {};
  }
  window.hhrFilter.filterType = filterType;

  var gaCategory = 'Filter action';
  var gaAction = 'Button click';
  var gaLabel = 'Filter type';
  var gaValue = window.hhrFilter.filterType;
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': gaValue
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel, gaValue);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel, gaValue);

  hhrRefreshFilter(el);
}

function hhrResetFilter(el) {
  jQuery(el)
    .closest(".hhrPage.hhrPageWithFilter")
    .removeClass("hhrFilterActive");
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  window.hhrFilter.filterSelected = [];
  window.hhrFilter.filterActive = [];

  var gaCategory = 'Filter action';
  var gaAction = 'Button click';
  var gaLabel = 'Filter reset';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  hhrRefreshFilter(el);
}

function hhrResetFilterEn(el) {
  jQuery(el)
    .closest(".hhrPage.hhrPageWithFilter")
    .removeClass("hhrFilterActive");
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  window.hhrFilter.filterSelected = [];
  window.hhrFilter.filterActive = [];

  var gaCategory = 'Filter action';
  var gaAction = 'Button click';
  var gaLabel = 'Filter reset';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  hhrRefreshFilterEn(el);
}

function hhrEmptyResultAutoRefresh(time) {
  window.hhrRefreshFilterCountDown = time ?? 10;
  window.hhrRefreshFilterCountDownInterval = setInterval(function () {
    --window.hhrRefreshFilterCountDown;
    if (window.hhrRefreshFilterCountDown > 0) {
      jQuery(".hhrCountDownValue").text(window.hhrRefreshFilterCountDown);
    } else {
      hhrResetFilter(jQuery(".hhrFilterReset"));
      clearInterval(window.hhrRefreshFilterCountDownInterval);
    }
  }, 1000);
}

function hhrEmptyResultAutoRefreshEn(time) {
  window.hhrRefreshFilterCountDown = time ?? 10;
  window.hhrRefreshFilterCountDownInterval = setInterval(function () {
    --window.hhrRefreshFilterCountDown;
    if (window.hhrRefreshFilterCountDown > 0) {
      jQuery(".hhrCountDownValue").text(window.hhrRefreshFilterCountDown);
    } else {
      hhrResetFilterEn(jQuery(".hhrFilterReset"));
      clearInterval(window.hhrRefreshFilterCountDownInterval);
    }
  }, 1000);
}

function hhrRefreshFilter(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var timeStart = Date.now();
  var formData = new FormData();
  formData.append("action", "refreshFilter");
  formData.append("filterType", window.hhrFilter.filterType);
  formData.append(
    "filterSelected",
    JSON.stringify(window.hhrFilter.filterSelected)
  );
  formData.append(
    "filterActive",
    JSON.stringify(window.hhrFilter.filterActive)
  );
  formData.append(
    "sortKey",
    window.hhrFilterSortKeysArray[window.hhrFilterSortActualKey]
  );
  formData.append("refreshContent", 1);
  formData.append("pageSize", 10);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrRefreshFilter: SUCCESS");
        if (data.hasOwnProperty("filter")) {
          jQuery(".hhrFilter").html(data.filter);
          hhrInitSliders(jQuery(".hhrFilter"));
        }
        if (data.hasOwnProperty("estatelist")) {
          jQuery(".hhrContent").html(data.estatelist);
        }
        if (data.hasOwnProperty("estatehtml")) {
          for (var id of Object.keys(data.estatehtml)) {
            jQuery("#hhrIntro" + id).replaceWith(data.estatehtml[id]);
          }
        }
        if (data.hasOwnProperty("nextload")) {
          jQuery(".hhrEstateIntro.toLoad").first().before(data.nextload);
        }
        hhrUpdateFilterCounter(el);
      } else {
        window.TaskMonitorDebug && console.log("hhrRefreshFilter: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrRefreshFilter: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrRefreshFilterEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var timeStart = Date.now();
  var formData = new FormData();
  formData.append("action", "refreshFilterEn");
  formData.append("filterType", window.hhrFilter.filterType);
  formData.append(
    "filterSelected",
    JSON.stringify(window.hhrFilter.filterSelected)
  );
  formData.append(
    "filterActive",
    JSON.stringify(window.hhrFilter.filterActive)
  );
  formData.append(
    "sortKey",
    window.hhrFilterSortKeysArray[window.hhrFilterSortActualKey]
  );
  formData.append("refreshContent", 1);
  formData.append("pageSize", 10);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrRefreshFilter: SUCCESS");
        if (data.hasOwnProperty("filter")) {
          jQuery(".hhrFilter").html(data.filter);
          hhrInitSlidersEn(jQuery(".hhrFilter"));
        }
        if (data.hasOwnProperty("estatelist")) {
          jQuery(".hhrContent").html(data.estatelist);
        }
        if (data.hasOwnProperty("estatehtml")) {
          for (var id of Object.keys(data.estatehtml)) {
            jQuery("#hhrIntro" + id).replaceWith(data.estatehtml[id]);
          }
        }
        if (data.hasOwnProperty("nextload")) {
          jQuery(".hhrEstateIntro.toLoad").first().before(data.nextload);
        }
        hhrUpdateFilterCounter(el);
      } else {
        window.TaskMonitorDebug && console.log("hhrRefreshFilter: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrRefreshFilter: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrInitSliders(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el)
    .find(".hhrFilterParamRange")
    .each(function () {
      var minimum = parseFloat(jQuery(this).attr("data-min"));
      var maximum = parseFloat(jQuery(this).attr("data-max"));
      jQuery(this)
        .find(".hhrSlider")
        .slider({
          range: true,
          min: minimum,
          max: maximum,
          values: [minimum, maximum],
          slide: function (event, ui) {
            // console.log(ui);
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMin")
              .text(ui.values[0].toLocaleString("cs"));
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMax")
              .text(ui.values[1].toLocaleString("cs"));
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMin")
              .attr("data-value", ui.values[0]);
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMax")
              .attr("data-value", ui.values[1]);
            hhrPostponedRefresh(
              jQuery(ui.handle).closest(".hhrFilterParam"),
              2000
            );
          },
        });
      // jQuery(this).find('.ui-slider-handle').draggable();
    });
}

function hhrInitSlidersEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el)
    .find(".hhrFilterParamRange")
    .each(function () {
      var minimum = parseFloat(jQuery(this).attr("data-min"));
      var maximum = parseFloat(jQuery(this).attr("data-max"));
      jQuery(this)
        .find(".hhrSlider")
        .slider({
          range: true,
          min: minimum,
          max: maximum,
          values: [minimum, maximum],
          slide: function (event, ui) {
            // console.log(ui);
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMin")
              .text(ui.values[0].toLocaleString("cs"));
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMax")
              .text(ui.values[1].toLocaleString("cs"));
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMin")
              .attr("data-value", ui.values[0]);
            jQuery(ui.handle)
              .closest(".hhrSliderBox")
              .find(".sliderMax")
              .attr("data-value", ui.values[1]);
            hhrPostponedRefreshEn(
              jQuery(ui.handle).closest(".hhrFilterParam"),
              2000
            );
          },
        });
      // jQuery(this).find('.ui-slider-handle').draggable();
    });
}

function hhrUpdateFilter(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);

  var gaCategory = 'Filter action';
  var gaAction = 'Filter click';
  var gaLabel = 'Filter update';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  var timeStart = Date.now();
  window.hhrRefreshQueued = false;
  var formData = new FormData();
  formData.append("action", "updateFilter");
  formData.append("filterType", window.hhrFilter.filterType);
  formData.append(
    "filterSelected",
    JSON.stringify(window.hhrFilter.filterSelected)
  );
  formData.append(
    "sortKey",
    window.hhrFilterSortKeysArray[window.hhrFilterSortActualKey]
  );
  formData.append("refreshContent", 1);
  formData.append("pageSize", 10);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrUpdateFilter: SUCCESS");
        if (data.hasOwnProperty("filtercounts")) {
          var categoryPosition = parseInt(
            jQuery(el).closest(".hhrFilterCategory").attr("data-position")
          );
          jQuery(".hhrFilter .hhrFilterCategory")
            .find(".hhrFilterParamCheck")
            .each(function () {
              if (
                parseInt(
                  jQuery(this)
                    .closest(".hhrFilterCategory")
                    .attr("data-position")
                ) >= categoryPosition
              ) {
                var category = jQuery(this).attr("data-category");
                var param = jQuery(this).attr("data-param");
                var value = jQuery(this).attr("data-value");
                var counter = data.filtercounts[category][param][value].pocet;
                var actualPocet = parseInt(
                  jQuery(this).find(".hhrPocet").text()
                );
                if (
                  parseInt(
                    jQuery(this)
                      .closest(".hhrFilterCategory")
                      .attr("data-position")
                  ) == categoryPosition &&
                  actualPocet < counter
                ) {
                  jQuery(this).find(".hhrPocet").text(counter);
                  if (jQuery(this).hasClass("empty")) {
                    jQuery(this).removeClass("empty");
                    jQuery(this)
                      .closest(".hhrFilterParam")
                      .removeClass("empty")
                      .show(1000);
                  }
                } else if (
                  parseInt(
                    jQuery(this)
                      .closest(".hhrFilterCategory")
                      .attr("data-position")
                  ) > categoryPosition
                ) {
                  jQuery(this).find(".hhrPocet").text(counter);
                  if (counter == 0) {
                    jQuery(this).addClass("empty");
                    jQuery(this)
                      .closest(".hhrFilterParam")
                      .addClass("empty")
                      .hide(1000);
                  } else if (jQuery(this).hasClass("empty")) {
                    jQuery(this).removeClass("empty");
                    jQuery(this)
                      .closest(".hhrFilterParam")
                      .removeClass("empty")
                      .show(1000);
                  }
                }
              }
            });
          jQuery(".hhrFilter .hhrFilterCategory")
            .find(".hhrFilterParamRange")
            .each(function () {
              if (
                parseInt(
                  jQuery(this)
                    .closest(".hhrFilterCategory")
                    .attr("data-position")
                ) > categoryPosition
              ) {
                var category = jQuery(this).attr("data-category");
                var param = jQuery(this).attr("data-param");
                var value = jQuery(this).attr("data-value");
                var counter = data.filtercounts[category][param][value].pocet;
                var newMin = parseInt(
                  data.filtercounts[category][param][value].value_min
                );
                var newMax = parseInt(
                  data.filtercounts[category][param][value].value_max
                );
                var oldMin = parseInt(jQuery(this).attr("data-min"));
                var oldMax = parseInt(jQuery(this).attr("data-max"));

                var minPct =
                  Math.round((newMin / oldMax) * 100).toString() + "%";
                var maxPct =
                  Math.round((newMax / oldMax) * 100).toString() + "%";

                jQuery(this)
                  .find(".ui-widget-content")
                  .css({
                    background:
                      "linear-gradient(to right, #acacac " +
                      minPct +
                      ", #ffffff " +
                      minPct +
                      ", #ffffff " +
                      maxPct +
                      ", #acacac " +
                      maxPct +
                      ",#acacac 100%)",
                  });
              }
            });
        }
        if (data.hasOwnProperty("estatelist")) {
          jQuery(".hhrContent").html(data.estatelist);
        }
        if (data.hasOwnProperty("estatehtml")) {
          for (var id of Object.keys(data.estatehtml)) {
            jQuery("#hhrIntro" + id).replaceWith(data.estatehtml[id]);
          }
        }
        if (data.hasOwnProperty("nextload")) {
          jQuery(".hhrEstateIntro.toLoad").first().before(data.nextload);
        }
        hhrUpdateFilterCounter(el);
      } else {
        window.TaskMonitorDebug && console.log("hhrUpdateFilter: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrUpdateFilter: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrUpdateFilterEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);

  var gaCategory = 'Filter action';
  var gaAction = 'Filter click';
  var gaLabel = 'Filter update';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  var timeStart = Date.now();
  window.hhrRefreshQueued = false;
  var formData = new FormData();
  formData.append("action", "updateFilterEn");
  formData.append("filterType", window.hhrFilter.filterType);
  formData.append(
    "filterSelected",
    JSON.stringify(window.hhrFilter.filterSelected)
  );
  formData.append(
    "sortKey",
    window.hhrFilterSortKeysArray[window.hhrFilterSortActualKey]
  );
  formData.append("refreshContent", 1);
  formData.append("pageSize", 10);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrUpdateFilter: SUCCESS");
        if (data.hasOwnProperty("filtercounts")) {
          var categoryPosition = parseInt(
            jQuery(el).closest(".hhrFilterCategory").attr("data-position")
          );
          jQuery(".hhrFilter .hhrFilterCategory")
            .find(".hhrFilterParamCheck")
            .each(function () {
              if (
                parseInt(
                  jQuery(this)
                    .closest(".hhrFilterCategory")
                    .attr("data-position")
                ) >= categoryPosition
              ) {
                var category = jQuery(this).attr("data-category");
                var param = jQuery(this).attr("data-param");
                var value = jQuery(this).attr("data-value");
                var counter = data.filtercounts[category][param][value].pocet;
                var actualPocet = parseInt(
                  jQuery(this).find(".hhrPocet").text()
                );
                if (
                  parseInt(
                    jQuery(this)
                      .closest(".hhrFilterCategory")
                      .attr("data-position")
                  ) == categoryPosition &&
                  actualPocet < counter
                ) {
                  jQuery(this).find(".hhrPocet").text(counter);
                  if (jQuery(this).hasClass("empty")) {
                    jQuery(this).removeClass("empty");
                    jQuery(this)
                      .closest(".hhrFilterParam")
                      .removeClass("empty")
                      .show(1000);
                  }
                } else if (
                  parseInt(
                    jQuery(this)
                      .closest(".hhrFilterCategory")
                      .attr("data-position")
                  ) > categoryPosition
                ) {
                  jQuery(this).find(".hhrPocet").text(counter);
                  if (counter == 0) {
                    jQuery(this).addClass("empty");
                    jQuery(this)
                      .closest(".hhrFilterParam")
                      .addClass("empty")
                      .hide(1000);
                  } else if (jQuery(this).hasClass("empty")) {
                    jQuery(this).removeClass("empty");
                    jQuery(this)
                      .closest(".hhrFilterParam")
                      .removeClass("empty")
                      .show(1000);
                  }
                }
              }
            });
          jQuery(".hhrFilter .hhrFilterCategory")
            .find(".hhrFilterParamRange")
            .each(function () {
              if (
                parseInt(
                  jQuery(this)
                    .closest(".hhrFilterCategory")
                    .attr("data-position")
                ) > categoryPosition
              ) {
                var category = jQuery(this).attr("data-category");
                var param = jQuery(this).attr("data-param");
                var value = jQuery(this).attr("data-value");
                var counter = data.filtercounts[category][param][value].pocet;
                var newMin = parseInt(
                  data.filtercounts[category][param][value].value_min
                );
                var newMax = parseInt(
                  data.filtercounts[category][param][value].value_max
                );
                var oldMin = parseInt(jQuery(this).attr("data-min"));
                var oldMax = parseInt(jQuery(this).attr("data-max"));

                var minPct =
                  Math.round((newMin / oldMax) * 100).toString() + "%";
                var maxPct =
                  Math.round((newMax / oldMax) * 100).toString() + "%";

                jQuery(this)
                  .find(".ui-widget-content")
                  .css({
                    background:
                      "linear-gradient(to right, #acacac " +
                      minPct +
                      ", #ffffff " +
                      minPct +
                      ", #ffffff " +
                      maxPct +
                      ", #acacac " +
                      maxPct +
                      ",#acacac 100%)",
                  });
              }
            });
        }
        if (data.hasOwnProperty("estatelist")) {
          jQuery(".hhrContent").html(data.estatelist);
        }
        if (data.hasOwnProperty("estatehtml")) {
          for (var id of Object.keys(data.estatehtml)) {
            jQuery("#hhrIntro" + id).replaceWith(data.estatehtml[id]);
          }
        }
        if (data.hasOwnProperty("nextload")) {
          jQuery(".hhrEstateIntro.toLoad").first().before(data.nextload);
        }
        hhrUpdateFilterCounterEn(el);
      } else {
        window.TaskMonitorDebug && console.log("hhrUpdateFilter: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrUpdateFilter: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrCategoryClick(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el).closest(".hhrFilterCategory").toggleClass("active");
  jQuery(el).siblings(".hhrFilterParams").toggleClass("hidden");
}

function hhrCategoryClickEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el).closest(".hhrFilterCategory").toggleClass("active");
  jQuery(el).siblings(".hhrFilterParams").toggleClass("hidden");
}

function hhrParamClick(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el).toggleClass("active");
  hhrPostponedRefresh(el, 0);
}

function hhrParamClickEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el).toggleClass("active");
  hhrPostponedRefreshEn(el, 0);
}

function hhrCollectFilter(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (window.hhrFilter === undefined) {
    window.hhrFilter = {};
  }
  window.hhrFilter.filterSelected = {};

  jQuery(".hhrFilterParamCheck.active").each(function () {
    var category = jQuery(this).attr("data-category");
    var param = jQuery(this).attr("data-param");
    var value = jQuery(this).attr("data-value");

    if (window.hhrFilter.filterSelected[category] === undefined) {
      window.hhrFilter.filterSelected[category] = {};
    }
    if (window.hhrFilter.filterSelected[category][param] === undefined) {
      window.hhrFilter.filterSelected[category][param] = [];
    }

    var newValue = {};
    newValue.value_text = value;
    window.hhrFilter.filterSelected[category][param].push(newValue);
  });
  window.TaskMonitorDebug && console.log(window.hhrFilter.filterSelected);

  jQuery(".hhrFilterParamRange").each(function () {
    var category = jQuery(this).attr("data-category");
    var param = jQuery(this).attr("data-param");
    var min = parseInt(jQuery(this).attr("data-min"));
    var max = parseInt(jQuery(this).attr("data-max"));
    var valueMin = parseInt(jQuery(this).find(".sliderMin").attr("data-value"));
    var valueMax = parseInt(jQuery(this).find(".sliderMax").attr("data-value"));

    if (min < valueMin || max > valueMax) {
      if (window.hhrFilter.filterSelected[category] === undefined) {
        window.hhrFilter.filterSelected[category] = {};
      }
      if (window.hhrFilter.filterSelected[category][param] === undefined) {
        window.hhrFilter.filterSelected[category][param] = [];
      }

      var newValue = {};
      newValue.value_min = valueMin;
      newValue.value_max = valueMax;
      newValue.value_text = "";
      window.hhrFilter.filterSelected[category][param].push(newValue);
    }
  });
  window.TaskMonitorDebug && console.log(window.hhrFilter.filterSelected);

  window.hhrFilter.filterActive = [];

  jQuery(".hhrFilterCategory.active").each(function () {
    var category = jQuery(this).attr("data-category");
    window.hhrFilter.filterActive.push(category);
  });
  window.TaskMonitorDebug && console.log(window.hhrFilter.filterActive);
  hhrUpdateFilter(el);
}

function hhrCollectFilterEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (window.hhrFilter === undefined) {
    window.hhrFilter = {};
  }
  window.hhrFilter.filterSelected = {};

  jQuery(".hhrFilterParamCheck.active").each(function () {
    var category = jQuery(this).attr("data-category");
    var param = jQuery(this).attr("data-param");
    var value = jQuery(this).attr("data-value");

    if (window.hhrFilter.filterSelected[category] === undefined) {
      window.hhrFilter.filterSelected[category] = {};
    }
    if (window.hhrFilter.filterSelected[category][param] === undefined) {
      window.hhrFilter.filterSelected[category][param] = [];
    }

    var newValue = {};
    newValue.value_text = value;
    window.hhrFilter.filterSelected[category][param].push(newValue);
  });
  window.TaskMonitorDebug && console.log(window.hhrFilter.filterSelected);

  jQuery(".hhrFilterParamRange").each(function () {
    var category = jQuery(this).attr("data-category");
    var param = jQuery(this).attr("data-param");
    var min = parseInt(jQuery(this).attr("data-min"));
    var max = parseInt(jQuery(this).attr("data-max"));
    var valueMin = parseInt(jQuery(this).find(".sliderMin").attr("data-value"));
    var valueMax = parseInt(jQuery(this).find(".sliderMax").attr("data-value"));

    if (min < valueMin || max > valueMax) {
      if (window.hhrFilter.filterSelected[category] === undefined) {
        window.hhrFilter.filterSelected[category] = {};
      }
      if (window.hhrFilter.filterSelected[category][param] === undefined) {
        window.hhrFilter.filterSelected[category][param] = [];
      }

      var newValue = {};
      newValue.value_min = valueMin;
      newValue.value_max = valueMax;
      newValue.value_text = "";
      window.hhrFilter.filterSelected[category][param].push(newValue);
    }
  });
  window.TaskMonitorDebug && console.log(window.hhrFilter.filterSelected);

  window.hhrFilter.filterActive = [];

  jQuery(".hhrFilterCategory.active").each(function () {
    var category = jQuery(this).attr("data-category");
    window.hhrFilter.filterActive.push(category);
  });
  window.TaskMonitorDebug && console.log(window.hhrFilter.filterActive);
  hhrUpdateFilterEn(el);
}

function hhrLoadNext(el, pageSize) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var timeStart = Date.now();
  var estatesToLoad = [];
  jQuery(".hhrEstateIntro.toLoad")
    .slice(0, pageSize)
    .each(function () {
      estatesToLoad.push(jQuery(this).attr("id").replace("hhrIntro", ""));
    });
  var formData = new FormData();
  formData.append("action", "loadNext");
  formData.append("estatesToLoad", JSON.stringify(estatesToLoad));
  formData.append("pageSize", pageSize);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrLoadNext: SUCCESS");
        if (data.hasOwnProperty("estatehtml")) {
          for (var id of Object.keys(data.estatehtml)) {
            jQuery("#hhrIntro" + id).replaceWith(data.estatehtml[id]);
          }
        }
        jQuery(el).closest(".hhrLoadNext").remove();
        if (data.hasOwnProperty("nextload")) {
          jQuery(".hhrEstateIntro.toLoad").first().before(data.nextload);
        }
        hhrUpdateFilterCounter(el);
      } else {
        window.TaskMonitorDebug && console.log("hhrLoadNext: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrLoadNext: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrLoadNextEn(el, pageSize) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var timeStart = Date.now();
  var estatesToLoad = [];
  jQuery(".hhrEstateIntro.toLoad")
    .slice(0, pageSize)
    .each(function () {
      estatesToLoad.push(jQuery(this).attr("id").replace("hhrIntro", ""));
    });
  var formData = new FormData();
  formData.append("action", "loadNextEn");
  formData.append("estatesToLoad", JSON.stringify(estatesToLoad));
  formData.append("pageSize", pageSize);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrLoadNextEn: SUCCESS");
        if (data.hasOwnProperty("estatehtml")) {
          for (var id of Object.keys(data.estatehtml)) {
            jQuery("#hhrIntro" + id).replaceWith(data.estatehtml[id]);
          }
        }
        jQuery(el).closest(".hhrLoadNext").remove();
        if (data.hasOwnProperty("nextload")) {
          jQuery(".hhrEstateIntro.toLoad").first().before(data.nextload);
        }
        hhrUpdateFilterCounterEn(el);
      } else {
        window.TaskMonitorDebug && console.log("hhrLoadNextEn: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrLoadNextEn: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrInitMap() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var zoom = parseInt(jQuery("#hhrSingleMap").attr("data-zoom"));
  var mapLat = parseFloat(jQuery("#hhrSingleMap").attr("data-lat"));
  var mapLng = parseFloat(jQuery("#hhrSingleMap").attr("data-lng"));
  var mapType = jQuery("#hhrSingleMap").attr("data-style");
  var mapBlind = jQuery("#hhrSingleMap").attr("data-blind") == 1 ? true : false;
  var title = mapBlind ? "" : jQuery("#hhrSingleMap").attr("data-marker");
  var options = {
    zoom: zoom,
    center: {
      lat: mapLat,
      lng: mapLng,
    },
    mapTypeId: mapType,
  };
  var map = new google.maps.Map(
    document.getElementById("hhrSingleMap"),
    options
  );

  function addMarker(prop) {
    window.TaskMonitorDebug && console.log(arguments.callee.name);
    var marker = new google.maps.Marker({
      position: prop.coordinates,
      map: map,
      draggarble: false,
    });
    if (prop.iconImage) {
      marker.setIcon(prop.iconImage);
    }
    if (prop.content) {
      var information = new google.maps.InfoWindow({
        content: prop.content,
      });
      marker.addListener("click", function () {
        information.open(map, marker);
      });
    }
  }
  if (mapBlind === false) {
    addMarker({
      coordinates: {
        lat: mapLat,
        lng: mapLng,
      },
      iconImage:
        "https://www.happyhouserentals.com/images/hhr-logo/HHR-map-marker-new.png",
      content: "<h4>" + title + "</h4>",
    });
  }
}

function phsw(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);

  var winHeight = window.innerHeight * 0.8;
  var winWidth = window.innerWidth * 0.8;
  var header = jQuery(".hhrArticle.hhrHeader h1").text();
  var items = [];
  jQuery(".hhrThumbs li").each(function () {
    var imgSrc = jQuery(this).attr("data-photo-url");
    var imgWidth = parseInt(jQuery(this).attr("data-photo-width"));
    var imgHeight = parseInt(jQuery(this).attr("data-photo-height"));

    var scale1 = winHeight / imgHeight;
    var scale2 = winWidth / imgWidth;

    if (scale1 < scale2 && scale1 > 1) {
      imgHeight = Math.round(imgHeight * scale1);
      imgWidth = Math.round(imgWidth * scale1);
    } else if (scale2 > 1) {
      imgHeight = Math.round(imgHeight * scale2);
      imgWidth = Math.round(imgWidth * scale2);
    }

    var item = {
      src: imgSrc,
      w: imgWidth,
      h: imgHeight,
      title: header,
    };
    items.push(item);
  });

  var pswpElementSource =
    '\
    <div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">\
        <div class="pswp__bg"></div>\
        <div class="pswp__scroll-wrap">\
            <div class="pswp__container">\
                <div class="pswp__item"></div>\
                <div class="pswp__item"></div>\
                <div class="pswp__item"></div>\
            </div>\
            <div class="pswp__ui pswp__ui--hidden">\
                <div class="pswp__top-bar">\
                    <div class="pswp__counter"></div>\
                    <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>\
                    <button class="pswp__button pswp__button--share" title="Share"></button>\
                    <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>\
                    <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>\
                    <div class="pswp__preloader">\
                        <div class="pswp__preloader__icn">\
                            <div class="pswp__preloader__cut">\
                                <div class="pswp__preloader__donut"></div>\
                            </div>\
                        </div>\
                    </div>\
                </div>\
                <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">\
                    <div class="pswp__share-tooltip"></div>\
                </div>\
                <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"></button>\
                <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"></button>\
                <div class="pswp__caption">\
                    <div class="pswp__caption__center"></div>\
                </div>\
            </div>\
        </div>\
    </div>';

  if (jQuery(".pswp").length === 0) {
    jQuery("body").append(pswpElementSource);
  }
  var pswpElement = jQuery(".pswp")[0];

  var index = jQuery(el).index();
  var options = {
    index: index,
    bgOpacity: 0.9,
    showHideOpacity: true,
    closeEl: true,
    captionEl: true,
    fullscreenEl: true,
    zoomEl: true,
    shareEl: false,
    counterEl: true,
    arrowEl: true,
    preloaderEl: false,
  };

  var lightBox = new PhotoSwipe(
    pswpElement,
    PhotoSwipeUI_Default,
    items,
    options
  );
  lightBox.init();

  lightBox.listen("destroy", function () {
    jQuery(".pswp").remove();
    jQuery(".pswp__preloader").remove();
    jQuery(".pswp__share-modal").remove();
    jQuery(".pswp__button").remove();
    jQuery(".pswp__button").remove();
    jQuery(".pswp__caption").remove();
  });
}

function pswpi(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);

  var sizeNormalizer =
    window.innerHeight < 820 || window.innerWidth < 1024 ? 1 : 0.8;

  var winHeight = window.innerHeight * sizeNormalizer;
  var winWidth = window.innerWidth * sizeNormalizer;
  var header = jQuery(el)
    .closest(".hhrEstateIntro")
    .find(".hhrIntroHeader h4")
    .text();
  var link =
    jQuery(el)
      .closest(".hhrEstateIntro")
      .find(".hhrIntroHeader a")
      .attr("href") === undefined
      ? ""
      : jQuery(el)
        .closest(".hhrEstateIntro")
        .find(".hhrIntroHeader a")
        .attr("href");
  var itemsArray =
    jQuery(el).attr("data-photo-array") !== undefined &&
      jQuery(el).attr("data-photo-array").length > 0
      ? JSON.parse(jQuery(el).attr("data-photo-array"))
      : [];
  var items = [];

  for (var i = 0; i < itemsArray.length; i++) {
    var imgSrc = itemsArray[i].src;
    var imgWidth = itemsArray[i].w;
    var imgHeight = itemsArray[i].h;

    var scale1 = winHeight / imgHeight;
    var scale2 = winWidth / imgWidth;

    if (scale1 < scale2 && scale1 > 1) {
      imgHeight = Math.round(imgHeight * scale1);
      imgWidth = Math.round(imgWidth * scale1);
    } else if (scale2 > 1) {
      imgHeight = Math.round(imgHeight * scale2);
      imgWidth = Math.round(imgWidth * scale2);
    }

    var item = {
      src: imgSrc,
      w: imgWidth,
      h: imgHeight,
      title: header,
    };
    items.push(item);
  }

  var estateId = jQuery(el).closest(".hhrEstateIntro").attr("id");

  if (jQuery("body").hasClass("en-GB")) {
    var htmlSlide = '<div class="pswp_hhr_slide">';
    htmlSlide += "<h2>" + header + "</h2>";
    htmlSlide +=
      '<div class="pswp_hhr_slide_intro">' +
      jQuery(el).closest(".hhrEstateIntro").find(".hhrIntro").html() +
      "</div>";
    htmlSlide += '<div class="pswp_hhr_slide_controls">';
    htmlSlide +=
      '<div class="pswp_hhr_iconbutton" onclick="hhrAddFavoritePass(this, \'' +
      estateId +
      '\')"><i class="fal fa-heart" aria-hidden="true"></i><div class="pswp_hhr_iconlabel">Add to Favorites</div></div>';
    htmlSlide +=
      '<div class="pswp_hhr_iconbutton"  onclick="hhrAddPlanPass(this, \'' +
      estateId +
      '\')"><i class="fal fa-calendar-check" aria-hidden="true"></i><div class="pswp_hhr_iconlabel">Add to list of Viewings</div></div>';
    htmlSlide +=
      '<a href="' +
      link +
      '" target="_blank" rel="noopener noreferrer"  class="pswp_hhr_iconbutton"><div><i class="fal fa-external-link" aria-hidden="true"></i><div class="pswp_hhr_iconlabel">Open in a separate window</div></div></a>';
    htmlSlide += "</div >";
    htmlSlide += "</div >";
  } else {
    var htmlSlide = '<div class="pswp_hhr_slide">';
    htmlSlide += "<h2>" + header + "</h2>";
    htmlSlide +=
      '<div class="pswp_hhr_slide_intro">' +
      jQuery(el).closest(".hhrEstateIntro").find(".hhrIntro").html() +
      "</div>";
    htmlSlide += '<div class="pswp_hhr_slide_controls">';
    htmlSlide +=
      '<div class="pswp_hhr_iconbutton" onclick="hhrAddFavoritePass(this, \'' +
      estateId +
      '\')"><i class="fal fa-heart" aria-hidden="true"></i><div class="pswp_hhr_iconlabel">PĹ™idat k oblĂ­benĂ˝m nabĂ­dkĂˇm</div></div>';
    htmlSlide +=
      '<div class="pswp_hhr_iconbutton"  onclick="hhrAddPlanPass(this, \'' +
      estateId +
      '\')"><i class="fal fa-calendar-check" aria-hidden="true"></i><div class="pswp_hhr_iconlabel">PĹ™idat do seznamu prohlĂ­dek</div></div>';
    htmlSlide +=
      '<a href="' +
      link +
      '" target="_blank" rel="noopener noreferrer"  class="pswp_hhr_iconbutton"><div><i class="fal fa-external-link" aria-hidden="true"></i><div class="pswp_hhr_iconlabel">OtevĹ™Ă­t v samostatnĂ©m oknÄ›</div></div></a>';
    htmlSlide += "</div >";
    htmlSlide += "</div >";
  }

  var item = {
    html: htmlSlide,
    isClickableElement: function (element) {
      return element;
    },
  };

  items.push(item);

  var pswpElementSource =
    '\
    <div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">\
        <div class="pswp__bg"></div>\
        <div class="pswp__scroll-wrap">\
            <div class="pswp__container">\
                <div class="pswp__item"></div>\
                <div class="pswp__item"></div>\
                <div class="pswp__item"></div>\
            </div>\
            <div class="pswp__ui pswp__ui--hidden">\
                <div class="pswp__top-bar">\
                    <div class="pswp__counter"></div>\
                    <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>\
                    <button class="pswp__button pswp__button--share" title="Share"></button>\
                    <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>\
                    <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>\
                    <div class="pswp__preloader">\
                        <div class="pswp__preloader__icn">\
                            <div class="pswp__preloader__cut">\
                                <div class="pswp__preloader__donut"></div>\
                            </div>\
                        </div>\
                    </div>\
                </div>\
                <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">\
                    <div class="pswp__share-tooltip"></div>\
                </div>\
                <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"></button>\
                <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"></button>\
                <div class="pswp__caption">\
                    <div class="pswp__caption__center"></div>\
                </div>\
            </div>\
        </div>\
    </div>';

  if (jQuery(".pswp").length === 0) {
    jQuery("body").append(pswpElementSource);
  }
  var pswpElement = jQuery(".pswp")[0];

  var index = jQuery(el).index();
  var options = {
    index: index,
    bgOpacity: 0.9,
    showHideOpacity: true,
    closeEl: true,
    captionEl: (sizeNormalizer =
      window.innerHeight < 820 || window.innerWidth < 1024 ? false : true),
    fullscreenEl: true,
    zoomEl: true,
    shareEl: false,
    counterEl: true,
    arrowEl: true,
    preloaderEl: false,
    barsSize: {
      top: (sizeNormalizer =
        window.innerHeight < 820 || window.innerWidth < 1024 ? 0 : 40),
      bottom: (sizeNormalizer =
        window.innerHeight < 820 || window.innerWidth < 1024 ? 0 : 40),
    },
  };

  var lightBox = new PhotoSwipe(
    pswpElement,
    PhotoSwipeUI_Default,
    items,
    options
  );
  lightBox.init();

  lightBox.listen("destroy", function () {
    jQuery(".pswp").remove();
    jQuery(".pswp__preloader").remove();
    jQuery(".pswp__share-modal").remove();
    jQuery(".pswp__button").remove();
    jQuery(".pswp__button").remove();
    jQuery(".pswp__caption").remove();
  });
}

function hhrAddPlan(el, estateId, externalId, remove) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  remove = remove !== undefined && remove === 1 ? "remove" : "add";
  
  var gaCategory = 'Form action';
  var gaAction = 'Property list click';
  var gaLabel = 'Plan';
  var gaValue = remove;
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': gaValue
  });
  
  alert( window.TaskMonitorBaseDir + "ajaxRko.php");

  // ga('send', 'event', gaCategory, gaAction, gaLabel, gaValue);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel, gaValue);

  var timeStart = Date.now();
  var title = jQuery(el)
    .closest(".hhrEstateIntro")
    .find(".hhrIntroHeader h4")
    .text();
  var link = jQuery(el)
    .closest(".hhrEstateIntro")
    .find(".hhrIntroHeader a")
    .attr("href");
  var formData = new FormData();
  formData.append("action", "addPlan");
  formData.append("estateId", estateId);
  formData.append("externalId", externalId);
  formData.append("title", title);
  formData.append("link", link);
  formData.append("remove", remove);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrAddPlan: SUCCESS");
        window.TaskMonitorDebug && console.log(data.planList);
        if (data.hasOwnProperty("planList")) {
          hhrUpdatePlanList(data.planList);
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrAddPlan: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrAddPlan: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrAddFavorite(el, estateId, externalId, remove) {
	
	alert(estateId);
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  remove = remove !== undefined && remove === 1 ? "remove" : "add";

  var gaCategory = 'Form action';
  var gaAction = 'Property list click';
  var gaLabel = 'Favourite';
  var gaValue = remove;
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': gaValue
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel, gaValue);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel, gaValue);

  var timeStart = Date.now();
  var title = jQuery(el)
    .closest(".hhrEstateIntro")
    .find(".hhrIntroHeader h4")
    .text();
  var link = jQuery(el)
    .closest(".hhrEstateIntro")
    .find(".hhrIntroHeader a")
    .attr("href");
  var formData = new FormData();
  formData.append("action", "addFavorite");
  formData.append("estateId", estateId);
  formData.append("externalId", externalId);
  formData.append("title", title);
  formData.append("link", link);
  formData.append("remove", remove);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrAddFavorite: SUCCESS");
        window.TaskMonitorDebug && console.log(data.favoriteList);
        if (data.hasOwnProperty("favoriteList")) {
          hhrUpdateFavoriteList(data.favoriteList);
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrAddFavorite: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrAddFavorite: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrInitLists() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var url = new URL(window.location.href);
  var hhrFilterLocality = url.searchParams.get("hhrfilterlocality");
  var hhrFilterPrice = url.searchParams.get("hhrfilterprice");
  var timeStart = Date.now();
  var formData = new FormData();
  formData.append("action", "getLists");
  formData.append("hhrFilterLocality", hhrFilterLocality);
  formData.append("hhrFilterPrice", hhrFilterPrice);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrInitLists: SUCCESS");
        window.TaskMonitorDebug && console.log(data.favoriteList);
        if (data.hasOwnProperty("favoriteList")) {
          hhrUpdateFavoriteList(data.favoriteList);
        }
        if (data.hasOwnProperty("planList")) {
          hhrUpdatePlanList(data.planList);
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrInitLists: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrInitLists: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrUpdateFavoriteList(favoriteList) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (jQuery(".hhrFavoriteList").length === 0) {
    var listHtml = '<div class="hhrFavoriteList">';
    listHtml +=
      '<div class="hhrFavoriteListIcon" onclick="hhrFavoriteListShow(this)"><i class="fal fa-heart" aria-hidden="true"></i><div class="hhrFavoriteCounter">0</div></div>';
    listHtml +=
      '<div class="hhrFavoriteListIconBack" onclick="hhrFavoriteListShow(this)"><i class="fal fa-chevron-right" aria-hidden="true"></i></div>';

    if (jQuery("body").hasClass("en-GB")) {
      listHtml += '<div class="hhrFavoriteListLabel">List of Favorites</div>';
    } else {
      listHtml +=
        '<div class="hhrFavoriteListLabel">Seznam oblĂ­benĂ˝ch nabĂ­dek</div>';
    }

    listHtml += '<div class="hhrFavoriteListList"></div>';
    listHtml += "</div>";
    jQuery("body").append(listHtml);
  }

  var counter = 0;
  var favoritiesContent = "";
  for (var key of Object.keys(favoriteList)) {
    var link =
      favoriteList[key].link !== undefined ? favoriteList[key].link : "";
    var title =
      favoriteList[key].title !== undefined
        ? favoriteList[key].title
        : "NabĂ­dka ÄŤĂ­slo " + key;
    var externalId =
      favoriteList[key].externalId !== undefined
        ? favoriteList[key].externalId
        : "";

    favoritiesContent += '<li class="hhrFavoriteItem">';
    favoritiesContent +=
      '<div class="hhrFavoriteRemove" onclick="hhrAddFavorite(this,' +
      key +
      ', null, 1)" data-estate-id="' +
      key +
      '" data-estate-external-id="' +
      externalId +
      '"><i class="fal fa-ban" aria-hidden="true"></i></div>';
    favoritiesContent +=
      '<a href="' +
      link +
      '" class="hhrFavoriteTitle"><div>' +
      title +
      "</div></a>";
    favoritiesContent += "</li>";
    counter++;
  }
  if (counter === 0) {
    if (jQuery("body").hasClass("en-GB")) {
      var favoritiesContent =
        '<ul class="hhrListUl">Your favorites list is currently empty</ul>';
    } else {
      var favoritiesContent =
        '<ul class="hhrListUl">VĂˇĹˇ seznam oblĂ­benĂ˝ch nabĂ­dek je prozatĂ­m prĂˇzdnĂ˝</ul>';
    }
  } else {
    favoritiesContent = '<ul class="hhrListUl">' + favoritiesContent + "</ul>";
  }
  jQuery(".hhrFavoriteList .hhrFavoriteListList").html(favoritiesContent);
  jQuery(".hhrFavoriteList .hhrFavoriteCounter").text(counter);
  jQuery(".hhrFavoriteList .hhrFavoriteListIcon")
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    )
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    );
  return true;
}

function hhrUpdatePlanList(planList) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (jQuery(".hhrPlanList").length === 0) {
    var listHtml = '<div class="hhrPlanList">';
    listHtml +=
      '<div class="hhrPlanListIcon" onclick="hhrPlanListShow(this)"><i class="fal fa-calendar" aria-hidden="true"></i><div class="hhrPlanCounter">0</div></div>';
    listHtml +=
      '<div class="hhrPlanListIconBack" onclick="hhrPlanListShow(this)"><i class="fal fa-chevron-right" aria-hidden="true"></i></div>';

    if (jQuery("body").hasClass("en-GB")) {
      listHtml += '<div class="hhrPlanListLabel">List of Viewings</div>';
    } else {
      listHtml +=
        '<div class="hhrPlanListLabel">Seznam nabĂ­dek k prohlĂ­dce</div>';
    }
    listHtml += '<div class="hhrPlanListList"></div>';
    listHtml += "</div>";
    jQuery("body").append(listHtml);
  }

  var counter = 0;
  var favoritiesContent = "";
  for (var key of Object.keys(planList)) {
    var link = planList[key].link !== undefined ? planList[key].link : "";
    var title =
      planList[key].title !== undefined
        ? planList[key].title
        : "NabĂ­dka ÄŤĂ­slo " + key;
    var externalId =
      planList[key].externalId !== undefined ? planList[key].externalId : "";

    favoritiesContent += '<li class="hhrPlanItem">';
    favoritiesContent +=
      '<div class="hhrPlanRemove" onclick="hhrAddPlan(this,' +
      key +
      ', null, 1)" data-estate-id="' +
      key +
      '" data-estate-external-id="' +
      externalId +
      '"><i class="fal fa-ban" aria-hidden="true"></i></div>';
    favoritiesContent +=
      '<a href="' +
      link +
      '" class="hhrPlanTitle"><div>' +
      title +
      "</div></a>";
    favoritiesContent += "</li>";
    counter++;
  }
  if (counter === 0) {
    if (jQuery("body").hasClass("en-GB")) {
      var favoritiesContent =
        '<ul class="hhrListUl">Your viewings list is currently empty</ul>';
    } else {
      var favoritiesContent =
        '<ul class="hhrListUl">VĂˇĹˇ seznam nabĂ­dek k prohlĂ­dce je prozatĂ­m prĂˇzdnĂ˝</ul>';
    }
  } else {
    favoritiesContent = '<ul class="hhrListUl">' + favoritiesContent + "</ul>";
    if (jQuery("body").hasClass("en-GB")) {
      favoritiesContent +=
        '<div class="hhrListButtons"><button class="list-btn btn-success" onclick="hhrPlanListSendForm(this)">Arrange Viewings</button></div>';
    } else {
      favoritiesContent +=
        '<div class="hhrListButtons"><button class="list-btn btn-success" onclick="hhrPlanListSendForm(this)">NaplĂˇnovat prohlĂ­dku</button></div>';
    }
  }
  jQuery(".hhrPlanList .hhrPlanListList").html(favoritiesContent);
  jQuery(".hhrPlanList .hhrPlanCounter").text(counter);
  jQuery(".hhrPlanList .hhrPlanListIcon")
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    )
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    );
  return true;
}

function hhrFavoriteListShow(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);

  var gaCategory = 'Favourities action';
  var gaAction = 'Button click';
  var gaLabel = 'Show form';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  jQuery(el).closest(".hhrFavoriteList").toggleClass("active");
}

function hhrPlanListShow(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);

  var gaCategory = 'Plan action';
  var gaAction = 'Button click';
  var gaLabel = 'Show form';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  jQuery(el).closest(".hhrPlanList").toggleClass("active");
}

function hhrAddFavoritePass(el, passId) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery("#" + passId)
    .find(".hhrIconbutton.addFavorite")
    .click();
  jQuery(el)
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    )
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    );
  return true;
}

function hhrAddPlanPass(el, passId) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery("#" + passId)
    .find(".hhrIconbutton.addPlan")
    .click();
  jQuery(el)
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    )
    .animate(
      {
        opacity: 0,
      },
      250
    )
    .animate(
      {
        opacity: 1,
      },
      250
    );
  return true;
}

function hhrSwitchFilter(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var bottom = jQuery(el).closest(".hhrFilterCounter").hasClass("bottom");
  var filterSwitch = jQuery(el)
    .closest(".hhrPageWithFilter")
    .find(".hhrFilter")
    .find(".hhrFilterControls")
    .hasClass("height-auto");
  if (filterSwitch) {
    jQuery(el)
      .closest(".hhrPageWithFilter")
      .find(".hhrFilter")
      .find(".hhrFilterControlsContainer")
      .slideUp("fast", function () {
        jQuery(el)
          .closest(".hhrPageWithFilter")
          .find(".hhrFilter")
          .find(".hhrFilterControls")
          .removeClass("height-auto");
        jQuery(el)
          .closest(".hhrPage.hhrPageWithFilter")
          .removeClass("hhrFilterActive");
      });
  } else {
    jQuery(el)
      .closest(".hhrPageWithFilter")
      .find(".hhrFilter")
      .find(".hhrFilterControlsContainer")
      .slideDown();
    jQuery(el)
      .closest(".hhrPageWithFilter")
      .find(".hhrFilter")
      .find(".hhrFilterControls")
      .addClass("height-auto");
    jQuery(el)
      .closest(".hhrPage.hhrPageWithFilter")
      .addClass("hhrFilterActive");
    if (bottom) {
      jQuery("html, body").animate(
        {
          scrollTop: jQuery(".hhrPageWithFilter").offset().top - 80,
        },
        1000
      );
    }
    jQuery(".hhrFilterActive").click(function (event) {
      if (
        jQuery(event.target).closest(".hhrFilterControls").length === 0 &&
        jQuery(event.target).closest(".hhrFilterSwitch").length === 0 &&
        jQuery(event.target).closest(".hhrFilterReset").length === 0
      ) {
        hhrSwitchFilter(event.target);
      }
    });
  }
}

function hhrSwitchFilterEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var bottom = jQuery(el).closest(".hhrFilterCounter").hasClass("bottom");
  var filterSwitch = jQuery(el)
    .closest(".hhrPageWithFilter")
    .find(".hhrFilter")
    .find(".hhrFilterControls")
    .hasClass("height-auto");
  if (filterSwitch) {
    jQuery(el)
      .closest(".hhrPageWithFilter")
      .find(".hhrFilter")
      .find(".hhrFilterControlsContainer")
      .slideUp("fast", function () {
        jQuery(el)
          .closest(".hhrPageWithFilter")
          .find(".hhrFilter")
          .find(".hhrFilterControls")
          .removeClass("height-auto");
        jQuery(el)
          .closest(".hhrPage.hhrPageWithFilter")
          .removeClass("hhrFilterActive");
      });
  } else {
    jQuery(el)
      .closest(".hhrPageWithFilter")
      .find(".hhrFilter")
      .find(".hhrFilterControlsContainer")
      .slideDown();
    jQuery(el)
      .closest(".hhrPageWithFilter")
      .find(".hhrFilter")
      .find(".hhrFilterControls")
      .addClass("height-auto");
    jQuery(el)
      .closest(".hhrPage.hhrPageWithFilter")
      .addClass("hhrFilterActive");
    if (bottom) {
      jQuery("html, body").animate(
        {
          scrollTop: jQuery(".hhrPageWithFilter").offset().top - 80,
        },
        1000
      );
    }
    jQuery(".hhrFilterActive").click(function (event) {
      if (
        jQuery(event.target).closest(".hhrFilterControls").length === 0 &&
        jQuery(event.target).closest(".hhrFilterSwitch").length === 0 &&
        jQuery(event.target).closest(".hhrFilterReset").length === 0
      ) {
        hhrSwitchFilterEn(event.target);
      }
    });
  }
}

function hhrQuickForm(el, contentHtml) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var formHtml =
    '<div class="hhr-quickForm-envelope">' + contentHtml + "</div>";
  jQuery("#wrapper").append(formHtml);
  jQuery("html, body").animate({ scrollTop: 0 });
  setTimeout(function () {
    jQuery(".hhr-quickForm-envelope").addClass("visible");
  }, 200);
}

function hhrQuickFormCancel(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el).closest(".hhr-quickForm-envelope").removeClass("visible");
  setTimeout(function () {
    jQuery(el).closest(".hhr-quickForm-envelope").remove();
  }, 1000);
}

function hhrQuickFormSend(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  /* avoid duplcate clicks */
  if (jQuery(el).hasClass('inProcess') || jQuery(el).hasClass('successfullySent')) {
    /* no action */
  } else {

    var gaCategory = 'Form action';
    var gaAction = 'Button click';
    var gaLabel = 'Quick Form Send';
    var gaValue = window.location.href;
    gtag('event', gaAction, {
      'gaCategory': gaCategory,
      'gaAction': gaAction,
      'gaLabel': gaLabel,
      'gaValue': gaValue
    });
  // ga('send', 'event', gaCategory, gaAction, gaLabel, gaValue);
    window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel, gaValue);

    jQuery(el).addClass('inProcess');
    var form = jQuery(el).closest(".hhr-quickForm");
    var formFields = [];
    var formField = {};
    formField.label = 'href';
    formField.value = window.location.href;
    formFields.push(formField);

    jQuery(form)
      .find(".hhr-quickForm-fieldSet .hhr-input")
      .each(function () {
        var formField = {};
        formField.label = jQuery(this)
          .closest(".hhr-quickForm-fieldSet")
          .find("label.hhr-input-label")
          .text();
        formField.value = jQuery(this).val();
        formFields.push(formField);
      });
    
    console.log(formFields);
    var action = jQuery(form).attr("data-action");
    var subject = jQuery(form).attr("data-subject");
    var lang = jQuery("body").hasClass("en-GB") ? "en" : "cs";
    var formData = new FormData();
    formData.append("action", action);
    formData.append("subject", subject);
    formData.append("lang", lang);
    formData.append("formFields", JSON.stringify(formFields));

    jQuery.ajax({
      type: "POST",
      url: window.TaskMonitorBaseDir + "ajaxRko.php",
      dataType: "json",
      cache: false,
      contentType: false,
      processData: false,
      data: formData,
      success: function (data, status) {
        if (data.hasOwnProperty("status") && data.status == "OK") {
          window.TaskMonitorDebug && console.log("hhrQuickFormSend: SUCCESS");
          jQuery(el).removeClass('inProcess').addClass('successfullySent');
          jQuery(".hhr-quickForm .success-message").removeClass("hidden");
          setTimeout(function () {
            jQuery(".hhr-quickForm .success-message").addClass("visible");
          }, 200);
          setTimeout(function () {
            hhrQuickFormCancel(jQuery(".hhr-quickForm"));
          }, 3000);
        } else {
          jQuery(el).removeClass('inProcess');
          window.TaskMonitorDebug && console.log("hhrQuickFormSend: WARNING");
          window.TaskMonitorDebug && console.log(data);
        }
      },
      error: function (data, status) {
        jQuery(el).removeClass('inProcess');
        window.TaskMonitorDebug && console.log("hhrQuickFormSend: ERROR");
        window.TaskMonitorDebug && console.log(data);
      },
    });

  }
}

function hhrWelcomeMessage() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var timeStart = Date.now();
  var formData = new FormData();
  formData.append("action", "welcomeMessage");

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrWelcomeMessage: SUCCESS");
        if (data.hasOwnProperty("message_cz")) {
          var messageHtmlCz =
            '<div class="hhrWelcomeMessageBox">' + data.message_cz + "</div>";
          jQuery("#section-slider").append(messageHtmlCz);
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrWelcomeMessage: WARNING");
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrWelcomeMessage: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrWelcomeMessageEn() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var timeStart = Date.now();
  var formData = new FormData();
  formData.append("action", "welcomeMessage");

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrWelcomeMessage: SUCCESS");
        if (data.hasOwnProperty("message_en")) {
          var messageHtmlEn =
            '<div class="hhrWelcomeMessageBox">' + data.message_en + "</div>";
          jQuery("#section-slider").append(messageHtmlEn);
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrWelcomeMessage: WARNING");
      }
    },
    error: function (data, status) {
      BiAjaxIcon("stop");
      window.TaskMonitorDebug && console.log("hhrWelcomeMessage: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  var timeDiff = Date.now() - timeStart;
  window.TaskMonitorDebug && console.log("funcTime:", timeDiff);
  return true;
}

function hhrHomeSearch() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  console.log("hhrHomeSearch");

  var gaCategory = 'Home page filter action';
  var gaAction = 'Button click';
  var gaLabel = 'Search';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  var estateId = jQuery(".hhr-home-filter-fieldset")
    .find('.hhr-input[name="id"]')
    .val();
  if (estateId !== undefined && estateId.length > 3) {
    /* find joomla alias by estate id */
    var formData = new FormData();
    formData.append("action", "getJoomlaAliasByEstateId");
    formData.append("estateId", estateId);
    if (jQuery("body").hasClass("en-GB")) {
      formData.append("lang", 'en');
    } else {
      formData.append("lang", 'cz');
    }
    jQuery.ajax({
      type: "POST",
      url: window.TaskMonitorBaseDir + "ajaxRko.php",
      dataType: "json",
      cache: false,
      contentType: false,
      processData: false,
      data: formData,
      success: function (data, status) {
        window.TaskMonitorDebug && console.log(data);
        if (data.hasOwnProperty("status") && data.status == "OK") {
          window.TaskMonitorDebug &&
            console.log("hhrHomeSearch-JoomlaAlias: SUCCESS");
          if (data.hasOwnProperty("joomla_alias")) {
            window.location.href = "/" + data.joomla_alias;
          }
        } else {
          window.TaskMonitorDebug &&
            console.log("hhrHomeSearch-JoomlaAlias: WARNING");
        }
      },
      error: function (data, status) {
        window.TaskMonitorDebug &&
          console.log("hhrHomeSearch-JoomlaAlias: ERROR");
        window.TaskMonitorDebug && console.log(data);
      },
    });
  } else {
    /* find estates by form params */
    var categorySelected = jQuery(".hhr-home-filterCategory").select2("data");
    var category = categorySelected[0].id;
    var localitySelected = jQuery(".hhr-home-filterLocality").select2("data");
    var locality = localitySelected[0].id;
    var price = jQuery(".hhr-home-filterPrice").val();
    var newUrl =
      category + "?hhrfilterlocality=" + locality + "&hhrfilterprice=" + price;
    console.log(category, locality, price);
    window.location.href = newUrl;
  }
}

function hhrFormInit() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(".hhrform-envelope")
    .find(".form-control")
    .change(function (event) {
      var lengthMin =
        jQuery(event.target).attr("data-min").length > 0
          ? jQuery(event.target).attr("data-min")
          : 0;
      var lengthMax =
        jQuery(event.target).attr("data-max").length > 0 &&
          jQuery(event.target).attr("data-max") > 0
          ? jQuery(event.target).attr("data-max")
          : 99999;
      var lengthActual = jQuery(event.target).val().length;

      if (lengthActual < lengthMin || lengthActual > lengthMax) {
        /* input out of limit */
        var errorText =
          '"' +
          jQuery(event.target).attr("data-title") +
          '" ' +
          jQuery(event.target).attr("data-error");
        jQuery(event.target)
          .closest(".form-group")
          .find(".fielderror")
          .text(errorText);
        jQuery(event.target).addClass("inputError");
        jQuery(event.target).closest(".form-group").find(".fielderror").show();
      } else {
        /* input in correct length */
        jQuery(event.target)
          .closest(".form-group")
          .find(".fielderror")
          .text("");
        jQuery(event.target).removeClass("inputError");
        jQuery(event.target).closest(".form-group").find(".fielderror").hide();
      }

      console.log(jQuery(event.target).attr("id") + " form control changed");
      console.log(
        "min:" + lengthMin + " max:" + lengthMax + " actual:" + lengthActual
      );
    });
  jQuery(".hhrform-envelope")
    .find("button.hhr-btn-submit")
    .click(function (event) {
      /* check if error input exists */
      jQuery(event.target)
        .closest(".hhrform-envelope")
        .find(".form-control.required.validate")
        .each(function () {
          jQuery(this).change();
        });
      var targetButton = jQuery(event.target).hasClass("hhr-btn-submit")
        ? jQuery(event.target)
        : jQuery(event.target).closest(".hhr-btn-submit");
      if (
        jQuery(event.target).closest(".hhrform-envelope").find(".inputError")
          .length > 0
      ) {
        /* error exists - form could not be sent */
        console.log("Error found!");
        var errorText =
          '"' +
          targetButton.attr("data-title") +
          '" ' +
          targetButton.attr("data-error");
        var errorDialog =
          '<div id="dialog-message"><div class="overlay"><div class="message"><div class="header">UpozornÄ›nĂ­</div><div class="text">' +
          errorText +
          '</div><div class="buttons"><button class="btn btn-default" onclick="jQuery(this).closest(\'#dialog-message\').hide().remove()">OK</button></div></div></div></div> ';
        jQuery(event.target).closest(".hhrform-envelope").append(errorDialog);
      } else {
        /* send form */
        console.log("Form could be sent out!");
        /* create array with form values */
        var form = jQuery(event.target).closest(".hhrform-envelope");
        var formId = form.attr("data-form-id");
        var sender = form.find("#form_email.form-control").val();
        var lang = jQuery("body").hasClass("en-GB") ? "en" : "cs";
        var formValues = [];
        jQuery(event.target)
          .closest(".hhrform-envelope")
          .find(".form-control.required.validate")
          .each(function () {
            var formItem = {};
            formItem.name = jQuery(this).attr("data-title");
            formItem.value = jQuery(this).val();
            formValues.push(formItem);
          });
        var formData = new FormData();
        formData.append("action", "hhrFormSend");
        formData.append("formId", formId);
        formData.append("lang", lang);
        formData.append("sender", sender);
        formData.append("formValues", JSON.stringify(formValues));

        jQuery.ajax({
          type: "POST",
          url: window.TaskMonitorBaseDir + "ajaxRko.php",
          dataType: "json",
          cache: false,
          contentType: false,
          processData: false,
          data: formData,
          success: function (data, status) {
            window.TaskMonitorDebug && console.log(data);
            if (data.hasOwnProperty("status") && data.status == "OK") {
              window.TaskMonitorDebug && console.log("hhrFormSend: SUCCESS");
              var successText =
                '"' +
                targetButton.attr("data-title") +
                '" ' +
                targetButton.attr("data-success");
              var successDialog =
                '<div id="dialog-message"><div class="overlay"><div class="message"><div class="header">Informace</div><div class="text">' +
                successText +
                '</div><div class="buttons"><button class="btn btn-default" onclick="jQuery(this).closest(\'#dialog-message\').hide().remove()">OK</button></div></div></div></div> ';
              jQuery(targetButton)
                .closest(".hhrform-envelope")
                .append(successDialog);

              /* clean all inputs */
              jQuery(targetButton)
                .closest(".hhrform-envelope")
                .find(".form-control")
                .each(function () {
                  jQuery(this).val("");
                });
            } else {
              window.TaskMonitorDebug && console.log("hhrFormSend: WARNING");
              window.TaskMonitorDebug && console.log(data);
            }
          },
          error: function (data, status) {
            window.TaskMonitorDebug && console.log("hhrFormSend: ERROR");
            window.TaskMonitorDebug && console.log(data);
          },
        });
      }

      console.log("button clicked");
    });
  return true;
}

function hhrFormInitEn() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(".hhrform-envelope")
    .find(".form-control")
    .change(function (event) {
      var lengthMin =
        jQuery(event.target).attr("data-min").length > 0
          ? jQuery(event.target).attr("data-min")
          : 0;
      var lengthMax =
        jQuery(event.target).attr("data-max").length > 0 &&
          jQuery(event.target).attr("data-max") > 0
          ? jQuery(event.target).attr("data-max")
          : 99999;
      var lengthActual = jQuery(event.target).val().length;

      if (lengthActual < lengthMin || lengthActual > lengthMax) {
        /* input out of limit */
        var errorText =
          '"' +
          jQuery(event.target).attr("data-title") +
          '" ' +
          jQuery(event.target).attr("data-error");
        jQuery(event.target)
          .closest(".form-group")
          .find(".fielderror")
          .text(errorText);
        jQuery(event.target).addClass("inputError");
        jQuery(event.target).closest(".form-group").find(".fielderror").show();
      } else {
        /* input in correct length */
        jQuery(event.target)
          .closest(".form-group")
          .find(".fielderror")
          .text("");
        jQuery(event.target).removeClass("inputError");
        jQuery(event.target).closest(".form-group").find(".fielderror").hide();
      }

      console.log(jQuery(event.target).attr("id") + " form control changed");
      console.log(
        "min:" + lengthMin + " max:" + lengthMax + " actual:" + lengthActual
      );
    });
  jQuery(".hhrform-envelope")
    .find("button.hhr-btn-submit")
    .click(function (event) {
      /* check if error input exists */
      jQuery(event.target)
        .closest(".hhrform-envelope")
        .find(".form-control.required.validate")
        .each(function () {
          jQuery(this).change();
        });
      var targetButton = jQuery(event.target).hasClass("hhr-btn-submit")
        ? jQuery(event.target)
        : jQuery(event.target).closest(".hhr-btn-submit");
      if (
        jQuery(event.target).closest(".hhrform-envelope").find(".inputError")
          .length > 0
      ) {
        /* error exists - form could not be sent */
        console.log("Error found!");
        var errorText =
          '"' +
          targetButton.attr("data-title") +
          '" ' +
          targetButton.attr("data-error");
        var errorDialog =
          '<div id="dialog-message"><div class="overlay"><div class="message"><div class="header">Warning</div><div class="text">' +
          errorText +
          '</div><div class="buttons"><button class="btn btn-default" onclick="jQuery(this).closest(\'#dialog-message\').hide().remove()">OK</button></div></div></div></div> ';
        jQuery(event.target).closest(".hhrform-envelope").append(errorDialog);
      } else {
        /* send form */
        console.log("Form could be sent out!");
        /* create array with form values */
        var form = jQuery(event.target).closest(".hhrform-envelope");
        var formId = form.attr("data-form-id");
        var sender = form.find("#form_email.form-control").val();
        var lang = jQuery("body").hasClass("en-GB") ? "en" : "cs";
        var formValues = [];
        jQuery(event.target)
          .closest(".hhrform-envelope")
          .find(".form-control.required.validate")
          .each(function () {
            var formItem = {};
            formItem.name = jQuery(this).attr("data-title");
            formItem.value = jQuery(this).val();
            formValues.push(formItem);
          });
        var formData = new FormData();
        formData.append("action", "hhrFormSend");
        formData.append("formId", formId);
        formData.append("sender", sender);
        formData.append("lang", lang);
        formData.append("formValues", JSON.stringify(formValues));

        jQuery.ajax({
          type: "POST",
          url: window.TaskMonitorBaseDir + "ajaxRko.php",
          dataType: "json",
          cache: false,
          contentType: false,
          processData: false,
          data: formData,
          success: function (data, status) {
            window.TaskMonitorDebug && console.log(data);
            if (data.hasOwnProperty("status") && data.status == "OK") {
              window.TaskMonitorDebug && console.log("hhrFormSend: SUCCESS");
              var successText =
                '"' +
                targetButton.attr("data-title") +
                '" ' +
                targetButton.attr("data-success");
              var successDialog =
                '<div id="dialog-message"><div class="overlay"><div class="message"><div class="header">Information</div><div class="text">' +
                successText +
                '</div><div class="buttons"><button class="btn btn-default" onclick="jQuery(this).closest(\'#dialog-message\').hide().remove()">OK</button></div></div></div></div> ';
              jQuery(targetButton)
                .closest(".hhrform-envelope")
                .append(successDialog);

              /* clean all inputs */
              jQuery(targetButton)
                .closest(".hhrform-envelope")
                .find(".form-control")
                .each(function () {
                  jQuery(this).val("");
                });
            } else {
              window.TaskMonitorDebug && console.log("hhrFormSend: WARNING");
              window.TaskMonitorDebug && console.log(data);
            }
          },
          error: function (data, status) {
            window.TaskMonitorDebug && console.log("hhrFormSend: ERROR");
            window.TaskMonitorDebug && console.log(data);
          },
        });
      }

      console.log("button clicked");
    });
  return true;
}

function hhrHomeFormInit() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var homeForm = jQuery(".hhr-home-filter");

  /* get initial form values */
  var formData = new FormData();
  formData.append("action", "hhrHomeFormInit");

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrHomeFormInit: SUCCESS");
        var formCategories = data.categories;
        for (const [key, value] of Object.entries(formCategories)) {
          var newOption = new Option(value, key, false, false);
          jQuery(homeForm)
            .find("select.hhr-home-filterCategory")
            .append(newOption)
            .trigger("change");
        }
        var formLocations = data.locations;
        for (const [key, value] of Object.entries(formLocations)) {
          var newOption = new Option(value, key, false, false);
          jQuery(homeForm)
            .find("select.hhr-home-filterLocality")
            .append(newOption)
            .trigger("change");
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrHomeFormInit: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug && console.log("hhrHomeFormInit: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  return true;
}

function hhrHomeFormInitEn() {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var homeForm = jQuery(".hhr-home-filter");

  /* get initial form values */
  var formData = new FormData();
  formData.append("action", "hhrHomeFormInitEn");

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug && console.log("hhrHomeFormInitEn: SUCCESS");
        var formCategories = data.categories;
        for (const [key, value] of Object.entries(formCategories)) {
          var newOption = new Option(value, key, false, false);
          jQuery(homeForm)
            .find("select.hhr-home-filterCategory")
            .append(newOption)
            .trigger("change");
        }
        var formLocations = data.locations;
        for (const [key, value] of Object.entries(formLocations)) {
          var newOption = new Option(value, key, false, false);
          jQuery(homeForm)
            .find("select.hhr-home-filterLocality")
            .append(newOption)
            .trigger("change");
        }
      } else {
        window.TaskMonitorDebug && console.log("hhrHomeFormInitEn: WARNING");
        window.TaskMonitorDebug && console.log(data);
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug && console.log("hhrHomeFormInitEn: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
  return true;
}

function hhrSearchByIdEnter(el, event) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  /* bind enter sensitivity on hhr inputs */
  if (event.which == 13) {
    if (jQuery(el).parent().hasClass("hhrFilterSerchById")) {
      /* search by ID on estate filter */
      jQuery(el).parent().find(".fa-search").click();
    }
  }
}

function hhrSearchById(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (jQuery(el).hasClass("fa-search") !== true) {
    console.log("Invalid search initiator!");
    return false;
  }
  var estateId = jQuery(el).parent().find('.hhr-input[name="id"]').val();

  /* find joomla alias by estate id */
  var formData = new FormData();
  formData.append("action", "getJoomlaAliasByEstateId");
  formData.append("estateId", estateId);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug &&
          console.log("hhrHomeSearch-JoomlaAlias: SUCCESS");
        if (data.hasOwnProperty("joomla_alias")) {
          window.location.href = "/" + data.joomla_alias;
        } else {
          var errorText = "NabĂ­dka s odpovĂ­dajĂ­cĂ­m ID nebyla nalezena";
          var errorDialog =
            '<div id="dialog-message" onclick="hhrStopPropagation(this, event)"><div class="overlay"><div class="message"><div class="header">UpozornÄ›nĂ­</div><div class="text">' +
            errorText +
            '</div><div class="buttons"><button class="btn btn-default" onclick="hhrCloseDialog(this, event)">OK</button></div></div></div></div> ';
          jQuery(el).append(errorDialog);
        }
      } else {
        window.TaskMonitorDebug &&
          console.log("hhrHomeSearch-JoomlaAlias: WARNING");
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug &&
        console.log("hhrHomeSearch-JoomlaAlias: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
}

function hhrSearchByIdEn(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  if (jQuery(el).hasClass("fa-search") !== true) {
    console.log("Invalid search initiator!");
    return false;
  }
  var estateId = jQuery(el).parent().find('.hhr-input[name="id"]').val();

  /* find joomla alias by estate id */
  var formData = new FormData();
  formData.append("action", "getJoomlaAliasByEstateId");
  formData.append("estateId", estateId);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug &&
          console.log("hhrHomeSearch-JoomlaAlias: SUCCESS");
        if (data.hasOwnProperty("joomla_alias")) {
          window.location.href = "/" + data.joomla_alias;
        } else {
          var errorText = "No estate with relevant ID found.";
          var errorDialog =
            '<div id="dialog-message" onclick="hhrStopPropagation(this, event)"><div class="overlay"><div class="message"><div class="header">Warning</div><div class="text">' +
            errorText +
            '</div><div class="buttons"><button class="btn btn-default" onclick="hhrCloseDialog(this, event)">OK</button></div></div></div></div> ';
          jQuery(el).append(errorDialog);
        }
      } else {
        window.TaskMonitorDebug &&
          console.log("hhrHomeSearch-JoomlaAlias: WARNING");
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug &&
        console.log("hhrHomeSearch-JoomlaAlias: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
}

function hhrStopPropagation(el, event) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  event.stopPropagation();
}

function hhrCloseDialog(el, event) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  jQuery(el).closest("#dialog-message").hide().remove();
}

function hhrFilterCategoryClick(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var newUrl = jQuery(el).attr("data-filter-category-link");
  window.location.href = newUrl;
}

function hhrOpenContactFormEn(el) {
  return hhrOpenContactForm(el);
}

function hhrOpenContactForm(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  event.preventDefault();
  var nabidkaId = jQuery(el)
    .closest(".hhrEstateIntro ")
    .attr("data-estate-external-id");

  if (jQuery("body").hasClass("en-GB")) {
    /* EN version */
    var contentHtml =
      '<div class="hhr-quickForm" data-subject="Enquiry for private offer ' +
      nabidkaId +
      '" data-action="quickFormSend">';
    contentHtml +=
      '<div class="hhr-quickForm-header">I am requesting more details about the private offer ID: ' +
      nabidkaId +
      "</div>";
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">Subject</label><input class="hhr-input" type="text" name="title" value="I am requesting more details about the private offer ID: ' +
      nabidkaId +
      '"/></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Full name</label><input class="hhr-input" type="text" name="name" /></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Phone</label><input class="hhr-input" type="text" name="phone" /></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">Important information</label><div class="hhr-quickForm-text"><p>Our specialist will contact you about your requested information.</p><p>By submitting the form, you agree to the processing of the information provided by you for the purpose of processing, preparation and subsequent contact.</p></div></div>';
    contentHtml +=
      '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet wide right-span success-message hidden"><label class="red">Thank you!</label><div class="hhr-quickForm-text"><p>Your request was successfully delivered.</p><p>Our specialist will contact you latest on next working day.</p></div></div>';
    contentHtml += "</div > ";
    hhrQuickForm(this, contentHtml);
  } else {
    /* CZ version */
    var contentHtml =
      '<div class="hhr-quickForm" data-subject="PoptĂˇvka na privĂˇtnĂ­ nabĂ­dku ' +
      nabidkaId +
      '" data-action="quickFormSend">';
    contentHtml +=
      '<div class="hhr-quickForm-header">PoptĂˇvĂˇm informace o privĂˇtnĂ­ nabĂ­dce ID: ' +
      nabidkaId +
      "</div>";
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">PĹ™edmÄ›t</label><input class="hhr-input" type="text" name="title" value="PoptĂˇvĂˇm informace o privĂˇtnĂ­ nabĂ­dce ID: ' +
      nabidkaId +
      '"/></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">JmĂ©no a pĹ™Ă­jmenĂ­</label><input class="hhr-input" type="text" name="name" /></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Telefon</label><input class="hhr-input" type="text" name="phone" /></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">DĹŻleĹľitĂ© informace</label><div class="hhr-quickForm-text"><p>Na zĂˇkladÄ› informacĂ­ VĂˇs po odeslĂˇnĂ­ formulĂˇĹ™e bude kontaktovat nĂˇĹˇ specialista.</p><p>OdeslĂˇnĂ­m formulĂˇĹ™e souhlasĂ­te se zpracovĂˇnĂ­m VĂˇmi uvedenĂ˝ch informacĂ­ za ĂşÄŤelem zpracovĂˇnĂ­, pĹ™Ă­pravy a nĂˇslednĂ©ho zpÄ›tnĂ©ho kontaktu.</p></div></div>';
    contentHtml +=
      '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
    contentHtml +=
      '<div class="hhr-quickForm-fieldSet wide right-span success-message hidden"><label class="red">DÄ›kujeme!</label><div class="hhr-quickForm-text"><p>VĂˇmi odeslanĂ© informace byly ĂşspÄ›ĹˇnÄ› doruÄŤeny.</p><p>NĂˇĹˇ specialista VĂˇs bude kontaktovat nejpozdÄ›ji v nĂˇsledujĂ­cĂ­m pracovnĂ­m dni.</p></div></div>';
    contentHtml += "</div > ";
    hhrQuickForm(this, contentHtml);
  }

  return;
}

function hhrPlanListSendForm(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  /* close list */
  hhrPlanListShow(el);

  var gaCategory = 'Form action';
  var gaAction = 'Button click';
  var gaLabel = 'Plan List Send Form';
  gtag('event', gaAction, {
    'gaCategory': gaCategory,
    'gaAction': gaAction,
    'gaLabel': gaLabel,
    'gaValue': null
  });
  // ga('send', 'event', gaCategory, gaAction, gaLabel);
  window.TaskMonitorDebug && console.log('ga', 'send', 'event', gaCategory, gaAction, gaLabel);

  /* find joomla alias by estate id */
  var formData = new FormData();
  formData.append("action", "hhrPlanListSendFormContent");

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug &&
          console.log("hhrPlanListSendFormContent: SUCCESS");
        hhrQuickForm(el, data.contentHtml);
      } else {
        window.TaskMonitorDebug &&
          console.log("hhrPlanListSendFormContent: WARNING");
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug &&
        console.log("hhrPlanListSendFormContent: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
}

function hhrFillAgentData(el) {
  window.TaskMonitorDebug && console.log(arguments.callee.name);
  var email = jQuery(el).val();
  var name = jQuery("option[value='" + email + "']").attr("data-name");
  jQuery(".hhr-input[name='agentName']").val(name);
  return true;
}

function hhrEstateStatusCheckEn() {
  var estateExternalId = jQuery('.hhr-input[name="estateExternalId"]').val();

  /* find estate status by estate id */
  var formData = new FormData();
  formData.append("action", "hhrEstateStatusCheck");
  formData.append("estateExternalId", estateExternalId);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug &&
          console.log("hhrEstateStatusCheck: SUCCESS");
        var statusMessage = data.estateStatusEn;
        var link = data.linkEn;
        var locationUpdate = data.locationUpdate == 'yes' ? true : false;
        var estateClass = data.estateClass;
        if (locationUpdate) {
          var htmlElement = '<div class="hhrFullWindowDark"><div class="hhrFullWindowMessage">' + statusMessage + '</div></div>';
          jQuery('.hhrArticleEnvelope').append(htmlElement);
          setTimeout(function () {
            location.href = link;
          }, 5000);
        } else {
          jQuery('.hhrArticleEnvelope').addClass(estateClass);
          var htmlMessage = '<div class="hhrSpecialStatus"><i class="fal fa-lock-alt"></i>' + statusMessage + '</div>';
          jQuery('.hhrArticleHeader').after(htmlMessage);
        }
      } else {
        window.TaskMonitorDebug &&
          console.log("hhrEstateStatusCheck: WARNING");
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug &&
        console.log("hhrEstateStatusCheck: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
}

function hhrEstateStatusCheck() {
  var estateExternalId = jQuery('.hhr-input[name="estateExternalId"]').val();

  /* find estate status by estate id */
  var formData = new FormData();
  formData.append("action", "hhrEstateStatusCheck");
  formData.append("estateExternalId", estateExternalId);

  jQuery.ajax({
    type: "POST",
    url: window.TaskMonitorBaseDir + "ajaxRko.php",
    dataType: "json",
    cache: false,
    contentType: false,
    processData: false,
    data: formData,
    success: function (data, status) {
      window.TaskMonitorDebug && console.log(data);
      if (data.hasOwnProperty("status") && data.status == "OK") {
        window.TaskMonitorDebug &&
          console.log("hhrEstateStatusCheck: SUCCESS");
        var statusMessage = data.estateStatusCz;
        var link = data.linkCz;
        var locationUpdate = data.locationUpdate == 'yes' ? true : false;
        var estateClass = data.estateClass;
        if (locationUpdate) {
          var htmlElement = '<div class="hhrFullWindowDark"><div class="hhrFullWindowMessage">' + statusMessage + '</div></div>';
          jQuery('.hhrArticleEnvelope').append(htmlElement);
          setTimeout(function () {
            location.href = link;
          }, 5000);
        } else {
          jQuery('.hhrArticleEnvelope').addClass(estateClass);
          var htmlMessage = '<div class="hhrSpecialStatus"><i class="fal fa-lock-alt"></i>' + statusMessage + '</div>';
          jQuery('.hhrArticleHeader').after(htmlMessage);
        }
      } else {
        window.TaskMonitorDebug &&
          console.log("hhrEstateStatusCheck: WARNING");
      }
    },
    error: function (data, status) {
      window.TaskMonitorDebug &&
        console.log("hhrEstateStatusCheck: ERROR");
      window.TaskMonitorDebug && console.log(data);
    },
  });
}

function hhrSwitchGridContent(el, step) {
  if (window.hhrGridSection === undefined) {
    window.hhrGridSection = 1;
  }
  var max = 4;
  if (step === -1) {
    /* go back */
    var x = window.hhrGridSection;
    var y = x === 1 ? max : x - 1;
    window.hhrGridSection = y;
    var itemx = jQuery(el).closest('.section-grid').find('.section-grid-content-envelope.item' + x.toString())
    var itemy = jQuery(el).closest('.section-grid').find('.section-grid-content-envelope.item' + y.toString())
    jQuery(itemx).fadeOut("slow", function () {
      jQuery(itemy).fadeIn("slow");
     });
  } else {
    /* go forward */
    var x = window.hhrGridSection;
    var y = x === max ? 1 : x + 1;
    window.hhrGridSection = y;
    var itemx = jQuery(el).closest('.section-grid').find('.section-grid-content-envelope.item' + x.toString())
    var itemy = jQuery(el).closest('.section-grid').find('.section-grid-content-envelope.item' + y.toString())
    jQuery(itemx).fadeOut("slow", function () {
      jQuery(itemy).fadeIn("slow");
    });
  }
} 

} catch (e) {
console.error('Error in file:/templates/archi/js/script.hhr.js; Error:' + e.message);
};
try {
/*! PhotoSwipe Default UI - 4.1.3 - 2019-01-08
 * http://photoswipe.com
 * Copyright (c) 2019 Dmitry Semenov; */
/**
 *
 * UI on top of main sliding area (caption, arrows, close button, etc.).
 * Built just using public methods/properties of PhotoSwipe.
 * 
 */
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define(factory);
    } else if (typeof exports === 'object') {
        module.exports = factory();
    } else {
        root.PhotoSwipeUI_Default = factory();
    }
})(this, function () {

    'use strict';



    var PhotoSwipeUI_Default =
        function (pswp, framework) {

            var ui = this;
            var _overlayUIUpdated = false,
                _controlsVisible = true,
                _fullscrenAPI,
                _controls,
                _captionContainer,
                _fakeCaptionContainer,
                _indexIndicator,
                _shareButton,
                _shareModal,
                _shareModalHidden = true,
                _initalCloseOnScrollValue,
                _isIdle,
                _listen,

                _loadingIndicator,
                _loadingIndicatorHidden,
                _loadingIndicatorTimeout,

                _galleryHasOneSlide,

                _options,
                _defaultUIOptions = {
                    barsSize: {
                        top: 44,
                        bottom: 'auto'
                    },
                    closeElClasses: ['item', 'caption', 'zoom-wrap', 'ui', 'top-bar'],
                    timeToIdle: 4000,
                    timeToIdleOutside: 1000,
                    loadingIndicatorDelay: 1000, // 2s

                    addCaptionHTMLFn: function (item, captionEl /*, isFake */ ) {
                        if (!item.title) {
                            captionEl.children[0].innerHTML = '';
                            return false;
                        }
                        captionEl.children[0].innerHTML = item.title;
                        return true;
                    },

                    closeEl: true,
                    captionEl: true,
                    fullscreenEl: true,
                    zoomEl: true,
                    shareEl: true,
                    counterEl: true,
                    arrowEl: true,
                    preloaderEl: true,

                    tapToClose: false,
                    tapToToggleControls: true,

                    clickToCloseNonZoomable: true,

                    shareButtons: [{
                            id: 'facebook',
                            label: 'Share on Facebook',
                            url: 'https://www.facebook.com/sharer/sharer.php?u={{url}}'
                        },
                        {
                            id: 'twitter',
                            label: 'Tweet',
                            url: 'https://twitter.com/intent/tweet?text={{text}}&url={{url}}'
                        },
                        {
                            id: 'pinterest',
                            label: 'Pin it',
                            url: 'http://www.pinterest.com/pin/create/button/' +
                                '?url={{url}}&media={{image_url}}&description={{text}}'
                        },
                        {
                            id: 'download',
                            label: 'Download image',
                            url: '{{raw_image_url}}',
                            download: true
                        }
                    ],
                    getImageURLForShare: function ( /* shareButtonData */ ) {
                        return pswp.currItem.src || '';
                    },
                    getPageURLForShare: function ( /* shareButtonData */ ) {
                        return window.location.href;
                    },
                    getTextForShare: function ( /* shareButtonData */ ) {
                        return pswp.currItem.title || '';
                    },

                    indexIndicatorSep: ' / ',
                    fitControlsWidth: 1200

                },
                _blockControlsTap,
                _blockControlsTapTimeout;



            var _onControlsTap = function (e) {
                    if (_blockControlsTap) {
                        return true;
                    }


                    e = e || window.event;

                    if (_options.timeToIdle && _options.mouseUsed && !_isIdle) {
                        // reset idle timer
                        _onIdleMouseMove();
                    }


                    var target = e.target || e.srcElement,
                        uiElement,
                        clickedClass = target.getAttribute('class') || '',
                        found;

                    for (var i = 0; i < _uiElements.length; i++) {
                        uiElement = _uiElements[i];
                        if (uiElement.onTap && clickedClass.indexOf('pswp__' + uiElement.name) > -1) {
                            uiElement.onTap();
                            found = true;

                        }
                    }

                    if (found) {
                        if (e.stopPropagation) {
                            e.stopPropagation();
                        }
                        _blockControlsTap = true;

                        // Some versions of Android don't prevent ghost click event 
                        // when preventDefault() was called on touchstart and/or touchend.
                        // 
                        // This happens on v4.3, 4.2, 4.1, 
                        // older versions strangely work correctly, 
                        // but just in case we add delay on all of them)	
                        var tapDelay = framework.features.isOldAndroid ? 600 : 30;
                        _blockControlsTapTimeout = setTimeout(function () {
                            _blockControlsTap = false;
                        }, tapDelay);
                    }

                },
                _fitControlsInViewport = function () {
                    return !pswp.likelyTouchDevice || _options.mouseUsed || screen.width > _options.fitControlsWidth;
                },
                _togglePswpClass = function (el, cName, add) {
                    framework[(add ? 'add' : 'remove') + 'Class'](el, 'pswp__' + cName);
                },

                // add class when there is just one item in the gallery
                // (by default it hides left/right arrows and 1ofX counter)
                _countNumItems = function () {
                    var hasOneSlide = (_options.getNumItemsFn() === 1);

                    if (hasOneSlide !== _galleryHasOneSlide) {
                        _togglePswpClass(_controls, 'ui--one-slide', hasOneSlide);
                        _galleryHasOneSlide = hasOneSlide;
                    }
                },
                _toggleShareModalClass = function () {
                    _togglePswpClass(_shareModal, 'share-modal--hidden', _shareModalHidden);
                },
                _toggleShareModal = function () {

                    _shareModalHidden = !_shareModalHidden;


                    if (!_shareModalHidden) {
                        _toggleShareModalClass();
                        setTimeout(function () {
                            if (!_shareModalHidden) {
                                framework.addClass(_shareModal, 'pswp__share-modal--fade-in');
                            }
                        }, 30);
                    } else {
                        framework.removeClass(_shareModal, 'pswp__share-modal--fade-in');
                        setTimeout(function () {
                            if (_shareModalHidden) {
                                _toggleShareModalClass();
                            }
                        }, 300);
                    }

                    if (!_shareModalHidden) {
                        _updateShareURLs();
                    }
                    return false;
                },

                _openWindowPopup = function (e) {
                    e = e || window.event;
                    var target = e.target || e.srcElement;

                    pswp.shout('shareLinkClick', e, target);

                    if (!target.href) {
                        return false;
                    }

                    if (target.hasAttribute('download')) {
                        return true;
                    }

                    window.open(target.href, 'pswp_share', 'scrollbars=yes,resizable=yes,toolbar=no,' +
                        'location=yes,width=550,height=420,top=100,left=' +
                        (window.screen ? Math.round(screen.width / 2 - 275) : 100));

                    if (!_shareModalHidden) {
                        _toggleShareModal();
                    }

                    return false;
                },
                _updateShareURLs = function () {
                    var shareButtonOut = '',
                        shareButtonData,
                        shareURL,
                        image_url,
                        page_url,
                        share_text;

                    for (var i = 0; i < _options.shareButtons.length; i++) {
                        shareButtonData = _options.shareButtons[i];

                        image_url = _options.getImageURLForShare(shareButtonData);
                        page_url = _options.getPageURLForShare(shareButtonData);
                        share_text = _options.getTextForShare(shareButtonData);

                        shareURL = shareButtonData.url.replace('{{url}}', encodeURIComponent(page_url))
                            .replace('{{image_url}}', encodeURIComponent(image_url))
                            .replace('{{raw_image_url}}', image_url)
                            .replace('{{text}}', encodeURIComponent(share_text));

                        shareButtonOut += '<a href="' + shareURL + '" target="_blank" ' +
                            'class="pswp__share--' + shareButtonData.id + '"' +
                            (shareButtonData.download ? 'download' : '') + '>' +
                            shareButtonData.label + '</a>';

                        if (_options.parseShareButtonOut) {
                            shareButtonOut = _options.parseShareButtonOut(shareButtonData, shareButtonOut);
                        }
                    }
                    _shareModal.children[0].innerHTML = shareButtonOut;
                    _shareModal.children[0].onclick = _openWindowPopup;

                },
                _hasCloseClass = function (target) {
                    for (var i = 0; i < _options.closeElClasses.length; i++) {
                        if (framework.hasClass(target, 'pswp__' + _options.closeElClasses[i])) {
                            return true;
                        }
                    }
                },
                _idleInterval,
                _idleTimer,
                _idleIncrement = 0,
                _onIdleMouseMove = function () {
                    clearTimeout(_idleTimer);
                    _idleIncrement = 0;
                    if (_isIdle) {
                        ui.setIdle(false);
                    }
                },
                _onMouseLeaveWindow = function (e) {
                    e = e ? e : window.event;
                    var from = e.relatedTarget || e.toElement;
                    if (!from || from.nodeName === 'HTML') {
                        clearTimeout(_idleTimer);
                        _idleTimer = setTimeout(function () {
                            ui.setIdle(true);
                        }, _options.timeToIdleOutside);
                    }
                },
                _setupFullscreenAPI = function () {
                    if (_options.fullscreenEl && !framework.features.isOldAndroid) {
                        if (!_fullscrenAPI) {
                            _fullscrenAPI = ui.getFullscreenAPI();
                        }
                        if (_fullscrenAPI) {
                            framework.bind(document, _fullscrenAPI.eventK, ui.updateFullscreen);
                            ui.updateFullscreen();
                            framework.addClass(pswp.template, 'pswp--supports-fs');
                        } else {
                            framework.removeClass(pswp.template, 'pswp--supports-fs');
                        }
                    }
                },
                _setupLoadingIndicator = function () {
                    // Setup loading indicator
                    if (_options.preloaderEl) {

                        _toggleLoadingIndicator(true);

                        _listen('beforeChange', function () {

                            clearTimeout(_loadingIndicatorTimeout);

                            // display loading indicator with delay
                            _loadingIndicatorTimeout = setTimeout(function () {

                                if (pswp.currItem && pswp.currItem.loading) {

                                    if (!pswp.allowProgressiveImg() || (pswp.currItem.img && !pswp.currItem.img.naturalWidth)) {
                                        // show preloader if progressive loading is not enabled, 
                                        // or image width is not defined yet (because of slow connection)
                                        _toggleLoadingIndicator(false);
                                        // items-controller.js function allowProgressiveImg
                                    }

                                } else {
                                    _toggleLoadingIndicator(true); // hide preloader
                                }

                            }, _options.loadingIndicatorDelay);

                        });
                        _listen('imageLoadComplete', function (index, item) {
                            if (pswp.currItem === item) {
                                _toggleLoadingIndicator(true);
                            }
                        });

                    }
                },
                _toggleLoadingIndicator = function (hide) {
                    if (_loadingIndicatorHidden !== hide) {
                        _togglePswpClass(_loadingIndicator, 'preloader--active', !hide);
                        _loadingIndicatorHidden = hide;
                    }
                },
                _applyNavBarGaps = function (item) {
                    var gap = item.vGap;

                    if (_fitControlsInViewport()) {

                        var bars = _options.barsSize;
                        if (_options.captionEl && bars.bottom === 'auto') {
                            if (!_fakeCaptionContainer) {
                                _fakeCaptionContainer = framework.createEl('pswp__caption pswp__caption--fake');
                                _fakeCaptionContainer.appendChild(framework.createEl('pswp__caption__center'));
                                _controls.insertBefore(_fakeCaptionContainer, _captionContainer);
                                framework.addClass(_controls, 'pswp__ui--fit');
                            }
                            if (_options.addCaptionHTMLFn(item, _fakeCaptionContainer, true)) {

                                var captionSize = _fakeCaptionContainer.clientHeight;
                                gap.bottom = parseInt(captionSize, 10) || 44;
                            } else {
                                gap.bottom = bars.top; // if no caption, set size of bottom gap to size of top
                            }
                        } else {
                            gap.bottom = bars.bottom === 'auto' ? 0 : bars.bottom;
                        }

                        // height of top bar is static, no need to calculate it
                        gap.top = bars.top;
                    } else {
                        gap.top = gap.bottom = 0;
                    }
                },
                _setupIdle = function () {
                    // Hide controls when mouse is used
                    if (_options.timeToIdle) {
                        _listen('mouseUsed', function () {

                            framework.bind(document, 'mousemove', _onIdleMouseMove);
                            framework.bind(document, 'mouseout', _onMouseLeaveWindow);

                            _idleInterval = setInterval(function () {
                                _idleIncrement++;
                                if (_idleIncrement === 2) {
                                    ui.setIdle(true);
                                }
                            }, _options.timeToIdle / 2);
                        });
                    }
                },
                _setupHidingControlsDuringGestures = function () {

                    // Hide controls on vertical drag
                    _listen('onVerticalDrag', function (now) {
                        if (_controlsVisible && now < 0.95) {
                            ui.hideControls();
                        } else if (!_controlsVisible && now >= 0.95) {
                            ui.showControls();
                        }
                    });

                    // Hide controls when pinching to close
                    var pinchControlsHidden;
                    _listen('onPinchClose', function (now) {
                        if (_controlsVisible && now < 0.9) {
                            ui.hideControls();
                            pinchControlsHidden = true;
                        } else if (pinchControlsHidden && !_controlsVisible && now > 0.9) {
                            ui.showControls();
                        }
                    });

                    _listen('zoomGestureEnded', function () {
                        pinchControlsHidden = false;
                        if (pinchControlsHidden && !_controlsVisible) {
                            ui.showControls();
                        }
                    });

                };



            var _uiElements = [{
                    name: 'caption',
                    option: 'captionEl',
                    onInit: function (el) {
                        _captionContainer = el;
                    }
                },
                {
                    name: 'share-modal',
                    option: 'shareEl',
                    onInit: function (el) {
                        _shareModal = el;
                    },
                    onTap: function () {
                        _toggleShareModal();
                    }
                },
                {
                    name: 'button--share',
                    option: 'shareEl',
                    onInit: function (el) {
                        _shareButton = el;
                    },
                    onTap: function () {
                        _toggleShareModal();
                    }
                },
                {
                    name: 'button--zoom',
                    option: 'zoomEl',
                    onTap: pswp.toggleDesktopZoom
                },
                {
                    name: 'counter',
                    option: 'counterEl',
                    onInit: function (el) {
                        _indexIndicator = el;
                    }
                },
                {
                    name: 'button--close',
                    option: 'closeEl',
                    onTap: pswp.close
                },
                {
                    name: 'button--arrow--left',
                    option: 'arrowEl',
                    onTap: pswp.prev
                },
                {
                    name: 'button--arrow--right',
                    option: 'arrowEl',
                    onTap: pswp.next
                },
                {
                    name: 'button--fs',
                    option: 'fullscreenEl',
                    onTap: function () {
                        if (_fullscrenAPI.isFullscreen()) {
                            _fullscrenAPI.exit();
                        } else {
                            _fullscrenAPI.enter();
                        }
                    }
                },
                {
                    name: 'preloader',
                    option: 'preloaderEl',
                    onInit: function (el) {
                        _loadingIndicator = el;
                    }
                }

            ];

            var _setupUIElements = function () {
                var item,
                    classAttr,
                    uiElement;

                var loopThroughChildElements = function (sChildren) {
                    if (!sChildren) {
                        return;
                    }

                    var l = sChildren.length;
                    for (var i = 0; i < l; i++) {
                        item = sChildren[i];
                        classAttr = item.className;

                        for (var a = 0; a < _uiElements.length; a++) {
                            uiElement = _uiElements[a];

                            if (classAttr.indexOf('pswp__' + uiElement.name) > -1) {

                                if (_options[uiElement.option]) { // if element is not disabled from options

                                    framework.removeClass(item, 'pswp__element--disabled');
                                    if (uiElement.onInit) {
                                        uiElement.onInit(item);
                                    }

                                    //item.style.display = 'block';
                                } else {
                                    framework.addClass(item, 'pswp__element--disabled');
                                    //item.style.display = 'none';
                                }
                            }
                        }
                    }
                };
                loopThroughChildElements(_controls.children);

                var topBar = framework.getChildByClass(_controls, 'pswp__top-bar');
                if (topBar) {
                    loopThroughChildElements(topBar.children);
                }
            };




            ui.init = function () {

                // extend options
                framework.extend(pswp.options, _defaultUIOptions, true);

                // create local link for fast access
                _options = pswp.options;

                // find pswp__ui element
                _controls = framework.getChildByClass(pswp.scrollWrap, 'pswp__ui');

                // create local link
                _listen = pswp.listen;


                _setupHidingControlsDuringGestures();

                // update controls when slides change
                _listen('beforeChange', ui.update);

                // toggle zoom on double-tap
                _listen('doubleTap', function (point) {
                    var initialZoomLevel = pswp.currItem.initialZoomLevel;
                    if (pswp.getZoomLevel() !== initialZoomLevel) {
                        pswp.zoomTo(initialZoomLevel, point, 333);
                    } else {
                        pswp.zoomTo(_options.getDoubleTapZoom(false, pswp.currItem), point, 333);
                    }
                });

                // Allow text selection in caption
                _listen('preventDragEvent', function (e, isDown, preventObj) {
                    var t = e.target || e.srcElement;
                    if (
                        t &&
                        t.getAttribute('class') && e.type.indexOf('mouse') > -1 &&
                        (t.getAttribute('class').indexOf('__caption') > 0 || (/(SMALL|STRONG|EM)/i).test(t.tagName))
                    ) {
                        preventObj.prevent = false;
                    }
                });

                // bind events for UI
                _listen('bindEvents', function () {
                    framework.bind(_controls, 'pswpTap click', _onControlsTap);
                    framework.bind(pswp.scrollWrap, 'pswpTap', ui.onGlobalTap);

                    if (!pswp.likelyTouchDevice) {
                        framework.bind(pswp.scrollWrap, 'mouseover', ui.onMouseOver);
                    }
                });

                // unbind events for UI
                _listen('unbindEvents', function () {
                    if (!_shareModalHidden) {
                        _toggleShareModal();
                    }

                    if (_idleInterval) {
                        clearInterval(_idleInterval);
                    }
                    framework.unbind(document, 'mouseout', _onMouseLeaveWindow);
                    framework.unbind(document, 'mousemove', _onIdleMouseMove);
                    framework.unbind(_controls, 'pswpTap click', _onControlsTap);
                    framework.unbind(pswp.scrollWrap, 'pswpTap', ui.onGlobalTap);
                    framework.unbind(pswp.scrollWrap, 'mouseover', ui.onMouseOver);

                    if (_fullscrenAPI) {
                        framework.unbind(document, _fullscrenAPI.eventK, ui.updateFullscreen);
                        if (_fullscrenAPI.isFullscreen()) {
                            _options.hideAnimationDuration = 0;
                            _fullscrenAPI.exit();
                        }
                        _fullscrenAPI = null;
                    }
                });


                // clean up things when gallery is destroyed
                _listen('destroy', function () {
                    if (_options.captionEl) {
                        if (_fakeCaptionContainer) {
                            _controls.removeChild(_fakeCaptionContainer);
                        }
                        framework.removeClass(_captionContainer, 'pswp__caption--empty');
                    }

                    if (_shareModal) {
                        _shareModal.children[0].onclick = null;
                    }
                    framework.removeClass(_controls, 'pswp__ui--over-close');
                    framework.addClass(_controls, 'pswp__ui--hidden');
                    ui.setIdle(false);
                });


                if (!_options.showAnimationDuration) {
                    framework.removeClass(_controls, 'pswp__ui--hidden');
                }
                _listen('initialZoomIn', function () {
                    if (_options.showAnimationDuration) {
                        framework.removeClass(_controls, 'pswp__ui--hidden');
                    }
                });
                _listen('initialZoomOut', function () {
                    framework.addClass(_controls, 'pswp__ui--hidden');
                });

                _listen('parseVerticalMargin', _applyNavBarGaps);

                _setupUIElements();

                if (_options.shareEl && _shareButton && _shareModal) {
                    _shareModalHidden = true;
                }

                _countNumItems();

                _setupIdle();

                _setupFullscreenAPI();

                _setupLoadingIndicator();
            };

            ui.setIdle = function (isIdle) {
                _isIdle = isIdle;
                _togglePswpClass(_controls, 'ui--idle', isIdle);
            };

            ui.update = function () {
                // Don't update UI if it's hidden
                if (_controlsVisible && pswp.currItem) {

                    ui.updateIndexIndicator();

                    if (_options.captionEl) {
                        _options.addCaptionHTMLFn(pswp.currItem, _captionContainer);

                        _togglePswpClass(_captionContainer, 'caption--empty', !pswp.currItem.title);
                    }

                    _overlayUIUpdated = true;

                } else {
                    _overlayUIUpdated = false;
                }

                if (!_shareModalHidden) {
                    _toggleShareModal();
                }

                _countNumItems();
            };

            ui.updateFullscreen = function (e) {

                if (e) {
                    // some browsers change window scroll position during the fullscreen
                    // so PhotoSwipe updates it just in case
                    setTimeout(function () {
                        pswp.setScrollOffset(0, framework.getScrollY());
                    }, 50);
                }

                // toogle pswp--fs class on root element
                framework[(_fullscrenAPI.isFullscreen() ? 'add' : 'remove') + 'Class'](pswp.template, 'pswp--fs');
            };

            ui.updateIndexIndicator = function () {
                if (_options.counterEl) {
                    _indexIndicator.innerHTML = (pswp.getCurrentIndex() + 1) +
                        _options.indexIndicatorSep +
                        _options.getNumItemsFn();
                }
            };

            ui.onGlobalTap = function (e) {
                e = e || window.event;
                var target = e.target || e.srcElement;

                if (_blockControlsTap) {
                    return;
                }

                if (e.detail && e.detail.pointerType === 'mouse') {

                    // close gallery if clicked outside of the image
                    if (_hasCloseClass(target)) {
                        pswp.close();
                        return;
                    }

                    if (framework.hasClass(target, 'pswp__img')) {
                        if (pswp.getZoomLevel() === 1 && pswp.getZoomLevel() <= pswp.currItem.fitRatio) {
                            if (_options.clickToCloseNonZoomable) {
                                pswp.close();
                            }
                        } else {
                            pswp.toggleDesktopZoom(e.detail.releasePoint);
                        }
                    }

                } else {

                    // tap anywhere (except buttons) to toggle visibility of controls
                    if (_options.tapToToggleControls) {
                        if (_controlsVisible) {
                            ui.hideControls();
                        } else {
                            ui.showControls();
                        }
                    }

                    // tap to close gallery
                    if (_options.tapToClose && (framework.hasClass(target, 'pswp__img') || _hasCloseClass(target))) {
                        pswp.close();
                        return;
                    }

                }
            };
            ui.onMouseOver = function (e) {
                e = e || window.event;
                var target = e.target || e.srcElement;

                // add class when mouse is over an element that should close the gallery
                _togglePswpClass(_controls, 'ui--over-close', _hasCloseClass(target));
            };

            ui.hideControls = function () {
                framework.addClass(_controls, 'pswp__ui--hidden');
                _controlsVisible = false;
            };

            ui.showControls = function () {
                _controlsVisible = true;
                if (!_overlayUIUpdated) {
                    ui.update();
                }
                framework.removeClass(_controls, 'pswp__ui--hidden');
            };

            ui.supportsFullscreen = function () {
                var d = document;
                return !!(d.exitFullscreen || d.mozCancelFullScreen || d.webkitExitFullscreen || d.msExitFullscreen);
            };

            ui.getFullscreenAPI = function () {
                var dE = document.documentElement,
                    api,
                    tF = 'fullscreenchange';

                if (dE.requestFullscreen) {
                    api = {
                        enterK: 'requestFullscreen',
                        exitK: 'exitFullscreen',
                        elementK: 'fullscreenElement',
                        eventK: tF
                    };

                } else if (dE.mozRequestFullScreen) {
                    api = {
                        enterK: 'mozRequestFullScreen',
                        exitK: 'mozCancelFullScreen',
                        elementK: 'mozFullScreenElement',
                        eventK: 'moz' + tF
                    };



                } else if (dE.webkitRequestFullscreen) {
                    api = {
                        enterK: 'webkitRequestFullscreen',
                        exitK: 'webkitExitFullscreen',
                        elementK: 'webkitFullscreenElement',
                        eventK: 'webkit' + tF
                    };

                } else if (dE.msRequestFullscreen) {
                    api = {
                        enterK: 'msRequestFullscreen',
                        exitK: 'msExitFullscreen',
                        elementK: 'msFullscreenElement',
                        eventK: 'MSFullscreenChange'
                    };
                }

                if (api) {
                    api.enter = function () {
                        // disable close-on-scroll in fullscreen
                        _initalCloseOnScrollValue = _options.closeOnScroll;
                        _options.closeOnScroll = false;

                        if (this.enterK === 'webkitRequestFullscreen') {
                            pswp.template[this.enterK](Element.ALLOW_KEYBOARD_INPUT);
                        } else {
                            return pswp.template[this.enterK]();
                        }
                    };
                    api.exit = function () {
                        _options.closeOnScroll = _initalCloseOnScrollValue;

                        return document[this.exitK]();

                    };
                    api.isFullscreen = function () {
                        return document[this.elementK];
                    };
                }

                return api;
            };



        };
    return PhotoSwipeUI_Default;


});
} catch (e) {
console.error('Error in file:/templates/archi/js/photoswipe-ui-default.min.js; Error:' + e.message);
};
try {
/*! PhotoSwipe - v4.1.3 - 2019-01-08
 * http://photoswipe.com
 * Copyright (c) 2019 Dmitry Semenov; */
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        define(factory);
    } else if (typeof exports === 'object') {
        module.exports = factory();
    } else {
        root.PhotoSwipe = factory();
    }
})(this, function () {

    'use strict';
    var PhotoSwipe = function (template, UiClass, items, options) {

        /*>>framework-bridge*/
        /**
         *
         * Set of generic functions used by gallery.
         * 
         * You're free to modify anything here as long as functionality is kept.
         * 
         */
        var framework = {
            features: null,
            bind: function (target, type, listener, unbind) {
                var methodName = (unbind ? 'remove' : 'add') + 'EventListener';
                type = type.split(' ');
                for (var i = 0; i < type.length; i++) {
                    if (type[i]) {
                        target[methodName](type[i], listener, false);
                    }
                }
            },
            isArray: function (obj) {
                return (obj instanceof Array);
            },
            createEl: function (classes, tag) {
                var el = document.createElement(tag || 'div');
                if (classes) {
                    el.className = classes;
                }
                return el;
            },
            getScrollY: function () {
                var yOffset = window.pageYOffset;
                return yOffset !== undefined ? yOffset : document.documentElement.scrollTop;
            },
            unbind: function (target, type, listener) {
                framework.bind(target, type, listener, true);
            },
            removeClass: function (el, className) {
                var reg = new RegExp('(\\s|^)' + className + '(\\s|$)');
                el.className = el.className.replace(reg, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
            },
            addClass: function (el, className) {
                if (!framework.hasClass(el, className)) {
                    el.className += (el.className ? ' ' : '') + className;
                }
            },
            hasClass: function (el, className) {
                return el.className && new RegExp('(^|\\s)' + className + '(\\s|$)').test(el.className);
            },
            getChildByClass: function (parentEl, childClassName) {
                var node = parentEl.firstChild;
                while (node) {
                    if (framework.hasClass(node, childClassName)) {
                        return node;
                    }
                    node = node.nextSibling;
                }
            },
            arraySearch: function (array, value, key) {
                var i = array.length;
                while (i--) {
                    if (array[i][key] === value) {
                        return i;
                    }
                }
                return -1;
            },
            extend: function (o1, o2, preventOverwrite) {
                for (var prop in o2) {
                    if (o2.hasOwnProperty(prop)) {
                        if (preventOverwrite && o1.hasOwnProperty(prop)) {
                            continue;
                        }
                        o1[prop] = o2[prop];
                    }
                }
            },
            easing: {
                sine: {
                    out: function (k) {
                        return Math.sin(k * (Math.PI / 2));
                    },
                    inOut: function (k) {
                        return -(Math.cos(Math.PI * k) - 1) / 2;
                    }
                },
                cubic: {
                    out: function (k) {
                        return --k * k * k + 1;
                    }
                }
                /*
                	elastic: {
                		out: function ( k ) {

                			var s, a = 0.1, p = 0.4;
                			if ( k === 0 ) return 0;
                			if ( k === 1 ) return 1;
                			if ( !a || a < 1 ) { a = 1; s = p / 4; }
                			else s = p * Math.asin( 1 / a ) / ( 2 * Math.PI );
                			return ( a * Math.pow( 2, - 10 * k) * Math.sin( ( k - s ) * ( 2 * Math.PI ) / p ) + 1 );

                		},
                	},
                	back: {
                		out: function ( k ) {
                			var s = 1.70158;
                			return --k * k * ( ( s + 1 ) * k + s ) + 1;
                		}
                	}
                */
            },

            /**
             * 
             * @return {object}
             * 
             * {
             *  raf : request animation frame function
             *  caf : cancel animation frame function
             *  transfrom : transform property key (with vendor), or null if not supported
             *  oldIE : IE8 or below
             * }
             * 
             */
            detectFeatures: function () {
                if (framework.features) {
                    return framework.features;
                }
                var helperEl = framework.createEl(),
                    helperStyle = helperEl.style,
                    vendor = '',
                    features = {};

                // IE8 and below
                features.oldIE = document.all && !document.addEventListener;

                features.touch = 'ontouchstart' in window;

                if (window.requestAnimationFrame) {
                    features.raf = window.requestAnimationFrame;
                    features.caf = window.cancelAnimationFrame;
                }

                features.pointerEvent = !!(window.PointerEvent) || navigator.msPointerEnabled;

                // fix false-positive detection of old Android in new IE
                // (IE11 ua string contains "Android 4.0")

                if (!features.pointerEvent) {

                    var ua = navigator.userAgent;

                    // Detect if device is iPhone or iPod and if it's older than iOS 8
                    // http://stackoverflow.com/a/14223920
                    // 
                    // This detection is made because of buggy top/bottom toolbars
                    // that don't trigger window.resize event.
                    // For more info refer to _isFixedPosition variable in core.js

                    if (/iP(hone|od)/.test(navigator.platform)) {
                        var v = (navigator.appVersion).match(/OS (\d+)_(\d+)_?(\d+)?/);
                        if (v && v.length > 0) {
                            v = parseInt(v[1], 10);
                            if (v >= 1 && v < 8) {
                                features.isOldIOSPhone = true;
                            }
                        }
                    }

                    // Detect old Android (before KitKat)
                    // due to bugs related to position:fixed
                    // http://stackoverflow.com/questions/7184573/pick-up-the-android-version-in-the-browser-by-javascript

                    var match = ua.match(/Android\s([0-9\.]*)/);
                    var androidversion = match ? match[1] : 0;
                    androidversion = parseFloat(androidversion);
                    if (androidversion >= 1) {
                        if (androidversion < 4.4) {
                            features.isOldAndroid = true; // for fixed position bug & performance
                        }
                        features.androidVersion = androidversion; // for touchend bug
                    }
                    features.isMobileOpera = /opera mini|opera mobi/i.test(ua);

                    // p.s. yes, yes, UA sniffing is bad, propose your solution for above bugs.
                }

                var styleChecks = ['transform', 'perspective', 'animationName'],
                    vendors = ['', 'webkit', 'Moz', 'ms', 'O'],
                    styleCheckItem,
                    styleName;

                for (var i = 0; i < 4; i++) {
                    vendor = vendors[i];

                    for (var a = 0; a < 3; a++) {
                        styleCheckItem = styleChecks[a];

                        // uppercase first letter of property name, if vendor is present
                        styleName = vendor + (vendor ?
                            styleCheckItem.charAt(0).toUpperCase() + styleCheckItem.slice(1) :
                            styleCheckItem);

                        if (!features[styleCheckItem] && styleName in helperStyle) {
                            features[styleCheckItem] = styleName;
                        }
                    }

                    if (vendor && !features.raf) {
                        vendor = vendor.toLowerCase();
                        features.raf = window[vendor + 'RequestAnimationFrame'];
                        if (features.raf) {
                            features.caf = window[vendor + 'CancelAnimationFrame'] ||
                                window[vendor + 'CancelRequestAnimationFrame'];
                        }
                    }
                }

                if (!features.raf) {
                    var lastTime = 0;
                    features.raf = function (fn) {
                        var currTime = new Date().getTime();
                        var timeToCall = Math.max(0, 16 - (currTime - lastTime));
                        var id = window.setTimeout(function () {
                            fn(currTime + timeToCall);
                        }, timeToCall);
                        lastTime = currTime + timeToCall;
                        return id;
                    };
                    features.caf = function (id) {
                        clearTimeout(id);
                    };
                }

                // Detect SVG support
                features.svg = !!document.createElementNS &&
                    !!document.createElementNS('http://www.w3.org/2000/svg', 'svg').createSVGRect;

                framework.features = features;

                return features;
            }
        };

        framework.detectFeatures();

        // Override addEventListener for old versions of IE
        if (framework.features.oldIE) {

            framework.bind = function (target, type, listener, unbind) {

                type = type.split(' ');

                var methodName = (unbind ? 'detach' : 'attach') + 'Event',
                    evName,
                    _handleEv = function () {
                        listener.handleEvent.call(listener);
                    };

                for (var i = 0; i < type.length; i++) {
                    evName = type[i];
                    if (evName) {

                        if (typeof listener === 'object' && listener.handleEvent) {
                            if (!unbind) {
                                listener['oldIE' + evName] = _handleEv;
                            } else {
                                if (!listener['oldIE' + evName]) {
                                    return false;
                                }
                            }

                            target[methodName]('on' + evName, listener['oldIE' + evName]);
                        } else {
                            target[methodName]('on' + evName, listener);
                        }

                    }
                }
            };

        }

        /*>>framework-bridge*/

        /*>>core*/
        //function(template, UiClass, items, options)

        var self = this;

        /**
         * Static vars, don't change unless you know what you're doing.
         */
        var DOUBLE_TAP_RADIUS = 25,
            NUM_HOLDERS = 3;

        /**
         * Options
         */
        var _options = {
          allowPanToNext: true,
          spacing: 0.12,
          bgOpacity: 1,
          mouseUsed: false,
          loop: true,
          pinchToClose: true,
          closeOnScroll: true,
          closeOnVerticalDrag: true,
          verticalDragRange: 0.75,
          hideAnimationDuration: 333,
          showAnimationDuration: 333,
          showHideOpacity: false,
          focus: true,
          escKey: true,
          arrowKeys: true,
          mainScrollEndFriction: 0.35,
          panEndFriction: 0.35,
          isClickableElement: function (el) {
            return el.tagName === "A";
          },
          getDoubleTapZoom: function (isMouseClick, item) {
            if (isMouseClick) {
              return 1;
            } else {
              // return item.initialZoomLevel < 0.7 ? 1 : 1.33;
              return item.initialZoomLevel < 0.7 ? 1 : 1;
            }
          },
        //   maxSpreadZoom: 1.33,
          maxSpreadZoom: 1,
          modal: true,

          // not fully implemented yet
          scaleMode: "fit", // TODO
        };
        framework.extend(_options, options);


        /**
         * Private helper variables & functions
         */

        var _getEmptyPoint = function () {
            return {
                x: 0,
                y: 0
            };
        };

        var _isOpen,
            _isDestroying,
            _closedByScroll,
            _currentItemIndex,
            _containerStyle,
            _containerShiftIndex,
            _currPanDist = _getEmptyPoint(),
            _startPanOffset = _getEmptyPoint(),
            _panOffset = _getEmptyPoint(),
            _upMoveEvents, // drag move, drag end & drag cancel events array
            _downEvents, // drag start events array
            _globalEventHandlers,
            _viewportSize = {},
            _currZoomLevel,
            _startZoomLevel,
            _translatePrefix,
            _translateSufix,
            _updateSizeInterval,
            _itemsNeedUpdate,
            _currPositionIndex = 0,
            _offset = {},
            _slideSize = _getEmptyPoint(), // size of slide area, including spacing
            _itemHolders,
            _prevItemIndex,
            _indexDiff = 0, // difference of indexes since last content update
            _dragStartEvent,
            _dragMoveEvent,
            _dragEndEvent,
            _dragCancelEvent,
            _transformKey,
            _pointerEventEnabled,
            _isFixedPosition = true,
            _likelyTouchDevice,
            _modules = [],
            _requestAF,
            _cancelAF,
            _initalClassName,
            _initalWindowScrollY,
            _oldIE,
            _currentWindowScrollY,
            _features,
            _windowVisibleSize = {},
            _renderMaxResolution = false,
            _orientationChangeTimeout,


            // Registers PhotoSWipe module (History, Controller ...)
            _registerModule = function (name, module) {
                framework.extend(self, module.publicMethods);
                _modules.push(name);
            },

            _getLoopedId = function (index) {
                var numSlides = _getNumItems();
                if (index > numSlides - 1) {
                    return index - numSlides;
                } else if (index < 0) {
                    return numSlides + index;
                }
                return index;
            },

            // Micro bind/trigger
            _listeners = {},
            _listen = function (name, fn) {
                if (!_listeners[name]) {
                    _listeners[name] = [];
                }
                return _listeners[name].push(fn);
            },
            _shout = function (name) {
                var listeners = _listeners[name];

                if (listeners) {
                    var args = Array.prototype.slice.call(arguments);
                    args.shift();

                    for (var i = 0; i < listeners.length; i++) {
                        listeners[i].apply(self, args);
                    }
                }
            },

            _getCurrentTime = function () {
                return new Date().getTime();
            },
            _applyBgOpacity = function (opacity) {
                _bgOpacity = opacity;
                self.bg.style.opacity = opacity * _options.bgOpacity;
            },

            _applyZoomTransform = function (styleObj, x, y, zoom, item) {
                if (!_renderMaxResolution || (item && item !== self.currItem)) {
                    zoom = zoom / (item ? item.fitRatio : self.currItem.fitRatio);
                }

                styleObj[_transformKey] = _translatePrefix + x + 'px, ' + y + 'px' + _translateSufix + ' scale(' + zoom + ')';
            },
            _applyCurrentZoomPan = function (allowRenderResolution) {
                if (_currZoomElementStyle) {

                    if (allowRenderResolution) {
                        if (_currZoomLevel > self.currItem.fitRatio) {
                            if (!_renderMaxResolution) {
                                _setImageSize(self.currItem, false, true);
                                _renderMaxResolution = true;
                            }
                        } else {
                            if (_renderMaxResolution) {
                                _setImageSize(self.currItem);
                                _renderMaxResolution = false;
                            }
                        }
                    }


                    _applyZoomTransform(_currZoomElementStyle, _panOffset.x, _panOffset.y, _currZoomLevel);
                }
            },
            _applyZoomPanToItem = function (item) {
                if (item.container) {

                    _applyZoomTransform(item.container.style,
                        item.initialPosition.x,
                        item.initialPosition.y,
                        item.initialZoomLevel,
                        item);
                }
            },
            _setTranslateX = function (x, elStyle) {
                elStyle[_transformKey] = _translatePrefix + x + 'px, 0px' + _translateSufix;
            },
            _moveMainScroll = function (x, dragging) {

                if (!_options.loop && dragging) {
                    var newSlideIndexOffset = _currentItemIndex + (_slideSize.x * _currPositionIndex - x) / _slideSize.x,
                        delta = Math.round(x - _mainScrollPos.x);

                    if ((newSlideIndexOffset < 0 && delta > 0) ||
                        (newSlideIndexOffset >= _getNumItems() - 1 && delta < 0)) {
                        x = _mainScrollPos.x + delta * _options.mainScrollEndFriction;
                    }
                }

                _mainScrollPos.x = x;
                _setTranslateX(x, _containerStyle);
            },
            _calculatePanOffset = function (axis, zoomLevel) {
                var m = _midZoomPoint[axis] - _offset[axis];
                return _startPanOffset[axis] + _currPanDist[axis] + m - m * (zoomLevel / _startZoomLevel);
            },

            _equalizePoints = function (p1, p2) {
                p1.x = p2.x;
                p1.y = p2.y;
                if (p2.id) {
                    p1.id = p2.id;
                }
            },
            _roundPoint = function (p) {
                p.x = Math.round(p.x);
                p.y = Math.round(p.y);
            },

            _mouseMoveTimeout = null,
            _onFirstMouseMove = function () {
                // Wait until mouse move event is fired at least twice during 100ms
                // We do this, because some mobile browsers trigger it on touchstart
                if (_mouseMoveTimeout) {
                    framework.unbind(document, 'mousemove', _onFirstMouseMove);
                    framework.addClass(template, 'pswp--has_mouse');
                    _options.mouseUsed = true;
                    _shout('mouseUsed');
                }
                _mouseMoveTimeout = setTimeout(function () {
                    _mouseMoveTimeout = null;
                }, 100);
            },

            _bindEvents = function () {
                framework.bind(document, 'keydown', self);

                if (_features.transform) {
                    // don't bind click event in browsers that don't support transform (mostly IE8)
                    framework.bind(self.scrollWrap, 'click', self);
                }


                if (!_options.mouseUsed) {
                    framework.bind(document, 'mousemove', _onFirstMouseMove);
                }

                framework.bind(window, 'resize scroll orientationchange', self);

                _shout('bindEvents');
            },

            _unbindEvents = function () {
                framework.unbind(window, 'resize scroll orientationchange', self);
                framework.unbind(window, 'scroll', _globalEventHandlers.scroll);
                framework.unbind(document, 'keydown', self);
                framework.unbind(document, 'mousemove', _onFirstMouseMove);

                if (_features.transform) {
                    framework.unbind(self.scrollWrap, 'click', self);
                }

                if (_isDragging) {
                    framework.unbind(window, _upMoveEvents, self);
                }

                clearTimeout(_orientationChangeTimeout);

                _shout('unbindEvents');
            },

            _calculatePanBounds = function (zoomLevel, update) {
                var bounds = _calculateItemSize(self.currItem, _viewportSize, zoomLevel);
                if (update) {
                    _currPanBounds = bounds;
                }
                return bounds;
            },

            _getMinZoomLevel = function (item) {
                if (!item) {
                    item = self.currItem;
                }
                return item.initialZoomLevel;
            },
            _getMaxZoomLevel = function (item) {
                if (!item) {
                    item = self.currItem;
                }
                return item.w > 0 ? _options.maxSpreadZoom : 1;
            },

            // Return true if offset is out of the bounds
            _modifyDestPanOffset = function (axis, destPanBounds, destPanOffset, destZoomLevel) {
                if (destZoomLevel === self.currItem.initialZoomLevel) {
                    destPanOffset[axis] = self.currItem.initialPosition[axis];
                    return true;
                } else {
                    destPanOffset[axis] = _calculatePanOffset(axis, destZoomLevel);

                    if (destPanOffset[axis] > destPanBounds.min[axis]) {
                        destPanOffset[axis] = destPanBounds.min[axis];
                        return true;
                    } else if (destPanOffset[axis] < destPanBounds.max[axis]) {
                        destPanOffset[axis] = destPanBounds.max[axis];
                        return true;
                    }
                }
                return false;
            },

            _setupTransforms = function () {

                if (_transformKey) {
                    // setup 3d transforms
                    var allow3dTransform = _features.perspective && !_likelyTouchDevice;
                    _translatePrefix = 'translate' + (allow3dTransform ? '3d(' : '(');
                    _translateSufix = _features.perspective ? ', 0px)' : ')';
                    return;
                }

                // Override zoom/pan/move functions in case old browser is used (most likely IE)
                // (so they use left/top/width/height, instead of CSS transform)

                _transformKey = 'left';
                framework.addClass(template, 'pswp--ie');

                _setTranslateX = function (x, elStyle) {
                    elStyle.left = x + 'px';
                };
                _applyZoomPanToItem = function (item) {

                    var zoomRatio = item.fitRatio > 1 ? 1 : item.fitRatio,
                        s = item.container.style,
                        w = zoomRatio * item.w,
                        h = zoomRatio * item.h;

                    s.width = w + 'px';
                    s.height = h + 'px';
                    s.left = item.initialPosition.x + 'px';
                    s.top = item.initialPosition.y + 'px';

                };
                _applyCurrentZoomPan = function () {
                    if (_currZoomElementStyle) {

                        var s = _currZoomElementStyle,
                            item = self.currItem,
                            zoomRatio = item.fitRatio > 1 ? 1 : item.fitRatio,
                            w = zoomRatio * item.w,
                            h = zoomRatio * item.h;

                        s.width = w + 'px';
                        s.height = h + 'px';


                        s.left = _panOffset.x + 'px';
                        s.top = _panOffset.y + 'px';
                    }

                };
            },

            _onKeyDown = function (e) {
                var keydownAction = '';
                if (_options.escKey && e.keyCode === 27) {
                    keydownAction = 'close';
                } else if (_options.arrowKeys) {
                    if (e.keyCode === 37) {
                        keydownAction = 'prev';
                    } else if (e.keyCode === 39) {
                        keydownAction = 'next';
                    }
                }

                if (keydownAction) {
                    // don't do anything if special key pressed to prevent from overriding default browser actions
                    // e.g. in Chrome on Mac cmd+arrow-left returns to previous page
                    if (!e.ctrlKey && !e.altKey && !e.shiftKey && !e.metaKey) {
                        if (e.preventDefault) {
                            e.preventDefault();
                        } else {
                            e.returnValue = false;
                        }
                        self[keydownAction]();
                    }
                }
            },

            _onGlobalClick = function (e) {
                if (!e) {
                    return;
                }

                // don't allow click event to pass through when triggering after drag or some other gesture
                if (_moved || _zoomStarted || _mainScrollAnimating || _verticalDragInitiated) {
                    e.preventDefault();
                    e.stopPropagation();
                }
            },

            _updatePageScrollOffset = function () {
                self.setScrollOffset(0, framework.getScrollY());
            };







        // Micro animation engine
        var _animations = {},
            _numAnimations = 0,
            _stopAnimation = function (name) {
                if (_animations[name]) {
                    if (_animations[name].raf) {
                        _cancelAF(_animations[name].raf);
                    }
                    _numAnimations--;
                    delete _animations[name];
                }
            },
            _registerStartAnimation = function (name) {
                if (_animations[name]) {
                    _stopAnimation(name);
                }
                if (!_animations[name]) {
                    _numAnimations++;
                    _animations[name] = {};
                }
            },
            _stopAllAnimations = function () {
                for (var prop in _animations) {

                    if (_animations.hasOwnProperty(prop)) {
                        _stopAnimation(prop);
                    }

                }
            },
            _animateProp = function (name, b, endProp, d, easingFn, onUpdate, onComplete) {
                var startAnimTime = _getCurrentTime(),
                    t;
                _registerStartAnimation(name);

                var animloop = function () {
                    if (_animations[name]) {

                        t = _getCurrentTime() - startAnimTime; // time diff
                        //b - beginning (start prop)
                        //d - anim duration

                        if (t >= d) {
                            _stopAnimation(name);
                            onUpdate(endProp);
                            if (onComplete) {
                                onComplete();
                            }
                            return;
                        }
                        onUpdate((endProp - b) * easingFn(t / d) + b);

                        _animations[name].raf = _requestAF(animloop);
                    }
                };
                animloop();
            };



        var publicMethods = {

            // make a few local variables and functions public
            shout: _shout,
            listen: _listen,
            viewportSize: _viewportSize,
            options: _options,

            isMainScrollAnimating: function () {
                return _mainScrollAnimating;
            },
            getZoomLevel: function () {
                return _currZoomLevel;
            },
            getCurrentIndex: function () {
                return _currentItemIndex;
            },
            isDragging: function () {
                return _isDragging;
            },
            isZooming: function () {
                return _isZooming;
            },
            setScrollOffset: function (x, y) {
                _offset.x = x;
                _currentWindowScrollY = _offset.y = y;
                _shout('updateScrollOffset', _offset);
            },
            applyZoomPan: function (zoomLevel, panX, panY, allowRenderResolution) {
                _panOffset.x = panX;
                _panOffset.y = panY;
                _currZoomLevel = zoomLevel;
                _applyCurrentZoomPan(allowRenderResolution);
            },

            init: function () {

                if (_isOpen || _isDestroying) {
                    return;
                }

                var i;

                self.framework = framework; // basic functionality
                self.template = template; // root DOM element of PhotoSwipe
                self.bg = framework.getChildByClass(template, 'pswp__bg');

                _initalClassName = template.className;
                _isOpen = true;

                _features = framework.detectFeatures();
                _requestAF = _features.raf;
                _cancelAF = _features.caf;
                _transformKey = _features.transform;
                _oldIE = _features.oldIE;

                self.scrollWrap = framework.getChildByClass(template, 'pswp__scroll-wrap');
                self.container = framework.getChildByClass(self.scrollWrap, 'pswp__container');

                _containerStyle = self.container.style; // for fast access

                // Objects that hold slides (there are only 3 in DOM)
                self.itemHolders = _itemHolders = [{
                        el: self.container.children[0],
                        wrap: 0,
                        index: -1
                    },
                    {
                        el: self.container.children[1],
                        wrap: 0,
                        index: -1
                    },
                    {
                        el: self.container.children[2],
                        wrap: 0,
                        index: -1
                    }
                ];

                // hide nearby item holders until initial zoom animation finishes (to avoid extra Paints)
                _itemHolders[0].el.style.display = _itemHolders[2].el.style.display = 'none';

                _setupTransforms();

                // Setup global events
                _globalEventHandlers = {
                    resize: self.updateSize,

                    // Fixes: iOS 10.3 resize event
                    // does not update scrollWrap.clientWidth instantly after resize
                    // https://github.com/dimsemenov/PhotoSwipe/issues/1315
                    orientationchange: function () {
                        clearTimeout(_orientationChangeTimeout);
                        _orientationChangeTimeout = setTimeout(function () {
                            if (_viewportSize.x !== self.scrollWrap.clientWidth) {
                                self.updateSize();
                            }
                        }, 500);
                    },
                    scroll: _updatePageScrollOffset,
                    keydown: _onKeyDown,
                    click: _onGlobalClick
                };

                // disable show/hide effects on old browsers that don't support CSS animations or transforms, 
                // old IOS, Android and Opera mobile. Blackberry seems to work fine, even older models.
                var oldPhone = _features.isOldIOSPhone || _features.isOldAndroid || _features.isMobileOpera;
                if (!_features.animationName || !_features.transform || oldPhone) {
                    _options.showAnimationDuration = _options.hideAnimationDuration = 0;
                }

                // init modules
                for (i = 0; i < _modules.length; i++) {
                    self['init' + _modules[i]]();
                }

                // init
                if (UiClass) {
                    var ui = self.ui = new UiClass(self, framework);
                    ui.init();
                }

                _shout('firstUpdate');
                _currentItemIndex = _currentItemIndex || _options.index || 0;
                // validate index
                if (isNaN(_currentItemIndex) || _currentItemIndex < 0 || _currentItemIndex >= _getNumItems()) {
                    _currentItemIndex = 0;
                }
                self.currItem = _getItemAt(_currentItemIndex);


                if (_features.isOldIOSPhone || _features.isOldAndroid) {
                    _isFixedPosition = false;
                }

                template.setAttribute('aria-hidden', 'false');
                if (_options.modal) {
                    if (!_isFixedPosition) {
                        template.style.position = 'absolute';
                        template.style.top = framework.getScrollY() + 'px';
                    } else {
                        template.style.position = 'fixed';
                    }
                }

                if (_currentWindowScrollY === undefined) {
                    _shout('initialLayout');
                    _currentWindowScrollY = _initalWindowScrollY = framework.getScrollY();
                }

                // add classes to root element of PhotoSwipe
                var rootClasses = 'pswp--open ';
                if (_options.mainClass) {
                    rootClasses += _options.mainClass + ' ';
                }
                if (_options.showHideOpacity) {
                    rootClasses += 'pswp--animate_opacity ';
                }
                rootClasses += _likelyTouchDevice ? 'pswp--touch' : 'pswp--notouch';
                rootClasses += _features.animationName ? ' pswp--css_animation' : '';
                rootClasses += _features.svg ? ' pswp--svg' : '';
                framework.addClass(template, rootClasses);

                self.updateSize();

                // initial update
                _containerShiftIndex = -1;
                _indexDiff = null;
                for (i = 0; i < NUM_HOLDERS; i++) {
                    _setTranslateX((i + _containerShiftIndex) * _slideSize.x, _itemHolders[i].el.style);
                }

                if (!_oldIE) {
                    framework.bind(self.scrollWrap, _downEvents, self); // no dragging for old IE
                }

                _listen('initialZoomInEnd', function () {
                    self.setContent(_itemHolders[0], _currentItemIndex - 1);
                    self.setContent(_itemHolders[2], _currentItemIndex + 1);

                    _itemHolders[0].el.style.display = _itemHolders[2].el.style.display = 'block';

                    if (_options.focus) {
                        // focus causes layout, 
                        // which causes lag during the animation, 
                        // that's why we delay it untill the initial zoom transition ends
                        template.focus();
                    }


                    _bindEvents();
                });

                // set content for center slide (first time)
                self.setContent(_itemHolders[1], _currentItemIndex);

                self.updateCurrItem();

                _shout('afterInit');

                if (!_isFixedPosition) {

                    // On all versions of iOS lower than 8.0, we check size of viewport every second.
                    // 
                    // This is done to detect when Safari top & bottom bars appear, 
                    // as this action doesn't trigger any events (like resize). 
                    // 
                    // On iOS8 they fixed this.
                    // 
                    // 10 Nov 2014: iOS 7 usage ~40%. iOS 8 usage 56%.

                    _updateSizeInterval = setInterval(function () {
                        if (!_numAnimations && !_isDragging && !_isZooming && (_currZoomLevel === self.currItem.initialZoomLevel)) {
                            self.updateSize();
                        }
                    }, 1000);
                }

                framework.addClass(template, 'pswp--visible');
            },

            // Close the gallery, then destroy it
            close: function () {
                if (!_isOpen) {
                    return;
                }

                _isOpen = false;
                _isDestroying = true;
                _shout('close');
                _unbindEvents();

                _showOrHide(self.currItem, null, true, self.destroy);
            },

            // destroys the gallery (unbinds events, cleans up intervals and timeouts to avoid memory leaks)
            destroy: function () {
                _shout('destroy');

                if (_showOrHideTimeout) {
                    clearTimeout(_showOrHideTimeout);
                }

                template.setAttribute('aria-hidden', 'true');
                template.className = _initalClassName;

                if (_updateSizeInterval) {
                    clearInterval(_updateSizeInterval);
                }

                framework.unbind(self.scrollWrap, _downEvents, self);

                // we unbind scroll event at the end, as closing animation may depend on it
                framework.unbind(window, 'scroll', self);

                _stopDragUpdateLoop();

                _stopAllAnimations();

                _listeners = null;
            },

            /**
             * Pan image to position
             * @param {Number} x     
             * @param {Number} y     
             * @param {Boolean} force Will ignore bounds if set to true.
             */
            panTo: function (x, y, force) {
                if (!force) {
                    if (x > _currPanBounds.min.x) {
                        x = _currPanBounds.min.x;
                    } else if (x < _currPanBounds.max.x) {
                        x = _currPanBounds.max.x;
                    }

                    if (y > _currPanBounds.min.y) {
                        y = _currPanBounds.min.y;
                    } else if (y < _currPanBounds.max.y) {
                        y = _currPanBounds.max.y;
                    }
                }

                _panOffset.x = x;
                _panOffset.y = y;
                _applyCurrentZoomPan();
            },

            handleEvent: function (e) {
                e = e || window.event;
                if (_globalEventHandlers[e.type]) {
                    _globalEventHandlers[e.type](e);
                }
            },


            goTo: function (index) {

                index = _getLoopedId(index);

                var diff = index - _currentItemIndex;
                _indexDiff = diff;

                _currentItemIndex = index;
                self.currItem = _getItemAt(_currentItemIndex);
                _currPositionIndex -= diff;

                _moveMainScroll(_slideSize.x * _currPositionIndex);


                _stopAllAnimations();
                _mainScrollAnimating = false;

                self.updateCurrItem();
            },
            next: function () {
                self.goTo(_currentItemIndex + 1);
            },
            prev: function () {
                self.goTo(_currentItemIndex - 1);
            },

            // update current zoom/pan objects
            updateCurrZoomItem: function (emulateSetContent) {
                if (emulateSetContent) {
                    _shout('beforeChange', 0);
                }

                // itemHolder[1] is middle (current) item
                if (_itemHolders[1].el.children.length) {
                    var zoomElement = _itemHolders[1].el.children[0];
                    if (framework.hasClass(zoomElement, 'pswp__zoom-wrap')) {
                        _currZoomElementStyle = zoomElement.style;
                    } else {
                        _currZoomElementStyle = null;
                    }
                } else {
                    _currZoomElementStyle = null;
                }

                _currPanBounds = self.currItem.bounds;
                _startZoomLevel = _currZoomLevel = self.currItem.initialZoomLevel;

                _panOffset.x = _currPanBounds.center.x;
                _panOffset.y = _currPanBounds.center.y;

                if (emulateSetContent) {
                    _shout('afterChange');
                }
            },


            invalidateCurrItems: function () {
                _itemsNeedUpdate = true;
                for (var i = 0; i < NUM_HOLDERS; i++) {
                    if (_itemHolders[i].item) {
                        _itemHolders[i].item.needsUpdate = true;
                    }
                }
            },

            updateCurrItem: function (beforeAnimation) {

                if (_indexDiff === 0) {
                    return;
                }

                var diffAbs = Math.abs(_indexDiff),
                    tempHolder;

                if (beforeAnimation && diffAbs < 2) {
                    return;
                }


                self.currItem = _getItemAt(_currentItemIndex);
                _renderMaxResolution = false;

                _shout('beforeChange', _indexDiff);

                if (diffAbs >= NUM_HOLDERS) {
                    _containerShiftIndex += _indexDiff + (_indexDiff > 0 ? -NUM_HOLDERS : NUM_HOLDERS);
                    diffAbs = NUM_HOLDERS;
                }
                for (var i = 0; i < diffAbs; i++) {
                    if (_indexDiff > 0) {
                        tempHolder = _itemHolders.shift();
                        _itemHolders[NUM_HOLDERS - 1] = tempHolder; // move first to last

                        _containerShiftIndex++;
                        _setTranslateX((_containerShiftIndex + 2) * _slideSize.x, tempHolder.el.style);
                        self.setContent(tempHolder, _currentItemIndex - diffAbs + i + 1 + 1);
                    } else {
                        tempHolder = _itemHolders.pop();
                        _itemHolders.unshift(tempHolder); // move last to first

                        _containerShiftIndex--;
                        _setTranslateX(_containerShiftIndex * _slideSize.x, tempHolder.el.style);
                        self.setContent(tempHolder, _currentItemIndex + diffAbs - i - 1 - 1);
                    }

                }

                // reset zoom/pan on previous item
                if (_currZoomElementStyle && Math.abs(_indexDiff) === 1) {

                    var prevItem = _getItemAt(_prevItemIndex);
                    if (prevItem.initialZoomLevel !== _currZoomLevel) {
                        _calculateItemSize(prevItem, _viewportSize);
                        _setImageSize(prevItem);
                        _applyZoomPanToItem(prevItem);
                    }

                }

                // reset diff after update
                _indexDiff = 0;

                self.updateCurrZoomItem();

                _prevItemIndex = _currentItemIndex;

                _shout('afterChange');

            },



            updateSize: function (force) {

                if (!_isFixedPosition && _options.modal) {
                    var windowScrollY = framework.getScrollY();
                    if (_currentWindowScrollY !== windowScrollY) {
                        template.style.top = windowScrollY + 'px';
                        _currentWindowScrollY = windowScrollY;
                    }
                    if (!force && _windowVisibleSize.x === window.innerWidth && _windowVisibleSize.y === window.innerHeight) {
                        return;
                    }
                    _windowVisibleSize.x = window.innerWidth;
                    _windowVisibleSize.y = window.innerHeight;

                    //template.style.width = _windowVisibleSize.x + 'px';
                    template.style.height = _windowVisibleSize.y + 'px';
                }



                _viewportSize.x = self.scrollWrap.clientWidth;
                _viewportSize.y = self.scrollWrap.clientHeight;

                _updatePageScrollOffset();

                _slideSize.x = _viewportSize.x + Math.round(_viewportSize.x * _options.spacing);
                _slideSize.y = _viewportSize.y;

                _moveMainScroll(_slideSize.x * _currPositionIndex);

                _shout('beforeResize'); // even may be used for example to switch image sources


                // don't re-calculate size on inital size update
                if (_containerShiftIndex !== undefined) {

                    var holder,
                        item,
                        hIndex;

                    for (var i = 0; i < NUM_HOLDERS; i++) {
                        holder = _itemHolders[i];
                        _setTranslateX((i + _containerShiftIndex) * _slideSize.x, holder.el.style);

                        hIndex = _currentItemIndex + i - 1;

                        if (_options.loop && _getNumItems() > 2) {
                            hIndex = _getLoopedId(hIndex);
                        }

                        // update zoom level on items and refresh source (if needsUpdate)
                        item = _getItemAt(hIndex);

                        // re-render gallery item if `needsUpdate`,
                        // or doesn't have `bounds` (entirely new slide object)
                        if (item && (_itemsNeedUpdate || item.needsUpdate || !item.bounds)) {

                            self.cleanSlide(item);

                            self.setContent(holder, hIndex);

                            // if "center" slide
                            if (i === 1) {
                                self.currItem = item;
                                self.updateCurrZoomItem(true);
                            }

                            item.needsUpdate = false;

                        } else if (holder.index === -1 && hIndex >= 0) {
                            // add content first time
                            self.setContent(holder, hIndex);
                        }
                        if (item && item.container) {
                            _calculateItemSize(item, _viewportSize);
                            _setImageSize(item);
                            _applyZoomPanToItem(item);
                        }

                    }
                    _itemsNeedUpdate = false;
                }

                _startZoomLevel = _currZoomLevel = self.currItem.initialZoomLevel;
                _currPanBounds = self.currItem.bounds;

                if (_currPanBounds) {
                    _panOffset.x = _currPanBounds.center.x;
                    _panOffset.y = _currPanBounds.center.y;
                    _applyCurrentZoomPan(true);
                }

                _shout('resize');
            },

            // Zoom current item to
            zoomTo: function (destZoomLevel, centerPoint, speed, easingFn, updateFn) {
                /*
                	if(destZoomLevel === 'fit') {
                		destZoomLevel = self.currItem.fitRatio;
                	} else if(destZoomLevel === 'fill') {
                		destZoomLevel = self.currItem.fillRatio;
                	}
                */

                if (centerPoint) {
                    _startZoomLevel = _currZoomLevel;
                    _midZoomPoint.x = Math.abs(centerPoint.x) - _panOffset.x;
                    _midZoomPoint.y = Math.abs(centerPoint.y) - _panOffset.y;
                    _equalizePoints(_startPanOffset, _panOffset);
                }

                var destPanBounds = _calculatePanBounds(destZoomLevel, false),
                    destPanOffset = {};

                _modifyDestPanOffset('x', destPanBounds, destPanOffset, destZoomLevel);
                _modifyDestPanOffset('y', destPanBounds, destPanOffset, destZoomLevel);

                var initialZoomLevel = _currZoomLevel;
                var initialPanOffset = {
                    x: _panOffset.x,
                    y: _panOffset.y
                };

                _roundPoint(destPanOffset);

                var onUpdate = function (now) {
                    if (now === 1) {
                        _currZoomLevel = destZoomLevel;
                        _panOffset.x = destPanOffset.x;
                        _panOffset.y = destPanOffset.y;
                    } else {
                        _currZoomLevel = (destZoomLevel - initialZoomLevel) * now + initialZoomLevel;
                        _panOffset.x = (destPanOffset.x - initialPanOffset.x) * now + initialPanOffset.x;
                        _panOffset.y = (destPanOffset.y - initialPanOffset.y) * now + initialPanOffset.y;
                    }

                    if (updateFn) {
                        updateFn(now);
                    }

                    _applyCurrentZoomPan(now === 1);
                };

                if (speed) {
                    _animateProp('customZoomTo', 0, 1, speed, easingFn || framework.easing.sine.inOut, onUpdate);
                } else {
                    onUpdate(1);
                }
            }


        };


        /*>>core*/

        /*>>gestures*/
        /**
         * Mouse/touch/pointer event handlers.
         * 
         * separated from @core.js for readability
         */

        var MIN_SWIPE_DISTANCE = 30,
            DIRECTION_CHECK_OFFSET = 10; // amount of pixels to drag to determine direction of swipe

        var _gestureStartTime,
            _gestureCheckSpeedTime,

            // pool of objects that are used during dragging of zooming
            p = {}, // first point
            p2 = {}, // second point (for zoom gesture)
            delta = {},
            _currPoint = {},
            _startPoint = {},
            _currPointers = [],
            _startMainScrollPos = {},
            _releaseAnimData,
            _posPoints = [], // array of points during dragging, used to determine type of gesture
            _tempPoint = {},

            _isZoomingIn,
            _verticalDragInitiated,
            _oldAndroidTouchEndTimeout,
            _currZoomedItemIndex = 0,
            _centerPoint = _getEmptyPoint(),
            _lastReleaseTime = 0,
            _isDragging, // at least one pointer is down
            _isMultitouch, // at least two _pointers are down
            _zoomStarted, // zoom level changed during zoom gesture
            _moved,
            _dragAnimFrame,
            _mainScrollShifted,
            _currentPoints, // array of current touch points
            _isZooming,
            _currPointsDistance,
            _startPointsDistance,
            _currPanBounds,
            _mainScrollPos = _getEmptyPoint(),
            _currZoomElementStyle,
            _mainScrollAnimating, // true, if animation after swipe gesture is running
            _midZoomPoint = _getEmptyPoint(),
            _currCenterPoint = _getEmptyPoint(),
            _direction,
            _isFirstMove,
            _opacityChanged,
            _bgOpacity,
            _wasOverInitialZoom,

            _isEqualPoints = function (p1, p2) {
                return p1.x === p2.x && p1.y === p2.y;
            },
            _isNearbyPoints = function (touch0, touch1) {
                return Math.abs(touch0.x - touch1.x) < DOUBLE_TAP_RADIUS && Math.abs(touch0.y - touch1.y) < DOUBLE_TAP_RADIUS;
            },
            _calculatePointsDistance = function (p1, p2) {
                _tempPoint.x = Math.abs(p1.x - p2.x);
                _tempPoint.y = Math.abs(p1.y - p2.y);
                return Math.sqrt(_tempPoint.x * _tempPoint.x + _tempPoint.y * _tempPoint.y);
            },
            _stopDragUpdateLoop = function () {
                if (_dragAnimFrame) {
                    _cancelAF(_dragAnimFrame);
                    _dragAnimFrame = null;
                }
            },
            _dragUpdateLoop = function () {
                if (_isDragging) {
                    _dragAnimFrame = _requestAF(_dragUpdateLoop);
                    _renderMovement();
                }
            },
            _canPan = function () {
                return !(_options.scaleMode === 'fit' && _currZoomLevel === self.currItem.initialZoomLevel);
            },

            // find the closest parent DOM element
            _closestElement = function (el, fn) {
                if (!el || el === document) {
                    return false;
                }

                // don't search elements above pswp__scroll-wrap
                if (el.getAttribute('class') && el.getAttribute('class').indexOf('pswp__scroll-wrap') > -1) {
                    return false;
                }

                if (fn(el)) {
                    return el;
                }

                return _closestElement(el.parentNode, fn);
            },

            _preventObj = {},
            _preventDefaultEventBehaviour = function (e, isDown) {
                _preventObj.prevent = !_closestElement(e.target, _options.isClickableElement);

                _shout('preventDragEvent', e, isDown, _preventObj);
                return _preventObj.prevent;

            },
            _convertTouchToPoint = function (touch, p) {
                p.x = touch.pageX;
                p.y = touch.pageY;
                p.id = touch.identifier;
                return p;
            },
            _findCenterOfPoints = function (p1, p2, pCenter) {
                pCenter.x = (p1.x + p2.x) * 0.5;
                pCenter.y = (p1.y + p2.y) * 0.5;
            },
            _pushPosPoint = function (time, x, y) {
                if (time - _gestureCheckSpeedTime > 50) {
                    var o = _posPoints.length > 2 ? _posPoints.shift() : {};
                    o.x = x;
                    o.y = y;
                    _posPoints.push(o);
                    _gestureCheckSpeedTime = time;
                }
            },

            _calculateVerticalDragOpacityRatio = function () {
                var yOffset = _panOffset.y - self.currItem.initialPosition.y; // difference between initial and current position
                return 1 - Math.abs(yOffset / (_viewportSize.y / 2));
            },


            // points pool, reused during touch events
            _ePoint1 = {},
            _ePoint2 = {},
            _tempPointsArr = [],
            _tempCounter,
            _getTouchPoints = function (e) {
                // clean up previous points, without recreating array
                while (_tempPointsArr.length > 0) {
                    _tempPointsArr.pop();
                }

                if (!_pointerEventEnabled) {
                    if (e.type.indexOf('touch') > -1) {

                        if (e.touches && e.touches.length > 0) {
                            _tempPointsArr[0] = _convertTouchToPoint(e.touches[0], _ePoint1);
                            if (e.touches.length > 1) {
                                _tempPointsArr[1] = _convertTouchToPoint(e.touches[1], _ePoint2);
                            }
                        }

                    } else {
                        _ePoint1.x = e.pageX;
                        _ePoint1.y = e.pageY;
                        _ePoint1.id = '';
                        _tempPointsArr[0] = _ePoint1; //_ePoint1;
                    }
                } else {
                    _tempCounter = 0;
                    // we can use forEach, as pointer events are supported only in modern browsers
                    _currPointers.forEach(function (p) {
                        if (_tempCounter === 0) {
                            _tempPointsArr[0] = p;
                        } else if (_tempCounter === 1) {
                            _tempPointsArr[1] = p;
                        }
                        _tempCounter++;

                    });
                }
                return _tempPointsArr;
            },

            _panOrMoveMainScroll = function (axis, delta) {

                var panFriction,
                    overDiff = 0,
                    newOffset = _panOffset[axis] + delta[axis],
                    startOverDiff,
                    dir = delta[axis] > 0,
                    newMainScrollPosition = _mainScrollPos.x + delta.x,
                    mainScrollDiff = _mainScrollPos.x - _startMainScrollPos.x,
                    newPanPos,
                    newMainScrollPos;

                // calculate fdistance over the bounds and friction
                if (newOffset > _currPanBounds.min[axis] || newOffset < _currPanBounds.max[axis]) {
                    panFriction = _options.panEndFriction;
                    // Linear increasing of friction, so at 1/4 of viewport it's at max value. 
                    // Looks not as nice as was expected. Left for history.
                    // panFriction = (1 - (_panOffset[axis] + delta[axis] + panBounds.min[axis]) / (_viewportSize[axis] / 4) );
                } else {
                    panFriction = 1;
                }

                newOffset = _panOffset[axis] + delta[axis] * panFriction;

                // move main scroll or start panning
                if (_options.allowPanToNext || _currZoomLevel === self.currItem.initialZoomLevel) {


                    if (!_currZoomElementStyle) {

                        newMainScrollPos = newMainScrollPosition;

                    } else if (_direction === 'h' && axis === 'x' && !_zoomStarted) {

                        if (dir) {
                            if (newOffset > _currPanBounds.min[axis]) {
                                panFriction = _options.panEndFriction;
                                overDiff = _currPanBounds.min[axis] - newOffset;
                                startOverDiff = _currPanBounds.min[axis] - _startPanOffset[axis];
                            }

                            // drag right
                            if ((startOverDiff <= 0 || mainScrollDiff < 0) && _getNumItems() > 1) {
                                newMainScrollPos = newMainScrollPosition;
                                if (mainScrollDiff < 0 && newMainScrollPosition > _startMainScrollPos.x) {
                                    newMainScrollPos = _startMainScrollPos.x;
                                }
                            } else {
                                if (_currPanBounds.min.x !== _currPanBounds.max.x) {
                                    newPanPos = newOffset;
                                }

                            }

                        } else {

                            if (newOffset < _currPanBounds.max[axis]) {
                                panFriction = _options.panEndFriction;
                                overDiff = newOffset - _currPanBounds.max[axis];
                                startOverDiff = _startPanOffset[axis] - _currPanBounds.max[axis];
                            }

                            if ((startOverDiff <= 0 || mainScrollDiff > 0) && _getNumItems() > 1) {
                                newMainScrollPos = newMainScrollPosition;

                                if (mainScrollDiff > 0 && newMainScrollPosition < _startMainScrollPos.x) {
                                    newMainScrollPos = _startMainScrollPos.x;
                                }

                            } else {
                                if (_currPanBounds.min.x !== _currPanBounds.max.x) {
                                    newPanPos = newOffset;
                                }
                            }

                        }


                        //
                    }

                    if (axis === 'x') {

                        if (newMainScrollPos !== undefined) {
                            _moveMainScroll(newMainScrollPos, true);
                            if (newMainScrollPos === _startMainScrollPos.x) {
                                _mainScrollShifted = false;
                            } else {
                                _mainScrollShifted = true;
                            }
                        }

                        if (_currPanBounds.min.x !== _currPanBounds.max.x) {
                            if (newPanPos !== undefined) {
                                _panOffset.x = newPanPos;
                            } else if (!_mainScrollShifted) {
                                _panOffset.x += delta.x * panFriction;
                            }
                        }

                        return newMainScrollPos !== undefined;
                    }

                }

                if (!_mainScrollAnimating) {

                    if (!_mainScrollShifted) {
                        if (_currZoomLevel > self.currItem.fitRatio) {
                            _panOffset[axis] += delta[axis] * panFriction;

                        }
                    }


                }

            },

            // Pointerdown/touchstart/mousedown handler
            _onDragStart = function (e) {

                // Allow dragging only via left mouse button.
                // As this handler is not added in IE8 - we ignore e.which
                // 
                // http://www.quirksmode.org/js/events_properties.html
                // https://developer.mozilla.org/en-US/docs/Web/API/event.button
                if (e.type === 'mousedown' && e.button > 0) {
                    return;
                }

                if (_initialZoomRunning) {
                    e.preventDefault();
                    return;
                }

                if (_oldAndroidTouchEndTimeout && e.type === 'mousedown') {
                    return;
                }

                if (_preventDefaultEventBehaviour(e, true)) {
                    e.preventDefault();
                }



                _shout('pointerDown');

                if (_pointerEventEnabled) {
                    var pointerIndex = framework.arraySearch(_currPointers, e.pointerId, 'id');
                    if (pointerIndex < 0) {
                        pointerIndex = _currPointers.length;
                    }
                    _currPointers[pointerIndex] = {
                        x: e.pageX,
                        y: e.pageY,
                        id: e.pointerId
                    };
                }



                var startPointsList = _getTouchPoints(e),
                    numPoints = startPointsList.length;

                _currentPoints = null;

                _stopAllAnimations();

                // init drag
                if (!_isDragging || numPoints === 1) {



                    _isDragging = _isFirstMove = true;
                    framework.bind(window, _upMoveEvents, self);

                    _isZoomingIn =
                        _wasOverInitialZoom =
                        _opacityChanged =
                        _verticalDragInitiated =
                        _mainScrollShifted =
                        _moved =
                        _isMultitouch =
                        _zoomStarted = false;

                    _direction = null;

                    _shout('firstTouchStart', startPointsList);

                    _equalizePoints(_startPanOffset, _panOffset);

                    _currPanDist.x = _currPanDist.y = 0;
                    _equalizePoints(_currPoint, startPointsList[0]);
                    _equalizePoints(_startPoint, _currPoint);

                    //_equalizePoints(_startMainScrollPos, _mainScrollPos);
                    _startMainScrollPos.x = _slideSize.x * _currPositionIndex;

                    _posPoints = [{
                        x: _currPoint.x,
                        y: _currPoint.y
                    }];

                    _gestureCheckSpeedTime = _gestureStartTime = _getCurrentTime();

                    //_mainScrollAnimationEnd(true);
                    _calculatePanBounds(_currZoomLevel, true);

                    // Start rendering
                    _stopDragUpdateLoop();
                    _dragUpdateLoop();

                }

                // init zoom
                if (!_isZooming && numPoints > 1 && !_mainScrollAnimating && !_mainScrollShifted) {
                    _startZoomLevel = _currZoomLevel;
                    _zoomStarted = false; // true if zoom changed at least once

                    _isZooming = _isMultitouch = true;
                    _currPanDist.y = _currPanDist.x = 0;

                    _equalizePoints(_startPanOffset, _panOffset);

                    _equalizePoints(p, startPointsList[0]);
                    _equalizePoints(p2, startPointsList[1]);

                    _findCenterOfPoints(p, p2, _currCenterPoint);

                    _midZoomPoint.x = Math.abs(_currCenterPoint.x) - _panOffset.x;
                    _midZoomPoint.y = Math.abs(_currCenterPoint.y) - _panOffset.y;
                    _currPointsDistance = _startPointsDistance = _calculatePointsDistance(p, p2);
                }


            },

            // Pointermove/touchmove/mousemove handler
            _onDragMove = function (e) {

                e.preventDefault();

                if (_pointerEventEnabled) {
                    var pointerIndex = framework.arraySearch(_currPointers, e.pointerId, 'id');
                    if (pointerIndex > -1) {
                        var p = _currPointers[pointerIndex];
                        p.x = e.pageX;
                        p.y = e.pageY;
                    }
                }

                if (_isDragging) {
                    var touchesList = _getTouchPoints(e);
                    if (!_direction && !_moved && !_isZooming) {

                        if (_mainScrollPos.x !== _slideSize.x * _currPositionIndex) {
                            // if main scroll position is shifted â€“ direction is always horizontal
                            _direction = 'h';
                        } else {
                            var diff = Math.abs(touchesList[0].x - _currPoint.x) - Math.abs(touchesList[0].y - _currPoint.y);
                            // check the direction of movement
                            if (Math.abs(diff) >= DIRECTION_CHECK_OFFSET) {
                                _direction = diff > 0 ? 'h' : 'v';
                                _currentPoints = touchesList;
                            }
                        }

                    } else {
                        _currentPoints = touchesList;
                    }
                }
            },
            // 
            _renderMovement = function () {

                if (!_currentPoints) {
                    return;
                }

                var numPoints = _currentPoints.length;

                if (numPoints === 0) {
                    return;
                }

                _equalizePoints(p, _currentPoints[0]);

                delta.x = p.x - _currPoint.x;
                delta.y = p.y - _currPoint.y;

                if (_isZooming && numPoints > 1) {
                    // Handle behaviour for more than 1 point

                    _currPoint.x = p.x;
                    _currPoint.y = p.y;

                    // check if one of two points changed
                    if (!delta.x && !delta.y && _isEqualPoints(_currentPoints[1], p2)) {
                        return;
                    }

                    _equalizePoints(p2, _currentPoints[1]);


                    if (!_zoomStarted) {
                        _zoomStarted = true;
                        _shout('zoomGestureStarted');
                    }

                    // Distance between two points
                    var pointsDistance = _calculatePointsDistance(p, p2);

                    var zoomLevel = _calculateZoomLevel(pointsDistance);

                    // slightly over the of initial zoom level
                    if (zoomLevel > self.currItem.initialZoomLevel + self.currItem.initialZoomLevel / 15) {
                        _wasOverInitialZoom = true;
                    }

                    // Apply the friction if zoom level is out of the bounds
                    var zoomFriction = 1,
                        minZoomLevel = _getMinZoomLevel(),
                        maxZoomLevel = _getMaxZoomLevel();

                    if (zoomLevel < minZoomLevel) {

                        if (_options.pinchToClose && !_wasOverInitialZoom && _startZoomLevel <= self.currItem.initialZoomLevel) {
                            // fade out background if zooming out
                            var minusDiff = minZoomLevel - zoomLevel;
                            var percent = 1 - minusDiff / (minZoomLevel / 1.2);

                            _applyBgOpacity(percent);
                            _shout('onPinchClose', percent);
                            _opacityChanged = true;
                        } else {
                            zoomFriction = (minZoomLevel - zoomLevel) / minZoomLevel;
                            if (zoomFriction > 1) {
                                zoomFriction = 1;
                            }
                            zoomLevel = minZoomLevel - zoomFriction * (minZoomLevel / 3);
                        }

                    } else if (zoomLevel > maxZoomLevel) {
                        // 1.5 - extra zoom level above the max. E.g. if max is x6, real max 6 + 1.5 = 7.5
                        zoomFriction = (zoomLevel - maxZoomLevel) / (minZoomLevel * 6);
                        if (zoomFriction > 1) {
                            zoomFriction = 1;
                        }
                        zoomLevel = maxZoomLevel + zoomFriction * minZoomLevel;
                    }

                    if (zoomFriction < 0) {
                        zoomFriction = 0;
                    }

                    // distance between touch points after friction is applied
                    _currPointsDistance = pointsDistance;

                    // _centerPoint - The point in the middle of two pointers
                    _findCenterOfPoints(p, p2, _centerPoint);

                    // paning with two pointers pressed
                    _currPanDist.x += _centerPoint.x - _currCenterPoint.x;
                    _currPanDist.y += _centerPoint.y - _currCenterPoint.y;
                    _equalizePoints(_currCenterPoint, _centerPoint);

                    _panOffset.x = _calculatePanOffset('x', zoomLevel);
                    _panOffset.y = _calculatePanOffset('y', zoomLevel);

                    _isZoomingIn = zoomLevel > _currZoomLevel;
                    _currZoomLevel = zoomLevel;
                    _applyCurrentZoomPan();

                } else {

                    // handle behaviour for one point (dragging or panning)

                    if (!_direction) {
                        return;
                    }

                    if (_isFirstMove) {
                        _isFirstMove = false;

                        // subtract drag distance that was used during the detection direction  

                        if (Math.abs(delta.x) >= DIRECTION_CHECK_OFFSET) {
                            delta.x -= _currentPoints[0].x - _startPoint.x;
                        }

                        if (Math.abs(delta.y) >= DIRECTION_CHECK_OFFSET) {
                            delta.y -= _currentPoints[0].y - _startPoint.y;
                        }
                    }

                    _currPoint.x = p.x;
                    _currPoint.y = p.y;

                    // do nothing if pointers position hasn't changed
                    if (delta.x === 0 && delta.y === 0) {
                        return;
                    }

                    if (_direction === 'v' && _options.closeOnVerticalDrag) {
                        if (!_canPan()) {
                            _currPanDist.y += delta.y;
                            _panOffset.y += delta.y;

                            var opacityRatio = _calculateVerticalDragOpacityRatio();

                            _verticalDragInitiated = true;
                            _shout('onVerticalDrag', opacityRatio);

                            _applyBgOpacity(opacityRatio);
                            _applyCurrentZoomPan();
                            return;
                        }
                    }

                    _pushPosPoint(_getCurrentTime(), p.x, p.y);

                    _moved = true;
                    _currPanBounds = self.currItem.bounds;

                    var mainScrollChanged = _panOrMoveMainScroll('x', delta);
                    if (!mainScrollChanged) {
                        _panOrMoveMainScroll('y', delta);

                        _roundPoint(_panOffset);
                        _applyCurrentZoomPan();
                    }

                }

            },

            // Pointerup/pointercancel/touchend/touchcancel/mouseup event handler
            _onDragRelease = function (e) {

                if (_features.isOldAndroid) {

                    if (_oldAndroidTouchEndTimeout && e.type === 'mouseup') {
                        return;
                    }

                    // on Android (v4.1, 4.2, 4.3 & possibly older) 
                    // ghost mousedown/up event isn't preventable via e.preventDefault,
                    // which causes fake mousedown event
                    // so we block mousedown/up for 600ms
                    if (e.type.indexOf('touch') > -1) {
                        clearTimeout(_oldAndroidTouchEndTimeout);
                        _oldAndroidTouchEndTimeout = setTimeout(function () {
                            _oldAndroidTouchEndTimeout = 0;
                        }, 600);
                    }

                }

                _shout('pointerUp');

                if (_preventDefaultEventBehaviour(e, false)) {
                    e.preventDefault();
                }

                var releasePoint;

                if (_pointerEventEnabled) {
                    var pointerIndex = framework.arraySearch(_currPointers, e.pointerId, 'id');

                    if (pointerIndex > -1) {
                        releasePoint = _currPointers.splice(pointerIndex, 1)[0];

                        if (navigator.msPointerEnabled) {
                            var MSPOINTER_TYPES = {
                                4: 'mouse', // event.MSPOINTER_TYPE_MOUSE
                                2: 'touch', // event.MSPOINTER_TYPE_TOUCH 
                                3: 'pen' // event.MSPOINTER_TYPE_PEN
                            };
                            releasePoint.type = MSPOINTER_TYPES[e.pointerType];

                            if (!releasePoint.type) {
                                releasePoint.type = e.pointerType || 'mouse';
                            }
                        } else {
                            releasePoint.type = e.pointerType || 'mouse';
                        }

                    }
                }

                var touchList = _getTouchPoints(e),
                    gestureType,
                    numPoints = touchList.length;

                if (e.type === 'mouseup') {
                    numPoints = 0;
                }

                // Do nothing if there were 3 touch points or more
                if (numPoints === 2) {
                    _currentPoints = null;
                    return true;
                }

                // if second pointer released
                if (numPoints === 1) {
                    _equalizePoints(_startPoint, touchList[0]);
                }


                // pointer hasn't moved, send "tap release" point
                if (numPoints === 0 && !_direction && !_mainScrollAnimating) {
                    if (!releasePoint) {
                        if (e.type === 'mouseup') {
                            releasePoint = {
                                x: e.pageX,
                                y: e.pageY,
                                type: 'mouse'
                            };
                        } else if (e.changedTouches && e.changedTouches[0]) {
                            releasePoint = {
                                x: e.changedTouches[0].pageX,
                                y: e.changedTouches[0].pageY,
                                type: 'touch'
                            };
                        }
                    }

                    _shout('touchRelease', e, releasePoint);
                }

                // Difference in time between releasing of two last touch points (zoom gesture)
                var releaseTimeDiff = -1;

                // Gesture completed, no pointers left
                if (numPoints === 0) {
                    _isDragging = false;
                    framework.unbind(window, _upMoveEvents, self);

                    _stopDragUpdateLoop();

                    if (_isZooming) {
                        // Two points released at the same time
                        releaseTimeDiff = 0;
                    } else if (_lastReleaseTime !== -1) {
                        releaseTimeDiff = _getCurrentTime() - _lastReleaseTime;
                    }
                }
                _lastReleaseTime = numPoints === 1 ? _getCurrentTime() : -1;

                if (releaseTimeDiff !== -1 && releaseTimeDiff < 150) {
                    gestureType = 'zoom';
                } else {
                    gestureType = 'swipe';
                }

                if (_isZooming && numPoints < 2) {
                    _isZooming = false;

                    // Only second point released
                    if (numPoints === 1) {
                        gestureType = 'zoomPointerUp';
                    }
                    _shout('zoomGestureEnded');
                }

                _currentPoints = null;
                if (!_moved && !_zoomStarted && !_mainScrollAnimating && !_verticalDragInitiated) {
                    // nothing to animate
                    return;
                }

                _stopAllAnimations();


                if (!_releaseAnimData) {
                    _releaseAnimData = _initDragReleaseAnimationData();
                }

                _releaseAnimData.calculateSwipeSpeed('x');


                if (_verticalDragInitiated) {

                    var opacityRatio = _calculateVerticalDragOpacityRatio();

                    if (opacityRatio < _options.verticalDragRange) {
                        self.close();
                    } else {
                        var initalPanY = _panOffset.y,
                            initialBgOpacity = _bgOpacity;

                        _animateProp('verticalDrag', 0, 1, 300, framework.easing.cubic.out, function (now) {

                            _panOffset.y = (self.currItem.initialPosition.y - initalPanY) * now + initalPanY;

                            _applyBgOpacity((1 - initialBgOpacity) * now + initialBgOpacity);
                            _applyCurrentZoomPan();
                        });

                        _shout('onVerticalDrag', 1);
                    }

                    return;
                }


                // main scroll 
                if ((_mainScrollShifted || _mainScrollAnimating) && numPoints === 0) {
                    var itemChanged = _finishSwipeMainScrollGesture(gestureType, _releaseAnimData);
                    if (itemChanged) {
                        return;
                    }
                    gestureType = 'zoomPointerUp';
                }

                // prevent zoom/pan animation when main scroll animation runs
                if (_mainScrollAnimating) {
                    return;
                }

                // Complete simple zoom gesture (reset zoom level if it's out of the bounds)  
                if (gestureType !== 'swipe') {
                    _completeZoomGesture();
                    return;
                }

                // Complete pan gesture if main scroll is not shifted, and it's possible to pan current image
                if (!_mainScrollShifted && _currZoomLevel > self.currItem.fitRatio) {
                    _completePanGesture(_releaseAnimData);
                }
            },


            // Returns object with data about gesture
            // It's created only once and then reused
            _initDragReleaseAnimationData = function () {
                // temp local vars
                var lastFlickDuration,
                    tempReleasePos;

                // s = this
                var s = {
                    lastFlickOffset: {},
                    lastFlickDist: {},
                    lastFlickSpeed: {},
                    slowDownRatio: {},
                    slowDownRatioReverse: {},
                    speedDecelerationRatio: {},
                    speedDecelerationRatioAbs: {},
                    distanceOffset: {},
                    backAnimDestination: {},
                    backAnimStarted: {},
                    calculateSwipeSpeed: function (axis) {


                        if (_posPoints.length > 1) {
                            lastFlickDuration = _getCurrentTime() - _gestureCheckSpeedTime + 50;
                            tempReleasePos = _posPoints[_posPoints.length - 2][axis];
                        } else {
                            lastFlickDuration = _getCurrentTime() - _gestureStartTime; // total gesture duration
                            tempReleasePos = _startPoint[axis];
                        }
                        s.lastFlickOffset[axis] = _currPoint[axis] - tempReleasePos;
                        s.lastFlickDist[axis] = Math.abs(s.lastFlickOffset[axis]);
                        if (s.lastFlickDist[axis] > 20) {
                            s.lastFlickSpeed[axis] = s.lastFlickOffset[axis] / lastFlickDuration;
                        } else {
                            s.lastFlickSpeed[axis] = 0;
                        }
                        if (Math.abs(s.lastFlickSpeed[axis]) < 0.1) {
                            s.lastFlickSpeed[axis] = 0;
                        }

                        s.slowDownRatio[axis] = 0.95;
                        s.slowDownRatioReverse[axis] = 1 - s.slowDownRatio[axis];
                        s.speedDecelerationRatio[axis] = 1;
                    },

                    calculateOverBoundsAnimOffset: function (axis, speed) {
                        if (!s.backAnimStarted[axis]) {

                            if (_panOffset[axis] > _currPanBounds.min[axis]) {
                                s.backAnimDestination[axis] = _currPanBounds.min[axis];

                            } else if (_panOffset[axis] < _currPanBounds.max[axis]) {
                                s.backAnimDestination[axis] = _currPanBounds.max[axis];
                            }

                            if (s.backAnimDestination[axis] !== undefined) {
                                s.slowDownRatio[axis] = 0.7;
                                s.slowDownRatioReverse[axis] = 1 - s.slowDownRatio[axis];
                                if (s.speedDecelerationRatioAbs[axis] < 0.05) {

                                    s.lastFlickSpeed[axis] = 0;
                                    s.backAnimStarted[axis] = true;

                                    _animateProp('bounceZoomPan' + axis, _panOffset[axis],
                                        s.backAnimDestination[axis],
                                        speed || 300,
                                        framework.easing.sine.out,
                                        function (pos) {
                                            _panOffset[axis] = pos;
                                            _applyCurrentZoomPan();
                                        }
                                    );

                                }
                            }
                        }
                    },

                    // Reduces the speed by slowDownRatio (per 10ms)
                    calculateAnimOffset: function (axis) {
                        if (!s.backAnimStarted[axis]) {
                            s.speedDecelerationRatio[axis] = s.speedDecelerationRatio[axis] * (s.slowDownRatio[axis] +
                                s.slowDownRatioReverse[axis] -
                                s.slowDownRatioReverse[axis] * s.timeDiff / 10);

                            s.speedDecelerationRatioAbs[axis] = Math.abs(s.lastFlickSpeed[axis] * s.speedDecelerationRatio[axis]);
                            s.distanceOffset[axis] = s.lastFlickSpeed[axis] * s.speedDecelerationRatio[axis] * s.timeDiff;
                            _panOffset[axis] += s.distanceOffset[axis];

                        }
                    },

                    panAnimLoop: function () {
                        if (_animations.zoomPan) {
                            _animations.zoomPan.raf = _requestAF(s.panAnimLoop);

                            s.now = _getCurrentTime();
                            s.timeDiff = s.now - s.lastNow;
                            s.lastNow = s.now;

                            s.calculateAnimOffset('x');
                            s.calculateAnimOffset('y');

                            _applyCurrentZoomPan();

                            s.calculateOverBoundsAnimOffset('x');
                            s.calculateOverBoundsAnimOffset('y');


                            if (s.speedDecelerationRatioAbs.x < 0.05 && s.speedDecelerationRatioAbs.y < 0.05) {

                                // round pan position
                                _panOffset.x = Math.round(_panOffset.x);
                                _panOffset.y = Math.round(_panOffset.y);
                                _applyCurrentZoomPan();

                                _stopAnimation('zoomPan');
                                return;
                            }
                        }

                    }
                };
                return s;
            },

            _completePanGesture = function (animData) {
                // calculate swipe speed for Y axis (paanning)
                animData.calculateSwipeSpeed('y');

                _currPanBounds = self.currItem.bounds;

                animData.backAnimDestination = {};
                animData.backAnimStarted = {};

                // Avoid acceleration animation if speed is too low
                if (Math.abs(animData.lastFlickSpeed.x) <= 0.05 && Math.abs(animData.lastFlickSpeed.y) <= 0.05) {
                    animData.speedDecelerationRatioAbs.x = animData.speedDecelerationRatioAbs.y = 0;

                    // Run pan drag release animation. E.g. if you drag image and release finger without momentum.
                    animData.calculateOverBoundsAnimOffset('x');
                    animData.calculateOverBoundsAnimOffset('y');
                    return true;
                }

                // Animation loop that controls the acceleration after pan gesture ends
                _registerStartAnimation('zoomPan');
                animData.lastNow = _getCurrentTime();
                animData.panAnimLoop();
            },


            _finishSwipeMainScrollGesture = function (gestureType, _releaseAnimData) {
                var itemChanged;
                if (!_mainScrollAnimating) {
                    _currZoomedItemIndex = _currentItemIndex;
                }



                var itemsDiff;

                if (gestureType === 'swipe') {
                    var totalShiftDist = _currPoint.x - _startPoint.x,
                        isFastLastFlick = _releaseAnimData.lastFlickDist.x < 10;

                    // if container is shifted for more than MIN_SWIPE_DISTANCE, 
                    // and last flick gesture was in right direction
                    if (totalShiftDist > MIN_SWIPE_DISTANCE &&
                        (isFastLastFlick || _releaseAnimData.lastFlickOffset.x > 20)) {
                        // go to prev item
                        itemsDiff = -1;
                    } else if (totalShiftDist < -MIN_SWIPE_DISTANCE &&
                        (isFastLastFlick || _releaseAnimData.lastFlickOffset.x < -20)) {
                        // go to next item
                        itemsDiff = 1;
                    }
                }

                var nextCircle;

                if (itemsDiff) {

                    _currentItemIndex += itemsDiff;

                    if (_currentItemIndex < 0) {
                        _currentItemIndex = _options.loop ? _getNumItems() - 1 : 0;
                        nextCircle = true;
                    } else if (_currentItemIndex >= _getNumItems()) {
                        _currentItemIndex = _options.loop ? 0 : _getNumItems() - 1;
                        nextCircle = true;
                    }

                    if (!nextCircle || _options.loop) {
                        _indexDiff += itemsDiff;
                        _currPositionIndex -= itemsDiff;
                        itemChanged = true;
                    }



                }

                var animateToX = _slideSize.x * _currPositionIndex;
                var animateToDist = Math.abs(animateToX - _mainScrollPos.x);
                var finishAnimDuration;


                if (!itemChanged && animateToX > _mainScrollPos.x !== _releaseAnimData.lastFlickSpeed.x > 0) {
                    // "return to current" duration, e.g. when dragging from slide 0 to -1
                    finishAnimDuration = 333;
                } else {
                    finishAnimDuration = Math.abs(_releaseAnimData.lastFlickSpeed.x) > 0 ?
                        animateToDist / Math.abs(_releaseAnimData.lastFlickSpeed.x) :
                        333;

                    finishAnimDuration = Math.min(finishAnimDuration, 400);
                    finishAnimDuration = Math.max(finishAnimDuration, 250);
                }

                if (_currZoomedItemIndex === _currentItemIndex) {
                    itemChanged = false;
                }

                _mainScrollAnimating = true;

                _shout('mainScrollAnimStart');

                _animateProp('mainScroll', _mainScrollPos.x, animateToX, finishAnimDuration, framework.easing.cubic.out,
                    _moveMainScroll,
                    function () {
                        _stopAllAnimations();
                        _mainScrollAnimating = false;
                        _currZoomedItemIndex = -1;

                        if (itemChanged || _currZoomedItemIndex !== _currentItemIndex) {
                            self.updateCurrItem();
                        }

                        _shout('mainScrollAnimComplete');
                    }
                );

                if (itemChanged) {
                    self.updateCurrItem(true);
                }

                return itemChanged;
            },

            _calculateZoomLevel = function (touchesDistance) {
                return 1 / _startPointsDistance * touchesDistance * _startZoomLevel;
            },

            // Resets zoom if it's out of bounds
            _completeZoomGesture = function () {
                var destZoomLevel = _currZoomLevel,
                    minZoomLevel = _getMinZoomLevel(),
                    maxZoomLevel = _getMaxZoomLevel();

                if (_currZoomLevel < minZoomLevel) {
                    destZoomLevel = minZoomLevel;
                } else if (_currZoomLevel > maxZoomLevel) {
                    destZoomLevel = maxZoomLevel;
                }

                var destOpacity = 1,
                    onUpdate,
                    initialOpacity = _bgOpacity;

                if (_opacityChanged && !_isZoomingIn && !_wasOverInitialZoom && _currZoomLevel < minZoomLevel) {
                    //_closedByScroll = true;
                    self.close();
                    return true;
                }

                if (_opacityChanged) {
                    onUpdate = function (now) {
                        _applyBgOpacity((destOpacity - initialOpacity) * now + initialOpacity);
                    };
                }

                self.zoomTo(destZoomLevel, 0, 200, framework.easing.cubic.out, onUpdate);
                return true;
            };


        _registerModule('Gestures', {
            publicMethods: {

                initGestures: function () {

                    // helper function that builds touch/pointer/mouse events
                    var addEventNames = function (pref, down, move, up, cancel) {
                        _dragStartEvent = pref + down;
                        _dragMoveEvent = pref + move;
                        _dragEndEvent = pref + up;
                        if (cancel) {
                            _dragCancelEvent = pref + cancel;
                        } else {
                            _dragCancelEvent = '';
                        }
                    };

                    _pointerEventEnabled = _features.pointerEvent;
                    if (_pointerEventEnabled && _features.touch) {
                        // we don't need touch events, if browser supports pointer events
                        _features.touch = false;
                    }

                    if (_pointerEventEnabled) {
                        if (navigator.msPointerEnabled) {
                            // IE10 pointer events are case-sensitive
                            addEventNames('MSPointer', 'Down', 'Move', 'Up', 'Cancel');
                        } else {
                            addEventNames('pointer', 'down', 'move', 'up', 'cancel');
                        }
                    } else if (_features.touch) {
                        addEventNames('touch', 'start', 'move', 'end', 'cancel');
                        _likelyTouchDevice = true;
                    } else {
                        addEventNames('mouse', 'down', 'move', 'up');
                    }

                    _upMoveEvents = _dragMoveEvent + ' ' + _dragEndEvent + ' ' + _dragCancelEvent;
                    _downEvents = _dragStartEvent;

                    if (_pointerEventEnabled && !_likelyTouchDevice) {
                        _likelyTouchDevice = (navigator.maxTouchPoints > 1) || (navigator.msMaxTouchPoints > 1);
                    }
                    // make variable public
                    self.likelyTouchDevice = _likelyTouchDevice;

                    _globalEventHandlers[_dragStartEvent] = _onDragStart;
                    _globalEventHandlers[_dragMoveEvent] = _onDragMove;
                    _globalEventHandlers[_dragEndEvent] = _onDragRelease; // the Kraken

                    if (_dragCancelEvent) {
                        _globalEventHandlers[_dragCancelEvent] = _globalEventHandlers[_dragEndEvent];
                    }

                    // Bind mouse events on device with detected hardware touch support, in case it supports multiple types of input.
                    if (_features.touch) {
                        _downEvents += ' mousedown';
                        _upMoveEvents += ' mousemove mouseup';
                        _globalEventHandlers.mousedown = _globalEventHandlers[_dragStartEvent];
                        _globalEventHandlers.mousemove = _globalEventHandlers[_dragMoveEvent];
                        _globalEventHandlers.mouseup = _globalEventHandlers[_dragEndEvent];
                    }

                    if (!_likelyTouchDevice) {
                        // don't allow pan to next slide from zoomed state on Desktop
                        _options.allowPanToNext = false;
                    }
                }

            }
        });


        /*>>gestures*/

        /*>>show-hide-transition*/
        /**
         * show-hide-transition.js:
         *
         * Manages initial opening or closing transition.
         *
         * If you're not planning to use transition for gallery at all,
         * you may set options hideAnimationDuration and showAnimationDuration to 0,
         * and just delete startAnimation function.
         * 
         */


        var _showOrHideTimeout,
            _showOrHide = function (item, img, out, completeFn) {

                if (_showOrHideTimeout) {
                    clearTimeout(_showOrHideTimeout);
                }

                _initialZoomRunning = true;
                _initialContentSet = true;

                // dimensions of small thumbnail {x:,y:,w:}.
                // Height is optional, as calculated based on large image.
                var thumbBounds;
                if (item.initialLayout) {
                    thumbBounds = item.initialLayout;
                    item.initialLayout = null;
                } else {
                    thumbBounds = _options.getThumbBoundsFn && _options.getThumbBoundsFn(_currentItemIndex);
                }

                var duration = out ? _options.hideAnimationDuration : _options.showAnimationDuration;

                var onComplete = function () {
                    _stopAnimation('initialZoom');
                    if (!out) {
                        _applyBgOpacity(1);
                        if (img) {
                            img.style.display = 'block';
                        }
                        framework.addClass(template, 'pswp--animated-in');
                        _shout('initialZoom' + (out ? 'OutEnd' : 'InEnd'));
                    } else {
                        self.template.removeAttribute('style');
                        self.bg.removeAttribute('style');
                    }

                    if (completeFn) {
                        completeFn();
                    }
                    _initialZoomRunning = false;
                };

                // if bounds aren't provided, just open gallery without animation
                if (!duration || !thumbBounds || thumbBounds.x === undefined) {

                    _shout('initialZoom' + (out ? 'Out' : 'In'));

                    _currZoomLevel = item.initialZoomLevel;
                    _equalizePoints(_panOffset, item.initialPosition);
                    _applyCurrentZoomPan();

                    template.style.opacity = out ? 0 : 1;
                    _applyBgOpacity(1);

                    if (duration) {
                        setTimeout(function () {
                            onComplete();
                        }, duration);
                    } else {
                        onComplete();
                    }

                    return;
                }

                var startAnimation = function () {
                    var closeWithRaf = _closedByScroll,
                        fadeEverything = !self.currItem.src || self.currItem.loadError || _options.showHideOpacity;

                    // apply hw-acceleration to image
                    if (item.miniImg) {
                        item.miniImg.style.webkitBackfaceVisibility = 'hidden';
                    }

                    if (!out) {
                        _currZoomLevel = thumbBounds.w / item.w;
                        _panOffset.x = thumbBounds.x;
                        _panOffset.y = thumbBounds.y - _initalWindowScrollY;

                        self[fadeEverything ? 'template' : 'bg'].style.opacity = 0.001;
                        _applyCurrentZoomPan();
                    }

                    _registerStartAnimation('initialZoom');

                    if (out && !closeWithRaf) {
                        framework.removeClass(template, 'pswp--animated-in');
                    }

                    if (fadeEverything) {
                        if (out) {
                            framework[(closeWithRaf ? 'remove' : 'add') + 'Class'](template, 'pswp--animate_opacity');
                        } else {
                            setTimeout(function () {
                                framework.addClass(template, 'pswp--animate_opacity');
                            }, 30);
                        }
                    }

                    _showOrHideTimeout = setTimeout(function () {

                        _shout('initialZoom' + (out ? 'Out' : 'In'));


                        if (!out) {

                            // "in" animation always uses CSS transitions (instead of rAF).
                            // CSS transition work faster here, 
                            // as developer may also want to animate other things, 
                            // like ui on top of sliding area, which can be animated just via CSS

                            _currZoomLevel = item.initialZoomLevel;
                            _equalizePoints(_panOffset, item.initialPosition);
                            _applyCurrentZoomPan();
                            _applyBgOpacity(1);

                            if (fadeEverything) {
                                template.style.opacity = 1;
                            } else {
                                _applyBgOpacity(1);
                            }

                            _showOrHideTimeout = setTimeout(onComplete, duration + 20);
                        } else {

                            // "out" animation uses rAF only when PhotoSwipe is closed by browser scroll, to recalculate position
                            var destZoomLevel = thumbBounds.w / item.w,
                                initialPanOffset = {
                                    x: _panOffset.x,
                                    y: _panOffset.y
                                },
                                initialZoomLevel = _currZoomLevel,
                                initalBgOpacity = _bgOpacity,
                                onUpdate = function (now) {

                                    if (now === 1) {
                                        _currZoomLevel = destZoomLevel;
                                        _panOffset.x = thumbBounds.x;
                                        _panOffset.y = thumbBounds.y - _currentWindowScrollY;
                                    } else {
                                        _currZoomLevel = (destZoomLevel - initialZoomLevel) * now + initialZoomLevel;
                                        _panOffset.x = (thumbBounds.x - initialPanOffset.x) * now + initialPanOffset.x;
                                        _panOffset.y = (thumbBounds.y - _currentWindowScrollY - initialPanOffset.y) * now + initialPanOffset.y;
                                    }

                                    _applyCurrentZoomPan();
                                    if (fadeEverything) {
                                        template.style.opacity = 1 - now;
                                    } else {
                                        _applyBgOpacity(initalBgOpacity - now * initalBgOpacity);
                                    }
                                };

                            if (closeWithRaf) {
                                _animateProp('initialZoom', 0, 1, duration, framework.easing.cubic.out, onUpdate, onComplete);
                            } else {
                                onUpdate(1);
                                _showOrHideTimeout = setTimeout(onComplete, duration + 20);
                            }
                        }

                    }, out ? 25 : 90); // Main purpose of this delay is to give browser time to paint and
                    // create composite layers of PhotoSwipe UI parts (background, controls, caption, arrows).
                    // Which avoids lag at the beginning of scale transition.
                };
                startAnimation();


            };

        /*>>show-hide-transition*/

        /*>>items-controller*/
        /**
         *
         * Controller manages gallery items, their dimensions, and their content.
         * 
         */

        var _items,
            _tempPanAreaSize = {},
            _imagesToAppendPool = [],
            _initialContentSet,
            _initialZoomRunning,
            _controllerDefaultOptions = {
                index: 0,
                errorMsg: '<div class="pswp__error-msg"><a href="%url%" target="_blank">The image</a> could not be loaded.</div>',
                forceProgressiveLoading: false, // TODO
                preload: [1, 1],
                getNumItemsFn: function () {
                    return _items.length;
                }
            };


        var _getItemAt,
            _getNumItems,
            _initialIsLoop,
            _getZeroBounds = function () {
                return {
                    center: {
                        x: 0,
                        y: 0
                    },
                    max: {
                        x: 0,
                        y: 0
                    },
                    min: {
                        x: 0,
                        y: 0
                    }
                };
            },
            _calculateSingleItemPanBounds = function (item, realPanElementW, realPanElementH) {
                var bounds = item.bounds;

                // position of element when it's centered
                bounds.center.x = Math.round((_tempPanAreaSize.x - realPanElementW) / 2);
                bounds.center.y = Math.round((_tempPanAreaSize.y - realPanElementH) / 2) + item.vGap.top;

                // maximum pan position
                bounds.max.x = (realPanElementW > _tempPanAreaSize.x) ?
                    Math.round(_tempPanAreaSize.x - realPanElementW) :
                    bounds.center.x;

                bounds.max.y = (realPanElementH > _tempPanAreaSize.y) ?
                    Math.round(_tempPanAreaSize.y - realPanElementH) + item.vGap.top :
                    bounds.center.y;

                // minimum pan position
                bounds.min.x = (realPanElementW > _tempPanAreaSize.x) ? 0 : bounds.center.x;
                bounds.min.y = (realPanElementH > _tempPanAreaSize.y) ? item.vGap.top : bounds.center.y;
            },
            _calculateItemSize = function (item, viewportSize, zoomLevel) {

                if (item.src && !item.loadError) {
                    var isInitial = !zoomLevel;

                    if (isInitial) {
                        if (!item.vGap) {
                            item.vGap = {
                                top: 0,
                                bottom: 0
                            };
                        }
                        // allows overriding vertical margin for individual items
                        _shout('parseVerticalMargin', item);
                    }


                    _tempPanAreaSize.x = viewportSize.x;
                    _tempPanAreaSize.y = viewportSize.y - item.vGap.top - item.vGap.bottom;

                    if (isInitial) {
                        var hRatio = _tempPanAreaSize.x / item.w;
                        var vRatio = _tempPanAreaSize.y / item.h;

                        item.fitRatio = hRatio < vRatio ? hRatio : vRatio;
                        //item.fillRatio = hRatio > vRatio ? hRatio : vRatio;

                        var scaleMode = _options.scaleMode;

                        if (scaleMode === 'orig') {
                            zoomLevel = 1;
                        } else if (scaleMode === 'fit') {
                            zoomLevel = item.fitRatio;
                        }

                        if (zoomLevel > 1) {
                            zoomLevel = 1;
                        }

                        item.initialZoomLevel = zoomLevel;

                        if (!item.bounds) {
                            // reuse bounds object
                            item.bounds = _getZeroBounds();
                        }
                    }

                    if (!zoomLevel) {
                        return;
                    }

                    _calculateSingleItemPanBounds(item, item.w * zoomLevel, item.h * zoomLevel);

                    if (isInitial && zoomLevel === item.initialZoomLevel) {
                        item.initialPosition = item.bounds.center;
                    }

                    return item.bounds;
                } else {
                    item.w = item.h = 0;
                    item.initialZoomLevel = item.fitRatio = 1;
                    item.bounds = _getZeroBounds();
                    item.initialPosition = item.bounds.center;

                    // if it's not image, we return zero bounds (content is not zoomable)
                    return item.bounds;
                }

            },




            _appendImage = function (index, item, baseDiv, img, preventAnimation, keepPlaceholder) {


                if (item.loadError) {
                    return;
                }

                if (img) {

                    item.imageAppended = true;
                    _setImageSize(item, img, (item === self.currItem && _renderMaxResolution));

                    baseDiv.appendChild(img);

                    if (keepPlaceholder) {
                        setTimeout(function () {
                            if (item && item.loaded && item.placeholder) {
                                item.placeholder.style.display = 'none';
                                item.placeholder = null;
                            }
                        }, 500);
                    }
                }
            },



            _preloadImage = function (item) {
                item.loading = true;
                item.loaded = false;
                var img = item.img = framework.createEl('pswp__img', 'img');
                var onComplete = function () {
                    item.loading = false;
                    item.loaded = true;

                    if (item.loadComplete) {
                        item.loadComplete(item);
                    } else {
                        item.img = null; // no need to store image object
                    }
                    img.onload = img.onerror = null;
                    img = null;
                };
                img.onload = onComplete;
                img.onerror = function () {
                    item.loadError = true;
                    onComplete();
                };

                img.src = item.src; // + '?a=' + Math.random();

                return img;
            },
            _checkForError = function (item, cleanUp) {
                if (item.src && item.loadError && item.container) {

                    if (cleanUp) {
                        item.container.innerHTML = '';
                    }

                    item.container.innerHTML = _options.errorMsg.replace('%url%', item.src);
                    return true;

                }
            },
            _setImageSize = function (item, img, maxRes) {
                if (!item.src) {
                    return;
                }

                if (!img) {
                    img = item.container.lastChild;
                }

                var w = maxRes ? item.w : Math.round(item.w * item.fitRatio),
                    h = maxRes ? item.h : Math.round(item.h * item.fitRatio);

                if (item.placeholder && !item.loaded) {
                    item.placeholder.style.width = w + 'px';
                    item.placeholder.style.height = h + 'px';
                }

                img.style.width = w + 'px';
                img.style.height = h + 'px';
            },
            _appendImagesPool = function () {

                if (_imagesToAppendPool.length) {
                    var poolItem;

                    for (var i = 0; i < _imagesToAppendPool.length; i++) {
                        poolItem = _imagesToAppendPool[i];
                        if (poolItem.holder.index === poolItem.index) {
                            _appendImage(poolItem.index, poolItem.item, poolItem.baseDiv, poolItem.img, false, poolItem.clearPlaceholder);
                        }
                    }
                    _imagesToAppendPool = [];
                }
            };



        _registerModule('Controller', {

            publicMethods: {

                lazyLoadItem: function (index) {
                    index = _getLoopedId(index);
                    var item = _getItemAt(index);

                    if (!item || ((item.loaded || item.loading) && !_itemsNeedUpdate)) {
                        return;
                    }

                    _shout('gettingData', index, item);

                    if (!item.src) {
                        return;
                    }

                    _preloadImage(item);
                },
                initController: function () {
                    framework.extend(_options, _controllerDefaultOptions, true);
                    self.items = _items = items;
                    _getItemAt = self.getItemAt;
                    _getNumItems = _options.getNumItemsFn; //self.getNumItems;



                    _initialIsLoop = _options.loop;
                    if (_getNumItems() < 3) {
                        _options.loop = false; // disable loop if less then 3 items
                    }

                    _listen('beforeChange', function (diff) {

                        var p = _options.preload,
                            isNext = diff === null ? true : (diff >= 0),
                            preloadBefore = Math.min(p[0], _getNumItems()),
                            preloadAfter = Math.min(p[1], _getNumItems()),
                            i;


                        for (i = 1; i <= (isNext ? preloadAfter : preloadBefore); i++) {
                            self.lazyLoadItem(_currentItemIndex + i);
                        }
                        for (i = 1; i <= (isNext ? preloadBefore : preloadAfter); i++) {
                            self.lazyLoadItem(_currentItemIndex - i);
                        }
                    });

                    _listen('initialLayout', function () {
                        self.currItem.initialLayout = _options.getThumbBoundsFn && _options.getThumbBoundsFn(_currentItemIndex);
                    });

                    _listen('mainScrollAnimComplete', _appendImagesPool);
                    _listen('initialZoomInEnd', _appendImagesPool);



                    _listen('destroy', function () {
                        var item;
                        for (var i = 0; i < _items.length; i++) {
                            item = _items[i];
                            // remove reference to DOM elements, for GC
                            if (item.container) {
                                item.container = null;
                            }
                            if (item.placeholder) {
                                item.placeholder = null;
                            }
                            if (item.img) {
                                item.img = null;
                            }
                            if (item.preloader) {
                                item.preloader = null;
                            }
                            if (item.loadError) {
                                item.loaded = item.loadError = false;
                            }
                        }
                        _imagesToAppendPool = null;
                    });
                },


                getItemAt: function (index) {
                    if (index >= 0) {
                        return _items[index] !== undefined ? _items[index] : false;
                    }
                    return false;
                },

                allowProgressiveImg: function () {
                    // 1. Progressive image loading isn't working on webkit/blink 
                    //    when hw-acceleration (e.g. translateZ) is applied to IMG element.
                    //    That's why in PhotoSwipe parent element gets zoom transform, not image itself.
                    //    
                    // 2. Progressive image loading sometimes blinks in webkit/blink when applying animation to parent element.
                    //    That's why it's disabled on touch devices (mainly because of swipe transition)
                    //    
                    // 3. Progressive image loading sometimes doesn't work in IE (up to 11).

                    // Don't allow progressive loading on non-large touch devices
                    return _options.forceProgressiveLoading || !_likelyTouchDevice || _options.mouseUsed || screen.width > 1200;
                    // 1200 - to eliminate touch devices with large screen (like Chromebook Pixel)
                },

                setContent: function (holder, index) {

                    if (_options.loop) {
                        index = _getLoopedId(index);
                    }

                    var prevItem = self.getItemAt(holder.index);
                    if (prevItem) {
                        prevItem.container = null;
                    }

                    var item = self.getItemAt(index),
                        img;

                    if (!item) {
                        holder.el.innerHTML = '';
                        return;
                    }

                    // allow to override data
                    _shout('gettingData', index, item);

                    holder.index = index;
                    holder.item = item;

                    // base container DIV is created only once for each of 3 holders
                    var baseDiv = item.container = framework.createEl('pswp__zoom-wrap');



                    if (!item.src && item.html) {
                        if (item.html.tagName) {
                            baseDiv.appendChild(item.html);
                        } else {
                            baseDiv.innerHTML = item.html;
                        }
                    }

                    _checkForError(item);

                    _calculateItemSize(item, _viewportSize);

                    if (item.src && !item.loadError && !item.loaded) {

                        item.loadComplete = function (item) {

                            // gallery closed before image finished loading
                            if (!_isOpen) {
                                return;
                            }

                            // check if holder hasn't changed while image was loading
                            if (holder && holder.index === index) {
                                if (_checkForError(item, true)) {
                                    item.loadComplete = item.img = null;
                                    _calculateItemSize(item, _viewportSize);
                                    _applyZoomPanToItem(item);

                                    if (holder.index === _currentItemIndex) {
                                        // recalculate dimensions
                                        self.updateCurrZoomItem();
                                    }
                                    return;
                                }
                                if (!item.imageAppended) {
                                    if (_features.transform && (_mainScrollAnimating || _initialZoomRunning)) {
                                        _imagesToAppendPool.push({
                                            item: item,
                                            baseDiv: baseDiv,
                                            img: item.img,
                                            index: index,
                                            holder: holder,
                                            clearPlaceholder: true
                                        });
                                    } else {
                                        _appendImage(index, item, baseDiv, item.img, _mainScrollAnimating || _initialZoomRunning, true);
                                    }
                                } else {
                                    // remove preloader & mini-img
                                    if (!_initialZoomRunning && item.placeholder) {
                                        item.placeholder.style.display = 'none';
                                        item.placeholder = null;
                                    }
                                }
                            }

                            item.loadComplete = null;
                            item.img = null; // no need to store image element after it's added

                            _shout('imageLoadComplete', index, item);
                        };

                        if (framework.features.transform) {

                            var placeholderClassName = 'pswp__img pswp__img--placeholder';
                            placeholderClassName += (item.msrc ? '' : ' pswp__img--placeholder--blank');

                            var placeholder = framework.createEl(placeholderClassName, item.msrc ? 'img' : '');
                            if (item.msrc) {
                                placeholder.src = item.msrc;
                            }

                            _setImageSize(item, placeholder);

                            baseDiv.appendChild(placeholder);
                            item.placeholder = placeholder;

                        }




                        if (!item.loading) {
                            _preloadImage(item);
                        }


                        if (self.allowProgressiveImg()) {
                            // just append image
                            if (!_initialContentSet && _features.transform) {
                                _imagesToAppendPool.push({
                                    item: item,
                                    baseDiv: baseDiv,
                                    img: item.img,
                                    index: index,
                                    holder: holder
                                });
                            } else {
                                _appendImage(index, item, baseDiv, item.img, true, true);
                            }
                        }

                    } else if (item.src && !item.loadError) {
                        // image object is created every time, due to bugs of image loading & delay when switching images
                        img = framework.createEl('pswp__img', 'img');
                        img.style.opacity = 1;
                        img.src = item.src;
                        _setImageSize(item, img);
                        _appendImage(index, item, baseDiv, img, true);
                    }


                    if (!_initialContentSet && index === _currentItemIndex) {
                        _currZoomElementStyle = baseDiv.style;
                        _showOrHide(item, (img || item.img));
                    } else {
                        _applyZoomPanToItem(item);
                    }

                    holder.el.innerHTML = '';
                    holder.el.appendChild(baseDiv);
                },

                cleanSlide: function (item) {
                    if (item.img) {
                        item.img.onload = item.img.onerror = null;
                    }
                    item.loaded = item.loading = item.img = item.imageAppended = false;
                }

            }
        });

        /*>>items-controller*/

        /*>>tap*/
        /**
         * tap.js:
         *
         * Displatches tap and double-tap events.
         * 
         */

        var tapTimer,
            tapReleasePoint = {},
            _dispatchTapEvent = function (origEvent, releasePoint, pointerType) {
                var e = document.createEvent('CustomEvent'),
                    eDetail = {
                        origEvent: origEvent,
                        target: origEvent.target,
                        releasePoint: releasePoint,
                        pointerType: pointerType || 'touch'
                    };

                e.initCustomEvent('pswpTap', true, true, eDetail);
                origEvent.target.dispatchEvent(e);
            };

        _registerModule('Tap', {
            publicMethods: {
                initTap: function () {
                    _listen('firstTouchStart', self.onTapStart);
                    _listen('touchRelease', self.onTapRelease);
                    _listen('destroy', function () {
                        tapReleasePoint = {};
                        tapTimer = null;
                    });
                },
                onTapStart: function (touchList) {
                    if (touchList.length > 1) {
                        clearTimeout(tapTimer);
                        tapTimer = null;
                    }
                },
                onTapRelease: function (e, releasePoint) {
                    if (!releasePoint) {
                        return;
                    }

                    if (!_moved && !_isMultitouch && !_numAnimations) {
                        var p0 = releasePoint;
                        if (tapTimer) {
                            clearTimeout(tapTimer);
                            tapTimer = null;

                            // Check if taped on the same place
                            if (_isNearbyPoints(p0, tapReleasePoint)) {
                                _shout('doubleTap', p0);
                                return;
                            }
                        }

                        if (releasePoint.type === 'mouse') {
                            _dispatchTapEvent(e, releasePoint, 'mouse');
                            return;
                        }

                        var clickedTagName = e.target.tagName.toUpperCase();
                        // avoid double tap delay on buttons and elements that have class pswp__single-tap
                        if (clickedTagName === 'BUTTON' || framework.hasClass(e.target, 'pswp__single-tap')) {
                            _dispatchTapEvent(e, releasePoint);
                            return;
                        }

                        _equalizePoints(tapReleasePoint, p0);

                        tapTimer = setTimeout(function () {
                            _dispatchTapEvent(e, releasePoint);
                            tapTimer = null;
                        }, 300);
                    }
                }
            }
        });

        /*>>tap*/

        /*>>desktop-zoom*/
        /**
         *
         * desktop-zoom.js:
         *
         * - Binds mousewheel event for paning zoomed image.
         * - Manages "dragging", "zoomed-in", "zoom-out" classes.
         *   (which are used for cursors and zoom icon)
         * - Adds toggleDesktopZoom function.
         * 
         */

        var _wheelDelta;

        _registerModule('DesktopZoom', {

            publicMethods: {

                initDesktopZoom: function () {

                    if (_oldIE) {
                        // no zoom for old IE (<=8)
                        return;
                    }

                    if (_likelyTouchDevice) {
                        // if detected hardware touch support, we wait until mouse is used,
                        // and only then apply desktop-zoom features
                        _listen('mouseUsed', function () {
                            self.setupDesktopZoom();
                        });
                    } else {
                        self.setupDesktopZoom(true);
                    }

                },

                setupDesktopZoom: function (onInit) {

                    _wheelDelta = {};

                    var events = 'wheel mousewheel DOMMouseScroll';

                    _listen('bindEvents', function () {
                        framework.bind(template, events, self.handleMouseWheel);
                    });

                    _listen('unbindEvents', function () {
                        if (_wheelDelta) {
                            framework.unbind(template, events, self.handleMouseWheel);
                        }
                    });

                    self.mouseZoomedIn = false;

                    var hasDraggingClass,
                        updateZoomable = function () {
                            if (self.mouseZoomedIn) {
                                framework.removeClass(template, 'pswp--zoomed-in');
                                self.mouseZoomedIn = false;
                            }
                            if (_currZoomLevel < 1) {
                                framework.addClass(template, 'pswp--zoom-allowed');
                            } else {
                                framework.removeClass(template, 'pswp--zoom-allowed');
                            }
                            removeDraggingClass();
                        },
                        removeDraggingClass = function () {
                            if (hasDraggingClass) {
                                framework.removeClass(template, 'pswp--dragging');
                                hasDraggingClass = false;
                            }
                        };

                    _listen('resize', updateZoomable);
                    _listen('afterChange', updateZoomable);
                    _listen('pointerDown', function () {
                        if (self.mouseZoomedIn) {
                            hasDraggingClass = true;
                            framework.addClass(template, 'pswp--dragging');
                        }
                    });
                    _listen('pointerUp', removeDraggingClass);

                    if (!onInit) {
                        updateZoomable();
                    }

                },

                handleMouseWheel: function (e) {

                    if (_currZoomLevel <= self.currItem.fitRatio) {
                        if (_options.modal) {

                            if (!_options.closeOnScroll || _numAnimations || _isDragging) {
                                e.preventDefault();
                            } else if (_transformKey && Math.abs(e.deltaY) > 2) {
                                // close PhotoSwipe
                                // if browser supports transforms & scroll changed enough
                                _closedByScroll = true;
                                self.close();
                            }

                        }
                        return true;
                    }

                    // allow just one event to fire
                    e.stopPropagation();

                    // https://developer.mozilla.org/en-US/docs/Web/Events/wheel
                    _wheelDelta.x = 0;

                    if ('deltaX' in e) {
                        if (e.deltaMode === 1 /* DOM_DELTA_LINE */ ) {
                            // 18 - average line height
                            _wheelDelta.x = e.deltaX * 18;
                            _wheelDelta.y = e.deltaY * 18;
                        } else {
                            _wheelDelta.x = e.deltaX;
                            _wheelDelta.y = e.deltaY;
                        }
                    } else if ('wheelDelta' in e) {
                        if (e.wheelDeltaX) {
                            _wheelDelta.x = -0.16 * e.wheelDeltaX;
                        }
                        if (e.wheelDeltaY) {
                            _wheelDelta.y = -0.16 * e.wheelDeltaY;
                        } else {
                            _wheelDelta.y = -0.16 * e.wheelDelta;
                        }
                    } else if ('detail' in e) {
                        _wheelDelta.y = e.detail;
                    } else {
                        return;
                    }

                    _calculatePanBounds(_currZoomLevel, true);

                    var newPanX = _panOffset.x - _wheelDelta.x,
                        newPanY = _panOffset.y - _wheelDelta.y;

                    // only prevent scrolling in nonmodal mode when not at edges
                    if (_options.modal ||
                        (
                            newPanX <= _currPanBounds.min.x && newPanX >= _currPanBounds.max.x &&
                            newPanY <= _currPanBounds.min.y && newPanY >= _currPanBounds.max.y
                        )) {
                        e.preventDefault();
                    }

                    // TODO: use rAF instead of mousewheel?
                    self.panTo(newPanX, newPanY);
                },

                toggleDesktopZoom: function (centerPoint) {
                    centerPoint = centerPoint || {
                        x: _viewportSize.x / 2 + _offset.x,
                        y: _viewportSize.y / 2 + _offset.y
                    };

                    var doubleTapZoomLevel = _options.getDoubleTapZoom(true, self.currItem);
                    var zoomOut = _currZoomLevel === doubleTapZoomLevel;

                    self.mouseZoomedIn = !zoomOut;

                    self.zoomTo(zoomOut ? self.currItem.initialZoomLevel : doubleTapZoomLevel, centerPoint, 333);
                    framework[(!zoomOut ? 'add' : 'remove') + 'Class'](template, 'pswp--zoomed-in');
                }

            }
        });


        /*>>desktop-zoom*/

        /*>>history*/
        /**
         *
         * history.js:
         *
         * - Back button to close gallery.
         * 
         * - Unique URL for each slide: example.com/&pid=1&gid=3
         *   (where PID is picture index, and GID and gallery index)
         *   
         * - Switch URL when slides change.
         * 
         */


        var _historyDefaultOptions = {
            history: true,
            galleryUID: 1
        };

        var _historyUpdateTimeout,
            _hashChangeTimeout,
            _hashAnimCheckTimeout,
            _hashChangedByScript,
            _hashChangedByHistory,
            _hashReseted,
            _initialHash,
            _historyChanged,
            _closedFromURL,
            _urlChangedOnce,
            _windowLoc,

            _supportsPushState,

            _getHash = function () {
                return _windowLoc.hash.substring(1);
            },
            _cleanHistoryTimeouts = function () {

                if (_historyUpdateTimeout) {
                    clearTimeout(_historyUpdateTimeout);
                }

                if (_hashAnimCheckTimeout) {
                    clearTimeout(_hashAnimCheckTimeout);
                }
            },

            // pid - Picture index
            // gid - Gallery index
            _parseItemIndexFromURL = function () {
                var hash = _getHash(),
                    params = {};

                if (hash.length < 5) { // pid=1
                    return params;
                }

                var i, vars = hash.split('&');
                for (i = 0; i < vars.length; i++) {
                    if (!vars[i]) {
                        continue;
                    }
                    var pair = vars[i].split('=');
                    if (pair.length < 2) {
                        continue;
                    }
                    params[pair[0]] = pair[1];
                }
                if (_options.galleryPIDs) {
                    // detect custom pid in hash and search for it among the items collection
                    var searchfor = params.pid;
                    params.pid = 0; // if custom pid cannot be found, fallback to the first item
                    for (i = 0; i < _items.length; i++) {
                        if (_items[i].pid === searchfor) {
                            params.pid = i;
                            break;
                        }
                    }
                } else {
                    params.pid = parseInt(params.pid, 10) - 1;
                }
                if (params.pid < 0) {
                    params.pid = 0;
                }
                return params;
            },
            _updateHash = function () {

                if (_hashAnimCheckTimeout) {
                    clearTimeout(_hashAnimCheckTimeout);
                }


                if (_numAnimations || _isDragging) {
                    // changing browser URL forces layout/paint in some browsers, which causes noticable lag during animation
                    // that's why we update hash only when no animations running
                    _hashAnimCheckTimeout = setTimeout(_updateHash, 500);
                    return;
                }

                if (_hashChangedByScript) {
                    clearTimeout(_hashChangeTimeout);
                } else {
                    _hashChangedByScript = true;
                }


                var pid = (_currentItemIndex + 1);
                var item = _getItemAt(_currentItemIndex);
                if (item.hasOwnProperty('pid')) {
                    // carry forward any custom pid assigned to the item
                    pid = item.pid;
                }
                var newHash = _initialHash + '&' + 'gid=' + _options.galleryUID + '&' + 'pid=' + pid;

                if (!_historyChanged) {
                    if (_windowLoc.hash.indexOf(newHash) === -1) {
                        _urlChangedOnce = true;
                    }
                    // first time - add new hisory record, then just replace
                }

                var newURL = _windowLoc.href.split('#')[0] + '#' + newHash;

                if (_supportsPushState) {

                    if ('#' + newHash !== window.location.hash) {
                        history[_historyChanged ? 'replaceState' : 'pushState']('', document.title, newURL);
                    }

                } else {
                    if (_historyChanged) {
                        _windowLoc.replace(newURL);
                    } else {
                        _windowLoc.hash = newHash;
                    }
                }



                _historyChanged = true;
                _hashChangeTimeout = setTimeout(function () {
                    _hashChangedByScript = false;
                }, 60);
            };





        _registerModule('History', {



            publicMethods: {
                initHistory: function () {

                    framework.extend(_options, _historyDefaultOptions, true);

                    if (!_options.history) {
                        return;
                    }


                    _windowLoc = window.location;
                    _urlChangedOnce = false;
                    _closedFromURL = false;
                    _historyChanged = false;
                    _initialHash = _getHash();
                    _supportsPushState = ('pushState' in history);


                    if (_initialHash.indexOf('gid=') > -1) {
                        _initialHash = _initialHash.split('&gid=')[0];
                        _initialHash = _initialHash.split('?gid=')[0];
                    }


                    _listen('afterChange', self.updateURL);
                    _listen('unbindEvents', function () {
                        framework.unbind(window, 'hashchange', self.onHashChange);
                    });


                    var returnToOriginal = function () {
                        _hashReseted = true;
                        if (!_closedFromURL) {

                            if (_urlChangedOnce) {
                                history.back();
                            } else {

                                if (_initialHash) {
                                    _windowLoc.hash = _initialHash;
                                } else {
                                    if (_supportsPushState) {

                                        // remove hash from url without refreshing it or scrolling to top
                                        history.pushState('', document.title, _windowLoc.pathname + _windowLoc.search);
                                    } else {
                                        _windowLoc.hash = '';
                                    }
                                }
                            }

                        }

                        _cleanHistoryTimeouts();
                    };


                    _listen('unbindEvents', function () {
                        if (_closedByScroll) {
                            // if PhotoSwipe is closed by scroll, we go "back" before the closing animation starts
                            // this is done to keep the scroll position
                            returnToOriginal();
                        }
                    });
                    _listen('destroy', function () {
                        if (!_hashReseted) {
                            returnToOriginal();
                        }
                    });
                    _listen('firstUpdate', function () {
                        _currentItemIndex = _parseItemIndexFromURL().pid;
                    });




                    var index = _initialHash.indexOf('pid=');
                    if (index > -1) {
                        _initialHash = _initialHash.substring(0, index);
                        if (_initialHash.slice(-1) === '&') {
                            _initialHash = _initialHash.slice(0, -1);
                        }
                    }


                    setTimeout(function () {
                        if (_isOpen) { // hasn't destroyed yet
                            framework.bind(window, 'hashchange', self.onHashChange);
                        }
                    }, 40);

                },
                onHashChange: function () {

                    if (_getHash() === _initialHash) {

                        _closedFromURL = true;
                        self.close();
                        return;
                    }
                    if (!_hashChangedByScript) {

                        _hashChangedByHistory = true;
                        self.goTo(_parseItemIndexFromURL().pid);
                        _hashChangedByHistory = false;
                    }

                },
                updateURL: function () {

                    // Delay the update of URL, to avoid lag during transition, 
                    // and to not to trigger actions like "refresh page sound" or "blinking favicon" to often

                    _cleanHistoryTimeouts();


                    if (_hashChangedByHistory) {
                        return;
                    }

                    if (!_historyChanged) {
                        _updateHash(); // first time
                    } else {
                        _historyUpdateTimeout = setTimeout(_updateHash, 800);
                    }
                }

            }
        });


        /*>>history*/
        framework.extend(self, publicMethods);
    };
    return PhotoSwipe;
});
} catch (e) {
console.error('Error in file:/templates/archi/js/photoswipe.min.js; Error:' + e.message);
};
try {
jQuery(document).ready(function () {
  jQuery("#mainmenu  a").click(function () {
    var v_url = this.hash;

    if (v_url.indexOf("#") != -1) {
      var v_hash = v_url.substring(v_url.indexOf("#") + 1);

      if (window.matchMedia("(max-width: 767px)").matches) {
        n = -1;
      } else {
        n = 69;
      }

      jQuery("html, body").animate(
        {
          scrollTop: jQuery("#" + v_hash).offset().top - n,
        },
        400,
        "easeInOutQuint"
      );
      return false;
    }

    if (jQuery(".hhrInzerovatCD.loaded").length > 0) {
      hhrBlockedMessageInit();
    }
  });

  jQuery(document).ajaxComplete(function () {
    if (jQuery(".hhrInzerovatCD.loaded").length > 0) {
      hhrBlockedMessageInit();
    }
  });

  // jQuery('#mainmenu a').click(function(e){
  //		var a_href = jQuery(this).attr('href');
  //        jQuery('#mainmenu a').removeClass('active');
  //        jQuery(this).addClass('active');
  //		scrollToElement(a_href, 500);
  //		return false;
  //	});
  //

  function hhrBlockedMessageInit() {
    jQuery(".hhrInzerovatCD.loaded").each(function () {
      jQuery(this).removeClass("loaded");
      var messageHtml = '<div class="disabledMessage">' + jQuery(this).html() + '</div>';
      jQuery(this)
        .closest(".hhrEstateIntro")
        .find(".hhrIntroImage")
        .append(messageHtml);
    });
  }

  if (jQuery(".logoSwitch").length > 0 && jQuery(window).outerWidth() > 992) {
    var scrolledNow = jQuery(window).scrollTop();
    var scrolledLimit = jQuery(".logoSwitch").outerHeight();
    if (scrolledNow > scrolledLimit) {
      jQuery("#logo").addClass("switched");
    }
    window.hhrScrolledLimit = scrolledLimit;
    jQuery(window).scroll(function () {
      if (jQuery(window).scrollTop() > window.hhrScrolledLimit) {
        if (jQuery("#logo").hasClass("switched") === false) {
          jQuery("#logo").addClass("switched");
        }
      } else {
        if (jQuery("#logo").hasClass("switched") === true) {
          jQuery("#logo").removeClass("switched");
        }
      }
    });
    console.log(scrolledNow, scrolledLimit);
  } else {
    setTimeout(function () {
      jQuery("#logo").addClass("switched");
    }, 2000);
  }

  jQuery(".hhr-slider-btn, .hhr-click-button").click(function () {
    if (jQuery(this).hasClass("link-nabizim-nemovitost")) {
      console.log('link "link-nabizim-nemovitost"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="NabĂ­dka nemovitosti" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">NabĂ­zĂ­m nemovitost</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">Kontaktovat nĂˇs mĹŻĹľete pomocĂ­ formulĂˇĹ™e nebo volejte na telefonnĂ­ ÄŤĂ­slo 774 480 450, pĹ™Ă­padnÄ› po 18 hodinÄ› 775 666 345.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">StruÄŤnĂ˝ popis nemovitosti</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">JmĂ©no a pĹ™Ă­jmenĂ­</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Telefon</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">DĹŻleĹľitĂ© informace</label><div class="hhr-quickForm-text"><p>Na zĂˇkladÄ› informacĂ­ VĂˇs po odeslĂˇnĂ­ formulĂˇĹ™e bude kontaktovat nĂ©kterĂ˝ z naĹˇich kolegĹŻ â€“ specialista na danou oblast.</p><p>OdeslĂˇnĂ­m formulĂˇĹ™e souhlasĂ­te se zpracovĂˇnĂ­m VĂˇmi uvedenĂ˝ch informacĂ­ za ĂşÄŤelem zpracovĂˇnĂ­, pĹ™Ă­pravy a nĂˇslednĂ©ho zpÄ›tnĂ©ho kontaktu.</p><br><p class="hhr-quickForm-message-red">TÄ›ĹˇĂ­me se na spoluprĂˇci</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">DÄ›kujeme!</label><div class="hhr-quickForm-text"><p>VĂˇmi odeslanĂ© informace byly ĂşspÄ›ĹˇnÄ› doruÄŤeny.</p><p>NĂˇĹˇ specialista VĂˇs bude kontaktovat nejpozdÄ›ji v nĂˇsledujĂ­cĂ­m pracovnĂ­m dni.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-poptavam-nemovitost")) {
      console.log('link "link-poptavam-nemovitost"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="PoptĂˇvka nemovitosti" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">PoptĂˇvĂˇm nemovitost</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red"> Kontaktovat nĂˇs mĹŻĹľete pomocĂ­ formulĂˇĹ™e nebo volejte na telefonnĂ­ ÄŤĂ­slo 774 480 450.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">StruÄŤnĂ˝ popis nemovitosti</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">JmĂ©no a pĹ™Ă­jmenĂ­</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Telefon</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">DĹŻleĹľitĂ© informace</label><div class="hhr-quickForm-text"><p>Na zĂˇkladÄ› informacĂ­ VĂˇs po odeslĂˇnĂ­ formulĂˇĹ™e bude kontaktovat nĂ©kterĂ˝ z naĹˇich kolegĹŻ â€“ specialista na danou oblast.</p><p>OdeslĂˇnĂ­m formulĂˇĹ™e souhlasĂ­te se zpracovĂˇnĂ­m VĂˇmi uvedenĂ˝ch informacĂ­ za ĂşÄŤelem zpracovĂˇnĂ­, pĹ™Ă­pravy a nĂˇslednĂ©ho zpÄ›tnĂ©ho kontaktu.</p><br><p class="hhr-quickForm-message-red">TÄ›ĹˇĂ­me se na spoluprĂˇci</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">DÄ›kujeme!</label><div class="hhr-quickForm-text"><p>VĂˇmi odeslanĂ© informace byly ĂşspÄ›ĹˇnÄ› doruÄŤeny.</p><p>NĂˇĹˇ specialista VĂˇs bude kontaktovat nejpozdÄ›ji v nĂˇsledujĂ­cĂ­m pracovnĂ­m dni.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-poptavam-spravu")) {
      console.log('link "link-poptavam-spravu"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="PoptĂˇvka sprĂˇvy nemovitosti" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">PoptĂˇvĂˇm sprĂˇvu nemovitosti</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">Kontaktovat nĂˇs mĹŻĹľete pomocĂ­ formulĂˇĹ™e nebo volejte na telefonnĂ­ ÄŤĂ­slo 774 480 450 pĹ™Ă­padnÄ› po 18 hodinÄ› 775 666 345.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">StruÄŤnĂ˝ popis nemovitosti</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">JmĂ©no a pĹ™Ă­jmenĂ­</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Telefon</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">DĹŻleĹľitĂ© informace</label><div class="hhr-quickForm-text"><p>Na zĂˇkladÄ› informacĂ­ VĂˇs po odeslĂˇnĂ­ formulĂˇĹ™e bude kontaktovat nĂ©kterĂ˝ z naĹˇich kolegĹŻ â€“ specialista na danou oblast.</p><p>OdeslĂˇnĂ­m formulĂˇĹ™e souhlasĂ­te se zpracovĂˇnĂ­m VĂˇmi uvedenĂ˝ch informacĂ­ za ĂşÄŤelem zpracovĂˇnĂ­, pĹ™Ă­pravy a nĂˇslednĂ©ho zpÄ›tnĂ©ho kontaktu.</p><br><p class="hhr-quickForm-message-red">TÄ›ĹˇĂ­me se na spoluprĂˇci</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">DÄ›kujeme!</label><div class="hhr-quickForm-text"><p>VĂˇmi odeslanĂ© informace byly ĂşspÄ›ĹˇnÄ› doruÄŤeny.</p><p>NĂˇĹˇ specialista VĂˇs bude kontaktovat nejpozdÄ›ji v nĂˇsledujĂ­cĂ­m pracovnĂ­m dni.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-poptavam-konzultaci")) {
      console.log('link "link-poptavam-konzultaci"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="NezĂˇvaznĂˇ konzultace" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">Ĺ˝ĂˇdĂˇm o nezĂˇvaznou konzultaci</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">Kontaktovat nĂˇs mĹŻĹľete pomocĂ­ formulĂˇĹ™e nebo volejte na telefonnĂ­ ÄŤĂ­slo 774 480 450 pĹ™Ă­padnÄ› po 18 hodinÄ› 775 666 345.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">StruÄŤnĂ˝ popis obsahu poĹľadovanĂ© konzultace</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">JmĂ©no a pĹ™Ă­jmenĂ­</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Telefon</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">DĹŻleĹľitĂ© informace</label><div class="hhr-quickForm-text"><p>Na zĂˇkladÄ› informacĂ­ VĂˇs po odeslĂˇnĂ­ formulĂˇĹ™e bude kontaktovat nĂ©kterĂ˝ z naĹˇich kolegĹŻ â€“ specialista na danou oblast.</p><p>OdeslĂˇnĂ­m formulĂˇĹ™e souhlasĂ­te se zpracovĂˇnĂ­m VĂˇmi uvedenĂ˝ch informacĂ­ za ĂşÄŤelem zpracovĂˇnĂ­, pĹ™Ă­pravy a nĂˇslednĂ©ho zpÄ›tnĂ©ho kontaktu.</p><br><p class="hhr-quickForm-message-red">TÄ›ĹˇĂ­me se na spoluprĂˇci</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">DÄ›kujeme!</label><div class="hhr-quickForm-text"><p>VĂˇmi odeslanĂ© informace byly ĂşspÄ›ĹˇnÄ› doruÄŤeny.</p><p>NĂˇĹˇ specialista VĂˇs bude kontaktovat nejpozdÄ›ji v nĂˇsledujĂ­cĂ­m pracovnĂ­m dni.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-nabizim-nemovitost-en")) {
      console.log('link "link-nabizim-nemovitost"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="Property offer" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">Offering a property</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">You can contact us by the form or call us on +420 774 480 450, after 6 PM on +420 775 666 345.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Short property description</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Full name</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Phone</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">Important information</label><div class="hhr-quickForm-text"><p>Based on the provided information one of our colleagues - a specialist in the given area - will contact you after submitting the form.</p><p>By submitting the form, you agree with processing the information provided by you for the purpose of data processing, preparation and subsequent contact.</p><br><p class="hhr-quickForm-message-red">We are looking forward to joint cooperation.</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">Thank You!</label><div class="hhr-quickForm-text"><p>Your message was successfully delivered</p><p>Our specialist will contact you within next working day.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-poptavam-nemovitost-en")) {
      console.log('link "link-poptavam-nemovitost"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="Property searching" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">Searching for a property</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">You can contact us by the form or call us on +420 774 480 450.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Short property description</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Full name</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Phone</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">Important information</label><div class="hhr-quickForm-text"><p>Based on the provided information one of our colleagues - a specialist in the given area - will contact you after submitting the form.</p><p>By submitting the form, you agree with processing the information provided by you for the purpose of data processing, preparation and subsequent contact.</p><br><p class="hhr-quickForm-message-red">We are looking forward to joint cooperation.</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">Thank You!</label><div class="hhr-quickForm-text"><p>Your message was successfully delivered</p><p>Our specialist will contact you within next working day.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-poptavam-spravu-en")) {
      console.log('link "link-poptavam-spravu"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="Property management enquiry" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">property management enquiry</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">You can contact us by the form or call us on +420 774 480 450, after 6 PM on +420 775 666 345.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Short property description</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Full name</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Phone</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">Important information</label><div class="hhr-quickForm-text"><p>Based on the provided information one of our colleagues - a specialist in the given area - will contact you after submitting the form.</p><p>By submitting the form, you agree with processing the information provided by you for the purpose of data processing, preparation and subsequent contact.</p><br><p class="hhr-quickForm-message-red">We are looking forward to joint cooperation.</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">Thank You!</label><div class="hhr-quickForm-text"><p>Your message was successfully delivered</p><p>Our specialist will contact you within next working day.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-poptavam-konzultaci-en")) {
      console.log('link "link-poptavam-konzultaci"');
      var contentHtml =
        '<div class="hhr-quickForm" data-subject="No-obligation Consultation" data-action="quickFormSend">';
      contentHtml +=
        '<div class="hhr-quickForm-header">I need no-obligation consultation</div>';
      contentHtml +=
        '<div class="hhr-quickForm-message-red">You can contact us by the form or call us on +420 774 480 450, after 6 PM on +420 775 666 345.</div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Consultation subject description</label><textarea class="hhr-input" name="property-text"></textarea></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide"><label class="hhr-input-label">Full name</label><input class="hhr-input" type="text" name="name" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Phone</label><input class="hhr-input" type="text" name="phone" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet wide right-span"><label class="red">Important information</label><div class="hhr-quickForm-text"><p>Based on the provided information one of our colleagues - a specialist in the given area - will contact you after submitting the form.</p><p>By submitting the form, you agree with processing the information provided by you for the purpose of data processing, preparation and subsequent contact.</p><br><p class="hhr-quickForm-message-red">We are looking forward to joint cooperation.</p></div></div>';
      contentHtml +=
        '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
      contentHtml +=
        '<div class="hhr-quickForm-fieldSet success-message wide hidden"><label class="red">Thank You!</label><div class="hhr-quickForm-text"><p>Your message was successfully delivered</p><p>Our specialist will contact you within next working day.</p></div></div>';
      contentHtml += "</div > ";
      hhrQuickForm(this, contentHtml);
    } else if (jQuery(this).hasClass("link-call")) {
      console.log('link "link-call"');
      // window.location.href = '/nabidka';
      var phoneNumber = jQuery(this).attr("data-tel");
      window.open("tel:" + phoneNumber, "_self");
    } else if (jQuery(this).hasClass("link-poptavam-cenu")) {
      console.log('link "link-price-calc"');
      window.location.href = '/index.php?option=com_content&amp;view=article&amp;id=1572&amp;Itemid=507';
    } else if (jQuery(this).hasClass("link-sprava-web-en")) {
      console.log('link "link-sprava-web-en"');
      window.location.href = 'https://www.happyhouse-sprava.cz/en/';
    } else if (jQuery(this).hasClass("link-sprava-web")) {
      console.log('link "link-sprava-web-en"');
      window.location.href = 'https://www.happyhouse-sprava.cz/';
    } else if (jQuery(this).hasClass("link-o-nas")) {
      console.log('link "link-o-nas"');
      window.location.href = '/o-nas/kariera';
    } else if (jQuery(this).hasClass("link-o-nas-en")) {
      console.log('link "link-o-nas-en"');
      window.location.href = '/en/o-nas-en/o-nas-a-kariera-en';
    }
  });

  jQuery(".hhrCallButton.link-call").click(function () {
    var phoneNumber = jQuery(this).attr("data-tel");
    window.open("tel:" + phoneNumber, "_self");
  });

  jQuery(".hhrCallButton.link-call").click(function () {
    var phoneNumber = jQuery(this).attr("data-tel");
    window.open("tel:" + phoneNumber, "_self");
  });

  jQuery(".hhrSearchButton").click(function () {
    var searchForm = jQuery('#section-slider .hhr-home-filter');
    if (jQuery(searchForm).hasClass('show')) {
      jQuery(searchForm).removeClass('show');
    } else {
      jQuery(searchForm).addClass('show');
    }
  });

  jQuery(".searchButtonClose").click(function () {
    var searchForm = jQuery('#section-slider .hhr-home-filter');
    if (jQuery(searchForm).hasClass('show')) {
      jQuery(searchForm).removeClass('show');
    } else {
      jQuery(searchForm).addClass('show');
    }
  });

});

function scrollToElement(selector, time, verticalOffset) {
  time = typeof time != "undefined" ? time : 1000;
  verticalOffset = typeof verticalOffset != "undefined" ? verticalOffset : 0;
  element = jQuery(selector);
  offset = element.offset();
  offsetTop = offset.top + verticalOffset;
  jQuery("html, body").animate(
    {
      scrollTop: offsetTop - 30,
    },
    time
  );
}

} catch (e) {
console.error('Error in file:/templates/archi/js/script.js; Error:' + e.message);
};
try {
/*! jQuery UI - v1.12.1 - 2021-02-03
* http://jqueryui.com
* Includes: widget.js, keycode.js, widgets/mouse.js, widgets/slider.js
* Copyright jQuery Foundation and other contributors; Licensed MIT */

!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):e(jQuery)}(function(r){r.ui=r.ui||{};r.ui.version="1.12.1";var n,i=0,h=Array.prototype.slice;r.cleanData=(n=r.cleanData,function(e){for(var t,i,s=0;null!=(i=e[s]);s++)try{(t=r._data(i,"events"))&&t.remove&&r(i).triggerHandler("remove")}catch(e){}n(e)}),r.widget=function(e,i,t){var s,n,a,o={},h=e.split(".")[0],l=h+"-"+(e=e.split(".")[1]);return t||(t=i,i=r.Widget),r.isArray(t)&&(t=r.extend.apply(null,[{}].concat(t))),r.expr[":"][l.toLowerCase()]=function(e){return!!r.data(e,l)},r[h]=r[h]||{},s=r[h][e],n=r[h][e]=function(e,t){if(!this._createWidget)return new n(e,t);arguments.length&&this._createWidget(e,t)},r.extend(n,s,{version:t.version,_proto:r.extend({},t),_childConstructors:[]}),(a=new i).options=r.widget.extend({},a.options),r.each(t,function(t,s){function n(){return i.prototype[t].apply(this,arguments)}function a(e){return i.prototype[t].apply(this,e)}r.isFunction(s)?o[t]=function(){var e,t=this._super,i=this._superApply;return this._super=n,this._superApply=a,e=s.apply(this,arguments),this._super=t,this._superApply=i,e}:o[t]=s}),n.prototype=r.widget.extend(a,{widgetEventPrefix:s&&a.widgetEventPrefix||e},o,{constructor:n,namespace:h,widgetName:e,widgetFullName:l}),s?(r.each(s._childConstructors,function(e,t){var i=t.prototype;r.widget(i.namespace+"."+i.widgetName,n,t._proto)}),delete s._childConstructors):i._childConstructors.push(n),r.widget.bridge(e,n),n},r.widget.extend=function(e){for(var t,i,s=h.call(arguments,1),n=0,a=s.length;n<a;n++)for(t in s[n])i=s[n][t],s[n].hasOwnProperty(t)&&void 0!==i&&(r.isPlainObject(i)?e[t]=r.isPlainObject(e[t])?r.widget.extend({},e[t],i):r.widget.extend({},i):e[t]=i);return e},r.widget.bridge=function(a,t){var o=t.prototype.widgetFullName||a;r.fn[a]=function(i){var e="string"==typeof i,s=h.call(arguments,1),n=this;return e?this.length||"instance"!==i?this.each(function(){var e,t=r.data(this,o);return"instance"===i?(n=t,!1):t?r.isFunction(t[i])&&"_"!==i.charAt(0)?(e=t[i].apply(t,s))!==t&&void 0!==e?(n=e&&e.jquery?n.pushStack(e.get()):e,!1):void 0:r.error("no such method '"+i+"' for "+a+" widget instance"):r.error("cannot call methods on "+a+" prior to initialization; attempted to call method '"+i+"'")}):n=void 0:(s.length&&(i=r.widget.extend.apply(null,[i].concat(s))),this.each(function(){var e=r.data(this,o);e?(e.option(i||{}),e._init&&e._init()):r.data(this,o,new t(i,this))})),n}},r.Widget=function(){},r.Widget._childConstructors=[],r.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:!1,create:null},_createWidget:function(e,t){t=r(t||this.defaultElement||this)[0],this.element=r(t),this.uuid=i++,this.eventNamespace="."+this.widgetName+this.uuid,this.bindings=r(),this.hoverable=r(),this.focusable=r(),this.classesElementLookup={},t!==this&&(r.data(t,this.widgetFullName,this),this._on(!0,this.element,{remove:function(e){e.target===t&&this.destroy()}}),this.document=r(t.style?t.ownerDocument:t.document||t),this.window=r(this.document[0].defaultView||this.document[0].parentWindow)),this.options=r.widget.extend({},this.options,this._getCreateOptions(),e),this._create(),this.options.disabled&&this._setOptionDisabled(this.options.disabled),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:function(){return{}},_getCreateEventData:r.noop,_create:r.noop,_init:r.noop,destroy:function(){var i=this;this._destroy(),r.each(this.classesElementLookup,function(e,t){i._removeClass(t,e)}),this.element.off(this.eventNamespace).removeData(this.widgetFullName),this.widget().off(this.eventNamespace).removeAttr("aria-disabled"),this.bindings.off(this.eventNamespace)},_destroy:r.noop,widget:function(){return this.element},option:function(e,t){var i,s,n,a=e;if(0===arguments.length)return r.widget.extend({},this.options);if("string"==typeof e)if(a={},e=(i=e.split(".")).shift(),i.length){for(s=a[e]=r.widget.extend({},this.options[e]),n=0;n<i.length-1;n++)s[i[n]]=s[i[n]]||{},s=s[i[n]];if(e=i.pop(),1===arguments.length)return void 0===s[e]?null:s[e];s[e]=t}else{if(1===arguments.length)return void 0===this.options[e]?null:this.options[e];a[e]=t}return this._setOptions(a),this},_setOptions:function(e){for(var t in e)this._setOption(t,e[t]);return this},_setOption:function(e,t){return"classes"===e&&this._setOptionClasses(t),this.options[e]=t,"disabled"===e&&this._setOptionDisabled(t),this},_setOptionClasses:function(e){var t,i,s;for(t in e)s=this.classesElementLookup[t],e[t]!==this.options.classes[t]&&s&&s.length&&(i=r(s.get()),this._removeClass(s,t),i.addClass(this._classes({element:i,keys:t,classes:e,add:!0})))},_setOptionDisabled:function(e){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!e),e&&(this._removeClass(this.hoverable,null,"ui-state-hover"),this._removeClass(this.focusable,null,"ui-state-focus"))},enable:function(){return this._setOptions({disabled:!1})},disable:function(){return this._setOptions({disabled:!0})},_classes:function(n){var a=[],o=this;function e(e,t){for(var i,s=0;s<e.length;s++)i=o.classesElementLookup[e[s]]||r(),i=n.add?r(r.unique(i.get().concat(n.element.get()))):r(i.not(n.element).get()),o.classesElementLookup[e[s]]=i,a.push(e[s]),t&&n.classes[e[s]]&&a.push(n.classes[e[s]])}return n=r.extend({element:this.element,classes:this.options.classes||{}},n),this._on(n.element,{remove:"_untrackClassesElement"}),n.keys&&e(n.keys.match(/\S+/g)||[],!0),n.extra&&e(n.extra.match(/\S+/g)||[]),a.join(" ")},_untrackClassesElement:function(i){var s=this;r.each(s.classesElementLookup,function(e,t){-1!==r.inArray(i.target,t)&&(s.classesElementLookup[e]=r(t.not(i.target).get()))})},_removeClass:function(e,t,i){return this._toggleClass(e,t,i,!1)},_addClass:function(e,t,i){return this._toggleClass(e,t,i,!0)},_toggleClass:function(e,t,i,s){s="boolean"==typeof s?s:i;var n="string"==typeof e||null===e,e={extra:n?t:i,keys:n?e:t,element:n?this.element:e,add:s};return e.element.toggleClass(this._classes(e),s),this},_on:function(n,a,e){var o,h=this;"boolean"!=typeof n&&(e=a,a=n,n=!1),e?(a=o=r(a),this.bindings=this.bindings.add(a)):(e=a,a=this.element,o=this.widget()),r.each(e,function(e,t){function i(){if(n||!0!==h.options.disabled&&!r(this).hasClass("ui-state-disabled"))return("string"==typeof t?h[t]:t).apply(h,arguments)}"string"!=typeof t&&(i.guid=t.guid=t.guid||i.guid||r.guid++);var s=e.match(/^([\w:-]*)\s*(.*)$/),e=s[1]+h.eventNamespace,s=s[2];s?o.on(e,s,i):a.on(e,i)})},_off:function(e,t){t=(t||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,e.off(t).off(t),this.bindings=r(this.bindings.not(e).get()),this.focusable=r(this.focusable.not(e).get()),this.hoverable=r(this.hoverable.not(e).get())},_delay:function(e,t){var i=this;return setTimeout(function(){return("string"==typeof e?i[e]:e).apply(i,arguments)},t||0)},_hoverable:function(e){this.hoverable=this.hoverable.add(e),this._on(e,{mouseenter:function(e){this._addClass(r(e.currentTarget),null,"ui-state-hover")},mouseleave:function(e){this._removeClass(r(e.currentTarget),null,"ui-state-hover")}})},_focusable:function(e){this.focusable=this.focusable.add(e),this._on(e,{focusin:function(e){this._addClass(r(e.currentTarget),null,"ui-state-focus")},focusout:function(e){this._removeClass(r(e.currentTarget),null,"ui-state-focus")}})},_trigger:function(e,t,i){var s,n,a=this.options[e];if(i=i||{},(t=r.Event(t)).type=(e===this.widgetEventPrefix?e:this.widgetEventPrefix+e).toLowerCase(),t.target=this.element[0],n=t.originalEvent)for(s in n)s in t||(t[s]=n[s]);return this.element.trigger(t,i),!(r.isFunction(a)&&!1===a.apply(this.element[0],[t].concat(i))||t.isDefaultPrevented())}},r.each({show:"fadeIn",hide:"fadeOut"},function(a,o){r.Widget.prototype["_"+a]=function(t,e,i){var s;"string"==typeof e&&(e={effect:e});var n=e?!0!==e&&"number"!=typeof e&&e.effect||o:a;"number"==typeof(e=e||{})&&(e={duration:e}),s=!r.isEmptyObject(e),e.complete=i,e.delay&&t.delay(e.delay),s&&r.effects&&r.effects.effect[n]?t[a](e):n!==a&&t[n]?t[n](e.duration,e.easing,i):t.queue(function(e){r(this)[a](),i&&i.call(t[0]),e()})}});r.widget,r.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38},r.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase());var a=!1;r(document).on("mouseup",function(){a=!1});r.widget("ui.mouse",{version:"1.12.1",options:{cancel:"input, textarea, button, select, option",distance:1,delay:0},_mouseInit:function(){var t=this;this.element.on("mousedown."+this.widgetName,function(e){return t._mouseDown(e)}).on("click."+this.widgetName,function(e){if(!0===r.data(e.target,t.widgetName+".preventClickEvent"))return r.removeData(e.target,t.widgetName+".preventClickEvent"),e.stopImmediatePropagation(),!1}),this.started=!1},_mouseDestroy:function(){this.element.off("."+this.widgetName),this._mouseMoveDelegate&&this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(e){if(!a){this._mouseMoved=!1,this._mouseStarted&&this._mouseUp(e),this._mouseDownEvent=e;var t=this,i=1===e.which,s=!("string"!=typeof this.options.cancel||!e.target.nodeName)&&r(e.target).closest(this.options.cancel).length;return i&&!s&&this._mouseCapture(e)?(this.mouseDelayMet=!this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){t.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(e)&&this._mouseDelayMet(e)&&(this._mouseStarted=!1!==this._mouseStart(e),!this._mouseStarted)?(e.preventDefault(),!0):(!0===r.data(e.target,this.widgetName+".preventClickEvent")&&r.removeData(e.target,this.widgetName+".preventClickEvent"),this._mouseMoveDelegate=function(e){return t._mouseMove(e)},this._mouseUpDelegate=function(e){return t._mouseUp(e)},this.document.on("mousemove."+this.widgetName,this._mouseMoveDelegate).on("mouseup."+this.widgetName,this._mouseUpDelegate),e.preventDefault(),a=!0)):!0}},_mouseMove:function(e){if(this._mouseMoved){if(r.ui.ie&&(!document.documentMode||document.documentMode<9)&&!e.button)return this._mouseUp(e);if(!e.which)if(e.originalEvent.altKey||e.originalEvent.ctrlKey||e.originalEvent.metaKey||e.originalEvent.shiftKey)this.ignoreMissingWhich=!0;else if(!this.ignoreMissingWhich)return this._mouseUp(e)}return(e.which||e.button)&&(this._mouseMoved=!0),this._mouseStarted?(this._mouseDrag(e),e.preventDefault()):(this._mouseDistanceMet(e)&&this._mouseDelayMet(e)&&(this._mouseStarted=!1!==this._mouseStart(this._mouseDownEvent,e),this._mouseStarted?this._mouseDrag(e):this._mouseUp(e)),!this._mouseStarted)},_mouseUp:function(e){this.document.off("mousemove."+this.widgetName,this._mouseMoveDelegate).off("mouseup."+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,e.target===this._mouseDownEvent.target&&r.data(e.target,this.widgetName+".preventClickEvent",!0),this._mouseStop(e)),this._mouseDelayTimer&&(clearTimeout(this._mouseDelayTimer),delete this._mouseDelayTimer),this.ignoreMissingWhich=!1,a=!1,e.preventDefault()},_mouseDistanceMet:function(e){return Math.max(Math.abs(this._mouseDownEvent.pageX-e.pageX),Math.abs(this._mouseDownEvent.pageY-e.pageY))>=this.options.distance},_mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}}),r.widget("ui.slider",r.ui.mouse,{version:"1.12.1",widgetEventPrefix:"slide",options:{animate:!1,classes:{"ui-slider":"ui-corner-all","ui-slider-handle":"ui-corner-all","ui-slider-range":"ui-corner-all ui-widget-header"},distance:0,max:100,min:0,orientation:"horizontal",range:!1,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},numPages:5,_create:function(){this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this._calculateNewMax(),this._addClass("ui-slider ui-slider-"+this.orientation,"ui-widget ui-widget-content"),this._refresh(),this._animateOff=!1},_refresh:function(){this._createRange(),this._createHandles(),this._setupEvents(),this._refreshValue()},_createHandles:function(){var e,t=this.options,i=this.element.find(".ui-slider-handle"),s=[],n=t.values&&t.values.length||1;for(i.length>n&&(i.slice(n).remove(),i=i.slice(0,n)),e=i.length;e<n;e++)s.push("<span tabindex='0'></span>");this.handles=i.add(r(s.join("")).appendTo(this.element)),this._addClass(this.handles,"ui-slider-handle","ui-state-default"),this.handle=this.handles.eq(0),this.handles.each(function(e){r(this).data("ui-slider-handle-index",e).attr("tabIndex",0)})},_createRange:function(){var e=this.options;e.range?(!0===e.range&&(e.values?e.values.length&&2!==e.values.length?e.values=[e.values[0],e.values[0]]:r.isArray(e.values)&&(e.values=e.values.slice(0)):e.values=[this._valueMin(),this._valueMin()]),this.range&&this.range.length?(this._removeClass(this.range,"ui-slider-range-min ui-slider-range-max"),this.range.css({left:"",bottom:""})):(this.range=r("<div>").appendTo(this.element),this._addClass(this.range,"ui-slider-range")),"min"!==e.range&&"max"!==e.range||this._addClass(this.range,"ui-slider-range-"+e.range)):(this.range&&this.range.remove(),this.range=null)},_setupEvents:function(){this._off(this.handles),this._on(this.handles,this._handleEvents),this._hoverable(this.handles),this._focusable(this.handles)},_destroy:function(){this.handles.remove(),this.range&&this.range.remove(),this._mouseDestroy()},_mouseCapture:function(e){var i,s,n,a,t,o,h=this,l=this.options;return!l.disabled&&(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),o={x:e.pageX,y:e.pageY},i=this._normValueFromMouse(o),s=this._valueMax()-this._valueMin()+1,this.handles.each(function(e){var t=Math.abs(i-h.values(e));(t<s||s===t&&(e===h._lastChangedValue||h.values(e)===l.min))&&(s=t,n=r(this),a=e)}),!1!==this._start(e,a)&&(this._mouseSliding=!0,this._handleIndex=a,this._addClass(n,null,"ui-state-active"),n.trigger("focus"),t=n.offset(),o=!r(e.target).parents().addBack().is(".ui-slider-handle"),this._clickOffset=o?{left:0,top:0}:{left:e.pageX-t.left-n.width()/2,top:e.pageY-t.top-n.height()/2-(parseInt(n.css("borderTopWidth"),10)||0)-(parseInt(n.css("borderBottomWidth"),10)||0)+(parseInt(n.css("marginTop"),10)||0)},this.handles.hasClass("ui-state-hover")||this._slide(e,a,i),this._animateOff=!0))},_mouseStart:function(){return!0},_mouseDrag:function(e){var t={x:e.pageX,y:e.pageY},t=this._normValueFromMouse(t);return this._slide(e,this._handleIndex,t),!1},_mouseStop:function(e){return this._removeClass(this.handles,null,"ui-state-active"),this._mouseSliding=!1,this._stop(e,this._handleIndex),this._change(e,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1},_detectOrientation:function(){this.orientation="vertical"===this.options.orientation?"vertical":"horizontal"},_normValueFromMouse:function(e){var t,e="horizontal"===this.orientation?(t=this.elementSize.width,e.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(t=this.elementSize.height,e.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),e=e/t;return 1<e&&(e=1),e<0&&(e=0),"vertical"===this.orientation&&(e=1-e),t=this._valueMax()-this._valueMin(),t=this._valueMin()+e*t,this._trimAlignValue(t)},_uiHash:function(e,t,i){var s={handle:this.handles[e],handleIndex:e,value:void 0!==t?t:this.value()};return this._hasMultipleValues()&&(s.value=void 0!==t?t:this.values(e),s.values=i||this.values()),s},_hasMultipleValues:function(){return this.options.values&&this.options.values.length},_start:function(e,t){return this._trigger("start",e,this._uiHash(t))},_slide:function(e,t,i){var s,n=this.value(),a=this.values();this._hasMultipleValues()&&(s=this.values(t?0:1),n=this.values(t),2===this.options.values.length&&!0===this.options.range&&(i=0===t?Math.min(s,i):Math.max(s,i)),a[t]=i),i!==n&&!1!==this._trigger("slide",e,this._uiHash(t,i,a))&&(this._hasMultipleValues()?this.values(t,i):this.value(i))},_stop:function(e,t){this._trigger("stop",e,this._uiHash(t))},_change:function(e,t){this._keySliding||this._mouseSliding||(this._lastChangedValue=t,this._trigger("change",e,this._uiHash(t)))},value:function(e){return arguments.length?(this.options.value=this._trimAlignValue(e),this._refreshValue(),void this._change(null,0)):this._value()},values:function(e,t){var i,s,n;if(1<arguments.length)return this.options.values[e]=this._trimAlignValue(t),this._refreshValue(),void this._change(null,e);if(!arguments.length)return this._values();if(!r.isArray(e))return this._hasMultipleValues()?this._values(e):this.value();for(i=this.options.values,s=e,n=0;n<i.length;n+=1)i[n]=this._trimAlignValue(s[n]),this._change(null,n);this._refreshValue()},_setOption:function(e,t){var i,s=0;switch("range"===e&&!0===this.options.range&&("min"===t?(this.options.value=this._values(0),this.options.values=null):"max"===t&&(this.options.value=this._values(this.options.values.length-1),this.options.values=null)),r.isArray(this.options.values)&&(s=this.options.values.length),this._super(e,t),e){case"orientation":this._detectOrientation(),this._removeClass("ui-slider-horizontal ui-slider-vertical")._addClass("ui-slider-"+this.orientation),this._refreshValue(),this.options.range&&this._refreshRange(t),this.handles.css("horizontal"===t?"bottom":"left","");break;case"value":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case"values":for(this._animateOff=!0,this._refreshValue(),i=s-1;0<=i;i--)this._change(null,i);this._animateOff=!1;break;case"step":case"min":case"max":this._animateOff=!0,this._calculateNewMax(),this._refreshValue(),this._animateOff=!1;break;case"range":this._animateOff=!0,this._refresh(),this._animateOff=!1}},_setOptionDisabled:function(e){this._super(e),this._toggleClass(null,"ui-state-disabled",!!e)},_value:function(){var e=this.options.value;return e=this._trimAlignValue(e)},_values:function(e){var t,i,s;if(arguments.length)return t=this.options.values[e],this._trimAlignValue(t);if(this._hasMultipleValues()){for(i=this.options.values.slice(),s=0;s<i.length;s+=1)i[s]=this._trimAlignValue(i[s]);return i}return[]},_trimAlignValue:function(e){if(e<=this._valueMin())return this._valueMin();if(e>=this._valueMax())return this._valueMax();var t=0<this.options.step?this.options.step:1,i=(e-this._valueMin())%t,e=e-i;return 2*Math.abs(i)>=t&&(e+=0<i?t:-t),parseFloat(e.toFixed(5))},_calculateNewMax:function(){var e=this.options.max,t=this._valueMin(),i=this.options.step;(e=Math.round((e-t)/i)*i+t)>this.options.max&&(e-=i),this.max=parseFloat(e.toFixed(this._precision()))},_precision:function(){var e=this._precisionOf(this.options.step);return null!==this.options.min&&(e=Math.max(e,this._precisionOf(this.options.min))),e},_precisionOf:function(e){var t=e.toString(),e=t.indexOf(".");return-1===e?0:t.length-e-1},_valueMin:function(){return this.options.min},_valueMax:function(){return this.max},_refreshRange:function(e){"vertical"===e&&this.range.css({width:"",left:""}),"horizontal"===e&&this.range.css({height:"",bottom:""})},_refreshValue:function(){var t,i,e,s,n,a=this.options.range,o=this.options,h=this,l=!this._animateOff&&o.animate,u={};this._hasMultipleValues()?this.handles.each(function(e){i=(h.values(e)-h._valueMin())/(h._valueMax()-h._valueMin())*100,u["horizontal"===h.orientation?"left":"bottom"]=i+"%",r(this).stop(1,1)[l?"animate":"css"](u,o.animate),!0===h.options.range&&("horizontal"===h.orientation?(0===e&&h.range.stop(1,1)[l?"animate":"css"]({left:i+"%"},o.animate),1===e&&h.range[l?"animate":"css"]({width:i-t+"%"},{queue:!1,duration:o.animate})):(0===e&&h.range.stop(1,1)[l?"animate":"css"]({bottom:i+"%"},o.animate),1===e&&h.range[l?"animate":"css"]({height:i-t+"%"},{queue:!1,duration:o.animate}))),t=i}):(e=this.value(),s=this._valueMin(),n=this._valueMax(),i=n!==s?(e-s)/(n-s)*100:0,u["horizontal"===this.orientation?"left":"bottom"]=i+"%",this.handle.stop(1,1)[l?"animate":"css"](u,o.animate),"min"===a&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:i+"%"},o.animate),"max"===a&&"horizontal"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({width:100-i+"%"},o.animate),"min"===a&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:i+"%"},o.animate),"max"===a&&"vertical"===this.orientation&&this.range.stop(1,1)[l?"animate":"css"]({height:100-i+"%"},o.animate))},_handleEvents:{keydown:function(e){var t,i,s,n=r(e.target).data("ui-slider-handle-index");switch(e.keyCode){case r.ui.keyCode.HOME:case r.ui.keyCode.END:case r.ui.keyCode.PAGE_UP:case r.ui.keyCode.PAGE_DOWN:case r.ui.keyCode.UP:case r.ui.keyCode.RIGHT:case r.ui.keyCode.DOWN:case r.ui.keyCode.LEFT:if(e.preventDefault(),!this._keySliding&&(this._keySliding=!0,this._addClass(r(e.target),null,"ui-state-active"),!1===this._start(e,n)))return}switch(s=this.options.step,t=i=this._hasMultipleValues()?this.values(n):this.value(),e.keyCode){case r.ui.keyCode.HOME:i=this._valueMin();break;case r.ui.keyCode.END:i=this._valueMax();break;case r.ui.keyCode.PAGE_UP:i=this._trimAlignValue(t+(this._valueMax()-this._valueMin())/this.numPages);break;case r.ui.keyCode.PAGE_DOWN:i=this._trimAlignValue(t-(this._valueMax()-this._valueMin())/this.numPages);break;case r.ui.keyCode.UP:case r.ui.keyCode.RIGHT:if(t===this._valueMax())return;i=this._trimAlignValue(t+s);break;case r.ui.keyCode.DOWN:case r.ui.keyCode.LEFT:if(t===this._valueMin())return;i=this._trimAlignValue(t-s)}this._slide(e,n,i)},keyup:function(e){var t=r(e.target).data("ui-slider-handle-index");this._keySliding&&(this._keySliding=!1,this._stop(e,t),this._change(e,t),this._removeClass(r(e.target),null,"ui-state-active"))}}})});
} catch (e) {
console.error('Error in file:/templates/archi/js/jquery-ui.min.slider.js; Error:' + e.message);
};
try {
/*!
 * jQuery UI Touch Punch 0.2.3
 *
 * Copyright 2011â€“2014, Dave Furfero
 * Dual licensed under the MIT or GPL Version 2 licenses.
 *
 * Depends:
 *  jquery.ui.widget.js
 *  jquery.ui.mouse.js
 */
!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent("MouseEvents");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch="ontouchend"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,"mouseover"),f(a,"mousemove"),f(a,"mousedown"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,"mousemove"))},b._touchEnd=function(a){e&&(f(a,"mouseup"),f(a,"mouseout"),this._touchMoved||f(a,"click"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,"_touchStart"),touchmove:a.proxy(b,"_touchMove"),touchend:a.proxy(b,"_touchEnd")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,"_touchStart"),touchmove:a.proxy(b,"_touchMove"),touchend:a.proxy(b,"_touchEnd")}),d.call(b)}}}(jQuery);
} catch (e) {
console.error('Error in file:/templates/archi/js/jquery.ui.touch-punch.min.js; Error:' + e.message);
};
try {
/* Load this script using conditional IE comments if you need to support IE 7 and IE 6. */

window.onload = function() {
	function addIcon(el, entity) {
		var html = el.innerHTML;
		el.innerHTML = '<span style="font-family: \'ElegantIcons\'">' + entity + '</span>' + html;
	}
	var icons = {
			'arrow_up' : '&#x21;',
			'arrow_down' : '&#x22;',
			'arrow_left' : '&#x23;',
			'arrow_right' : '&#x24;',
			'arrow_left-up' : '&#x25;',
			'arrow_right-up' : '&#x26;',
			'arrow_right-down' : '&#x27;',
			'arrow_left-down' : '&#x28;',
			'arrow-up-down' : '&#x29;',
			'arrow_up-down_alt' : '&#x2a;',
			'arrow_left-right_alt' : '&#x2b;',
			'arrow_left-right' : '&#x2c;',
			'arrow_expand_alt2' : '&#x2d;',
			'arrow_expand_alt' : '&#x2e;',
			'arrow_condense' : '&#x2f;',
			'arrow_expand' : '&#x30;',
			'arrow_move' : '&#x31;',
			'arrow_carrot-up' : '&#x32;',
			'arrow_carrot-down' : '&#x33;',
			'arrow_carrot-left' : '&#x34;',
			'arrow_carrot-right' : '&#x35;',
			'arrow_carrot-2up' : '&#x36;',
			'arrow_carrot-2down' : '&#x37;',
			'arrow_carrot-2left' : '&#x38;',
			'arrow_carrot-2right' : '&#x39;',
			'arrow_carrot-up_alt2' : '&#x3a;',
			'arrow_carrot-down_alt2' : '&#x3b;',
			'arrow_carrot-left_alt2' : '&#x3c;',
			'arrow_carrot-right_alt2' : '&#x3d;',
			'arrow_carrot-2up_alt2' : '&#x3e;',
			'arrow_carrot-2down_alt2' : '&#x3f;',
			'arrow_carrot-2left_alt2' : '&#x40;',
			'arrow_carrot-2right_alt2' : '&#x41;',
			'arrow_triangle-up' : '&#x42;',
			'arrow_triangle-down' : '&#x43;',
			'arrow_triangle-left' : '&#x44;',
			'arrow_triangle-right' : '&#x45;',
			'arrow_triangle-up_alt2' : '&#x46;',
			'arrow_triangle-down_alt2' : '&#x47;',
			'arrow_triangle-left_alt2' : '&#x48;',
			'arrow_triangle-right_alt2' : '&#x49;',
			'arrow_back' : '&#x4a;',
			'icon_minus-06' : '&#x4b;',
			'icon_plus' : '&#x4c;',
			'icon_close' : '&#x4d;',
			'icon_check' : '&#x4e;',
			'icon_minus_alt2' : '&#x4f;',
			'icon_plus_alt2' : '&#x50;',
			'icon_close_alt2' : '&#x51;',
			'icon_check_alt2' : '&#x52;',
			'icon_zoom-out_alt' : '&#x53;',
			'icon_zoom-in_alt' : '&#x54;',
			'icon_search' : '&#x55;',
			'icon_box-empty' : '&#x56;',
			'icon_box-selected' : '&#x57;',
			'icon_minus-box' : '&#x58;',
			'icon_plus-box' : '&#x59;',
			'icon_box-checked' : '&#x5a;',
			'icon_circle-empty' : '&#x5b;',
			'icon_circle-slelected' : '&#x5c;',
			'icon_stop_alt2' : '&#x5d;',
			'icon_stop' : '&#x5e;',
			'icon_pause_alt2' : '&#x5f;',
			'icon_pause' : '&#x60;',
			'icon_menu' : '&#x61;',
			'icon_menu-square_alt2' : '&#x62;',
			'icon_menu-circle_alt2' : '&#x63;',
			'icon_ul' : '&#x64;',
			'icon_ol' : '&#x65;',
			'icon_adjust-horiz' : '&#x66;',
			'icon_adjust-vert' : '&#x67;',
			'icon_document_alt' : '&#x68;',
			'icon_documents_alt' : '&#x69;',
			'icon_pencil' : '&#x6a;',
			'icon_pencil-edit_alt' : '&#x6b;',
			'icon_pencil-edit' : '&#x6c;',
			'icon_folder-alt' : '&#x6d;',
			'icon_folder-open_alt' : '&#x6e;',
			'icon_folder-add_alt' : '&#x6f;',
			'icon_info_alt' : '&#x70;',
			'icon_error-oct_alt' : '&#x71;',
			'icon_error-circle_alt' : '&#x72;',
			'icon_error-triangle_alt' : '&#x73;',
			'icon_question_alt2' : '&#x74;',
			'icon_question' : '&#x75;',
			'icon_comment_alt' : '&#x76;',
			'icon_chat_alt' : '&#x77;',
			'icon_vol-mute_alt' : '&#x78;',
			'icon_volume-low_alt' : '&#x79;',
			'icon_volume-high_alt' : '&#x7a;',
			'icon_quotations' : '&#x7b;',
			'icon_quotations_alt2' : '&#x7c;',
			'icon_clock_alt' : '&#x7d;',
			'icon_lock_alt' : '&#x7e;',
			'icon_lock-open_alt' : '&#xe000;',
			'icon_key_alt' : '&#xe001;',
			'icon_cloud_alt' : '&#xe002;',
			'icon_cloud-upload_alt' : '&#xe003;',
			'icon_cloud-download_alt' : '&#xe004;',
			'icon_image' : '&#xe005;',
			'icon_images' : '&#xe006;',
			'icon_lightbulb_alt' : '&#xe007;',
			'icon_gift_alt' : '&#xe008;',
			'icon_house_alt' : '&#xe009;',
			'icon_genius' : '&#xe00a;',
			'icon_mobile' : '&#xe00b;',
			'icon_tablet' : '&#xe00c;',
			'icon_laptop' : '&#xe00d;',
			'icon_desktop' : '&#xe00e;',
			'icon_camera_alt' : '&#xe00f;',
			'icon_mail_alt' : '&#xe010;',
			'icon_cone_alt' : '&#xe011;',
			'icon_ribbon_alt' : '&#xe012;',
			'icon_bag_alt' : '&#xe013;',
			'icon_creditcard' : '&#xe014;',
			'icon_cart_alt' : '&#xe015;',
			'icon_paperclip' : '&#xe016;',
			'icon_tag_alt' : '&#xe017;',
			'icon_tags_alt' : '&#xe018;',
			'icon_trash_alt' : '&#xe019;',
			'icon_cursor_alt' : '&#xe01a;',
			'icon_mic_alt' : '&#xe01b;',
			'icon_compass_alt' : '&#xe01c;',
			'icon_pin_alt' : '&#xe01d;',
			'icon_pushpin_alt' : '&#xe01e;',
			'icon_map_alt' : '&#xe01f;',
			'icon_drawer_alt' : '&#xe020;',
			'icon_toolbox_alt' : '&#xe021;',
			'icon_book_alt' : '&#xe022;',
			'icon_calendar' : '&#xe023;',
			'icon_film' : '&#xe024;',
			'icon_table' : '&#xe025;',
			'icon_contacts_alt' : '&#xe026;',
			'icon_headphones' : '&#xe027;',
			'icon_lifesaver' : '&#xe028;',
			'icon_piechart' : '&#xe029;',
			'icon_refresh' : '&#xe02a;',
			'icon_link_alt' : '&#xe02b;',
			'icon_link' : '&#xe02c;',
			'icon_loading' : '&#xe02d;',
			'icon_blocked' : '&#xe02e;',
			'icon_archive_alt' : '&#xe02f;',
			'icon_heart_alt' : '&#xe030;',
			'icon_star_alt' : '&#xe031;',
			'icon_star-half_alt' : '&#xe032;',
			'icon_star' : '&#xe033;',
			'icon_star-half' : '&#xe034;',
			'icon_tools' : '&#xe035;',
			'icon_tool' : '&#xe036;',
			'icon_cog' : '&#xe037;',
			'icon_cogs' : '&#xe038;',
			'arrow_up_alt' : '&#xe039;',
			'arrow_down_alt' : '&#xe03a;',
			'arrow_left_alt' : '&#xe03b;',
			'arrow_right_alt' : '&#xe03c;',
			'arrow_left-up_alt' : '&#xe03d;',
			'arrow_right-up_alt' : '&#xe03e;',
			'arrow_right-down_alt' : '&#xe03f;',
			'arrow_left-down_alt' : '&#xe040;',
			'arrow_condense_alt' : '&#xe041;',
			'arrow_expand_alt3' : '&#xe042;',
			'arrow_carrot_up_alt' : '&#xe043;',
			'arrow_carrot-down_alt' : '&#xe044;',
			'arrow_carrot-left_alt' : '&#xe045;',
			'arrow_carrot-right_alt' : '&#xe046;',
			'arrow_carrot-2up_alt' : '&#xe047;',
			'arrow_carrot-2dwnn_alt' : '&#xe048;',
			'arrow_carrot-2left_alt' : '&#xe049;',
			'arrow_carrot-2right_alt' : '&#xe04a;',
			'arrow_triangle-up_alt' : '&#xe04b;',
			'arrow_triangle-down_alt' : '&#xe04c;',
			'arrow_triangle-left_alt' : '&#xe04d;',
			'arrow_triangle-right_alt' : '&#xe04e;',
			'icon_minus_alt' : '&#xe04f;',
			'icon_plus_alt' : '&#xe050;',
			'icon_close_alt' : '&#xe051;',
			'icon_check_alt' : '&#xe052;',
			'icon_zoom-out' : '&#xe053;',
			'icon_zoom-in' : '&#xe054;',
			'icon_stop_alt' : '&#xe055;',
			'icon_menu-square_alt' : '&#xe056;',
			'icon_menu-circle_alt' : '&#xe057;',
			'icon_document' : '&#xe058;',
			'icon_documents' : '&#xe059;',
			'icon_pencil_alt' : '&#xe05a;',
			'icon_folder' : '&#xe05b;',
			'icon_folder-open' : '&#xe05c;',
			'icon_folder-add' : '&#xe05d;',
			'icon_folder_upload' : '&#xe05e;',
			'icon_folder_download' : '&#xe05f;',
			'icon_info' : '&#xe060;',
			'icon_error-circle' : '&#xe061;',
			'icon_error-oct' : '&#xe062;',
			'icon_error-triangle' : '&#xe063;',
			'icon_question_alt' : '&#xe064;',
			'icon_comment' : '&#xe065;',
			'icon_chat' : '&#xe066;',
			'icon_vol-mute' : '&#xe067;',
			'icon_volume-low' : '&#xe068;',
			'icon_volume-high' : '&#xe069;',
			'icon_quotations_alt' : '&#xe06a;',
			'icon_clock' : '&#xe06b;',
			'icon_lock' : '&#xe06c;',
			'icon_lock-open' : '&#xe06d;',
			'icon_key' : '&#xe06e;',
			'icon_cloud' : '&#xe06f;',
			'icon_cloud-upload' : '&#xe070;',
			'icon_cloud-download' : '&#xe071;',
			'icon_lightbulb' : '&#xe072;',
			'icon_gift' : '&#xe073;',
			'icon_house' : '&#xe074;',
			'icon_camera' : '&#xe075;',
			'icon_mail' : '&#xe076;',
			'icon_cone' : '&#xe077;',
			'icon_ribbon' : '&#xe078;',
			'icon_bag' : '&#xe079;',
			'icon_cart' : '&#xe07a;',
			'icon_tag' : '&#xe07b;',
			'icon_tags' : '&#xe07c;',
			'icon_trash' : '&#xe07d;',
			'icon_cursor' : '&#xe07e;',
			'icon_mic' : '&#xe07f;',
			'icon_compass' : '&#xe080;',
			'icon_pin' : '&#xe081;',
			'icon_pushpin' : '&#xe082;',
			'icon_map' : '&#xe083;',
			'icon_drawer' : '&#xe084;',
			'icon_toolbox' : '&#xe085;',
			'icon_book' : '&#xe086;',
			'icon_contacts' : '&#xe087;',
			'icon_archive' : '&#xe088;',
			'icon_heart' : '&#xe089;',
			'icon_profile' : '&#xe08a;',
			'icon_group' : '&#xe08b;',
			'icon_grid-2x2' : '&#xe08c;',
			'icon_grid-3x3' : '&#xe08d;',
			'icon_music' : '&#xe08e;',
			'icon_pause_alt' : '&#xe08f;',
			'icon_phone' : '&#xe090;',
			'icon_upload' : '&#xe091;',
			'icon_download' : '&#xe092;',
			'social_facebook' : '&#xe093;',
			'social_twitter' : '&#xe094;',
			'social_pinterest' : '&#xe095;',
			'social_googleplus' : '&#xe096;',
			'social_tumblr' : '&#xe097;',
			'social_tumbleupon' : '&#xe098;',
			'social_wordpress' : '&#xe099;',
			'social_instagram' : '&#xe09a;',
			'social_dribbble' : '&#xe09b;',
			'social_vimeo' : '&#xe09c;',
			'social_linkedin' : '&#xe09d;',
			'social_rss' : '&#xe09e;',
			'social_deviantart' : '&#xe09f;',
			'social_share' : '&#xe0a0;',
			'social_myspace' : '&#xe0a1;',
			'social_skype' : '&#xe0a2;',
			'social_youtube' : '&#xe0a3;',
			'social_picassa' : '&#xe0a4;',
			'social_googledrive' : '&#xe0a5;',
			'social_flickr' : '&#xe0a6;',
			'social_blogger' : '&#xe0a7;',
			'social_spotify' : '&#xe0a8;',
			'social_delicious' : '&#xe0a9;',
			'social_facebook_circle' : '&#xe0aa;',
			'social_twitter_circle' : '&#xe0ab;',
			'social_pinterest_circle' : '&#xe0ac;',
			'social_googleplus_circle' : '&#xe0ad;',
			'social_tumblr_circle' : '&#xe0ae;',
			'social_stumbleupon_circle' : '&#xe0af;',
			'social_wordpress_circle' : '&#xe0b0;',
			'social_instagram_circle' : '&#xe0b1;',
			'social_dribbble_circle' : '&#xe0b2;',
			'social_vimeo_circle' : '&#xe0b3;',
			'social_linkedin_circle' : '&#xe0b4;',
			'social_rss_circle' : '&#xe0b5;',
			'social_deviantart_circle' : '&#xe0b6;',
			'social_share_circle' : '&#xe0b7;',
			'social_myspace_circle' : '&#xe0b8;',
			'social_skype_circle' : '&#xe0b9;',
			'social_youtube_circle' : '&#xe0ba;',
			'social_picassa_circle' : '&#xe0bb;',
			'social_googledrive_alt2' : '&#xe0bc;',
			'social_flickr_circle' : '&#xe0bd;',
			'social_blogger_circle' : '&#xe0be;',
			'social_spotify_circle' : '&#xe0bf;',
			'social_delicious_circle' : '&#xe0c0;',
			'social_facebook_square' : '&#xe0c1;',
			'social_twitter_square' : '&#xe0c2;',
			'social_pinterest_square' : '&#xe0c3;',
			'social_googleplus_square' : '&#xe0c4;',
			'social_tumblr_square' : '&#xe0c5;',
			'social_stumbleupon_square' : '&#xe0c6;',
			'social_wordpress_square' : '&#xe0c7;',
			'social_instagram_square' : '&#xe0c8;',
			'social_dribbble_square' : '&#xe0c9;',
			'social_vimeo_square' : '&#xe0ca;',
			'social_linkedin_square' : '&#xe0cb;',
			'social_rss_square' : '&#xe0cc;',
			'social_deviantart_square' : '&#xe0cd;',
			'social_share_square' : '&#xe0ce;',
			'social_myspace_square' : '&#xe0cf;',
			'social_skype_square' : '&#xe0d0;',
			'social_youtube_square' : '&#xe0d1;',
			'social_picassa_square' : '&#xe0d2;',
			'social_googledrive_square' : '&#xe0d3;',
			'social_flickr_square' : '&#xe0d4;',
			'social_blogger_square' : '&#xe0d5;',
			'social_spotify_square' : '&#xe0d6;',
			'social_delicious_square' : '&#xe0d7;',
			'icon_printer' : '&#xe103;',
			'icon_calulator' : '&#xe0ee;',
			'icon_building' : '&#xe0ef;',
			'icon_floppy' : '&#xe0e8;',
			'icon_drive' : '&#xe0ea;',
			'icon_search-2' : '&#xe101;',
			'icon_id' : '&#xe107;',
			'icon_id-2' : '&#xe108;',
			'icon_puzzle' : '&#xe102;',
			'icon_like' : '&#xe106;',
			'icon_dislike' : '&#xe0eb;',
			'icon_mug' : '&#xe105;',
			'icon_currency' : '&#xe0ed;',
			'icon_wallet' : '&#xe100;',
			'icon_pens' : '&#xe104;',
			'icon_easel' : '&#xe0e9;',
			'icon_flowchart' : '&#xe109;',
			'icon_datareport' : '&#xe0ec;',
			'icon_briefcase' : '&#xe0fe;',
			'icon_shield' : '&#xe0f6;',
			'icon_percent' : '&#xe0fb;',
			'icon_globe' : '&#xe0e2;',
			'icon_globe-2' : '&#xe0e3;',
			'icon_target' : '&#xe0f5;',
			'icon_hourglass' : '&#xe0e1;',
			'icon_balance' : '&#xe0ff;',
			'icon_rook' : '&#xe0f8;',
			'icon_printer-alt' : '&#xe0fa;',
			'icon_calculator_alt' : '&#xe0e7;',
			'icon_building_alt' : '&#xe0fd;',
			'icon_floppy_alt' : '&#xe0e4;',
			'icon_drive_alt' : '&#xe0e5;',
			'icon_search_alt' : '&#xe0f7;',
			'icon_id_alt' : '&#xe0e0;',
			'icon_id-2_alt' : '&#xe0fc;',
			'icon_puzzle_alt' : '&#xe0f9;',
			'icon_like_alt' : '&#xe0dd;',
			'icon_dislike_alt' : '&#xe0f1;',
			'icon_mug_alt' : '&#xe0dc;',
			'icon_currency_alt' : '&#xe0f3;',
			'icon_wallet_alt' : '&#xe0d8;',
			'icon_pens_alt' : '&#xe0db;',
			'icon_easel_alt' : '&#xe0f0;',
			'icon_flowchart_alt' : '&#xe0df;',
			'icon_datareport_alt' : '&#xe0f2;',
			'icon_briefcase_alt' : '&#xe0f4;',
			'icon_shield_alt' : '&#xe0d9;',
			'icon_percent_alt' : '&#xe0da;',
			'icon_globe_alt' : '&#xe0de;',
			'icon_clipboard' : '&#xe0e6;'
		},
		els = document.getElementsByTagName('*'),
		i, attr, c, el;
	for (i = 0; ; i += 1) {
		el = els[i];
		if(!el) {
			break;
		}
		attr = el.getAttribute('data-icon');
		if (attr) {
			addIcon(el, attr);
		}
		c = el.className;
		c = c.match(/[^\s'"]+/);
		if (c && icons[c[0]]) {
			addIcon(el, icons[c[0]]);
		}
	}
};
} catch (e) {
console.error('Error in file:/templates/archi/fonts/elegant_font/HTML_CSS/lte-ie7.js; Error:' + e.message);
};