<?php
/* !!! AJAX WEB VERSION !!! */
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);

include_once 'hhrFilterPage.php';
$process = new ProcessMini();
$processRealko = new ProcessRko($process);



if ($process->logged)
{

    if (!empty($_REQUEST))
    {
        if (isset($_REQUEST['action']))
        {
            $action = $_REQUEST['action'];
        }
        else
        {
            $action = 'NoAction';
        }
    }
    else
    {
        $action = 'NoRequest';
    }


    switch ($action)
    {
        case 'NoAction':
            $finalArray['request'] = $_REQUEST;
            $finalArray['status'] = 'ERR-ACTION_IN_REQUEST_MISSING';
            break;
        case 'NoRequest':
            $finalArray['status'] = 'ERR-REQUEST_MISSING';
            break;


        case 'refreshFilter':
            $filterType = $_REQUEST['filterType'];
            $filterSelected = json_decode($_REQUEST['filterSelected'], true);
            $filterValues = $filterSelected == 'undefined' || empty($filterSelected) ? [] : $filterSelected;
            $filterActivated = json_decode($_REQUEST['filterActive'], true);
            $filterCategoryActive = $filterActivated == 'undefined' || empty($filterActivated) ? [] : $filterActivated;
            $refreshContent = $_REQUEST['refreshContent'] == 1 ? true : false;
            $pageSize = $_REQUEST['pageSize'];
            $sortKey = $_REQUEST['sortKey'];

            switch ($sortKey)
            {
                case 'sortDateAsc':
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
                case 'sortDateDesc':
                    $orderBy = 'update_order';
                    $asc = false;
                    break;
                case 'sortCenaAsc':
                    $orderBy = 'price_order';
                    $asc = true;
                    break;
                case 'sortCenaDesc':
                    $orderBy = 'price_order';
                    $asc = false;
                    break;
                default:
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
            }

            $filter = $processRealko->renderFilter($filterType, $filterValues, $filterCategoryActive, $orderBy, $asc);
            $finalArray['status'] = 'OK';
            $finalArray['filter'] = $filter;
            if ($refreshContent)
            {
                $finalArray['estatelist'] = $processRealko->renderEstateList($filterType, $filterValues);
                if (isset($processRealko->estateList) && count($processRealko->estateList) > 0)
                {
                    for ($i = 0; $i < $pageSize; $i++)
                    {
                        if (isset($processRealko->estateList[$i]))
                        {
                            $estatesToRender[] = $processRealko->estateList[$i];
                        }
                    }
                    $finalArray['estatehtml'] = $processRealko->renderEstateHtmlIntro($estatesToRender);
                    if (isset($processRealko->estateList[$i + 1]))
                    {
                        $finalArray['nextload'] = $processRealko->renderNextloadButton($pageSize);
                    }
                }

            }
            $finalArray['estatecount'] = count($processRealko->estateList);

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'refreshFilterEn':
            $filterType = $_REQUEST['filterType'];
            $filterSelected = json_decode($_REQUEST['filterSelected'], true);
            $filterValues = $filterSelected == 'undefined' || empty($filterSelected) ? [] : $filterSelected;
            $filterActivated = json_decode($_REQUEST['filterActive'], true);
            $filterCategoryActive = $filterActivated == 'undefined' || empty($filterActivated) ? [] : $filterActivated;
            $refreshContent = $_REQUEST['refreshContent'] == 1 ? true : false;
            $pageSize = $_REQUEST['pageSize'];
            $sortKey = $_REQUEST['sortKey'];

            switch ($sortKey)
            {
                case 'sortDateAsc':
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
                case 'sortDateDesc':
                    $orderBy = 'update_order';
                    $asc = false;
                    break;
                case 'sortCenaAsc':
                    $orderBy = 'price_order';
                    $asc = true;
                    break;
                case 'sortCenaDesc':
                    $orderBy = 'price_order';
                    $asc = false;
                    break;
                default:
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
            }

            $filter = $processRealko->renderFilterEn($filterType, $filterValues, $filterCategoryActive, $orderBy, $asc);
            $finalArray['status'] = 'OK';
            $finalArray['filter'] = $filter;
            if ($refreshContent)
            {
                $finalArray['estatelist'] = $processRealko->renderEstateListEn($filterType, $filterValues);
                if (isset($processRealko->estateList) && count($processRealko->estateList) > 0)
                {
                    for ($i = 0; $i < $pageSize; $i++)
                    {
                        if (isset($processRealko->estateList[$i]))
                        {
                            $estatesToRender[] = $processRealko->estateList[$i];
                        }
                    }
                    $finalArray['estatehtml'] = $processRealko->renderEstateHtmlIntroEn($estatesToRender);
                    if (isset($processRealko->estateList[$i + 1]))
                    {
                        $finalArray['nextload'] = $processRealko->renderNextloadButtonEn($pageSize);
                    }
                }

            }
            $finalArray['estatecount'] = count($processRealko->estateList);

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'updateFilter':
            $filterType = $_REQUEST['filterType'];
            $filterSelected = json_decode($_REQUEST['filterSelected'], true);
            $filterValues = $filterSelected == 'undefined' || empty($filterSelected) ? [] : $filterSelected;
            $refreshContent = $_REQUEST['refreshContent'] == 1 ? true : false;
            $pageSize = $_REQUEST['pageSize'];
            $sortKey = $_REQUEST['sortKey'];

            switch ($sortKey)
            {
                case 'sortDateAsc':
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
                case 'sortDateDesc':
                    $orderBy = 'update_order';
                    $asc = false;
                    break;
                case 'sortCenaAsc':
                    $orderBy = 'price_order';
                    $asc = true;
                    break;
                case 'sortCenaDesc':
                    $orderBy = 'price_order';
                    $asc = false;
                    break;
                default:
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
            }

            $filterCounts = $processRealko->updateFilterCounts($filterType, $filterValues, $orderBy, $asc);
            $finalArray['status'] = 'OK';
            $finalArray['filtercounts'] = $filterCounts;
            if ($refreshContent)
            {
                $finalArray['estatelist'] = $processRealko->renderEstateList($filterType, $filterValues);
                if (isset($processRealko->estateList) && count($processRealko->estateList) > 0)
                {
                    for ($i = 0; $i < $pageSize; $i++)
                    {
                        if (isset($processRealko->estateList[$i]))
                        {
                            $estatesToRender[] = $processRealko->estateList[$i];
                        }
                    }
                    $finalArray['estatehtml'] = $processRealko->renderEstateHtmlIntro($estatesToRender);
                    if (isset($processRealko->estateList[$i + 1]))
                    {
                        $finalArray['nextload'] = $processRealko->renderNextloadButton($pageSize);
                    }
                }
            }
            $finalArray['estatecount'] = count($processRealko->estateList);

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'updateFilterEn':
            $filterType = $_REQUEST['filterType'];
            $filterSelected = json_decode($_REQUEST['filterSelected'], true);
            $filterValues = $filterSelected == 'undefined' || empty($filterSelected) ? [] : $filterSelected;
            $refreshContent = $_REQUEST['refreshContent'] == 1 ? true : false;
            $pageSize = $_REQUEST['pageSize'];
            $sortKey = $_REQUEST['sortKey'];

            switch ($sortKey)
            {
                case 'sortDateAsc':
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
                case 'sortDateDesc':
                    $orderBy = 'update_order';
                    $asc = false;
                    break;
                case 'sortCenaAsc':
                    $orderBy = 'price_order';
                    $asc = true;
                    break;
                case 'sortCenaDesc':
                    $orderBy = 'price_order';
                    $asc = false;
                    break;
                default:
                    $orderBy = 'update_order';
                    $asc = true;
                    break;
            }

            $filterCounts = $processRealko->updateFilterCounts($filterType, $filterValues, $orderBy, $asc);
            $finalArray['status'] = 'OK';
            $finalArray['filtercounts'] = $filterCounts;
            if ($refreshContent)
            {
                $finalArray['estatelist'] = $processRealko->renderEstateListEn($filterType, $filterValues);
                if (isset($processRealko->estateList) && count($processRealko->estateList) > 0)
                {
                    for ($i = 0; $i < $pageSize; $i++)
                    {
                        if (isset($processRealko->estateList[$i]))
                        {
                            $estatesToRender[] = $processRealko->estateList[$i];
                        }
                    }
                    $finalArray['estatehtml'] = $processRealko->renderEstateHtmlIntroEn($estatesToRender);
                    if (isset($processRealko->estateList[$i + 1]))
                    {
                        $finalArray['nextload'] = $processRealko->renderNextloadButtonEn($pageSize);
                    }
                }
            }
            $finalArray['estatecount'] = count($processRealko->estateList);

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'loadNext':
            $estatesToLoad = json_decode($_REQUEST['estatesToLoad'], true);
            $pageSize = $_REQUEST['pageSize'];
            $process->debugMessage[] = $estatesToLoad;
            $finalArray['status'] = 'OK';
            $finalArray['estatehtml'] = $processRealko->renderEstateHtmlIntro($estatesToLoad);
            $finalArray['nextload'] = $processRealko->renderNextloadButton($pageSize);

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'loadNextEn':
            $estatesToLoad = json_decode($_REQUEST['estatesToLoad'], true);
            $pageSize = $_REQUEST['pageSize'];
            $process->debugMessage[] = $estatesToLoad;
            $finalArray['status'] = 'OK';
            $finalArray['estatehtml'] = $processRealko->renderEstateHtmlIntroEn($estatesToLoad);
            $finalArray['nextload'] = $processRealko->renderNextloadButtonEn($pageSize);

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'addPlan':
            $estateId = $_REQUEST['estateId'];
            $externalId = $_REQUEST['externalId'];
            $title = $_REQUEST['title'];
            $link = $_REQUEST['link'];
            $remove = $_REQUEST['remove'] === 'remove' ? true : false;
            session_start();

            if (isset($_SESSION))
            {
                if (isset($_SESSION['hhrPlanList']) && $remove)
                {
                    unset($_SESSION['hhrPlanList'][$estateId]);
                }
                else
                {
                    $_SESSION['hhrPlanList'][$estateId]['title'] = $title;
                    $_SESSION['hhrPlanList'][$estateId]['link'] = $link;
                    $_SESSION['hhrPlanList'][$estateId]['externalId'] = $externalId;
                }
                $finalArray['status'] = 'OK';
                $finalArray['planList'] = $_SESSION['hhrPlanList'];

            }
            else
            {
                $finalArray['status'] = 'ERR-PLANLIST_LOADING_FAILED';

            }

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'addFavorite':
            $estateId = $_REQUEST['estateId'];
            $externalId = $_REQUEST['externalId'];
            $title = $_REQUEST['title'];
            $link = $_REQUEST['link'];
            $remove = $_REQUEST['remove'] === 'remove' ? true : false;
            session_start();

            if (isset($_SESSION))
            {
                if (isset($_SESSION['hhrFavoriteList']) && $remove)
                {
                    unset($_SESSION['hhrFavoriteList'][$estateId]);
                }
                else
                {
                    $_SESSION['hhrFavoriteList'][$estateId]['title'] = $title;
                    $_SESSION['hhrFavoriteList'][$estateId]['link'] = $link;
                    $_SESSION['hhrFavoriteList'][$estateId]['externalId'] = $externalId;
                }
                $finalArray['status'] = 'OK';
                $finalArray['favoriteList'] = $_SESSION['hhrFavoriteList'];

            }
            else
            {
                $finalArray['status'] = 'ERR-FAVORITELIST_LOADING_FAILED';

            }

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'getLists':
            session_start();

            if (isset($_SESSION))
            {
                $finalArray['status'] = 'OK';

                if (isset($_SESSION['hhrFavoriteList']) && count($_SESSION['hhrFavoriteList']) > 0)
                {
                    $finalArray['favoriteList'] = $_SESSION['hhrFavoriteList'];
                }

                if (isset($_SESSION['hhrPlanList']) && count($_SESSION['hhrPlanList']) > 0)
                {
                    $finalArray['planList'] = $_SESSION['hhrPlanList'];
                }

            }
            else
            {
                $finalArray['status'] = 'ERR-LISTS_LOADING_FAILED';
            }

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'quickFormSend':
            $lang = $_REQUEST['lang'];
            $subject = $_REQUEST['subject'];
            $formFields = json_decode($_REQUEST['formFields'], true);
            $reciever = 'info@happyhouserentals.com';
            // $reciever = 'support@hk-press.cz';
            $sender = 'info@happyhouserentals.com';

            if (isset($formFields) && is_array($formFields) && count($formFields) > 0)
            {

                switch ($subject)
                {
                    case 'Nabídka nemovitosti':
                    case 'Poptávka nemovitosti':
                    case 'Poptávka správy nemovitosti':
                        $template = file_get_contents('template2.html.template');
                        foreach ($formFields as $formField)
                        {
                            if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                            {
                                $sender = $formField['value'];
                            }
                            else if (strpos($formField['label'], 'email') !== false && strpos($formField['value'], '@happyhouserentals.com') > 1)
                            {
                                // $reciever = $formField['value'];
                            }

                            switch ($formField['label'])
                            {
                                case 'Stručný popis nemovitosti':
                                    $template = str_replace('__LABEL_DESCRIPTION__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_DESCRIPTION__', $formField['value'], $template);
                                    break;
                                case 'Jméno a příjmení':
                                    $template = str_replace('__LABEL_NAME__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                    break;
                                case 'Telefon':
                                    $template = str_replace('__LABEL_PHONE__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                    break;
                                case 'Email':
                                    $template = str_replace('__LABEL_EMAIL__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                    break;
                            }

                            $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                        }

                        $header = $subject;
                        $template = str_replace('__HEADER__', $header, $template);

                        $subHeader = 'Nový požadavek z webového portálu';
                        $template = str_replace('__SUB_HEADER__', $subHeader, $template);

                        $textFooter1 = 'Děkujeme za zájem využít služeb naší realitní kanceláře Happy House Rentals, s.r.o. Vaši poptávku vyřídíme během několika hodin, nejpozději do následujícího pracovního dne.';
                        $template = str_replace('__TEXT_FOOTER_1__', $textFooter1, $template);
                        $textFooter2 = 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com';
                        $template = str_replace('__TEXT_FOOTER_2__', $textFooter2, $template);
                        $textFooter3 = 'PRODEJ | PRONÁJEM | SPRÁVA NEMOVITOSTÍ | ČINŽOVNÍ DOMY';
                        $template = str_replace('__TEXT_FOOTER_3__', $textFooter3, $template);
                        $emailHtml = $template;
                        break;

                    case 'Property offer':
                    case 'Property searching':
                    case 'Property management enquiry':
                        $template = file_get_contents('template2.html.template');
                        foreach ($formFields as $formField)
                        {
                            if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                            {
                                $sender = $formField['value'];
                            }
                            else if (strpos($formField['label'], 'email') !== false && strpos($formField['value'], '@happyhouserentals.com') > 1)
                            {
                                // $reciever = $formField['value'];
                            }

                            switch ($formField['label'])
                            {
                                case 'Short property description':
                                    $template = str_replace('__LABEL_DESCRIPTION__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_DESCRIPTION__', $formField['value'], $template);
                                    break;
                                case 'Full name':
                                    $template = str_replace('__LABEL_NAME__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                    break;
                                case 'Phone':
                                    $template = str_replace('__LABEL_PHONE__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                    break;
                                case 'Email':
                                    $template = str_replace('__LABEL_EMAIL__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                    break;
                            }

                            $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                        }

                        $header = $subject;
                        $template = str_replace('__HEADER__', $header, $template);

                        $subHeader = 'New request from the site www.HappyHouseRentals.com';
                        $template = str_replace('__SUB_HEADER__', $subHeader, $template);

                        $textFooter1 = 'Thank you for your interest in the services of our real estate agency Happy House Rentals, s.r.o. We will process your request within a few hours, but no later than the next working day.';
                        $template = str_replace('__TEXT_FOOTER_1__', $textFooter1, $template);
                        $textFooter2 = 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com';
                        $template = str_replace('__TEXT_FOOTER_2__', $textFooter2, $template);
                        $textFooter3 = 'SALES | RENTALS | PROPERTY / FACILITY MANAGEMENT | SALES OF APARTMENT BUILDINGS';
                        $template = str_replace('__TEXT_FOOTER_3__', $textFooter3, $template);
                        $emailHtml = $template;
                        break;

                    case 'Naplánování prohlídky':
                        $template = file_get_contents('template3.html.template');
                        $estateList = [];
                        foreach ($formFields as $formField)
                        {
                            if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                            {
                                $sender = $formField['value'];
                            }
                            else if ($formField['label'] == 'Agent' && strpos($formField['value'], '@happyhouserentals.com') > 1)
                            {
                                $reciever = $formField['value'];
                                // $reciever = 'support@videotechnik.cz';
                            }

                            if (strpos($formField['label'], 'Estate') !== false)
                            {
                                if (strpos($formField['label'], 'Estate ID') !== false)
                                {
                                    $estateList[$formField['value']]['Estate ID'] = $formField['value'];
                                }
                                if (strpos($formField['label'], 'Estate External ID') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate External ID'] = $formField['value'];
                                        }
                                    }
                                }
                                if (strpos($formField['label'], 'Estate Title') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate Title'] = $formField['value'];
                                        }
                                    }
                                }
                                if (strpos($formField['label'], 'Estate Link') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate Link'] = $formField['value'];
                                        }
                                    }
                                }

                            }

                            switch ($formField['label'])
                            {
                                case 'Vybraný agent':
                                    $template = str_replace('__LABEL_AGENT_NAME__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_AGENT_NAME__', $formField['value'], $template);
                                    break;
                                case 'Doplňující informace':
                                    $template = str_replace('__LABEL_DESCRIPTION2__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_DESCRIPTION2__', $formField['value'], $template);
                                    break;
                                case 'Jméno a příjmení':
                                    $template = str_replace('__LABEL_NAME__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                    break;
                                case 'Telefon':
                                    $template = str_replace('__LABEL_PHONE__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                    break;
                                case 'Email':
                                    $template = str_replace('__LABEL_EMAIL__', $formField['label'], $template);
                                    $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                    break;

                            }

                            $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                        }

                        $estateListHtml = '';

                        foreach ($estateList as $estateId => $estateData)
                        {
                            $estateItemHtml = '<div><a href="' . $estateData['Estate Link'] . '">' . $estateData['Estate External ID'] . '</a><br><span>' . $estateData['Estate Title'] . '</span></div>';
                            $estateListHtml .= $estateItemHtml;
                        }

                        // $estateListHtml .= '<pre>' . print_r($estateList, true) . '</pre>';

                        $template = str_replace('__LABEL_DESCRIPTION1__', 'Seznam nemovitostí', $template);
                        $template = str_replace('__TEXT_DESCRIPTION1__', $estateListHtml, $template);

                        $header = $subject;
                        $template = str_replace('__HEADER__', $header, $template);

                        $subHeader = 'Nový požadavek z webového portálu';
                        $template = str_replace('__SUB_HEADER__', $subHeader, $template);

                        $textFooter1 = 'Děkujeme za zájem využít služeb naší realitní kanceláře Happy House Rentals, s.r.o. Vaši poptávku vyřídíme během několika hodin, nejpozději do následujícího pracovního dne.';
                        $template = str_replace('__TEXT_FOOTER_1__', $textFooter1, $template);
                        $textFooter2 = 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com';
                        $template = str_replace('__TEXT_FOOTER_2__', $textFooter2, $template);
                        $textFooter3 = 'PRODEJ | PRONÁJEM | SPRÁVA NEMOVITOSTÍ | ČINŽOVNÍ DOMY';
                        $template = str_replace('__TEXT_FOOTER_3__', $textFooter3, $template);
                        $emailHtml = $template;
                        break;

                    default:
                        /* Handle cases with property ID in subject */

                        if (strpos($subject, 'Naplánování prohlídky') !== false)
                        {
                            $template = file_get_contents('template3.html.template');
                            $estateList = [];
                            foreach ($formFields as $formField)
                            {
                                if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                                {
                                    $sender = $formField['value'];
                                }
                                else if ($formField['label'] == 'Kontaktní email agenta' && strpos($formField['value'], '@happyhouserentals.com') > 1)
                                {
                                    $reciever = $formField['value'];
                                    // $reciever = 'support@videotechnik.cz';
                                }

                                if (strpos($formField['label'], 'ID nabídky') !== false)
                                {
                                    $estateList[$formField['value']]['Estate ID'] = $formField['value'];
                                }
                                if (strpos($formField['label'], '"ID nabídky"') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate External ID'] = $formField['value'];
                                        }
                                    }
                                }
                                if (strpos($formField['label'], 'Název nabídky') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate Title'] = $formField['value'];
                                        }
                                    }
                                }
                                if (strpos($formField['label'], 'Estate Link') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate Link'] = $formField['value'];
                                        }
                                    }
                                }



                                switch ($formField['label'])
                                {
                                    case 'Vybraný agent':
                                        $template = str_replace('__LABEL_AGENT_NAME__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_AGENT_NAME__', $formField['value'], $template);
                                        break;
                                    case 'Doplňující informace':
                                        $template = str_replace('__LABEL_DESCRIPTION2__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_DESCRIPTION2__', $formField['value'], $template);
                                        break;
                                    case 'Jméno a příjmení':
                                        $template = str_replace('__LABEL_NAME__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                        break;
                                    case 'Telefon':
                                        $template = str_replace('__LABEL_PHONE__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                        break;
                                    case 'Email':
                                        $template = str_replace('__LABEL_EMAIL__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                        break;
                                    case 'Název nabídky':
                                        $template = str_replace('__LABEL_DESCRIPTION1__', 'Vybraná nabídka', $template);
                                        $template = str_replace('__TEXT_DESCRIPTION1__', $formField['value'], $template);
                                        break;
                                    case 'href':
                                        $hrefLink = '<a href="' . $formField['value'] . '">__TEXT_DESCRIPTION1__</a>';
                                        $template = str_replace('__TEXT_DESCRIPTION1__', $hrefLink, $template);
                                        break;
                                }

                                $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                            }

                            $estateListHtml = '';

                            foreach ($estateList as $estateId => $estateData)
                            {
                                $estateItemHtml = '<div><span>' . $estateData['Estate External ID'] . '</span><br><span>' . $estateData['Estate Title'] . '</span></div>';
                                $estateListHtml .= $estateItemHtml;
                            }

                            // $estateListHtml .= '<pre>' . print_r($estateList, true) . '</pre>';

                            $template = str_replace('__LABEL_DESCRIPTION1__', 'Vybraná nabídka', $template);
                            $template = str_replace('__TEXT_DESCRIPTION1__', $estateListHtml, $template);

                            $header = $subject;
                            $template = str_replace('__HEADER__', $header, $template);

                            $subHeader = 'Nový požadavek z webového portálu';
                            $template = str_replace('__SUB_HEADER__', $subHeader, $template);

                            $textFooter1 = 'Děkujeme za zájem využít služeb naší realitní kanceláře Happy House Rentals, s.r.o. Vaši poptávku vyřídíme během několika hodin, nejpozději do následujícího pracovního dne.';
                            $template = str_replace('__TEXT_FOOTER_1__', $textFooter1, $template);
                            $textFooter2 = 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com';
                            $template = str_replace('__TEXT_FOOTER_2__', $textFooter2, $template);
                            $textFooter3 = 'PRODEJ | PRONÁJEM | SPRÁVA NEMOVITOSTÍ | ČINŽOVNÍ DOMY';
                            $template = str_replace('__TEXT_FOOTER_3__', $textFooter3, $template);
                            $emailHtml = $template;

                        }
                        elseif (strpos($subject, 'Visit request on') !== false)
                        {
                            /*
                          [{"label":"Selected agent","value":"Petr Karásek "},{"label":"Agent contact email","value":"karasek@happyhouserentals.com"},{"label":"Full name","value":"Daniel Bernat"},{"label":"Phone","value":"771173605"},{"label":"Email","value":"support@hk-press.cz"},{"label":"Additional details","value":"Testovací email (DAN)"},{"label":"property ID","value":"N35761"},{"label":"Property title","value":"Spacious, bright apartment (110.46 sqm) after complete reconstruction with two bedrooms and a garage on the 3rd floor in the center of Prague 1, Štěpánská street"},{"label":"href","value":"https://www.happyhouserentals.com/en/662127"}]
                           */

                            $template = file_get_contents('template3.html.template');
                            $estateList = [];
                            foreach ($formFields as $formField)
                            {
                                if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                                {
                                    $sender = $formField['value'];
                                }
                                else if ($formField['label'] == 'Agent contact email' && strpos($formField['value'], '@happyhouserentals.com') > 1)
                                {
                                    $reciever = $formField['value'];
                                    // $reciever = 'support@videotechnik.cz';
                                }

                                if (strpos($formField['label'], 'property ID') !== false)
                                {
                                    $estateList[$formField['value']]['Estate ID'] = $formField['value'];
                                }
                                if (strpos($formField['label'], 'property ID') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate External ID'] = $formField['value'];
                                        }
                                    }
                                }
                                if (strpos($formField['label'], 'Property title') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate Title'] = $formField['value'];
                                        }
                                    }
                                }
                                if (strpos($formField['label'], 'Estate Link') !== false)
                                {
                                    foreach ($estateList as $estateId => $estateData)
                                    {
                                        if (strpos($formField['label'], strval($estateId)) !== false)
                                        {
                                            $estateList[$estateId]['Estate Link'] = $formField['value'];
                                        }
                                    }
                                }


                                switch ($formField['label'])
                                {
                                    case 'Selected agent':
                                        $template = str_replace('__LABEL_AGENT_NAME__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_AGENT_NAME__', $formField['value'], $template);
                                        break;
                                    case 'Additional details':
                                        $template = str_replace('__LABEL_DESCRIPTION2__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_DESCRIPTION2__', $formField['value'], $template);
                                        break;
                                    case 'Full name':
                                        $template = str_replace('__LABEL_NAME__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                        break;
                                    case 'Phone':
                                        $template = str_replace('__LABEL_PHONE__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                        break;
                                    case 'Email':
                                        $template = str_replace('__LABEL_EMAIL__', $formField['label'], $template);
                                        $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                        break;
                                    case 'Property title':
                                        $template = str_replace('__LABEL_DESCRIPTION1__', 'Selected property', $template);
                                        $template = str_replace('__TEXT_DESCRIPTION1__', $formField['value'], $template);
                                        break;
                                    case 'href':
                                        $hrefLink = '<a href="' . $formField['value'] . '">__TEXT_DESCRIPTION1__</a>';
                                        $template = str_replace('__TEXT_DESCRIPTION1__', $hrefLink, $template);
                                        break;
                                }

                                $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                            }

                            $estateListHtml = '';

                            foreach ($estateList as $estateId => $estateData)
                            {
                                $estateItemHtml = '<div><span>' . $estateData['Estate External ID'] . '</span><br><span>' . $estateData['Estate Title'] . '</span></div>';
                                $estateListHtml .= $estateItemHtml;
                            }

                        $estateListHtml .= '<pre>' . print_r($estateList, true) . '</pre>';

                            $template = str_replace('__LABEL_DESCRIPTION1__', 'Selected property', $template);
                            $template = str_replace('__TEXT_DESCRIPTION1__', $estateListHtml, $template);

                            $header = $subject;
                            $template = str_replace('__HEADER__', $header, $template);

                            $subHeader = 'New request from Web Portal';
                            $template = str_replace('__SUB_HEADER__', $subHeader, $template);

                            $textFooter1 = 'Thank you for your interest in the services of our real estate agency Happy House Rentals, s.r.o. We will process your request within a few hours, but no later than the next working day.';
                            $template = str_replace('__TEXT_FOOTER_1__', $textFooter1, $template);
                            $textFooter2 = 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com';
                            $template = str_replace('__TEXT_FOOTER_2__', $textFooter2, $template);
                            $textFooter3 = 'SALES | RENTALS | PROPERTY / FACILITY MANAGEMENT | SALES OF APARTMENT BUILDINGS';
                            $template = str_replace('__TEXT_FOOTER_3__', $textFooter3, $template);
                            $emailHtml = $template;

                        }
                        else
                        {
                            $emailHtml = $lang == 'en' ? '<h3>New request from the site www.HappyHouseRentals.com</h3>' : '<h3>Nový požadavek z portálu www.HappyHouseRentals.com</h3>';

                            $emailHtml .= '<h3>' . $subject . '</h3><br>';

                            foreach ($formFields as $formField)
                            {
                                if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                                {
                                    $sender = $formField['value'];
                                }
                                else if (strpos($formField['label'], 'email') !== false && strpos($formField['value'], '@happyhouserentals.com') > 1)
                                {
                                    // $reciever = $formField['value'];
                                }
                                $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                            }
                            $emailHtml .= $lang == 'en' ? '<br><br><p>Thank you for your interest in the services of our real estate agency Happy House Rentals, s.r.o. We will process your request within a few hours, but no later than the next working day.</p><hr><span>Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com</span><br><span><b>SALES | RENTALS | PROPERTY / FACILITY MANAGEMENT | SALES OF APARTMENT BUILDINGS</b></span>' : '<br><br><p>Děkujeme za zájem využít služeb naší realitní kanceláře Happy House Rentals, s.r.o. Vaši poptávku vyřídíme během několika hodin, nejpozději do následujícího pracovního dne.</p><hr><span>Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com</span><br><span><b>PRODEJ | PRONÁJEM | SPRÁVA NEMOVITOSTÍ | ČINŽOVNÍ DOMY</b></span>';

                        }


                        break;

                }



                if (empty($sender) || $sender == 'info@happyhouserentals.com')
                {
                    $finalArray['status'] = 'ERR-SENDER_EMPTY';
                    $finalArray['debug'] = $process->debugMessage;

                }
                else
                {
                    $processMail = new ProcessMail($process);
                    $emailResult = $processMail->sendHhrForm($reciever, $sender, $subject, $emailHtml, $formFields);

                    if ($emailResult)
                    {
                        $finalArray['status'] = 'OK';
                    }
                    else
                    {
                        $finalArray['status'] = 'ERR';
                        $finalArray['error'] = 'ERR-MAIL_RESULT_ERROR';
                        $finalArray['debug'] = $process->debugMessage;
                    }

                }

            }
            else
            {
                $finalArray['status'] = 'ERR-FORMFIELDS_EMPTY';
                $finalArray['debug'] = $process->debugMessage;

            }
            break;

        case 'welcomeMessage':
            $welcomeMessageArray = $processRealko->getWelcomeMessage();
            $finalArray['status'] = 'OK';
            if (isset($welcomeMessageArray) && is_array($welcomeMessageArray) && count($welcomeMessageArray) > 0)
            {
                $messageCZ = '';
                $messageEN = '';
                foreach ($welcomeMessageArray as $row)
                {
                    $messageCZ .= '<div class="hhrWelcomeMessage">' . str_replace("\rn", '<br />', $row['message_cz']) . '</div>';
                    $messageEN .= '<div class="hhrWelcomeMessage">' . str_replace(PHP_EOL, '<br />', $row['message_en']) . '</div>';
                }
                $finalArray['message_cz'] = $messageCZ;
                $finalArray['message_en'] = $messageEN;

            }
            else
            {
                $finalArray['error'] = 'ERR-NO_MESSAGE_FOUND';
            }
            $finalArray['debug'] = $process->debugMessage;

            break;


        case 'getJoomlaAliasByEstateId':
            $estateId = $_REQUEST['estateId'];
            $lang = $_REQUEST['lang'];

            if (substr($estateId, 0, 1) !== 'N' && substr($estateId, 0, 1) !== 'n')
            {
                // $estateId = 'N' . $estateId;
            }

            $joomlaAlias = $lang == 'en' ? 'en/' . $processRealko->getJoomlaAliasByEstateIdEn($estateId) : $processRealko->getJoomlaAliasByEstateId($estateId);
            $finalArray['status'] = 'OK';
            if (isset($joomlaAlias))
            {
                $finalArray['joomla_alias'] = $joomlaAlias;
            }
            else
            {
                $finalArray['error'] = 'ERR-NO_ESTATE_FOUND';
            }
            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'hhrFormSend':
            $formId = $_REQUEST['formId'];
            $sender = $_REQUEST['sender'];
            $lang = $_REQUEST['lang'];
            $formValues = json_decode($_REQUEST['formValues'], true);

            switch ($formId)
            {
                case 'basic-contact-form':
                    $template = file_get_contents('template2.html.template');

                    $subject = $lang == 'cs' ? 'Zpráva z kontaktního formuláře' : 'Message from Contact form';

                    foreach ($formValues as $formField)
                    {

                        switch ($formField['name'])
                        {
                            case 'Váš dotaz':
                                $template = str_replace('__LABEL_DESCRIPTION__', 'Dotaz', $template);
                                $template = str_replace('__TEXT_DESCRIPTION__', $formField['value'], $template);
                                break;
                            case 'Jméno a příjmení':
                                $template = str_replace('__LABEL_NAME__', $formField['name'], $template);
                                $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                break;
                            case 'Telefonní číslo':
                                $template = str_replace('__LABEL_PHONE__', $formField['name'], $template);
                                $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                break;
                            case 'Emailová adresa':
                                $template = str_replace('__LABEL_EMAIL__', $formField['name'], $template);
                                $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                break;

                            case 'Your question':
                                $template = str_replace('__LABEL_DESCRIPTION__', 'Question', $template);
                                $template = str_replace('__TEXT_DESCRIPTION__', $formField['value'], $template);
                                break;
                            case 'Name and surname':
                                $template = str_replace('__LABEL_NAME__', $formField['name'], $template);
                                $template = str_replace('__TEXT_NAME__', $formField['value'], $template);
                                break;
                            case 'Phone number':
                                $template = str_replace('__LABEL_PHONE__', $formField['name'], $template);
                                $template = str_replace('__TEXT_PHONE__', $formField['value'], $template);
                                break;
                            case 'Email address':
                                $template = str_replace('__LABEL_EMAIL__', $formField['name'], $template);
                                $template = str_replace('__TEXT_EMAIL__', $formField['value'], $template);
                                break;
                        }

                        $emailHtml .= '<b>' . $formField['name'] . '</b><p>' . $formField['value'] . '</p>';
                    }



                    $header = $subject;
                    $template = str_replace('__HEADER__', $header, $template);

                    $subHeader = $lang == 'cs' ? 'Nová zpráva z webového portálu' : 'New message from the Web portal';
                    $template = str_replace('__SUB_HEADER__', $subHeader, $template);

                    $textFooter1 = $lang == 'cs' ? 'Děkujeme za zájem využít služeb naší realitní kanceláře Happy House Rentals, s.r.o. Vaši poptávku vyřídíme během několika hodin, nejpozději do následujícího pracovního dne.' : 'Thank you for your interest in the services of our real estate agency Happy House Rentals, s.r.o. We will process your request within a few hours, but no later than the next working day.';
                    $template = str_replace('__TEXT_FOOTER_1__', $textFooter1, $template);
                    $textFooter2 = $lang == 'cs' ? 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com' : 'Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com';
                    $template = str_replace('__TEXT_FOOTER_2__', $textFooter2, $template);
                    $textFooter3 = $lang == 'cs' ? 'PRODEJ | PRONÁJEM | SPRÁVA NEMOVITOSTÍ | ČINŽOVNÍ DOMY' : 'SALES | RENTALS | PROPERTY / FACILITY MANAGEMENT | SALES OF APARTMENT BUILDINGS';
                    $template = str_replace('__TEXT_FOOTER_3__', $textFooter3, $template);
                    $emailHtml = $template;
                    break;

                default:
                    $emailHtml = $lang == 'en' ? '<h3>New message from the site www.HappyHouseRentals.com</h3>' : '<h3>Nová zpráva z portálu www.HappyHouseRentals.com</h3>';

                    $emailHtml .= '<h3>' . $subject . '</h3><br>';

                    foreach ($formFields as $formField)
                    {
                        if ($formField['label'] == 'Email' && strpos($formField['value'], '@') > 1)
                        {
                            $sender = $formField['value'];
                        }
                        else if (strpos($formField['label'], 'email') !== false && strpos($formField['value'], '@happyhouserentals.com') > 1)
                        {
                            // $reciever = $formField['value'];
                        }
                        $emailHtml .= '<b>' . $formField['label'] . '</b><p>' . $formField['value'] . '</p>';
                    }
                    $emailHtml .= $lang == 'en' ? '<br><br><p>Thank you for your interest in the services of our real estate agency Happy House Rentals, s.r.o. We will process your request within a few hours, but no later than the next working day.</p><hr><span>Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com</span><br><span><b>SALES | RENTALS | PROPERTY / FACILITY MANAGEMENT | SALES OF APARTMENT BUILDINGS</b></span>' : '<br><br><p>Děkujeme za zájem využít služeb naší realitní kanceláře Happy House Rentals, s.r.o. Vaši poptávku vyřídíme během několika hodin, nejpozději do následujícího pracovního dne.</p><hr><span>Happy House Rentals, s.r.o., Uruguayská 78/12, 120 00 Praha 2 - Vinohrady, info@happyhouserentals.com</span><br><span><b>PRODEJ | PRONÁJEM | SPRÁVA NEMOVITOSTÍ | ČINŽOVNÍ DOMY</b></span>';
                    break;

            }

            $subject = empty($subject) ? $formId : $subject;
            $message = empty($emailHtml) ? 'New message from your WEB portal (' . $formId . ')' : $emailHtml;

            $processMail = new ProcessMail($process);
            $reciever = $processMail->emailFrom;
            $emailResult = $processMail->sendHhrForm($reciever, $sender, $subject, $message, $formValues);


            if ($emailResult)
            {
                $finalArray['status'] = 'OK';
            }
            else
            {
                $finalArray['status'] = 'ERR';
                $finalArray['error'] = 'ERR-MAIL_RESULT_ERROR';
                $finalArray['debug'] = $process->debugMessage;
            }

            break;


        case 'hhrHomeFormInit':

            $formCategories = $processRealko->getHhrHomeFormCategories();
            $formLocations = $processRealko->getHhrHomeFormLocations();


            if (isset($formCategories) && isset($formLocations))
            {
                $finalArray['status'] = 'OK';
                $finalArray['categories'] = $formCategories;
                $finalArray['locations'] = $formLocations;
            }
            else
            {
                $finalArray['status'] = 'ERR';
                $finalArray['error'] = 'ERR-NO_DATA_RETRIEVED';
            }
            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'hhrHomeFormInitEn':

            $formCategories = $processRealko->getHhrHomeFormCategoriesEn();
            $formLocations = $processRealko->getHhrHomeFormLocationsEn();


            if (isset($formCategories) && isset($formLocations))
            {
                $finalArray['status'] = 'OK';
                $finalArray['categories'] = $formCategories;
                $finalArray['locations'] = $formLocations;
            }
            else
            {
                $finalArray['status'] = 'ERR';
                $finalArray['error'] = 'ERR-NO_DATA_RETRIEVED';
            }
            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'hhrPlanListSendFormContent':
            session_start();

            if (isset($_SESSION) && isset($_SESSION['hhrPlanList']))
            {

                $agentsArray = $processRealko->getEstateAgentsListByEstateIdArray($_SESSION['hhrPlanList']);

                if (isset($agentsArray) && is_array($agentsArray) && count($agentsArray) > 0)
                {
                    $select = '<select id="agentSelect" class="hhrSelectAgent hhr-input" name="agentEmail" onchange="hhrFillAgentData(this)">';

                    foreach ($agentsArray as $email => $agentArray)
                    {
                        $agentName = empty($agentArray['degree_before']) ? '' : $agentArray['degree_before'] . ' ';
                        $agentName .= empty($agentArray['firstname']) ? '' : $agentArray['firstname'] . ' ';
                        $agentName .= empty($agentArray['lastname']) ? '' : $agentArray['lastname'];
                        $agentName .= empty($agentArray['degree_after']) ? '' : ' ' . $agentArray['degree_after'];
                        $select .= '<option value="' . $email . '" data-name="' . $agentName . '">' . $agentName . '</option>';
                        if (empty($firstAgentName))
                        {
                            $firstAgentName = $agentName;
                        }
                    }
                    $select .= '</select>';

                    $contentHtml = '<div class="hhr-quickForm" data-subject="Naplánování prohlídky" data-action="quickFormSend">';
                    $contentHtml .= '<div class="hhr-quickForm-header">Žádám o naplánování prohlídky</div>';

                    $contentHtml .= '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">Vybraný agent</label><input class="hhr-input" type="text" name="agentName" value="' . $firstAgentName . '"/></div>';

                    $contentHtml .= '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Jméno a příjmení</label><input class="hhr-input" type="text" name="name" /></div>';
                    $contentHtml .= '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Telefon</label><input class="hhr-input" type="text" name="phone" /></div>';
                    $contentHtml .= '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Email</label><input class="hhr-input" type="text" name="email" /></div>';
                    $contentHtml .= '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Agent</label>' . $select . '</div>';
                    $contentHtml .= '<div class="hhr-quickForm-fieldSet"><label class="hhr-input-label">Doplňující informace</label><textarea class="hhr-input" name="property-text"></textarea></div>';

                    $estateCounter = 0;
                    foreach ($_SESSION['hhrPlanList'] as $estateId => $estateData)
                    {
                        $estateCounter++;
                        $contentHtml .= '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">Estate ID (' . $estateId . ')</label><input class="hhr-input" type="text" name="estateId[' . $estateCounter . ']" value="' . $estateId . '"/></div>';
                        $contentHtml .= '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">Estate External ID (' . $estateId . ')</label><input class="hhr-input" type="text" name="estateExternalId[' . $estateCounter . ']" value="' . $estateData['externalId'] . '"/></div>';
                        $contentHtml .= '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">Estate Title (' . $estateId . ')</label><input class="hhr-input" type="text" name="estateTitle[' . $estateCounter . ']" value="' . $estateData['title'] . '"/></div>';
                        $contentHtml .= '<div class="hhr-quickForm-fieldSet hidden"><label class="hhr-input-label">Estate Link (' . $estateId . ')</label><input class="hhr-input" type="text" name="estateLink[' . $estateCounter . ']" value="' . $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . $estateData['link'] . '"/></div>';

                    }

                    $contentHtml .= '<div class="hhr-quickForm-fieldSet"><label class="red">Důležité informace</label><div class="hhr-quickForm-text"><p>Na základě informací Vás po odeslání formuláře bude kontaktovat náš specialista.</p><p>Odesláním formuláře souhlasíte se zpracováním Vámi uvedených informací za účelem zpracování, přípravy a následného zpětného kontaktu.</p></div></div>';
                    $contentHtml .= '<div class="hhr-quickForm-controls"><button class="hhr-quickForm-btn btn-send" onclick="hhrQuickFormSend(this)"></button><button class="hhr-quickForm-btn btn-cancel" onclick="hhrQuickFormCancel(this)"><i class="fal fa-times"></i></button></div>';
                    $contentHtml .= '<div class="hhr-quickForm-fieldSet success-message hidden"><label class="red">Děkujeme!</label><div class="hhr-quickForm-text"><p>Vámi odeslané informace byly úspěšně doručeny.</p><p>Náš specialista Vás bude kontaktovat nejpozději v následujícím pracovním dni.</p></div></div>';
                    $contentHtml .= '</div > ';

                    $finalArray['status'] = 'OK';
                    $finalArray['contentHtml'] = $contentHtml;
                }
                else
                {
                    $finalArray['status'] = 'ERR-AGENT_NOT_FOUND';
                }


            }
            else
            {
                $finalArray['status'] = 'ERR-PLANLIST_NOT_FOUND';

            }

            $finalArray['debug'] = $process->debugMessage;

            break;

        case 'hhrEstateStatusCheck':

            $estateExternalId = isset($_REQUEST['estateExternalId']) ? $_REQUEST['estateExternalId'] : null;

            $statusMessageCz[2] = 'Nabídka je aktivní';
            $statusMessageEn[2] = 'The Estate is active';
            $statusMessageCz[3] = 'Nabídka je rezervována';
            $statusMessageEn[3] = 'The Estate is reserved';
            $statusMessageCz[4] = 'Nabídka již není dostupná';
            $statusMessageEn[4] = 'The Estate is no longer available';
            $statusMessageCz[5] = 'Nabídka již není dostupná';
            $statusMessageEn[5] = 'The Estate is no longer available';
            $statusMessageCz[6] = 'Inzerce nabídky je omezena';
            $statusMessageEn[6] = 'The advertising of this Estate is limited';

            $class[2] = 'estateActive';
            $class[3] = 'estateReserved';
            $class[4] = 'estateNotAvailable';
            $class[5] = 'estateNotAvailable';
            $class[6] = 'estateNotAvailable';


            if (isset($estateExternalId) && !empty($estateExternalId))
            {
                $estateStatusArr = $processRealko->getHhrEstateStatus($estateExternalId);
                if (isset($estateStatusArr) && is_array($estateStatusArr))
                {
                    if (isset($estateStatusArr) && isset($estateStatusArr['css_class']) && $estateStatusArr['css_class'] == 'disabled')
                    {
                        $statusMessageCzText = isset($statusMessageCz[6]) ? $statusMessageCz[6] : '';
                        $statusMessageEnText = isset($statusMessageEn[6]) ? $statusMessageEn[6] : '';
                        $statusClass = isset($class[6]) ? $class[6] : '';
                        $locationUpdate = 'yes';
                    }
                    elseif (isset($estateStatusArr) && isset($estateStatusArr['to_update']) && $estateStatusArr['to_update'] == 0)
                    {
                        $statusMessageCzText = isset($statusMessageCz[$estateStatusArr['commission_status_id']]) ? $statusMessageCz[$estateStatusArr['commission_status_id']] : '';
                        $statusMessageEnText = isset($statusMessageEn[$estateStatusArr['commission_status_id']]) ? $statusMessageEn[$estateStatusArr['commission_status_id']] : '';
                        $statusClass = isset($class[$estateStatusArr['commission_status_id']]) ? $class[$estateStatusArr['commission_status_id']] : '';
                        $locationUpdate = isset($estateStatusArr['commission_status_id']) && $estateStatusArr['commission_status_id'] > 3 ? 'yes' : 'no';
                    }
                    else
                    {
                        $statusMessageCzText = isset($statusMessageCz[5]) ? $statusMessageCz[5] : '';
                        $statusMessageEnText = isset($statusMessageEn[5]) ? $statusMessageEn[5] : '';
                        $statusClass = isset($class[5]) ? $class[5] : '';
                        $locationUpdate = 'yes';
                    }

                    $linkCz = isset($estateStatusArr) && isset($estateStatusArr['link']) ? $estateStatusArr['link'] : '/';
                    $linkEn = isset($estateStatusArr) && isset($estateStatusArr['link_en']) ? $estateStatusArr['link_en'] : '/en/';


                    $finalArray['status'] = 'OK';
                    $finalArray['estateStatusCz'] = $statusMessageCzText;
                    $finalArray['estateStatusEn'] = $statusMessageEnText;
                    $finalArray['linkCz'] = $linkCz;
                    $finalArray['linkEn'] = $linkEn;
                    $finalArray['locationUpdate'] = $locationUpdate;
                    $finalArray['estateClass'] = $statusClass;
                    $finalArray['estateStatusArr'] = $estateStatusArr;
                }

            }
            else
            {
                $finalArray['status'] = 'ERR';
                $finalArray['message'] = 'ERR_Empty_Estate_ID';
            }

            break;


        default:
            $finalArray['status'] = 'ERR-UNKNOWN_ACTION_REQUESTED';
            $finalArray['post'] = $_POST;
    }

    // ECHO RESULT
    if (!isset($finalArray))
    {
        $finalArray['status'] = 'ERR-AJAXDATA_GENERAL_ERROR';
    }
    elseif (empty($finalArray['status']) && !empty($finalArray['data']))
    {
        $finalArray['status'] = 'OK';
    }
    elseif (empty($finalArray['status']) && empty($finalArray['data']))
    {
        $finalArray['status'] = 'ERR-NO_DATA_RESULT';
    }
    $return = json_encode($finalArray);

    //header("Access-Control-Allow-Origin: *");
    header("Content-Type: application/json; charset=UTF-8");
    echo $return;
}
else
{
    $finalArray['status'] = 'ERR-UNAUTHORIZED-ACCESS';
    $return = json_encode($finalArray);
    header("Content-Type: application/json; charset=UTF-8");
    echo $return;
}